<?php
use Cake\Core\Configure;
$keyFeatures = Configure::read('keyFeatures');
ksort($keyFeatures['COUNTRY']);
ksort($keyFeatures['DEPARTMENT']);
?>
<div class="mainwrapper">
	<div class="leftpanel">
		<?php echo $this->element('admin/sidebar');?>                
	</div><!-- leftpanel -->
	
	<div class="mainpanel">
		<div class="pageheader">
			<div class="media">
				<div class="pageicon pull-left">
					<i class="fa fa-user"></i>
				</div>
				<div class="media-body">
					<ul class="breadcrumb">
						<li><a href="<?php echo $this->Url->build(['controller' => 'Admins', 'action' => 'dashboard']);?>"><i class="glyphicon glyphicon-home"></i> Dashboard</a></li>
						<li><a href="<?php echo $this->Url->build(['controller' => 'users', 'action' => 'restaurant']);?>"> Manage Restaurant</a></li>
						
						<li>Edit Restaurant</li>
					</ul>
					<h4>Edit Restaurant</h4>
				</div>
			</div><!-- media -->
		</div><!-- pageheader -->
		
		<div class="contentpanel">
                        
                        <div class="row">
				
				<?php echo $this->Flash->render(); ?>
				<?php
                //pr($user);
                echo $this->Form->create($users, ['type' =>'file', 'novalidate'=>'novalidate']);?>
                <?php //echo $this->Form->create('Department', ['url'=>['controller'=>'departments', 'action'=>'add']]);?>
								
                                <div class="panel panel-default">
                                    <div class="panel-heading">  
                                        <h4 class="panel-title">Edit Restaurant</h4>
                                        <p>Please provide below information to edit Restaurant.</p>
                                    </div><!-- panel-heading -->
                                    <div class="panel-body">
                                        <div class="row">
					
					
					
				
					
				
					
					<div class="form-group">
						<label class="col-sm-3 control-label">Full Name <span class="asterisk">*</span></label>
						<div class="col-sm-9">
							<?php echo $this->Form->input('fullName', ['error' => ['minLength' =>  __('You can submit up to ')],'class' => 'form-control','type'=>'text', 'required'=>false,'placeholder' => '', 'div' => false, 'label' => false, 'maxlength'=>100]); ?>
						</div>
					</div>
                    
					<div class="form-group">
						<label class="col-sm-3 control-label">Email <span class="asterisk">*</span></label>
						<div class="col-sm-9">
							<?php echo $this->Form->input('email', ['error' => ['minLength' =>  __('You can submit up to ')],'class' => 'form-control','type'=>'text', 'required'=>false,'placeholder' => '', 'readonly'=>true, 'div' => false, 'label' => false, 'maxlength'=>255]); ?>
						</div>
					</div><!-- form-group -->
					
					
					<div class="form-group">
						<label class="col-sm-3 control-label">Password </label>
						<div class="col-sm-9">
							<?php echo $this->Form->input('password', ['error' => ['minLength' =>  __('You can submit up to ')], 'value' => '', 'class' => 'form-control','type'=>'password', 'required'=>false,'placeholder' => '', 'div' => false, 'label' => false, 'maxlength'=>100]); ?>
						</div>
					</div><!-- form-group -->
					
					
					<div class="form-group">
						<label class="col-sm-3 control-label">Confirm Password </label>
						<div class="col-sm-9">
							<?php echo $this->Form->input('confirm_password', ['error' => ['minLength' =>  __('You can submit up to ')], 'value' => '', 'class' => 'form-control','type'=>'password', 'required'=>false,'placeholder' => '', 'div' => false, 'label' => false, 'maxlength'=>100]); ?>
						</div>
					</div><!-- form-group -->
					
					
					
					<div class="form-group">
						<label class="col-sm-3 control-label">Phone Number <!-- <span class="asterisk">*</span> --></label>
						<div class="col-sm-9">
							<?php echo $this->Form->input('contactNumber', ['error' => ['minLength' =>  __('You can submit up to ')],'class' => 'form-control','type'=>'text', 'required'=>false,'placeholder' => '', 'div' => false, 'label' => false, 'maxlength'=>100]); ?>
						</div>
					</div><!-- form-group -->
					
					<div class="form-group">
						<label class="col-sm-3 control-label">Address <!-- <span class="asterisk">*</span> --></label>
						<div class="col-sm-9">
							<?php echo $this->Form->input('address', ['error' => ['minLength' =>  __('You can submit up to ')],'class' => 'form-control','type'=>'text', 'required'=>false,'placeholder' => '', 'div' => false, 'label' => false, 'maxlength'=>255]); ?>
						</div>
					</div><!-- form-group -->
					
					
					
					<div class="form-group">
						<label class="col-sm-3 control-label">Zip code <!-- <span class="asterisk">*</span> --></label>
						<div class="col-sm-9">
							<?php echo $this->Form->input('zipCode', ['error' => ['minLength' =>  __('You can submit up to ')],'class' => 'form-control','type'=>'text', 'required'=>false,'placeholder' => '', 'div' => false, 'label' => false, 'maxlength'=>10]); ?>
						</div>
					</div><!-- form-group -->
					
					
					<div class="form-group">
						<label class="col-sm-3 control-label">City <!-- <span class="asterisk">*</span> --></label>
						<div class="col-sm-9">
							<?php echo $this->Form->input('city', ['error' => ['minLength' =>  __('You can submit up to ')],'class' => 'form-control','type'=>'text', 'required'=>false,'placeholder' => '', 'div' => false, 'label' => false, 'maxlength'=>50]); ?>
						</div>
					</div><!-- form-group -->
					
					
					<div class="form-group">
						<label class="col-sm-3 control-label">State <!-- <span class="asterisk">*</span> --></label>
						<div class="col-sm-9">
							<?php echo $this->Form->input('state', ['error' => ['minLength' =>  __('You can submit up to ')],'class' => 'form-control','type'=>'text', 'required'=>false,'placeholder' => '', 'div' => false, 'label' => false, 'maxlength'=>50]); ?>
						</div>
					</div><!-- form-group -->
					
					<div class="form-group">
						<label class="col-sm-3 control-label">Latitude <!-- <span class="asterisk">*</span> --></label>
						<div class="col-sm-9">
							<?php echo $this->Form->input('latitude', ['class' => 'form-control','type'=>'text', 'required'=>false,'placeholder' => '', 'div' => false, 'label' => false, 'maxlength'=>50]); ?>
						</div>
					</div>
					
						<div class="form-group">
						<label class="col-sm-3 control-label">Longitude <!-- <span class="asterisk">*</span> --></label>
						<div class="col-sm-9">
							<?php echo $this->Form->input('longitude', ['class' => 'form-control','type'=>'text', 'required'=>false,'placeholder' => '', 'div' => false, 'label' => false, 'maxlength'=>50]); ?>
						</div>
					</div>
					
					
					<div class="form-group">
						<label class="col-sm-3 control-label">Bank Name <!-- <span class="asterisk">*</span> --></label>
						<div class="col-sm-9">
							<?php echo $this->Form->input('BankName', ['class' => 'form-control','type'=>'text', 'required'=>false,'placeholder' => '', 'div' => false, 'label' => false, 'maxlength'=>50]); ?>
						</div>
					</div>
					<div class="form-group">
						<label class="col-sm-3 control-label">Account Holder Name <!-- <span class="asterisk">*</span> --></label>
						<div class="col-sm-9">
							<?php echo $this->Form->input('AccountHolderName', ['class' => 'form-control','type'=>'text', 'required'=>false,'placeholder' => '', 'div' => false, 'label' => false, 'maxlength'=>50]); ?>
						</div>
					</div>
					<div class="form-group">
						<label class="col-sm-3 control-label">Account No <!-- <span class="asterisk">*</span> --></label>
						<div class="col-sm-9">
							<?php echo $this->Form->input('AccountNo', ['class' => 'form-control','type'=>'text', 'required'=>false,'placeholder' => '', 'div' => false, 'label' => false, 'maxlength'=>50]); ?>
						</div>
					</div>
					<div class="form-group">
						<label class="col-sm-3 control-label">RoutingNo <!-- <span class="asterisk">*</span> --></label>
						<div class="col-sm-9">
							<?php echo $this->Form->input('RoutingNo', ['class' => 'form-control','type'=>'text', 'required'=>false,'placeholder' => '', 'div' => false, 'label' => false, 'maxlength'=>50]); ?>
						</div>
					</div>
					
					
					 <div class="form-group">
						<label class="col-sm-3 control-label">Status <span class="asterisk">*</span></label>
						<div class="col-sm-9">
							<?php echo $this->Form->input('status', [
							'options' => array(1 => 'Active', 0 => 'Inactive'), 'class' => 'selectbox', 'data-placeholder' => 'Choose One', 'style' => 'width:100%', 'id' => 'country', 'label' => false,
							'div' => false]);?>
						   <label class="error" for="Country"></label> 
						</div>                                                 
					</div><!-- form-group --> 
					
					
					<div class="form-group">
							<label class="col-sm-3 control-label">Company Logo </label>
							<div class="col-sm-9">
								<?php
												$profilePic = $users->profile_picture;
												$imagePath = WWW_ROOT . 'img/uploads/users/'.trim($profilePic);
												$profilePicture = $this->Url->build('/', true).'img/uploads/users/thumb/no-image-100x100.jpg';
														//Checking file in bulk folder	   
												if(trim($profilePic)!='' && file_exists($imagePath)) {
																$profilePicture = $this->Url->build('/') . 'img/uploads/users/' . trim($profilePic); 
												}
								if($profilePicture!=''){ ?>
									<img src="<?php echo $profilePicture; ?>" style="max-height:150px; max-width:150px" /><br>
								<?php }?><br>
								<?php echo $this->Form->input('profile_picture', array('class' => '','type'=>'file', 'placeholder' => '', 'div' => false, 'label' => false, 'maxlength'=>200)); ?>
								<samll>(Note: Image type jpg, jpeg, gif, png only)</samll>
							</div>
						</div>
					
					<div class="form-group">
							<label class="col-sm-3 control-label">Company Background </label>
							<div class="col-sm-9">
								<?php
												$profilePic2 = $users->companyBackground;
												$imagePath = WWW_ROOT . 'img/uploads/users/'.trim($profilePic2);
												$profilePicture2 = $this->Url->build('/', true).'img/uploads/users/thumb/no-image-100x100.jpg';
												if(trim($profilePic2)!='' && file_exists($imagePath)) {
																$profilePicture2 = $this->Url->build('/') . 'img/uploads/users/' . trim($profilePic2); 
												}
								if($profilePicture2 !=''){ ?>
									<img src="<?php echo $profilePicture2; ?>" style="max-height:150px; max-width:150px" /><br>
								<?php }?><br>
								<?php echo $this->Form->input('companyBackground', array('class' => '','type'=>'file', 'placeholder' => '', 'div' => false, 'label' => false, 'maxlength'=>200)); ?>
								<samll>(Note: Image type jpg, jpeg, gif, png only)</samll>
							</div>
						</div>
					
					<div class="form-group">
						<label class="col-sm-3 control-label">Restaurant Category</label>
						<div class="col-sm-9">
							<?php echo $this->Form->input('categoryID', ['options' => $parentClientList, 'id'=>'select-multi','class' => 'selectbox', 'data-placeholder' => 'Choose One', 'style' => 'width:100%', 'multiple' => true, 'label' => false,
							'div' => false]);?>
						</div>                                                 
					</div>

								</div><!-- row -->
							</div><!-- panel-body -->
							
							<div class="panel-footer">
							  <div class="row">
								<div class="col-sm-9 col-sm-offset-3">
									<?php echo $this->Form->submit('Submit', ['class' => 'btn btn-primary mr5',  'div' => false, 'label' =>false]); ?>
								</div>
							  </div>
							</div><!-- panel-footer -->  
						</div><!-- panel -->
					   <?php echo $this->Form->end();?>                                
				   <!-- col-md-6 -->                           
				</div><!-- row-->    
			</div><!-- contentpanel -->
		</div><!-- contentpanel -->		
	</div><!-- mainpanel -->
</div><!-- mainwrapper -->

<script>
/*jQuery("#country, #business_id, #department_name").select2({
	minimumResultsForSearch: -1
});*/
jQuery("#select-basic, #select-multi").select2();

jQuery("#business_id").on('change', function(){
	var business_id = jQuery(this).val();
    $("#loder").css("display", "block");
	jQuery.ajax({
        url : "<?php echo $this->Url->build(['controller' => 'users', 'action' => 'departments']);?>/"+business_id,
        success: function(response) {
            $("#loder").css("display", "none");
			jQuery("#department_name").html(response);            
            return false;
        }
    });
    
});

$(function() {
    $('#dob').datepicker( {
        changeMonth: true,
        changeYear: true,
        showButtonPanel: true,
        dateFormat: 'yy-mm-dd',
        yearRange: "-100:+0",
        /*onClose: function(dateText, inst) { 
            var month = $("#ui-datepicker-div .ui-datepicker-month :selected").val();
            var year = $("#ui-datepicker-div .ui-datepicker-year :selected").val();
            $(this).datepicker('setDate', new Date(year, month, 1));
        }*/
    });
});

</script>
<style>
    button.ui-datepicker-current { display: none; }
</style>
