<?php
/**
 * CakePHP(tm) : Rapid Development Framework (http://cakephp.org)
 * Copyright (c) Cake Software Foundation, Inc. (http://cakefoundation.org)
 *
 * Licensed under The MIT License
 * For full copyright and license information, please see the LICENSE.txt
 * Redistributions of files must retain the above copyright notice.
 *
 * @copyright Copyright (c) Cake Software Foundation, Inc. (http://cakefoundation.org)
 * @link      http://cakephp.org CakePHP(tm) Project
 * @since     0.2.9
 * @license   http://www.opensource.org/licenses/mit-license.php MIT License
 */
namespace App\Controller;

use Cake\Core\Configure;
use Cake\View\Helper\HtmlHelper;
use Cake\Network\Exception\NotFoundException;
use Cake\View\Exception\MissingTemplateException;
use Cake\Routing\Router;
use Cake\Auth\DefaultPasswordHasher;
use Cake\ORM\TableRegistry;
use Cake\Datasource\ConnectionManager;

use Cake\View\Helper\PaginatorHelper;
use Cake\I18n\Time;

use Firebase\JWT\JWT;
use Firebase\JWT\Key;

require_once('jwt/autoload.php');

$keyFeatures = Configure::read('keyFeatures');

$Relations = $keyFeatures['Relations'];
$Relations_B = $keyFeatures['Relations_B'];

$Vechle_colors = $keyFeatures['Vechle_colors'];
$Vechle_colors_B = $keyFeatures['Vechle_colors_B'];

$Brands = $keyFeatures['Brands'];
$Brands_B = $keyFeatures['Brands_B'];

$Bike_brands = $keyFeatures['Bike_brands'];
$Bike_brands_B = $keyFeatures['Bike_brands_B'];


/**
 * Static content controller
 *
 * This controller will render views from Template/Pages/
 *
 * @link http://book.cakephp.org/3.0/en/controllers/pages-controller.html
 */

$req_dump = '-------------------------'.date('Y-m-d H:i:s').'---------------------';
$inputJSON = file_get_contents('php://input');
if($inputJSON){
	$input = json_decode($inputJSON, TRUE);
$req_dump .= print_r($input, TRUE);
}
$req_dump .= print_r($_POST, TRUE);
$req_dump .= print_r($_FILES, TRUE);
$fp = fopen('request.log', 'a');
fwrite($fp, $req_dump);
fclose($fp);

class ServicesController extends AppController
{
    var $profilePath 		= 'https://demo4.evirtualservices.net/pathmark/img/uploads/users/';
	var $dashboardPath 		= 'https://demo4.evirtualservices.net/pathmark/img/uploads/dashboard/';
	var $catPath 			= 'https://demo4.evirtualservices.net/pathmark/img/uploads/category/';
	var $carPath 			= 'https://demo4.evirtualservices.net/pathmark/img/uploads/cars/';
	var $workPath 			= 'https://demo4.evirtualservices.net/pathmark/img/uploads/work/';
	var $baseUrl 			= 'https://demo4.evirtualservices.net/pathmark/';
	// function index(){
	// 	//header("Content-type:application/json");
	// 	Configure::write('Session.checkAgent', false);
	// 	$response=array();
	// 	//$this->layout='';
	// 	//print_r($this->request->header('token')); die('ggggg');
	// 	if($this->request->data('body') !=''){
	// 		$this->request->data=$this->request->data;
	// 	}else{
	// 		$inputJSON = file_get_contents('php://input');
	// 		if($inputJSON){
	// 			$this->request->data = json_decode($inputJSON, TRUE);
	// 		}
	// 	}
	// 	if(@$this->request->data['body']){
	// 		//print_r($this->request->data['body']); //die;
	// 		$resPonse = $this->decodetoken(trim($this->request->data['body']));
	// 		if($resPonse['status'] == 200){
	// 			$this->request->data = json_decode(json_encode($resPonse['data']), true);
	// 			//echo "<pre>";
	// 			//print_r($this->request->data); die('ffffff');
	// 			$action = trim($this->request->data['action']);
	// 				//echo $action;
	// 				//pr($this->request->data); die;
	// 			if(!empty($action)){
	// 					$getResponse = $this->$action();
	// 					$response['status'] = $getResponse['status'];
	// 					$response['msg'] = (@$getResponse['msg']) ? @$getResponse['msg'] : '';
	// 					unset($getResponse['status']);
	// 					$response['body'] = $this->encodejwtreturn($getResponse);
	// 					//$response = $this->$action();
	// 					unset($this->request->data['action']);
	// 			}else{
	// 				$response['status'] = 'Fails';
	// 				$response['msg'] = 'Invalid action key';
	// 				$response['currentTime date'] = date('Y-m-d H:i:s');
	// 				$response['milisecond'] = time();
	// 			}
	// 		}else{
	// 			$response['status'] = 'Fails';
	// 			$response['msg'] = $resPonse['msg'];
	// 		}
	// 	}else{
	// 		$response['status'] = 'Fails';
	// 		$response['msg'] = 'Invalid action key';
	// 	}
	// 	//$encrypt = $this->encodejwtreturn($response);
	// 	//echo json_encode($encrypt); die;
	// 	echo json_encode($response); die;
	// }
    

	function index(){
		//header("Content-type:application/json");
		Configure::write('Session.checkAgent', false);
		$response=array();
		//$this->layout='';
		//print_r($this->request->header('token')); die('ggggg');
		if($this->request->data('action') !=''){
			$this->request->data=$this->request->data;
		}else{
			$inputJSON = file_get_contents('php://input');
			if($inputJSON){
				$this->request->data = json_decode($inputJSON, TRUE);
			}
		}
		if(@$this->request->data['action']){
			$skipArray = ['bookingdetail','bookinglist','listbyprice','rideend','testnotification','getprice','termAndConditions_user','privacypolicy_user','getprice','socialLoginAction','updatepayment','shareride','help','notificationall','gettoken','aboutus','privacypolicy','termAndConditions','disclamer','faq','resetpassword','verifyOTP','profile','addcarinformation','getprice','registration','login','forgotpassword','countrylist','category'];
			$token = $this->request->header('token');
			$auth = '';
			if(@$token){
				$getres = $this->decodetoken($token);
				$auth =  $getres['status'];
			}
			//echo $auth."<br>".$token; die;
			if(in_array($this->request->data['action'], $skipArray) || $auth == 200){
				$action = trim($this->request->data['action']);
					//echo $action;
					//pr($this->request->data); die;
				if(!empty($action)){
						$response = $this->$action();
				}else{
					$response['status'] = 'Fails';
					$response['msg'] = 'Invalid action key';
					$response['currentTime date'] = date('Y-m-d H:i:s');
					$response['milisecond'] = time();
				}
			}else{
				$response['status'] = 'Fails';
				$response['msg'] = 'You are not authorize to access the API';
			}
		}else{
			$response['status'] = 'Fails';
			$response['msg'] = 'Invalid action key';
		}
		echo json_encode($response); die;
	}

	function decodetoken($token=null){
		$jwt = ($token) ? $token : @$this->request->data['token'];
		$key  = '68V0zWFrS72GbpPreidkQFLfj4v9m3Ti+DXc8OB0gcM=';
		//$secret_Key  = '68V0zWFrS72GbpPreidkQFLfj4v9m3Ti+DXc8OB0gcM=';
		//$body = JWT::decode($tokenData, new Key($secret_Key, 'HS512'));

		try {

			//$decoded = JWT::decode($jwt, $key, array('HS256'));
			$decodedata = JWT::decode($jwt, new Key($key, 'HS512'));
			//echo "<pre>";
			//pr($decodedata); die;
			//$refresh_token=$decoded->data->refresh_token;
			//die('!!!!!!!23432!!!!!!!!!!!');
			$decoded['status'] = 200;
			$decoded['data'] = $decodedata;
			}
			
			catch (\Exception $e){
			   //die('!!!!!!!!!!!!!!!!!!');
				$decoded['status'] = 'Fails';
				$decoded['msg'] = $e->getMessage();
			}
		//echo json_encode($decoded); die;
		return $decoded;
	}
	function decodejwt($token=null){
		$jwt = ($token) ? $token : @$this->request->data['token'];
		$key  = '68V0zWFrS72GbpPreidkQFLfj4v9m3Ti+DXc8OB0gcM=';
		//$secret_Key  = '68V0zWFrS72GbpPreidkQFLfj4v9m3Ti+DXc8OB0gcM=';
		//$body = JWT::decode($tokenData, new Key($secret_Key, 'HS512'));

		try {
			//$decoded = JWT::decode($jwt, $key, array('HS256'));
			$decodedata = JWT::decode($jwt, new Key($key, 'HS512'));
			//echo "<pre>";
			pr($decodedata); die;
			//$refresh_token=$decoded->data->refresh_token;
			//die('!!!!!!!23432!!!!!!!!!!!');
			$decoded['status'] = 200;
			$decoded['data'] = $decodedata;
			}
			
			catch (\Exception $e){
			   //die('!!!!!!!!!!!!!!!!!!');
				$decoded['status'] = 'Fails';
				$decoded['msg'] = $e->getMessage();
			}
		echo "<pre>"; print_r($decoded); die;
		return $decoded;
	}
	function encodejwtreturn($data=NULL){
		$secret_Key  = '68V0zWFrS72GbpPreidkQFLfj4v9m3Ti+DXc8OB0gcM=';
		$date   = time();
		$expire_at     = $date + 1000;      // Add 1 seconds = 60
		$domainName = "evirtualservices.com";
		$body   = $this->request->data; // Retrieved from filtered POST data
		$request_data = [
			'iat'  => $date,         // Issued at: time when the token was generated
			'iss'  => $domainName,  // Issuer
			'nbf'  => $date,         // Not before
			'exp'  => $expire_at,    // Expire
		];
		
		$jwt = JWT::encode(
			$request_data,
			$secret_Key,
			'HS512'
		);
		return $jwt;
		//die;
	}
	function encodejwt(){
		$secret_Key  = '68V0zWFrS72GbpPreidkQFLfj4v9m3Ti+DXc8OB0gcM=';
		$date   = time();
		$expire_at = $date + 100;      // Add 60 seconds
		$domainName = "EVS";
		$body   = $this->request->data;                                           // Retrieved from filtered POST data
		$request_data = [
			'iat'  => $date,         // Issued at: time when the token was generated
			'iss'  => $domainName,  // Issuer
			'nbf'  => $date,         // Not before
			'exp'  => $expire_at,    // Expire
		];
		
		echo $jwt = JWT::encode(
			$request_data,
			$secret_Key,
			'HS512'
		);
		die;
	}

	function checkjwt(){
		$secret_Key  = '68V0zWFrS72GbpPreidkQFLfj4v9m3Ti+DXc8OB0gcM=';
		$date   = time();
		$expire_at     = $date + 6;      // Add 60 seconds
		$domainName = "evirtualservices.comn";
		$username   = "raushan";                                           // Retrieved from filtered POST data
		$request_data = [
			'iat'  => $date,         // Issued at: time when the token was generated
			'iss'  => $domainName,                   // Issuer
			'nbf'  => $date,         // Not before
			'exp'  => $expire_at,                    // Expire
			'userName' => $username,                 // User name
		];
		
		echo $jwt = JWT::encode(
			$request_data,
			$secret_Key,
			'HS512'
		);
		echo "<br>";
		
		//$secret_Key  = '68V0zWFrS72GbpPreidkQFLfj4v9m3Ti+DXc8OB0gcM=';
		$token = JWT::decode($jwt, new Key($secret_Key, 'HS512'));
		echo "<pre>";
		print_r($token);
		die;
	}



	private function registration(){
		$this->loadModel('Users');
		if($this->request->data('email') !='' && $this->request->data('fullName') !='' && $this->request->data['countryCode'] !='' && $this->request->data('contactNumber') !='' && $this->request->data('password') !=''){
			$this->loadModel('Users');
			$usr = $this->Users->find()->where(['OR'=>[['Users.email' => $this->request->data('email')],['Users.contactNumber' => $this->request->data('contactNumber')]]])->first();
			//pr($usr); die;
			if(!empty($usr)){
				$response['status'] = 'Fails';
				$response['msg'] = 'Email or Phone number is already registered.';
				if(@$this->request->data['language'] =='bn'){
					$response['msg'] ="ইমেল বা ফোন নম্বর ইতিমধ্যে নিবন্ধিত আছে";
				}
			}else{
				$this->request->data['password'] = str_replace(' ', '', $this->request->data('password'));
				$this->request->data['email'] = str_replace(' ', '', $this->request->data('email'));
				$this->request->data['Pcode'] = base64_encode($this->request->data['password']);
				$users = $this->Users->newEntity();
				$users = $this->Users->patchEntity($users, $this->request->data, ['validate' => false]);
				$users['created'] 	= date('Y-m-d H:i:s');
				$users['username'] 	= $this->request->data('email');
				$users['status'] 	= '1';
				$users['AdminApproved'] 	= '1';	
				if($this->request->data['role'] == 'Driver'){
					$users['AdminApproved'] 	= 0;
				}
				$OOTP = rand(111111,999999);
				$users['OTP'] 		= $OOTP;
				$fileName = '';
				if(@$_FILES['image']['name']){
					$fileName=time().stripslashes($_FILES['image']['name']);
					$fileName= str_replace(" ","",$fileName);
					$users['profile_picture']=$fileName;
				}
				$fileName2 = '';
				if(@$_FILES['ssnImage']['name']){    // this is use for NID iamge
					$fileName2=time().stripslashes($_FILES['ssnImage']['name']);
					$fileName2= str_replace(" ","",$fileName2);
					$users['ssnImage']=$fileName2;
				}
				//$path = WWW_ROOT . 'img/uploads/feature/original/';
				if ($this->Users->save($users)) {
					if(@$_FILES['image']['name'] !='' && $fileName !=''){
						$target = WWW_ROOT.'/img/uploads/users/'.$fileName;
						$source=$_FILES['image']['tmp_name'];
						move_uploaded_file($source,$target);
					}
					if(@$_FILES['ssnImage']['name'] !='' && $fileName2 !=''){
						$target = WWW_ROOT.'/img/uploads/users/'.$fileName2;
						$source=$_FILES['ssnImage']['tmp_name'];
						move_uploaded_file($source,$target);
					}
					$response['status'] = 'success';
					$response['msg'] = 'Data save successfully.';
					//@mail('raushan.kumar@evirtualservices.com', 'HELLO', 'YES test mail');
					$to=$this->request->data('email');
					//$to='raushan.kumar@evirtualservices.com';
					$subject="Pathmark Registration";
					$message="Dear ".ucfirst($this->request->data('fullName'));
					$message .= '<br>Your new <strong><span style="color:#2133A1">zarib</span> Account has been created. Welcome to the <strong><span style="color:#2133A1">zarib</span></strong> family!';
					$message .= '<br>From now on, please log in to your account using your email address and password';
					$message .='<br><br> Thank you for registering with <strong><span style="color:#2133A1">zarib</span>. Your credentials is given below:';
					$message .='<br>Name: '.ucfirst($this->request->data['fullName']);
					$message .='<br>Email: '.$this->request->data('email').'<br>Password: '.$this->request->data['password'];
					$message .='<br>OTP: '.$users->OTP;
					$this->phpemail($to, $subject, $message);
					$dd = $this->profile($users->id);
					$response['data'] = $dd['data'];

					$nuber = $mob_number=substr($this->request->data['contactNumber'],-10);
					if(mb_strlen($nuber) == 10){
						$nub = "0".$nuber;
						$msg = "ZARIB registration request, Your login OTP is ".$OOTP;
						$this->sendotp($nub, $msg);
					}
				}
			}
		}else{
			$response['status'] = 'Fails';
			$response['msg'] = 'Email, contactNumber,fullName and password required';
		}
		return  $response;
	}
	
	
	private function login($slug=NULL){
		if($this->request->data){
			//pr($this->request->data); die;
			$this->loadModel('Users');
			//$usr = $this->Users->find()->where(['Users.email' => $this->request->data('email')])->first();
			$usr = $this->Users->find()->where(['Users.role !='=>'Admin','OR'=>[['Users.email' => $this->request->data('email')],['Users.contactNumber' => $this->request->data('email')]]])->first();
			if(!empty($usr)){
				//$check = (new DefaultPasswordHasher)->check(trim($this->request->data('password')),$usr->password);
				//if($check && $usr->status == 1){
				if($usr->status == 1){
					if($usr->role == @$this->request->data['role']){
						//$userdetail['FreedomUsers'] = $usr;
						//$this->request->session()->write($userdetail);
						$this->request->data['OTP'] 		= rand(111111,999999);
						unset($this->request->data['email']);
						$usr = $this->Users->patchEntity($usr, $this->request->data, ['validate' => false]);
						$this->Users->save($usr);
						$response['status'] = 'success';
						$response['msg'] = 'Data save successfully.';
						$response['AuthToken'] = $this->encodejwtreturn();
						$RES = $this->profile($usr->id);
						$response['data'] = $RES['data'];
						$to=$usr->email;
						//$to='raushan.kumar@evirtualservices.com';
						$subject="Pathmark login OTP";
						$message="Dear ".ucfirst($usr->fullName);
						$message .= '<br>Your login OTP is below:';
						$message .='<br>OTP: '.$this->request->data['OTP'];
						$this->phpemail($to, $subject, $message);

						$nuber = $mob_number=substr($usr->contactNumber,-10);
						if(mb_strlen($nuber) == 10){
							$nub = "0".$nuber;
							$msg = "ZARIB login request,  Your login OTP is ".$this->request->data['OTP'];
							$this->sendotp($nub, $msg);
						}

						//$response['data'] = $this->profile($users->id);
					}else{
						$response['status'] = 'Fails';
						$response['msg'] = 'Email or password is wrong.';
					}
				}else{
						$response['status'] = 'Fails';
						$response['msg'] = 'Please contact Zarib App admin to activate your account.';
						if(@$this->request->data['language'] =='bn'){
							$response['msg'] = 'আপনার অ্যাকাউন্ট সক্রিয় করতে Zarib অ্যাপ অ্যাডমিনের সাথে যোগাযোগ করুন';
						}
				}
			}else{
					$response['status'] = 'Fails';
					$response['msg'] = 'Email or password is wrong.';
			}
		}else{
			$response['status'] = 'Fails';
			$response['msg'] = 'Email or password is required.';
		}
		return  $response;
	}

	private function gettoken(){
		$this->loadModel('Users');
		//die('ddd');
		//pr(@$this->request->data); die;
		if(@$this->request->data['userId'] !='' && @$this->request->data['email'] !='' && @$this->request->data['role'] !=''){
			$users = $this->Users->find()->Where(['Users.role' => $this->request->data['role'],'Users.id' => $this->request->data['userId'], 'Users.email' => $this->request->data['email']])->first();
			if(@$users->id !=''){
				$response['status'] = 'success';
				//$response['data'] = $array;
				$response['AuthToken'] = $this->encodejwtreturn();
			}else{
				$response['status'] = 'Fails';
				$response['msg'] = 'Email or password is required.';
			}
		}else{
			$response['status'] = 'Fails';
			$response['msg'] = 'Email or password is required.';
		}
		return  $response;
	}
	
	private function verifyOTP(){
		$this->loadModel('Users');
		if($this->request->data['userId'] !='' && $this->request->data['OTP']){
			$users = $this->Users->find()->where(['Users.id'=>$this->request->data['userId'],'Users.OTP'=>$this->request->data['OTP']])->first();
			if(@$users->id !=''){
				$articles = TableRegistry::get('Users');
				$query = $articles->query();
				$query->update()
					->set(['OTP'=>''])
					->where(['id' => $users->id])
					->execute();
				$response['status'] = 'success';
				$response['msg'] = 'OTP verified successfully.';
			}else{
				$response['status'] = 'Fails';
				$response['msg'] = 'Please enter valid OTP';
			}
		}else{
			$response['status'] = 'Fails';
			$response['msg'] = 'userId and OTP is required.';
		}
		return  $response;
	}
	
	private function profile($userId = NULL){
			$this->loadModel('Users');
			$this->loadModel('Reviews');
			$this->loadModel('Bookings');
			
			$latitude 	= @$this->request->data['latitude']; 
			$longitude	= @$this->request->data['logitude'];
				
			@$userID = ($userId) ? $userId : $this->request->data('userId');
			
			$userD = $this->Users->find()->where(['Users.id' => $userID])->contain(['Carinformations','Countries'])->first();
			//pr($userD); die;
			if($userD){
				$UserDetail['userId'] 				= ($userD->id) ? $userD->id : '';
				$UserDetail['fullName'] 			= ($userD->fullName) ? $userD->fullName : '';
				$UserDetail['lastName'] 			= ($userD->lastName) ? $userD->lastName : '';
				$UserDetail['middleName'] 			= ($userD->middleName) ? $userD->middleName : '';
				$UserDetail['email'] 				= ($userD->email) ? $userD->email : '';
				$UserDetail['gender'] 				= ($userD->gender) ? $userD->gender : '';
				$UserDetail['role'] 				= ($userD->role) ? $userD->role : '';
				$UserDetail['dob'] 					= ($userD->dob) ? $userD->dob : '';
				$UserDetail['address'] 				= ($userD->address) ? $userD->address : '';
				$UserDetail['zipCode'] 				= ($userD->zipCode) ? $userD->zipCode : '';
				$UserDetail['state'] 				= ($userD->state) ? $userD->state : '';
				$UserDetail['contactNumber'] 		= ($userD->contactNumber) ? $userD->contactNumber :'';
				$UserDetail['countryCode'] 			= (@$userD->country->phonecode) ? @$userD->country->phonecode :'';
				$UserDetail['countryName'] 			= (@$userD->country->name) ? @$userD->country->name :'';
				$UserDetail['countryId'] 			= (@$userD->countryId) ? @$userD->countryId :'';
				
				$UserDetail['image'] 				= ($userD->profile_picture) ? $this->profilePath.$userD->profile_picture : '';
				if(strpos($userD->profile_picture, "http") !== false){
					$UserDetail['image'] = $userD->profile_picture;
				}
				$UserDetail['device'] 				= ($userD->device) ? $userD->device : '';
				$UserDetail['deviceToken'] 			= ($userD->deviceToken) ? $userD->deviceToken : '';
				$UserDetail['firebaseId'] 			= ($userD->firebaseId) ? $userD->firebaseId : '';
				$UserDetail['socialId'] 			= ($userD->socialId) ? $userD->socialId : '';
				$UserDetail['socialType'] 			= ($userD->socialType) ? $userD->socialType : '';
				
				$UserDetail['latitude'] 			= ($userD->latitude) ? $userD->latitude : '';
				$UserDetail['longitude'] 			= ($userD->longitude) ? $userD->longitude : '';

				$UserDetail['pickupAddress'] 		= ($userD->pickupAddress) ? $userD->pickupAddress : '';
				$UserDetail['dropAddress'] 			= ($userD->dropAddress) ? $userD->dropAddress : '';
				$UserDetail['pickup_Latitude'] 		= ($userD->pickup_Latitude) ? $userD->pickup_Latitude : '';
				$UserDetail['pickup_Longitude'] 	= ($userD->pickup_Longitude) ? $userD->pickup_Longitude : '';
				$UserDetail['drop_Latitude'] 		= ($userD->drop_Latitude) ? $userD->drop_Latitude : '';
				$UserDetail['drop_Longitude'] 		= ($userD->drop_Longitude) ? $userD->drop_Longitude : '';
				$UserDetail['Working_startDate'] 	= ($userD->Working_startDate) ? date('Y-m-d',strtotime($userD->Working_startDate)) : '';
				$UserDetail['Working_endDate'] 		= ($userD->Working_endDate) ? date('Y-m-d',strtotime($userD->Working_endDate)) : '';
				$UserDetail['Working_startTime'] 	= ($userD->Working_startTime) ? $userD->Working_startTime : '';
				$UserDetail['Working_endTime'] 		= ($userD->Working_endTime) ? $userD->Working_endTime : '';
				
				$UserDetail['drivingLicenceNo'] 	= ($userD->drivingLicenceNo) ? $userD->drivingLicenceNo : '';
				$UserDetail['LicenceExpiryDate'] 	= ($userD->LicenceExpiryDate) ? $userD->LicenceExpiryDate : '';
				$UserDetail['issueDate'] 			= ($userD->issueDate) ? $userD->issueDate : '';
				$UserDetail['vechicleType'] 		= ($userD->vechicleType) ? $userD->vechicleType : '';
				
				//This is use for NID image
				$UserDetail['ssnImage'] 			= ($userD->ssnImage) ? $this->profilePath.$userD->ssnImage : '';
				$UserDetail['DrivingLicenceImage']	= ($userD->DrivingLicenceImage) ? $this->profilePath.$userD->DrivingLicenceImage : '';
				//$UserDetail['AutoInsurance'] 		= ($userD->AutoInsurance) ? $this->profilePath.$userD->AutoInsurance : '';
				$UserDetail['SSN'] 					= ($userD->SSN) ? $userD->SSN : '';
				$UserDetail['INDNo'] 				= ($userD->INDNo) ? $userD->INDNo : '';
				
				$UserDetail['BankName'] 			= ($userD->BankName) ? $userD->BankName : '';
				$UserDetail['AccountHolderName'] 	= ($userD->AccountHolderName) ? $userD->AccountHolderName : '';
				$UserDetail['AccountNo'] 			= ($userD->AccountNo) ? $userD->AccountNo : '';
				$UserDetail['RoutingNo'] 			= ($userD->RoutingNo) ? $userD->RoutingNo : '';
				$UserDetail['AccountType'] 			= ($userD->AccountType) ? $userD->AccountType :'';
				$UserDetail['AVGRating'] 			= ($userD->AVGRating) ? $userD->AVGRating : 0;
				$UserDetail['wallet'] 				= ($userD->wallet) ? $userD->wallet : 0;
				$UserDetail['DriverOn'] 			= ($userD->DriverOn) ? $userD->DriverOn :'0';
				$DD = $this->carinformationlist($userID);
				$UserDetail['carinfromation'] 		= (@$DD['data']) ? @$DD['data'] : array();
				$UserDetail['AdminApproved'] 		= ($userD->AdminApproved) ? $userD->AdminApproved : 0;
				$UserDetail['OTP'] 					= ($userD->OTP) ? $userD->OTP : '';
				$UserDetail['update_admin_approve']	= ($userD->update_admin_approve) ? $userD->update_admin_approve : '';
				$UserDetail['status'] 				= ($userD->status) ? $userD->status : 0;
				if($userD->role == 'Member'){
					$booking = $this->Bookings->find()->where(['Bookings.userId'=>$userD->id])->order(['Bookings.id'=>'desc'])->first();
				}else{
					$booking = $this->Bookings->find()->where(['Bookings.driverId'=>$userD->id])->order(['Bookings.id'=>'desc'])->first();
				}
				$UserDetail['status'] 				= ($userD->status) ? $userD->status : 0;
				$UserDetail['Last_booking_status'] 	= (@$booking->rideStatus) ?  @$booking->rideStatus : '';
				$UserDetail['Last_booking_id'] 		= (@$booking->id) ?  @$booking->id : '';

				
				
			}else{
				$response['status'] = 'Fails';
				$response['msg'] = 'UserId required';
			}
			$response['status'] = 'success';
			$response['data'] = (@$UserDetail) ? @$UserDetail : array();
			$response['msg']  = "Profile Updated Successfully"; 
			$response['AuthToken'] = $this->encodejwtreturn();
			return  $response;
	}
	
	private function socialLoginAction(){
		$this->loadModel('Users');
		if($this->request->data('socialId') !='' && $this->request->data('socialType') !=''){
			$this->loadModel('Users');
			$usr = $this->Users->find()->where(['Users.socialId' => $this->request->data('socialId'),'Users.socialType' => $this->request->data('socialType')])->first();
			$users= array();
			if(@$this->request->data['email'] !=''){
				$users = $this->Users->find()->where(['Users.email' => $this->request->data('email')])->first();
			}
			if(empty($usr)){
				if(empty($users)){
					$users = $this->Users->newEntity();
				}
				$users = $this->Users->patchEntity($users, $this->request->data, ['validate' => false]);
				$users['created'] 	= date('Y-m-d H:i:s');
				$users['username'] 	= $this->request->data('email');
				$users['status'] 	= '1';
				$users['role'] 		= 'Member';
				//$users['profile_picture'] 		= $this->request->data('image');
				
				//$path = WWW_ROOT . 'img/uploads/feature/original/';
				if ($this->Users->save($users)) {
					$response['status'] = 'success';
					$response['msg'] = 'Data save successfully.';
					$DD = $this->profile($users->id);
					$response['data'] = $DD['data'];
					$response['AuthToken'] = $this->encodejwtreturn();
				}
			}else{
				$response['status'] = 'success';
				$response['msg'] = 'Data save successfully.';
				$DD = $this->profile($usr->id);
				$response['data'] = $DD['data'];
			}
		}else{
			$response['status'] = 'Fails';
			$response['msg'] = 'Email, fullName, socialId and socialType required';
		}
		return  $response;
	}
	
	
	private function editprofile(){
		$this->loadModel('Users');
		if($this->request->data('userId') !=''){
			$this->loadModel('Users');
			$users = $this->Users->find()->where(['Users.id' => $this->request->data('userId')])->first();
			if(!empty($users)){
				//ssnImage:   == Photo Identityfication
				//drivlingImage:    ==Business Licence
				//AutoInsurance:    ==business Insurance
				unset($this->request->data['ssnImage']);
				unset($this->request->data['drivlingImage']);
				unset($this->request->data['AutoInsurance']);
				unset($this->request->data['DrivingLicenceImage']);
				//@unset($this->request->data('email'));
				$users = $this->Users->patchEntity($users, $this->request->data, ['validate' => false]);
				if(@$this->request->data['Working_startDate'] !=''){
					$users['Working_startDate'] = date('Y-m-d',strtotime(@$this->request->data['Working_startDate']));
				}
				if(@$this->request->data['Working_endDate'] !=''){
					$users['Working_endDate'] = date('Y-m-d',strtotime(@$this->request->data['Working_endDate']));
				}
				if(@$this->request->data['Working_startTime'] !=''){
					$users['Working_startTime'] = date('H:i',strtotime(@$this->request->data['Working_startTime']));
				}
				if(@$this->request->data['Working_endTime'] !=''){
					$users['Working_endTime'] = date('H:i',strtotime(@$this->request->data['Working_endTime']));
				}
				if(@$this->request->data['issueDate'] !=''){
					$users['issueDate'] = date('Y-m-d',strtotime(@$this->request->data['issueDate']));
				}
				if(@$this->request->data['LicenceExpiryDate'] !=''){
					$users['LicenceExpiryDate'] = date('Y-m-d',strtotime(@$this->request->data['LicenceExpiryDate']));
				}
				$fileName = '';
				if(@$this->request->data['image']['name'] !='' && @$this->request->data['image']['error'] == 0 ){
					$fileName=time().stripslashes(@$this->request->data['image']['name']);
					$fileName= str_replace(" ","",$fileName);
					$users['profile_picture']=$fileName;
					$url = $this->profilePath.$users->profile_picture;
					@unlink($url);
				}
				$fileName2 = '';
				if(@$_FILES['ssnImage']['name']){    // this is use for NID iamge
					$fileName2=time().stripslashes($_FILES['ssnImage']['name']);
					$fileName2= str_replace(" ","",$fileName2);
					$users['ssnImage']=$fileName2;
					$url = $this->profilePath.$users->ssnImage;
					@unlink($url);
				}
				$fileName3 = '';
				if(@$_FILES['DrivingLicenceImage']['name']){
					$fileName3=time().stripslashes($_FILES['DrivingLicenceImage']['name']);
					$fileName3= str_replace(" ","",$fileName3);
					$users['DrivingLicenceImage']=$fileName3;
					$users['driver_licence_image_approve']=0;
					$url = $this->profilePath.$users->DrivingLicenceImage;
					@unlink($url);
				}
				$fileName4 = '';
				if(@$_FILES['AutoInsurance']['name']){
					$fileName4=time().stripslashes($_FILES['AutoInsurance']['name']);
					$fileName4= str_replace(" ","",$fileName4);
					$users['AutoInsurance']=$fileName4;
					$url = $this->profilePath.$users->AutoInsurance;
					@unlink($url);
				}
				$users['update_admin_approve'] = 2;
				//$path = WWW_ROOT . 'img/uploads/feature/original/';
				if ($this->Users->save($users)) {
					if(@$this->request->data['image']['name'] !='' && $fileName !=''){
						$target = WWW_ROOT.'/img/uploads/users/'.$fileName;
						$source=@$this->request->data['image']['tmp_name'];
						move_uploaded_file($source,$target);
					}
					if(@$_FILES['ssnImage']['name'] !='' && $fileName2 !=''){
						$target = WWW_ROOT.'/img/uploads/users/'.$fileName2;
						$source=$_FILES['ssnImage']['tmp_name'];
						move_uploaded_file($source,$target);
					}
					if(@$_FILES['DrivingLicenceImage']['name'] !='' && $fileName3 !=''){
						$target = WWW_ROOT.'/img/uploads/users/'.$fileName3;
						$source=$_FILES['DrivingLicenceImage']['tmp_name'];
						move_uploaded_file($source,$target);
					}
					if(@$_FILES['AutoInsurance']['name'] !='' && $fileName4 !=''){
						$target = WWW_ROOT.'/img/uploads/users/'.$fileName4;
						$source=$_FILES['AutoInsurance']['tmp_name'];
						move_uploaded_file($source,$target);
					}
					$response['status'] = 'success';
					$response['msg'] = 'Profile updated successfully';
					$DD = $this->profile($users->id);
					$response['data'] = $DD['data'];
					$response['AuthToken'] = $this->encodejwtreturn();
				}
			}else{
				$response['status'] = 'Fails';
				$response['msg'] = 'UserId does not exist';
			}
		}else{
			$response['status'] = 'Fails';
			$response['msg'] = 'UserID is required';
		}
		return  $response;
	}
	
	
	private function changepassword(){
		$this->loadModel('Users');
		if($this->request->data('userId')){
			$users = $this->Users->find()->Where(['Users.id' => $this->request->data('userId')])->first();
			$check = (new DefaultPasswordHasher)->check($this->request->data('oldPassword'), $users->password);
			if($check){
				$users = $this->Users->patchEntity($users, ['password'=> $this->request->data('newPassword'),'Pcode' => base64_encode($this->request->data['newPassword'])],['validate' => false]);
				$this->Users->save($users);
				$response['status'] = 'success';
				$response['msg'] = 'Password Updated Successfully.';
				$response['AuthToken'] = $this->encodejwtreturn();
			}else{
				$response['status'] = 'Fails';
				$response['msg'] = 'Current password does not match.';
			}
		}else{
			$response['status'] = 'Fails';
			$response['msg'] = 'UserId is required.';
		}
		return  $response;
	}
	
	function forgotpassword(){
		$this->loadModel('Users');
		if($this->request->data('email')){
			$users = $this->Users->find()->Where(['Users.role !='=>'Admin','Users.email' => $this->request->data('email')])->first();
			$OLDPASS = base64_decode(@$users->Pcode);
			//$check = (new DefaultPasswordHasher)->check($this->request->data('oldPassword'), $users->password);
			if($users){
				$Token = rand(111111,999999);
				$users = $this->Users->patchEntity($users, ['passwordToken'=> $Token],['validate' => false]);
				$this->Users->save($users);
				//$to = $users->email;
				$to = 'raushan@mailinator.com';
				$subject = 'ParhMark-Reset Password '.$to;
				$message="Dear ".ucfirst($users->fullName);
				$message.="<br><br> You have request for the reset password. Your new credentials is given below:";
				$message.='<br>Name: '.ucfirst($users->fullName);
				$message.='<br>Email: '.$this->request->data['email'].'<br>Token: '.$Token;
				$this->phpemail($to,$subject,$message);

				$nuber = $mob_number=substr($users->contactNumber,-10);
				if(mb_strlen($nuber) == 10){
					$nub = "0".$nuber;
					$msg = "ZARIB login request,  Your login OTP is ".$Token;
					$this->sendotp($nub, $msg);
				}
								
				$response['status'] = 'success';
				$response['email'] = $users->email;
				$response['userId'] = $users->id;
				$response['contactNumber'] = $users->contactNumber;
				$response['msg'] = 'Password reset token sent to the registered email.';
			}else{
				$response['status'] = 'Fails';
				$response['msg'] = 'Email does not exist with zarib.';
			}
		}else{
			$response['status'] = 'Fails';
			$response['msg'] = 'email is required.';
		}
		return  $response;
	}
	
	function forgotresendotp(){
		if($this->request->data('userId') !=''){
			$this->loadModel('Users');
			$usr = $this->Users->find()->where(['Users.id'=>$this->request->data('userId')])->first();
			if(@$usr->id != ''){
				//$OTP = rand(111111,999999);
				//$articles = TableRegistry::get('Users');
				//	$query = $articles->query();
				//	$query->update()
				//	->set(['passwordToken' =>$OTP])
				//	->where(['id' => $usr->id])
				//	->execute();
				//$MSG = 'Pludin code '.$OTP;
				//$number = trim($usr->countryCode).substr(trim($usr->contactNumber),-10);
				//$this->sendsmsnew($number,$MSG);
				
				$to = $users->email;
				$subject = 'Zarib-Reset Password '.$to;
				$message="Dear ".ucfirst($users->fullName);
				$message.="<br><br> You have request for the reset password. Your new credentials is given below:";
				$message.='<br>Name: '.ucfirst($users->fullName);
				$message.='<br>Email: '.$this->request->data['email'].'<br>Token: '.$usr->passwordToken;
				$this->phpemail($to,$subject,$message);
				
				$response['status'] = 'success';
				$response['msg'] = 'Resend the OTP with the registered email address';
			}else{
				$response['status'] = 'Fails';
				$response['msg'] = 'Phone already verified.';
			}
		}
			return  $response;
	}

	
	
	function resetpassword(){
		$this->loadModel('Users');
		if($this->request->data['email'] !='' && @$this->request->data['OTP'] !='' && @$this->request->data['password'] !=''){
			$users = $this->Users->find()->where(['Users.email' => $this->request->data['email']])->first();
			//echo "<pre>"; print_r($users); die('fff');
			//$OLDP = base64_decode($users->FP);
			if(@$users->passwordToken == $this->request->data['OTP']){
				$users = $this->Users->patchEntity($users, ['passwordToken'=>'','password'=> $this->request->data['password']],['validate' => false]);
				$this->Users->save($users);
				//$re = $this->updatefirebasepassword($users->email, base64_decode($users->FP),$this->request->data['password']);
				$response['status'] 		= 'success';
				$response['email'] 			= $this->request->data['email'];
				//$response['oldpassword'] 	= $OLDP;
				$response['newpassword'] 	= $this->request->data['password'];
				$response['msg'] 			= 'Password update successfully.';
			}else{
				$response['status'] = 'Fails';
				$response['msg'] = 'OTP not valid';
			}
		}else{
			$response['status'] = 'Fails';
			$response['msg'] = 'email, OTP and password are required.';
		}
		return  $response;
	}
		
	
	
	private function termAndConditions(){
		$this->loadModel('Pages');
		$pages = $this->Pages->find()->Where(['Pages.id' => 5])->first();
		$response['status'] = 'success';
		$response['msg'] = $pages->content;
		if(@$this->request->data['language'] == 'bn'){
			$response['msg'] = $pages->content_B;
		}
		$response['msg_B'] = $pages->content_B;
		$response['AuthToken'] = $this->encodejwtreturn();
		return  $response;
	}
	
	private function privacypolicy(){
		$this->loadModel('Pages');
		$pages = $this->Pages->find()->Where(['Pages.id' => 4])->first();
		$response['status'] = 'success';
		$response['msg'] = $pages->content;
		if(@$this->request->data['language'] == 'bn'){
			$response['msg'] = $pages->content_B;
		}
		$response['msg_B'] = $pages->content_B;
		$response['AuthToken'] = $this->encodejwtreturn();
		return  $response;
	}

	private function termAndConditions_user(){
		$this->loadModel('Pages');
		$pages = $this->Pages->find()->Where(['Pages.id' => 8])->first();
		$response['status'] = 'success';
		$response['msg'] = $pages->content;
		if(@$this->request->data['language'] == 'bn'){
			$response['msg'] = $pages->content_B;
		}
		$response['msg_B'] = $pages->content_B;
		$response['AuthToken'] = $this->encodejwtreturn();
		return  $response;
	}
	
	private function privacypolicy_user(){
		$this->loadModel('Pages');
		$pages = $this->Pages->find()->Where(['Pages.id' => 7])->first();
		$response['status'] = 'success';
		$response['msg'] = $pages->content;
		if(@$this->request->data['language'] == 'bn'){
			$response['msg'] = $pages->content_B;
		}
		$response['msg_B'] = $pages->content_B;
		$response['AuthToken'] = $this->encodejwtreturn();
		return  $response;
	}

	private function disclamer(){
		$this->loadModel('Pages');
		$pages = $this->Pages->find()->Where(['Pages.id' => 2])->first();
		$response['status'] = 'success';
		$response['msg'] = (@$pages->content) ? @$pages->content : '';
		if(@$this->request->data['language'] == 'bn'){
			$response['msg'] = (@$pages->content_B) ? @$pages->content_B : '';
		}
		$response['AuthToken'] = $this->encodejwtreturn();
		return  $response;
	}
	
	
	private function aboutus(){
		$this->loadModel('Pages');
		$pages = $this->Pages->find()->Where(['Pages.id' => 3])->first();
		$response['status'] = 'success';
		$response['msg'] = (@$pages->content) ? @$pages->content : '';
		$response['AuthToken'] = $this->encodejwtreturn();
		return  $response;
	}
	
	private function faq(){
		$this->loadModel('Faqs');
		$conditions[] = ['Faqs.status' => 1];
		$type = (@$this->request->data['type']) ? @$this->request->data['type'] : '';
		if($type !=''){
			$conditions[] = ['Faqs.type' => $type];
		}
		$pages = $this->Faqs->find()->Where($conditions)->toArray();
		$i=0;
		$array = array();
		if($pages){
			foreach($pages as $page){
				$array[$i]['id'] 		= $page->id;
				$array[$i]['question'] 	= $page->question;
				$array[$i]['answer'] 	= $page->answer;
				if(@$this->request->data['language'] == 'bn'){
					$array[$i]['question'] = ($page->question_B) ? $page->question_B : '';
					$array[$i]['answer'] 	= ($page->answer_B) ? $page->answer_B : '';
				}
				$array[$i]['question_B'] = ($page->question_B) ? $page->question_B : '';
				$array[$i]['answer_B'] 	= ($page->answer_B) ? $page->answer_B : '';
				$i++;
			}
		}
		$response['status'] = 'success';
		$response['data'] = $array;
		$response['AuthToken'] = $this->encodejwtreturn();
		return  $response;
	}
	
	
	private function countrylist(){
		$this->loadModel('Countries');
		$parentCountryList = $this->Countries->find()->where(['Countries.status'=>1])->order(['Countries.name'=>'ASC'])->toArray();
		$PC = array();
		$list = array();
		foreach($parentCountryList as $key=>$VV){
			$PC['id'] = $VV->id;
			$PC['name'] = $VV->name;
			if(@$this->request->data['language'] == 'bn'){
				$PC['name'] = $VV->name_B;
			}else{
				$PC['name'] = $VV->name;
			}
			$PC['phonecode'] = '+'.$VV->phonecode;
			$list[] = $PC;
		}
		$response['status'] = "success";
		$response['data'] = ($list) ? $list : array();
		return $response;
	}
				
				
				
	private function category($type=NULL){
		$this->loadModel('Categories');
		$Type = (isset($this->request->data['TYPE'])) ? @$this->request->data['TYPE'] : '';
		if($Type !=''){
			$conditons = array('Categories.status' => '1', 'Categories.TYPE' => $Type , 'Categories.parentId' => 0);
		}else{
			$conditons = array('Categories.status' => '1', 'Categories.parentId' => 0);
		}
		//$conditons = array('Categories.status' => '1', 'Categories.TYPE' => $Type , 'Categories.parentId' => 0);
		if(isset($this->request->data['keyword']) && $this->request->data['keyword'] !=''){
			$conditons = array('Categories.name LIKE' =>'%'.$this->request->data['keyword'].'%','Categories.status' => '1' , 'Categories.parentId' => 0);
		}
		$cat=$this->Categories->find('all')->where($conditons)->toArray();
		$carArray=array();
		$i=0;
		//$cat=$this->array_filter_recursive($cat);
		foreach($cat as $v){
			$carArray[$i]['id'] 		= $v->id;
			if(@$this->request->data['language'] == 'bn'){
				$carArray[$i]['name'] 		= $v->name_B;
			}else{
				$carArray[$i]['name'] 		= $v->name;
			}
			
			$carArray[$i]['TYPE'] 		= $v->TYPE;
			$carArray[$i]['noOfPerson'] = $v->noOfPerson;
			$carArray[$i]['perMile'] 	= ($v->perMile) ? $v->perMile : "0";
			$carArray[$i]['image'] 		= ($v->image) ? $this->catPath.$v->image : '';
			$i++; 
		}
		$response['status'] = "success";
		$response['data'] = ($carArray) ? $this->array_filter_recursive($carArray) : array();
		$response['AuthToken'] = $this->encodejwtreturn();
		return $response; 
	}
			
	private function statelist(){
		$this->loadModel('States');
		$parentCountryList = $this->States->find()->where(['States.country_id'=>231, 'States.status'=>1])->order(['States.name'=>'ASC'])->toArray();
		$PC = array();
		foreach($parentCountryList as $key=>$VV){
			$PC['id'] 	= $VV->id;
			$PC['name'] = $VV->name;
			if(@$this->request->data['language'] == 'bn'){
				$PC['name'] = $VV->name_b;
			}else{
				$PC['name'] = $VV->name;
			}
			$list[] 	= $PC;
		}
		$response['status'] = "success";
		$response['data'] = $list;
		$response['AuthToken'] = $this->encodejwtreturn();
		return $response;
	}
				
	private function updatepayment(){
		if($this->request->data['userId'] !='' && $this->request->data['bookingId'] !='' && $this->request->data['transactionId'] !='' && $this->request->data['totalAmount'] !=''){
			$this->loadModel('Bookings');
			$this->loadModel('Transactions');
			$paymentID = (@$this->request->data['paymentID']) ? @$this->request->data['paymentID'] : '';

			$bookings = $this->Bookings->find()->where(['Bookings.id'=>$this->request->data['bookingId']])->contain(['Users','Drivers','Categories'])->first();
			
			$DriverAmount = round((((float)$this->request->data['totalAmount'] - ((float)@$this->request->data['TIP'] + $bookings->last_cancel_amount)) * 0.85),2) + (float)@$this->request->data['TIP'];
			
			$articles = TableRegistry::get('Bookings');
			$query = $articles->query();
			$query->update()
				->set(['paymentID'=>$paymentID,'driverAmount'=>$DriverAmount,'paymentMethod'=>$this->request->data['paymentMethod'],'rideStatus'=>5,'paymentStatus'=>1,'totalAmount' =>@$this->request->data['totalAmount'],'transactionId'=>@$this->request->data['transactionId'], 'couponCode'=>@$this->request->data['couponCode'],'discountAmount'=>@$this->request->data['discountAmount'],'TIP'=>@$this->request->data['TIP']])
				->where(['id' => $this->request->data['bookingId']])
				->execute();
			
			if(@$bookings->last_cancel_amount > 0){
				$exxp = explode(",", $bookings->last_cancle_bookingId);
				foreach($exxp as $getId){
					$articles2 = TableRegistry::get('Bookings');
					$query2 = $articles2->query();
					$query2->update()
						->set(['paymentID'=>$paymentID,'paymentMethod'=>$this->request->data['paymentMethod'],'paymentStatus'=>1,'transactionId'=>@$this->request->data['transactionId']])
						->where(['id' => $getId])
						->execute();
				}
				
			}
			
			if(strtolower($this->request->data['paymentMethod']) == 'cash'){
				$articles = TableRegistry::get('Users');
				$query = $articles->query();
				$query->update()
				->set($query->newExpr('wallet = wallet - '.(float)(@$this->request->data['totalAmount'] - @$DriverAmount)))
				->where(['id' => @$bookings->driverId])
				->execute();
			}else{
				$articles = TableRegistry::get('Users');
				$query = $articles->query();
				$query->update()
				->set($query->newExpr('wallet = wallet + '.(float)@$DriverAmount))
				->where(['id' => @$bookings->driverId])
				->execute();
			}
			
			$TransactionsData['userId'] 				= $bookings->userId;
			$TransactionsData['driverId'] 				= $bookings->driverId;
			$TransactionsData['bookingId'] 				= $bookings->id;
			$TransactionsData['amount'] 				= $this->request->data['totalAmount'];
			$TransactionsData['paymentMethod']			= $this->request->data['paymentMethod'];
			
			$Transactions = $this->Transactions->newEntity();
			$Transactions = $this->Transactions->patchEntity($Transactions, $TransactionsData, ['validate' => false]);
			$Transactions['created'] 	= date('Y-m-d H:i:s');
			$Transactions['status'] 	= '1';
			$this->Transactions->save($Transactions);
		//pr($bookings); die;
		//$to='raushan.kumar@evirtualservices.com';

			$email_data['Custome_name'] 	= @$bookings->user->fullName;
			$email_data['invoice_id'] 		= @$bookings->id;
			$email_data['date'] 			= date('Y-m-d',strtotime(@$bookings->bookingDate));
			$email_data['pickup_location'] 	= @$bookings->Actual_PickupAddress;
			$email_data['drop_location'] 	= @$bookings->Actual_Drop_Address;
			$email_data['distance'] 		= @$bookings->totalDistance;
			$email_data['time'] 			= @$bookings->totalTime;
			$email_data['total_Amount'] 	= @$this->request->data['totalAmount'];
			$email_data['TIP'] 				= @$this->request->data['TIP'];
			$email_data['Booking_Fee'] 		= @$bookings->bookingFee;
			$email_data['p_cancelation'] 	= @$bookings->last_cancel_amount;
			$email_data['discount'] 		= @$this->request->data['discountAmount'];
			$email_data['payment_method'] 	= @$this->request->data['paymentMethod'];
			$email_data['Driver_name'] 		= @$bookings->driver->fullName;
			$email_data['driver_image'] 	= $this->profilePath.@$bookings->driver->profile_picture;
			$email_data['driver_rating'] 	= @$bookings->driver->AVGRating;
			$email_data['carType'] 			= @$bookings->category->TYPE; 
			$email_data['promotional_discount'] 			= @$bookings->promotional_discount; 
			$email_data['promotional_percentage'] 			= @$bookings->promotional_percentage; 
			$email_data['FinalFare'] 			= @$bookings->FinalFare; 
			$email_data['totalAmount'] 			= @$bookings->totalAmount; 
			$to = @$bookings->user->email;
			$subject = "Payment Invoice";
			//pr($email_data); die;
			if($to){
				//$to = 'raushan@mailinator.com';
				$this->caremail($to, $subject, $email_data);
			}
			
			//$bodyU['message'] 	= 'Your booking has been completed.';
			$bodyU['message'] 		= 'Your payment of '.$this->request->data['totalAmount'].' for your recent ride has been successfully processed.';
			$bodyU['type'] 			= 'Payment';
			if(strtolower(@$bookings->user->device) =='ios'){
				$this->sednIosPushNotification(@$bookings->user->deviceToken,$bodyU);
			}else{
				$this->sendNotificationOnAndroid(@$bookings->user->deviceToken,$bodyU);
			}
			
			//$bodyV['message'] 		= 'Your payment has been completed';
			$bodyV['message'] 		= 'Payment of '.@$this->request->data['totalAmount'].' for your recent ride with '.$bookings->user->fullName.' has been processed.';
			$bodyV['type'] 			= 'Payment';
			$bodyV['totalAmount'] 	= @$this->request->data['totalAmount'];
			$bodyV['paymentMethod'] = @$this->request->data['paymentMethod'];
			$bodyV['bookingId'] 	= $bookings->id;
			$bodyV['Actual_PickupAddress']	= $bookings->Actual_PickupAddress;
			$bodyV['Actual_Drop_Address']	= $bookings->Actual_Drop_Address;
			$bodyV['userId']	= $bookings->userId;
			if(strtolower(@$bookings->driver->device) =='ios'){
				$this->sednIosPushNotification(@$bookings->driver->deviceToken,$bodyV);
			}else{
				$this->sendNotificationOnAndroid(@$bookings->driver->deviceToken,$bodyV);
			}
							
			//$bookings = $this->Bookings->find()->where(['Bookings.id'=>$this->request->data['bookingId'], 'Bookings.userId'=>$this->request->data['userId']])->first();
			//$bookings = $this->Bookings->patchEntity($bookings, $INVO, ['validate' => false]);
			//$Booking['status'] 		= '0';
			//$this->Bookings->save($Booking);
			
			$response['status'] = "success";
			$response['msg'] = 'Booking payment successfully.';
			if(@$this->request->data['language'] =='bn'){
				$response['msg'] ="বুকিং পেমেন্ট সফল";
			}
			$response['AuthToken'] = $this->encodejwtreturn();
		}else{
			$response['status'] = 'Fail';
			$response['msg'] = 'userId, transactionId, totalAmount and bookingId are required';	
		}
		return $response; 
	}

	function updateadminpayment(){
		$this->loadModel('Adminpayments');
		if($this->request->data['userId'] !='' && $this->request->data['amount'] !='' && $this->request->data['transactionId'] !=''){
			$reviews = $this->Adminpayments->newEntity();
			$reviews = $this->Adminpayments->patchEntity($reviews, $this->request->data, ['validate' => false]);
			$reviews['created'] 	= date('Y-m-d H:i:s');
			$this->Adminpayments->save($reviews);

			// $articles = TableRegistry::get('Users');
			// 	$query = $articles->query();
			// 	$query->update()
			// 	->set($query->newExpr('wallet = wallet + '.(float)@$this->request->data['amount']))
			// 	->where(['id' => $this->request->data['userId']])
			// 	->execute();

			$response['status'] = "success";
			$response['msg'] = 'Update payment successfully.';
		}else{
			$response['status'] = 'Fail';
			$response['msg'] = 'userId, transactionId, and amount are required';	
		}
		return $response;  
	}

	private function upadteadminpaymentlist($userId=NULL){
		$this->loadModel('Adminpayments');
		@$USERID = ($userId) ? $userId : $this->request->data('userId');
		@$pageNo = ($this->request->data['pageNo']) ? $this->request->data['pageNo'] : 1;
		if($USERID !=''){
			$this->paginate = [
				'limit' => '10',//$limit,
				'order' => ['Adminpayments.id' => 'desc'],
				'page'=>$pageNo,
			];
			$condition[] = ['Adminpayments.userId'=>$USERID];
			$userservices = array();    
			$query = $this->Adminpayments->find('all')->where($condition);
			$totalCount =  $query->count();
			if($pageNo <= ceil($totalCount/10)){
				$userservices = $this->paginate($query);
				$userservices = $userservices->toArray();
			}
			$Darray = array();
			$i=0;
			//echo "<pre>"; print_r($userservices); die;
			foreach($userservices as $val){
				$Darray[$i]['adminpaymentId'] 		= ($val->id) ? $val->id : '';
				$Darray[$i]['amount'] 				= ($val->amount) ? $val->amount : '';
				$Darray[$i]['PaymentMethod'] 		= ($val->PaymentMethod) ? $val->PaymentMethod : '';
				$Darray[$i]['transactionId'] 		= ($val->transactionId) ? $val->transactionId : '';
				$Darray[$i]['status'] 				= ($val->status) ? $val->status : '';
				$Darray[$i]['created'] 				= ($val->created) ? date("M jS, Y, g:i a", strtotime($val->created)) : '';
				$i++;
			}
			$response['status'] = "success";
			$response['data'] 			= ($Darray) ? $this->array_filter_recursive($Darray) : array();
			$response['AuthToken'] = $this->encodejwtreturn();
		}else{
			$response['status'] = 'Fails';
			$response['msg'] = 'USERID is required.';
		}
		return  $response;
	}
	
			
	private function finddriver(){
		$this->loadModel('Users');
		if($this->request->data('userId') !='' && $this->request->data('latitude') !='' && $this->request->data('longitude') !=''){
			$latitude 	= $this->request->data['latitude']; 
			$longitude	= $this->request->data['longitude'];
			$conn = ConnectionManager::get('default');
			$radius = "( 3959 * acos( cos( radians($latitude) ) * cos( radians(latitude) ) * cos( radians(longitude) - radians($longitude))  + sin(radians($latitude ))	* sin( radians(latitude))))";
			//$query = "SELECT id, address, fullName, AVGRating,latitude,longitude,profile_picture,contactNumber, $radius AS distance FROM users WHERE status=1 AND DriverOn=1 AND deviceToken !='' AND `role`='Driver' HAVING distance < 100 ORDER BY distance LIMIT 0 , 500";
			$query = "SELECT id, address, fullName, AVGRating,latitude,longitude,profile_picture,device,deviceToken,contactNumber, $radius AS distance FROM users WHERE status= 1 AND DriverOn= 1 AND deviceToken !='' AND latitude !='' AND `role`='Driver' HAVING distance < 2 ORDER BY distance LIMIT 0 , 100";

			$stmt = $conn->execute($query);
			$results = $stmt ->fetchAll('assoc');
			//echo "<pre>"; print_r($results); die;
			$i = 0;
			$array = array();
			foreach($results as $val){
				$array[$i]['id'] = $val['id'];
				$array[$i]['fullName'] 				= ($val['fullName']) ? $val['fullName'] : '';
				$array[$i]['latitude'] 				= ($val['latitude']) ? $val['latitude'] : '';
				$array[$i]['longitude'] 			= ($val['longitude']) ? $val['longitude'] : '';
				$array[$i]['address'] 				= ($val['address']) ? $val['address'] : '';
				$array[$i]['AVGRating'] 			= ($val['AVGRating']) ? $val['AVGRating'] : '0';
				$array[$i]['contactNumber'] 		= ($val['contactNumber']) ? $val['contactNumber'] : '';
				$array[$i]['profile_picture'] 		= ($val['profile_picture']) ? $this->profilePath.$val['profile_picture'] : '';
				$array[$i]['distance'] 				= $this->distance($latitude,$longitude,$val['latitude'], $val['longitude']);
				$i++;
			}
			$response['status'] = "success";
			$response['data'] = ($array) ? $this->array_filter_recursive($array) : array();
			$response['AuthToken'] = $this->encodejwtreturn();
		}else{
			$response['status'] = 'Fail';
			$response['msg'] = 'userId, latitude and longitude are required';	
		}
		return $response; 
	}
			
			
	private function addbooking(){
		$this->loadModel('Bookings');
		$this->loadModel('Users');
		$this->loadModel('Categories');
		$this->loadModel('Bookingrequests');
		//die;
		if($this->request->data['userId'] !='' && $this->request->data['categoryId'] !='' && $this->request->data['RequestPickupAddress'] !='' && $this->request->data['RequestPickupLatLong'] !='' && $this->request->data['RequestDropAddress'] !='' && $this->request->data['RequestDropLatLong'] !=''){
		$PICKUPLATLONG = explode(",",$this->request->data['RequestPickupLatLong']);
		$latitude 	= $PICKUPLATLONG[0];
		$longitude	= $PICKUPLATLONG[1];

		$DropLATLONG = explode(",",$this->request->data['RequestDropLatLong']);
		$Droplatitude 	= $DropLATLONG[0];
		$Droplongitude	= $DropLATLONG[1];

		$USERS = $this->Users->find()->where(['Users.id'=>$this->request->data['userId']])->first();
		$CategoryID = $this->Categories->find()->where(['Categories.id'=>$this->request->data['categoryId']])->first(); 
		$conn = ConnectionManager::get('default');
		$radius = "( 3959 * acos( cos( radians($latitude) ) * cos( radians(latitude) ) * cos( radians(longitude) - radians($longitude))  + sin(radians($latitude ))	* sin( radians(latitude))))";
		//$radiusDrop = "( 3959 * acos( cos( radians($Droplatitude) ) * cos( radians(drop_Latitude) ) * cos( radians(drop_Longitude) - radians($Droplongitude))  + sin(radians($Droplatitude ))	* sin( radians(drop_Latitude))))";
		//$radiusPickup = "( 3959 * acos( cos( radians($latitude) ) * cos( radians(pickup_Latitude) ) * cos( radians(pickup_Longitude) - radians($longitude))  + sin(radians($latitude ))	* sin( radians(pickup_Latitude))))";
		$DATE = (@$this->request->data['bookingDate']) ? date('Y-m-d',strtotime(@$this->request->data['bookingDate'])) : date('Y-m-d');
		$query = "SELECT id, address, fullName, categoryId,profile_picture,device,deviceToken,contactNumber, $radius AS distance FROM users WHERE status= 1 AND DriverOn= 1 AND deviceToken !='' AND FIND_IN_SET(".$this->request->data['categoryId'].",categoryId) AND `role`='Driver' HAVING distance < 2 ORDER BY distance LIMIT 0 , 100";
		//DATE(NOW()) between Working_startDate and Working_endDate
		//$query = "SELECT id, address, fullName, categoryId,profile_picture,device,deviceToken,contactNumber, $radiusPickup AS distance, $radiusDrop AS distancedrop FROM users WHERE Working_startDate <= '$DATE' AND Working_endDate >= '$DATE' AND status= 1 AND DriverOn= 1 AND deviceToken !='' AND FIND_IN_SET(".$this->request->data['categoryId'].",categoryId) AND `role`='Driver' HAVING distance < 100 AND distancedrop < 100 ORDER BY distance LIMIT 0 , 1000";
		$stmt = $conn->execute($query);
		$results = $stmt ->fetchAll('assoc');
		
		$tastOrderId = $this->Bookings->find()->order(['Bookings.groupId'=>'desc'])->first();
		$groupID = 1;
		if(@$tastOrderId->groupId !=''){
			$groupID = (@$tastOrderId->groupId) + 1;
		}
		//pr($results); die('ddd');
			if($results){
				$booking = $this->Bookings->newEntity();
				$this->request->data['estimatedPrice'] 	= (@$this->request->data['estimateAmount']) ? @$this->request->data['estimateAmount'] : '';
				$this->request->data['totalTime'] 		= (@$this->request->data['duration']) ? @$this->request->data['duration'] : '';
				$this->request->data['totalDistance'] 	= (@$this->request->data['distance']) ?  @$this->request->data['distance'] : '';
				$booking = $this->Bookings->patchEntity($booking, $this->request->data, ['validate' => false]);
				$booking['created'] 		= date('Y-m-d H:i:s');
				$booking['RideCode'] = rand(111111,999999);
				if(@$this->request->data['bookingDate'] !=''){
					$booking['bookingDate'] 		= date('Y-m-d',strtotime($this->request->data['bookingDate']));
				}else{
					$booking['bookingDate'] = date('Y-m-d');
				}
				$booking['status'] 			= '1';
				$this->Bookings->save($booking);
				foreach($results as $val){
					$Request = $this->Bookingrequests->newEntity();
					$INV['driverId']		= $val['id'];
					$INV['bookingId']		= $booking->id;
					$Request = $this->Bookingrequests->patchEntity($Request, $INV, ['validate' => false]);
					$Request['created'] 		= date('Y-m-d H:i:s');
					$Request['status'] 			= '1';
					$this->Bookingrequests->save($Request);
					
					//$bodyV['message'] 					= 'New booking request for Confirm or Cancel.';
					$bodyV['message'] 					= 'New ride request from '.@$USERS->fullName;
					$bodyV['type'] 						= 'request';
					$bodyV['RequestPickupAddress'] 		= @$this->request->data['RequestPickupAddress'];
					$bodyV['RequestPickupLatLong'] 		= @$this->request->data['RequestPickupLatLong'];
					$bodyV['RequestDropAddress'] 		= @$this->request->data['RequestDropAddress'];
					$bodyV['RequestDropLatLong'] 		= @$this->request->data['RequestDropLatLong'];
					$bodyV['duration'] 					= @$this->request->data['duration'];
					$bodyV['distance'] 					= @$this->request->data['distance'];
					$bodyV['passenger_rating'] 			= @$USERS->AVGRating;
					$bodyV['bookingDate'] 				= date('m-d-Y',strtotime(@$this->request->data['bookingDate']));
					$bodyV['bookingTime'] 				= (@$this->request->data['bookingTime']) ? @$this->request->data['bookingTime'] : "";
					// $bodyV['CustomerImage'] 			= (@$val['profile_picture']) ? $this->profilePath.@$val['profile_picture'] : '';
					// $bodyV['CustomerName'] 				= (@$val['fullName']) ? @$val['fullName'] : '';
					// $bodyV['CustomerPhone'] 			= (@$val['contactNumber']) ? @$val['contactNumber'] : '';
					// $bodyV['device'] 					= (@$val['device']) ? @$val['device'] : '';
					// $bodyV['deviceToken'] 				= (@$val['deviceToken']) ? @$val['deviceToken'] : '';
					$bodyV['CustomerImage'] 			= (@$USERS->profile_picture) ? $this->profilePath.@$USERS->profile_picture : '';
					$bodyV['CustomerName'] 				= (@$USERS->fullName) ? @$USERS->fullName : '';
					$bodyV['CustomerPhone'] 			= (@$USERS->contactNumber) ? @$USERS->contactNumber : '';

					$bodyV['estimateAmount'] 			= @$this->request->data['estimateAmount'];
					$bodyV['bookingId'] 				= (@$booking->id) ? @$booking->id : '';
					$bodyV['RideCode'] 					= (@$booking->RideCode) ? @$booking->RideCode : '';
					
					if(strtolower(@$val['device']) =='ios'){
						$this->sednIosPushNotification(@$val['deviceToken'],$bodyV);
					}else{
						$this->sendNotificationOnAndroid(@$val['deviceToken'],$bodyV);
					}
					//pr($val);
					//pr($EE); die('ddd');
				}
				//echo "<pre>";
				$DDS = $this->checkaccept($booking->id, 1,$booking->categoryId);
				//$DDS = $this->checkaccept2($booking->id, 1);
				//echo $DDS['check'];
				//print_r($DDS); die;
				if($DDS['status'] == 'Fail'){
					$this->Bookingrequests->deleteAll(['Bookingrequests.bookingId'=>$booking->id]);
					$articles = TableRegistry::get('Bookings');
					$query = $articles->query();
					$query->update()
					->set(['rideStatus' =>6])
					->where(['id' => $booking->id])
					->execute();
				}else{
					$this->Bookingrequests->deleteAll(['Bookingrequests.bookingId'=>$booking->id]);
				}
				$response = $DDS;
				$response['AuthToken'] = $this->encodejwtreturn();
					
			}else{
				$response['status'] = 'Fail';
				$response['msg'] = 'Driver not found within 100 mile';
				if(@$this->request->data['language'] =='bn'){
					$response['msg'] = 'ড্রাইভার না 100 মাইল দিয়ে পাওয়া গেছে';
				}
			}
						
		}else{
			$response['status'] = 'Fail';
			$response['msg'] = 'userId, RequestPickupAddress,RequestDropAddress,RequestPickupLatLong,RequestDropLatLong and categoryId are required';	
		}
		return 	$response;
	}
	
		private function ccc($bookingID = NULL){
			$this->loadModel('Bookings');
			$categoryId = 2;
			$bookingID = $this->request->data['bookingID'];
			$bookingss = $this->Bookings->find()->where(['Bookings.id'=>$bookingID])->contain(['Drivers'=>
																['Carinformations'=>function($q){ return $q->where(['Carinformations.status'=>1,'Carinformations.categoryId'=>$categoryId]);}
																	]
																])->first();
			echo "<pre>";
			print_r($bookingss);
			die('ddddddddd');
		}
		
		private function checkaccept($bookingID=NULL,$time=NULL,$categoryId=NULL){
			$this->loadModel('Bookings');
			$bookingss = $this->Bookings->find()->where(['Bookings.id'=>$bookingID])->contain(['Drivers'=>['Carinformations']])->first();
			//print_r($booking);
			if(@$bookingss->driverId != 0){
				$DATA['bookingId'] 						= $bookingss->id;
				$DATA['userId'] 						= $bookingss->userId;
				$DATA['driverId'] 						= $bookingss->driverId;
				$DATA['RequestPickupAddress'] 			= $bookingss->RequestPickupAddress;
				$DATA['RequestDropAddress'] 			= $bookingss->RequestDropAddress;
				$DATA['RequestPickupLatLong'] 			= $bookingss->RequestPickupLatLong;
				$DATA['RequestDropLatLong'] 			= $bookingss->RequestDropLatLong;
				$DATA['bookingDate'] 					= $bookingss->bookingDate;
				$DATA['rideStatus'] 					= $bookingss->rideStatus;  //0=send, 1=accepted, 2=PickupArrived, 3=RideStart,4=dropStatus,5=PaymentDone
				
				$DATA['driverName'] 					= (@$bookingss->driver->fullName) ? @$bookingss->driver->fullName : '';
				$DATA['driverPhone'] 					= (@$bookingss->driver->contactNumber) ?  @$bookingss->driver->contactNumber : '';
				$DATA['carInformation'] 				= (@$bookingss->driver->carinformations) ? @$bookingss->driver->carinformations : array();
				$response['status'] = 'success';
				$response['bookingId'] = $bookingss->id;
				$response['data'] = $DATA;
				//echo "<pre>";
				//print_r($bookingss);print_r($DATA); die;
				//return 	$response;
				//return	json_encode($response);
			}else{
				if($time < 50){
					sleep(3);
					$Ttime = $time+3;
					$dd = $this->checkaccept($bookingID, $Ttime,$categoryId);
					if($dd['status'] == 'Fail'){
							$response = $dd;
					}else{
						$response = $dd;
					}
				}else{
					//die('NNNNNNNNNNNNNNNNN');
					$response['status'] = 'Fail';
					$response['msg'] = 'No vechicle is available. Please try again.';
					if(@$this->request->data['language'] =='bn'){
						$response['msg'] = 'কোনো যানবাহন পাওয়া যাচ্ছে না। কিছু সময় পরে চেষ্টা করুন.
';
					}
					//return	json_encode($response);
				}
			}
			return 	@$response;
		}
		
		private function driverconfirm(){
			$this->loadModel('Bookings');
			$this->loadModel('Users');
			$this->loadModel('Categories');
			$keyFeatures = Configure::read('keyFeatures');
			$Vechle_colors = $keyFeatures['Vechle_colors'];
			$Vechle_colors_B = $keyFeatures['Vechle_colors_B'];
			if($this->request->data['bookingId'] !='' && $this->request->data['driverId'] !=''){
				$driverD = $this->Users->find()->where(['Users.id'=>$this->request->data['driverId']])->contain(['Carinformations'])->first();
				$bookings = $this->Bookings->find()->where(['Bookings.id' => $this->request->data['bookingId'],'Bookings.driverId'=>0])->contain(['Users'])->first();
				if(!empty($bookings)){
					$articles = TableRegistry::get('Bookings');
					$query = $articles->query();
					$query->update()
					->set(['status' =>1,'rideStatus' =>1,'driverId' =>$this->request->data['driverId']])
					->where(['id' => $bookings->id])
					->execute();
					if($bookings->bookingDate =='' && $bookings->bookingTime ==''){
						// $articles2 = TableRegistry::get('Users');
						// $query2 = $articles2->query();
						// $query2->update()
						// ->set(['DriverOn' =>0])
						// ->where(['id' => $this->request->data['driverId']])
						// ->execute();
					}
					$response['status'] 					= 'success';
					$response['UserName'] 					= (@$bookings->user->fullName) ?  @$bookings->user->fullName : '';
					$response['userId'] 					= (@$bookings->user->id) ?  @$bookings->user->id : '';
					$response['userAVGRating'] 				= (@$bookings->user->AVGRating) ?  @$bookings->user->AVGRating : '';
					$response['userImage'] 					= (@$bookings->user->profile_picture) ?  $this->profilePath.@$bookings->user->profile_picture : '';
					$response['UserContactNumber'] 			= (@$bookings->user->contactNumber) ?  @$bookings->user->contactNumber : '';
					$response['RequestPickupAddress'] 		= (@$bookings->RequestPickupAddress) ?  @$bookings->RequestPickupAddress : '';
					$response['RequestDropAddress'] 		= (@$bookings->RequestDropAddress) ?  @$bookings->RequestDropAddress : '';
					$response['RequestPickupLatLong'] 		= (@$bookings->RequestPickupLatLong) ?  @$bookings->RequestPickupLatLong : '';
					$response['RequestDropLatLong'] 		= (@$bookings->RequestDropLatLong) ?  @$bookings->RequestDropLatLong : '';
					
					$response['msg'] 						= 'Confirmed successfully.';
					//$bodyU['message'] 						= @$driverD->fullName.' has confirmed your booking.';
					$bodyU['message'] 						= 'Your ride with '.@$driverD->fullName.' is confirmed';
					$bodyU['type'] 							= 'confirm';
					$bodyU['driverName'] 					= @$driverD->fullName;
					$bodyU['driverId'] 						= @$driverD->id;
					$bodyU['device'] 						= (@$driverD->device) ? @$driverD->device : '';
					$bodyU['deviceToken'] 					= (@$driverD->deviceToken) ? @$driverD->deviceToken : '';
					$bodyU['driverContact'] 				= @$driverD->contactNumber;
					$bodyU['estimatedPrice'] 				= @$bookings->estimatedPrice;
					$bodyU['totalTime'] 					= @$bookings->totalTime;
					$bodyU['totalDistance'] 				= @$bookings->totalDistance;
					$bodyU['RequestPickupAddress'] 			= @$bookings->RequestPickupAddress;
					$bodyU['RequestDropAddress'] 			= @$bookings->RequestDropAddress;
					$bodyU['RequestPickupLatLong'] 			= @$bookings->RequestPickupLatLong;
					$bodyU['RequestDropLatLong'] 			= @$bookings->RequestDropLatLong;
					$bodyU['bookingDate'] 					= @$bookings->bookingDate;
					$bodyU['bookingTime'] 					= @$bookings->bookingTime;
					$bodyU['DriverImage'] 					= ($driverD->profile_picture) ? $this->profilePath.$driverD->profile_picture : '';
					$bodyU['vehicleNumber']					= '';
					$bodyU['VehicleColor'] 					= '';
					$bodyU['vehicleType'] 					= '';
					$bodyU['driverLatitude'] 				= $driverD->latitude;
					$bodyU['driverlongitude'] 				= $driverD->longitude;
					$bodyU['rating'] 						= @$driverD->AVGRating;
					$bodyU['RideCode'] 						= @$bookings->RideCode;
					foreach($driverD->carinformations as $VV){
						if($VV->categoryId == $bookings->categoryId){
							$bodyU['vehicleNumber']= $VV->carNumber;
							$bodyU['VehicleColor'] = @$Vechle_colors[$VV->carColor];
							if(@$this->request->data['language'] =='bn'){
								$bodyU['VehicleColor'] = @$Vechle_colors_B[$VV->carColor];
							}
							$bodyU['vehicleType'] = $VV->vehicleType;
						}
					}
					$bodyU['bookingId'] 			= (@$bookings->id) ? @$bookings->id : '';
			
					//pr($driverD);pr($bodyU);die('ddd');
					if(strtolower(@$bookings->user->device) =='ios'){
						$this->sednIosPushNotification(@$bookings->user->deviceToken,$bodyU);
					}else{
						$this->sendNotificationOnAndroid(@$bookings->user->deviceToken,$bodyU);
					}

					$bodyV['message'] 						= 'You\'ve accepted a ride request from '.@$bookings->user->fullName.'. Navigate to their pickup location.';
					$bodyV['type'] 							= 'confirm';
					if(strtolower(@$driverD->device) =='ios'){
						$this->sednIosPushNotification(@$driverD->deviceToken,$bodyV);
					}else{
						$this->sendNotificationOnAndroid(@$driverD->deviceToken,$bodyV);
					}
					$response['AuthToken'] = $this->encodejwtreturn();
				}else{
					$response['status'] = 'Fails';
					$response['msg'] = 'Booking already close or accepted by someone\'s else';
					if(@$this->request->data['language'] =='bn'){
						$response['msg'] ="বুকিং ইতিমধ্যেই বন্ধ বা অন্য কেউ দ্বারা গৃহীত";
					}
				}
			}else{
				$response['status'] = 'Fails';
				$response['msg'] = 'bookingId and driverId are required';
			}
			return  $response;
		}
		
		private function customerverify(){
			$this->loadModel('Bookings');
			if($this->request->data['bookingId'] !='' && $this->request->data['userId'] !='' && $this->request->data['RideCode'] !=''){
				$bookings = $this->Bookings->find()->where(['Bookings.id' => $this->request->data['bookingId'],'Bookings.userId'=>$this->request->data['userId'],'Bookings.RideCode'=>$this->request->data['RideCode']])->contain(['Users','Drivers'=>['Carinformations']])->first();
				if(@$bookings->id !=''){

					$articles = TableRegistry::get('Bookings');
					$query = $articles->query();
					$query->update()
						->set(['RideCode' =>9])
						->where(['id' => $bookings->id])
						->execute();
					$response['status'] 			= 'success';
					$response['msg'] 				= 'booking verified successfully.';
					if(@$this->request->data['language'] =='bn'){
						$response['msg'] ="বুকিং সফলভাবে যাচাই করা হয়েছে";
					}
					$response['AuthToken'] = $this->encodejwtreturn();
					$bodyV['message'] 					='Booking confirmed. Now you can start the ride. ';
					$bodyV['type'] 						= 'booking confirmed';
					if(strtolower(@$bookings->driver->device) =='ios'){
						$this->sednIosPushNotification(@$bookings->driver->deviceToken,$bodyV);
					}else{
						$this->sendNotificationOnAndroid(@$bookings->driver->deviceToken,$bodyV);
					}
					
				}else{
					$response['status'] = 'Fails';
					$response['msg'] = 'Shared code invalid for this ride.';
					if(@$this->request->data['language'] =='bn'){
						$response['msg'] ="শেয়ার করা কোড এই রাইডের জন্য অবৈধ";
					}
				}
			}else{
				$response['status'] = 'Fails';
				$response['msg'] = 'bookingId, RideCode and driverId are required';
			}
			return  $response;
		}

		private function bookingverify(){
			$this->loadModel('Bookings');
			if($this->request->data['bookingId'] !='' && $this->request->data['driverId'] !=''){
				$bookings = $this->Bookings->find()->where(['Bookings.id' => $this->request->data['bookingId'],'Bookings.driverId'=>$this->request->data['driverId'],'Bookings.RideCode'=>9])->contain(['Users','Drivers'=>['Carinformations']])->first();
				if(@$bookings->id !=''){

					$newcondition = ['Bookings.driverId'=>$this->request->data['driverId'],
					'OR'=>[
						['Bookings.rideStatus IN'=>[3,4],'Bookings.bookingTime IS'=>NULL],
						['Bookings.rideStatus IN'=>[3,4],'Bookings.bookingTime <='=>date('H:i',time() + 1800),'Bookings.bookingDate'=>date('Y-m-d')]
						]
					];
					//echo date('Y-m-d H:i');
					//pr($newcondition);
					$historydata = $this->Bookings->find()->where($newcondition)->order(['Bookings.id'=>'desc'])->first();
					//pr($historydata); die('YESSSSSSSSSSSSS');
					
					if($historydata){
						$response['status'] = 'Fails';
						$response['msg'] = 'First you have to complete old ride.';
						if(@$this->request->data['language'] =='bn'){
							$response['msg'] ="প্রথমে আপনাকে পুরানো রাইড সম্পূর্ণ করতে হবে";
						}
					}else{
						$articles = TableRegistry::get('Bookings');
						$query = $articles->query();
						$query->update()
							->set(['RideCode' =>0])
							->where(['id' => $bookings->id])
							->execute();
						$response['status'] 			= 'success';
						$response['msg'] 				= 'booking verified successfully.';
						if(@$this->request->data['language'] =='bn'){
							$response['msg'] ="বুকিং সফলভাবে যাচাই করা হয়েছে";
						}
						$response['AuthToken'] = $this->encodejwtreturn();
					}
				}else{
					$response['status'] = 'Fails';
					$response['msg'] = 'Wait For Passenger Confirmation';
					if(@$this->request->data['language'] =='bn'){
						$response['msg'] ="শেয়ার করা কোড এই রাইডের জন্য অবৈধ";
					}
				}
			}else{
				$response['status'] = 'Fails';
				$response['msg'] = 'bookingId, RideCode and driverId are required';
			}
			return  $response;
		}



		private function driverarrived(){
			$this->loadModel('Bookings');
			if($this->request->data['bookingId'] !='' && $this->request->data['driverId'] !=''){
				$keyFeatures = Configure::read('keyFeatures');
				$Vechle_colors = $keyFeatures['Vechle_colors'];
				$Vechle_colors_B = $keyFeatures['Vechle_colors_B'];
				$bookings = $this->Bookings->find()->where(['Bookings.id' => $this->request->data['bookingId'],'Bookings.driverId'=>$this->request->data['driverId']])->contain(['Users','Drivers'=>['Carinformations']])->first();
				if(@$bookings->id !=''){
					$articles = TableRegistry::get('Bookings');
					$query = $articles->query();
					$query->update()
						->set(['rideStatus' =>2])
						->where(['id' => $bookings->id])
						->execute();
					
					//$bodyU['message'] 					= @$bookings->driver->fullName.' has arrived at your location.';
					$bodyU['message'] 					='Your driver, '.@$bookings->driver->fullName.', has arrived at your pickup location. Please meet them';
					$bodyU['type'] 						= 'arrived';
					$bodyU['driverName'] 				= @$bookings->driver->fullName;
					$bodyU['driverId'] 					= @$bookings->driver->id;
					$bodyU['driverContact'] 			= @$bookings->driver->contactNumber;
					$bodyU['device'] 					= (@$bookings->driver->device) ? @$bookings->driver->device : '';
					$bodyU['deviceToken'] 				= (@$bookings->driver->deviceToken) ? @$bookings->driver->deviceToken : '';
					$bodyU['RequestPickupAddress'] 		= @$bookings->RequestPickupAddress;
					$bodyU['RequestDropAddress'] 		= @$bookings->RequestDropAddress;
					$bodyU['RequestPickupLatLong'] 		= @$bookings->RequestPickupLatLong;
					$bodyU['RequestDropLatLong'] 		= @$bookings->RequestDropLatLong;
					$bodyU['DriverImage'] 				= (@$bookings->driver->profile_picture) ? $this->profilePath.@$bookings->driver->profile_picture : '';
					$bodyU['vehicleNumber']				= '';
					$bodyU['VehicleColor'] 				= '';
					$bodyU['vehicleType'] 				= '';
					$bodyU['driverLatitude'] 			= @$bookings->driver->latitude;
					$bodyU['driverlongitude'] 			= @$bookings->driver->longitude;
					$bodyU['rating'] 					= @$bookings->driver->AVGRating;
					$bodyU['RideCode'] 					= @$bookings->RideCode;
					foreach(@$bookings->driver->carinformations as $VV){
						if($VV->categoryId == $bookings->categoryId){
							$bodyU['vehicleNumber']= $VV->carNumber;
							$bodyU['VehicleColor'] = @$Vechle_colors[$VV->carColor];
							if(@$this->request->data['language'] =='bn'){
								$bodyU['VehicleColor'] = @$Vechle_colors_B[$VV->carColor];
							}
							$bodyU['vehicleType'] = $VV->vehicleType;
						}
					}
					$bodyU['bookingId'] 			= (@$bookings->id) ? @$bookings->id : '';
					//pr($bookings); 
					//pr($bodyU); die('hello');
					if(strtolower(@$bookings->user->device) =='ios'){
						$this->sednIosPushNotification(@$bookings->user->deviceToken,$bodyU);
					}else{
						$this->sendNotificationOnAndroid(@$bookings->user->deviceToken,$bodyU);
					}
					$response['status'] 			= 'success';
					$response['msg'] 				= 'Arrived successfully.';
					$response['AuthToken'] = $this->encodejwtreturn();
				}else{
					$response['status'] = 'Fails';
					$response['msg'] = 'Ride already started.';
				}
			}else{
				$response['status'] = 'Fails';
				$response['msg'] = 'bookingId and driverId are required';
			}
			return  $response;
		}
			
		private function ridestart(){
			$this->loadModel('Bookings');
			$keyFeatures = Configure::read('keyFeatures');
			$Vechle_colors = $keyFeatures['Vechle_colors'];
			$Vechle_colors_B = $keyFeatures['Vechle_colors_B'];
			if($this->request->data['bookingId'] !='' && $this->request->data['driverId'] !='' && $this->request->data['Actual_PickupAddress'] !='' && $this->request->data['Actual_Pickup_Lat_Long'] !=''){
				$bookings = $this->Bookings->find()->where(['Bookings.id' => $this->request->data['bookingId'],'Bookings.driverId'=>$this->request->data['driverId']])->contain(['Users','Drivers'=>['Carinformations']])->first();
				if(@$bookings->id !=''){
					$articles = TableRegistry::get('Bookings');
					$query = $articles->query();
					$query->update()
						->set(['rideStatus'=>3,'Actual_Pickup_Lat_Long'=>$this->request->data['Actual_Pickup_Lat_Long'],'Actual_PickupAddress'=>$this->request->data['Actual_PickupAddress']])
						->where(['id' => $this->request->data['bookingId']])
						->execute();
					$response['status'] 				= 'success';
					$response['msg'] 					= 'Ride started successfully.';
					
					$bodyU['message'] 					= @$bookings->driver->fullName.' has start your ride.';
					$bodyU['type'] 						= 'ridestart';
					$bodyU['driverName'] 				= @$bookings->driver->fullName;
					$bodyU['driverId'] 					= @$bookings->driver->id;
					$bodyU['driverContact'] 			= @$bookings->driver->contactNumber;
					$bodyU['device'] 					= (@$bookings->driver->device) ? @$bookings->driver->device : '';
					$bodyU['deviceToken'] 				= (@$bookings->driver->deviceToken) ? @$bookings->driver->deviceToken : '';
					$bodyU['RequestPickupAddress'] 		= @$bookings->RequestPickupAddress;
					$bodyU['RequestDropAddress'] 		= @$bookings->RequestDropAddress;
					$bodyU['RequestPickupLatLong'] 		= @$bookings->RequestPickupLatLong;
					$bodyU['RequestDropLatLong'] 		= @$bookings->RequestDropLatLong;
					$bodyU['DriverImage'] 				= (@$bookings->driver->profile_picture) ? $this->profilePath.@$bookings->driver->profile_picture : '';
					$bodyU['vehicleNumber']				= '';
					$bodyU['VehicleColor'] 				= '';
					$bodyU['vehicleType'] 				= '';
					$bodyU['driverLatitude'] 			= @$bookings->driver->latitude;
					$bodyU['driverlongitude'] 			= @$bookings->driver->longitude;
					$bodyU['rating'] 					= @$bookings->driver->AVGRating;
					foreach(@$bookings->driver->carinformations as $VV){
						if($VV->categoryId == $bookings->categoryId){
							$bodyU['vehicleNumber']= $VV->carNumber;
							$bodyU['VehicleColor'] = @$Vechle_colors[$VV->carColor];
							if(@$this->request->data['language'] =='bn'){
								$bodyU['VehicleColor'] = @$Vechle_colors_B[$VV->carColor];
							}
							$bodyU['vehicleType'] = $VV->vehicleType;
						}
					}
					$bodyU['bookingId'] 			= (@$bookings->id) ? @$bookings->id : '';
					if(strtolower(@$bookings->user->device) =='ios'){
						$this->sednIosPushNotification(@$bookings->user->deviceToken,$bodyU);
					}else{
						$this->sendNotificationOnAndroid(@$bookings->user->deviceToken,$bodyU);
					}
					$response['AuthToken'] = $this->encodejwtreturn();		
				}else{
					$response['status'] = 'Fails';
					$response['msg'] = 'Ride already started.';
				}
			}else{
				$response['status'] = 'Fails';
				$response['msg'] = 'bookingId and driverId are required';
			}
				return  $response;
		}
			
			
		private function rideend(){
			$this->loadModel('Bookings');
			if($this->request->data['bookingId'] !='' && $this->request->data['driverId'] !='' && $this->request->data['Actual_Drop_Lat_Long'] !='' && $this->request->data['Actual_Drop_Address'] !=''){
				$bookings = $this->Bookings->find()->where(['Bookings.id' => $this->request->data['bookingId'],'Bookings.driverId'=>$this->request->data['driverId'],'Bookings.rideStatus'=>3])->contain(['Users','Categories','Drivers'=>['Carinformations']])->first();
				$L_C_ID = '';
				$L_C_Amount = 0;
				//pr($bookings);die('dd');
				if(@$bookings->id !=''){
					$Last_cancel = $this->Bookings->find()->where(['Bookings.cancelBy'=>'Member','Bookings.userId'=>$bookings->userId, 'Bookings.rideStatus'=>7,'Bookings.paymentStatus'=>0])->toArray();
					if(@$Last_cancel){
						$temp = [];
						foreach(@$Last_cancel as $LKD){
							$temp[] = $LKD->id;
							$L_C_Amount += $LKD->totalAmount;
						}
						$L_C_ID = implode(',',$temp); 
					}
					$url ="https://maps.googleapis.com/maps/api/distancematrix/json?units=imperial&key=AIzaSyB3sYhSTD7GEn1j6SsH-QL_GVNG6oUsfM0&origins=".$bookings->Actual_Pickup_Lat_Long."&destinations=".$this->request->data['Actual_Drop_Lat_Long']."&mode=driving";
					//$url ="https://maps.googleapis.com/maps/api/distancematrix/json?units=imperial&key=AIzaSyA2dE-WpZUYM_2CbBH8_Jh97bY1AJCWoHg&origins=".$this->request->data['pickuplatLong']."&destinations=".$this->request->data['droplatLong'];
					$ch = curl_init();
					// Disable SSL verification
					curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
					// Will return the response, if false it print the response
					curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
					// Set the url
					curl_setopt($ch, CURLOPT_URL,$url);
					// Execute
					$result=curl_exec($ch);
					// Closing
					curl_close($ch);
						//echo "<pre>"; print_r(json_decode($result));
						//echo round($result->rows->elements->duration->value*0.000621371192, 2);
						//die;
					$result_array2=json_decode($result);
					$DDS = explode(" ",$result_array2->rows[0]->elements[0]->distance->text);
					$distance = $DDS[0];
					//$res_distance = preg_replace("/[^0-9]/", "", $distance );
					$res_distance = preg_replace("/[^0-9-\+\.]+/", "", $distance);
					$TTime = $result_array2->rows[0]->elements[0]->duration->text;
					$TOTAL_MIN 		= ceil(($result_array2->rows[0]->elements[0]->duration->value) / 60 );
					$FinalFare		= round( ( ($res_distance * $bookings->category->perMile) + ($TOTAL_MIN * $bookings->category->watingTime) + $bookings->category->basic), 2);
					//$FinalFare = round($res_distance * $bookings->category->perMile, 2);
					
					if(@$bookings->category->miniumFair > $FinalFare){
						$FinalFare = @$bookings->category->miniumFair;
					}

					$Discount_percentage = @$bookings->category->perDiscount;
					$Promotional_total = 0;
					if(@$bookings->category->perDiscount > 0){
						$Promotional_total = round(($FinalFare * @$bookings->category->perDiscount)/100,2);
					}

					$T_AMOUNT = (($FinalFare + @$bookings->category->booking_fee + $L_C_Amount) - $Promotional_total);

					$articles = TableRegistry::get('Bookings');
					$query = $articles->query();
					$query->update()
						->set(['totalAmount'=>$T_AMOUNT,
						'promotional_percentage'=>$Discount_percentage,
						'promotional_discount'=>$Promotional_total,
						'bookingFee'=>@$bookings->category->booking_fee,
						'status' =>2,
						'rideStatus'=>4,
						'totalDistance'=>$distance,
						'totalTime'=>$TTime,
						'FinalFare'=>$FinalFare,
						'Actual_Drop_Lat_Long'=>$this->request->data['Actual_Drop_Lat_Long'],
						'Actual_Drop_Address'=>$this->request->data['Actual_Drop_Address'],
						'last_cancle_bookingId'=>$L_C_ID,
						'last_cancel_amount'=>$L_C_Amount])
						->where(['id' => $this->request->data['bookingId']])
						->execute();
					$response['status'] 				= 'success';	
					$response['msg'] 					= 'Ride Completed successfully.';
					if(@$this->request->data['language'] =='bn'){
						$response['msg'] ="রাইড সফলভাবে সম্পন্ন হয়েছে";
					}
					$response['totalDistance'] 			= $distance;
					
					$response['totalTime'] 				= $TTime;
					$response['FinalFare'] 				= $FinalFare;
					$response['totalAmount'] 			= $T_AMOUNT;
					
					//$bodyU['message'] 					= @$bookings->driver->fullName.' has start your ride.';
					$bodyU['message'] 					='You\'ve arrived at your destination. Thank you for riding with us! Your fare is '.$FinalFare.'.';
					$bodyU['type'] 						= 'rideend';
					$bodyU['totalDistance'] 			= $distance;
					$bodyU['totalTime'] 				= $TTime;
					$bodyU['FinalFare'] 				= $FinalFare;
					$bodyU['Discount_percentage'] 		= $Discount_percentage;
					$bodyU['Promotional_total'] 		= $Promotional_total;
					$bodyU['Last_cancel_amount'] 		= (@$L_C_Amount) ? @$L_C_Amount : 0;
					$bodyU['Last_cancel_booking_ID'] 	= (@$L_C_ID) ? @$L_C_ID : '';
					$bodyU['driverName'] 				= @$bookings->driver->fullName;
					$bodyU['driverId'] 					= @$bookings->driver->id;
					$bodyU['driverContact'] 			= @$bookings->driver->contactNumber;
					$bodyU['RequestPickupAddress'] 		= @$bookings->RequestPickupAddress;
					$bodyU['RequestDropAddress'] 		= @$bookings->RequestDropAddress;
					$bodyU['RequestPickupLatLong'] 		= @$bookings->RequestPickupLatLong;
					$bodyU['RequestDropLatLong'] 		= @$bookings->RequestDropLatLong;
					$bodyU['DriverImage'] 				= (@$bookings->driver->profile_picture) ? $this->profilePath.@$bookings->driver->profile_picture : '';
					$bodyU['vehicleNumber']				= '';
					$bodyU['VehicleColor'] 				= '';
					$bodyU['vehicleType'] 				= '';
					$bodyU['driverLatitude'] 			= @$bookings->driver->latitude;
					$bodyU['driverlongitude'] 			= @$bookings->driver->longitude;
					$bodyU['rating'] 					= @$bookings->driver->AVGRating;
					$bodyU['bookingFee'] 				= @$bookings->category->booking_fee;
					$bodyU['totalAmount'] 				= ($FinalFare + @$bookings->categories->booking_fee + $bodyU['Last_cancel_amount']) - $Promotional_total;
					
					foreach(@$bookings->driver->carinformations as $VV){
						if($VV->categoryId == $bookings->categoryId){
							$bodyU['vehicleNumber']= $VV->carNumber;
							$bodyU['VehicleColor'] = @$Vechle_colors[$VV->carColor];
							if(@$this->request->data['language'] =='bn'){
								$bodyU['VehicleColor'] = @$Vechle_colors_B[$VV->carColor];
							}
							$bodyU['vehicleType'] = $VV->vehicleType;
						}
					}
					$bodyU['bookingId'] 				= (@$bookings->id) ? @$bookings->id : '';
					
					$articles2 = TableRegistry::get('Users');
					$query2 = $articles2->query();
					$query2->update()
						->set(['DriverOn' =>1])
						->where(['id' => @$bookings->driver->id])
						->execute();
							
					$fields = array(
						'DriverCode'  	=> @$bookings->driverId,
						'PassengerCode' => @$bookings->userId,
						'Country'  		=> 'USA',
						'Currency' 		=> 'USD',
						'Amount'		=> $FinalFare
					);
							
					if(strtolower(@$bookings->user->device) =='ios'){
						$this->sednIosPushNotification(@$bookings->user->deviceToken,$bodyU);
					}else{
						$this->sendNotificationOnAndroid(@$bookings->user->deviceToken,$bodyU);
					}

					$bodyV['message'] 					='You\'ve successfully completed the ride with '.@$bookings->user->fullName.'.';
					$bodyV['type'] 						= 'rideend';
					if(strtolower(@$bookings->driver->device) =='ios'){
						$this->sednIosPushNotification(@$bookings->driver->deviceToken,$bodyV);
					}else{
						$this->sendNotificationOnAndroid(@$bookings->driver->deviceToken,$bodyV);
					}


					// $email_data['Custome_name'] = 'Raushan';
					// $email_data['invoice_id'] = '102346';
					// $email_data['date'] = '2024-03-02';
					// $email_data['pickup_location'] = 'Housefull';
					// $email_data['drop_location'] = 'New Delhi, 110096';
					// $email_data['distance'] = '20';
					// $email_data['time'] = '35.46';
					// $email_data['total_Amount'] = '225';
					// $email_data['TIP'] = '10';
					// $email_data['Booking_Fee'] = '11';
					// $email_data['p_cancelation'] = '5';
					// $email_data['discount'] = '5';
					// $email_data['payment_method'] = '225';
					// $email_data['Driver_name'] = 'ABC';
					// $email_data['driver_image'] = 'sfsdf';
					// $email_data['driver_rating'] = '4.2';
					// $to = 'raushan@mailinator.com';
					// $subject = "Payment Invoice";
					// $this->caremail($to, $subject, $email_data);

					
					$response['AuthToken'] = $this->encodejwtreturn();		
				}else{
					$response['status'] = 'Fails';
					$response['msg'] = 'Ride already completed or not started yet.';
				}
			}else{
				$response['status'] = 'Fails';
				$response['msg'] = 'bookingId, Actual_Drop_Lat_Long, Actual_Drop_Address and driverId are required';
			}
			return  $response;
		}
			
			
			
		private function ridecancel(){
			$this->loadModel('Bookings');
			if($this->request->data['bookingId'] !='' && $this->request->data['userId'] !='' && $this->request->data['userType'] !='' && $this->request->data['cancelReason'] !=''){
				$bookings = $this->Bookings->find()->where(['Bookings.id' => $this->request->data['bookingId']])->contain(['Users','Drivers'=>['Carinformations']])->first();
				if(@$bookings->id !=''){
					$cancelAmount = 0;
					$DriverAmount = 0;
					if(@$this->request->data['userType'] == 'Member'){
						$cancelAmount = (@$this->request->data['totalAmount']) ? @$this->request->data['totalAmount'] : 5;
						$DriverAmount = round((float)$cancelAmount * 0.8,2);
						//$DriverAmount = $cancelAmount;
					}
					$T_ID = (@$this->request->data['transactionId']) ? @$this->request->data['transactionId'] : '';
					$articles = TableRegistry::get('Bookings');
					$query = $articles->query();
					$query->update()
					->set(['totalAmount'=>$cancelAmount,'driverAmount'=>$DriverAmount,'paymentStatus'=>0,'transactionId'=>$T_ID,'rideStatus'=>7,'cancelBy'=>@$this->request->data['userType'],'cancelReason'=>@$this->request->data['cancelReason'],'cancelComment'=>@$this->request->data['cancelComment']])
					->where(['id' => $this->request->data['bookingId']])
					->execute();

					if(@$this->request->data['userType'] == 'Member'){
						$articles3 = TableRegistry::get('Users');
						$query3 = $articles3->query();
						$query3->update()
						->set($query3->newExpr('wallet = wallet + '.(float)@$DriverAmount))
						->where(['id' => @$bookings->driver->id])
						->execute();
					}

					$response['status'] 			= 'success';
					$response['msg'] 				= 'Ride cancelled successfully.';
					$response['AuthToken'] = $this->encodejwtreturn();
					if(@$this->request->data['userType'] == 'Member'){
						$bodyU['message'] 					= @$bookings->user->fullName.' has cancelled your ride.';
						$bodyU['type'] 						= 'cancel';
						$bodyU['userName'] 					= @$bookings->user->fullName;
						$bodyU['userId'] 					= @$bookings->user->id;
						$bodyU['userContact'] 				= @$bookings->user->contactNumber;
						$bodyU['RequestPickupAddress'] 		= @$bookings->RequestPickupAddress;
						$bodyU['RequestDropAddress'] 		= @$bookings->RequestDropAddress;
						$bodyU['RequestPickupLatLong'] 		= @$bookings->RequestPickupLatLong;
						$bodyU['RequestDropLatLong'] 		= @$bookings->RequestDropLatLong;
						$bodyU['DriverImage'] 				= (@$bookings->driver->profile_picture) ? $this->profilePath.@$bookings->driver->profile_picture : '';
						$bodyU['vehicleNumber']				= '';
						$bodyU['VehicleColor'] 				= '';
						$bodyU['driverLatitude'] 			= @$bookings->driver->latitude;
						$bodyU['driverlongitude'] 			= @$bookings->driver->longitude;
						
						$bodyU['cancelReason'] 				= @$this->request->data['cancelReason'];
						$bodyU['cancelComment'] 			= @$this->request->data['cancelComment'];
						
						$bodyU['rating'] 					= @$bookings->driver->AVGRating;
						foreach(@$bookings->driver->carinformations as $VV){
							if($VV->categoryId == $bookings->categoryId){
								$bodyU['vehicleNumber']= $VV->carNumber;
								$bodyU['VehicleColor'] = @$Vechle_colors[$VV->carColor];
								if(@$this->request->data['language'] =='bn'){
									$bodyU['VehicleColor'] = @$Vechle_colors_B[$VV->carColor];
								}
							}
						}
						$bodyU['bookingId'] 			= (@$bookings->id) ? @$bookings->id : '';
						if(strtolower(@$bookings->driver->device) =='ios'){
							$this->sednIosPushNotification(@$bookings->driver->deviceToken,$bodyU);
						}else{
							$this->sendNotificationOnAndroid(@$bookings->driver->deviceToken,$bodyU);
						}
					}else{
						//$bodyU['message'] 					= @$bookings->driver->fullName.' has cancel your ride.';
						$bodyU['message'] 					= 'Unfortunately, your driver has canceled the ride.';
						$bodyU['type'] 						= 'cancel';
						$bodyU['driverName'] 				= @$bookings->driver->fullName;
						$bodyU['driverId'] 					= @$bookings->driver->id;
						$bodyU['driverContact'] 			= @$bookings->driver->contactNumber;
						$bodyU['RequestPickupAddress'] 		= @$bookings->RequestPickupAddress;
						$bodyU['RequestDropAddress'] 		= @$bookings->RequestDropAddress;
						$bodyU['RequestPickupLatLong'] 		= @$bookings->RequestPickupLatLong;
						$bodyU['RequestDropLatLong'] 		= @$bookings->RequestDropLatLong;
						$bodyU['DriverImage'] 				= (@$bookings->driver->profile_picture) ? $this->profilePath.@$bookings->driver->profile_picture : '';
						$bodyU['vehicleNumber']				= '';
						$bodyU['VehicleColor'] 				= '';
						$bodyU['driverLatitude'] 			= @$bookings->driver->latitude;
						$bodyU['driverlongitude'] 			= @$bookings->driver->longitude;
						$bodyU['rating'] 					= @$bookings->driver->AVGRating;
						$bodyU['cancelReason'] 				= @$this->request->data['cancelReason'];
						$bodyU['cancelComment'] 			= @$this->request->data['cancelComment'];
						
						foreach(@$bookings->driver->carinformations as $VV){
							if($VV->id == $bookings->categoryId){
								$bodyU['vehicleNumber']= $VV->carNumber;
								$bodyU['VehicleColor'] = $VV->carColor;
								$bodyU['VehicleColor'] = @$Vechle_colors[$VV->carColor];
								if(@$this->request->data['language'] =='bn'){
									$bodyU['VehicleColor'] = @$Vechle_colors_B[$VV->carColor];
								}
							}
						}
						$bodyU['bookingId'] 				= (@$bookings->id) ? @$bookings->id : '';
						if(strtolower(@$bookings->user->device) =='ios'){
							$this->sednIosPushNotification(@$bookings->user->deviceToken,$bodyU);
						}else{
							$this->sendNotificationOnAndroid(@$bookings->user->deviceToken,$bodyU);
						}
					}
					$articles2 = TableRegistry::get('Users');
					$query2 = $articles2->query();
					$query2->update()
						->set(['DriverOn' =>1])
						->where(['id' => @$bookings->driver->id])
						->execute();
							
				}else{
					$response['status'] = 'Fails';
					$response['msg'] = 'Ride already started.';
				}
			}else{
				$response['status'] = 'Fails';
				$response['msg'] = 'bookingId, userType, cancelReason and userId are required';
			}
			return  $response;
		}
	
	
	
		private function changebookingstatus(){
			$this->loadModel('Bookings');
			$this->loadModel('Users');
			$this->loadModel('Bookingrequests');
			$this->loadModel('Categories');
			if($this->request->data['bookingId'] !='' && $this->request->data['status'] !='' && $this->request->data['driverId'] !=''){
				$DRIVER = $this->Users->find()->where(['Users.id'=>$this->request->data['driverId']])->first();
				$bookings = $this->Bookings->find()->where(['Bookings.id' => $this->request->data['bookingId']])->contain(['Users','Vendors'])->first();
				$CategoryID = $this->Categories->find()->where(['Categories.id'=>$bookings->categoryId])->first(); 
				if(!empty($bookings)){
					//pr($products); die;
					if($this->request->data['status'] == 1){
						if($bookings->status == 0){
							$SS = 6;
							if(@$this->request->data['bookingTYPE'] == 'CURRENT'){
								$SS = 1;
							}
							$articles = TableRegistry::get('Bookings');
							$query = $articles->query();
							$query->update()
							->set(['vendorId'=>$this->request->data['driverId'],'status' =>$SS])
							->where(['id' => $this->request->data['bookingId']])
							->execute();
							$this->Bookingrequests->deleteAll(['Bookingrequests.bookingId'=>$this->request->data['bookingId']]);
						}else{
							$response['status'] = 'Fails';
							$response['msg'] = 'Booking already close or accepted by someone\'s else';
							$response['AuthToken'] = $this->encodejwtreturn();
							return  $response;
						}
					}elseif($this->request->data['status'] == 2){
						$articles = TableRegistry::get('Bookings');
						$query = $articles->query();
						$query->update()
						->set(['status' =>2])
						->where(['id' => $this->request->data['bookingId']])
						->execute();
						
						$driver = $this->Users->find()->where(['Users.id'=>$this->request->data['driverId']])->first();
						$totalAMOUNT = $driver->wallet + $bookings->totalAmount;
						$articles2 = TableRegistry::get('Users');
						$query2 = $articles2->query();
						$query2->update()
							->set(['wallet' => $totalAMOUNT])
							->where(['id' => $driver->id])
							->execute();
									
						$response['msg'] = 'Booking completed succssfully.';
					}elseif($this->request->data['status'] == 3){
						$da = $this->Bookingrequests->find()->where(['Bookingrequests.bookingId'=>$this->request->data['bookingId'],'Bookingrequests.driverId'=>$this->request->data['driverId'] ])->first();
						@$this->Bookingrequests->delete(@$da);
						//$articles = TableRegistry::get('Bookings');
						//	$query = $articles->query();
						//	$query->update()
						//	->set(['status' =>3])
						//	->where(['id' => $this->request->data['bookingId']])
						//	->execute();
								
						$response['msg'] = 'Booking declined';
					}
					$response['status'] = 'success';
					if($this->request->data['status'] == 1){
						$response['msg'] 				= 'Booking accepted successfully.';
						$bodyU['message'] 				= @$bookings->vendor->fullName.' has been accepted your booking successfully.';
						$bodyU['vendorID'] 				= (@$DRIVER->id) ? @$DRIVER->id : '';
						$bodyU['vendorFullName'] 		= (@$DRIVER->fullName) ? @$DRIVER->fullName : '';
						$bodyU['vendorContactNumber'] 	= @$DRIVER->contactNumber;
						$bodyU['latitude'] 				= @$bookings->latitude;
						$bodyU['longitude'] 			= @$bookings->longitude;
						$bodyU['address'] 				= @$bookings->address;
						$bodyU['vendorImage'] 			= (@$DRIVER->profile_picture) ? $this->profilePath.$DRIVER->profile_picture : "";
						$bodyU['vendorRating'] 			= (@$DRIVER->AVGRating) ? @$DRIVER->AVGRating : 0;
						$bodyU['vendorPhone'] 			= (@$DRIVER->contactNumber) ? @$DRIVER->contactNumber : "";
						$bodyU['categoryName'] 			= @$CategoryID->name;
						$bodyU['type'] 					= 'accept';
						$bodyU['today']				 	= (date('Y-m-d',strtotime(@$bookings->bookingDate)) == date('Y-m-d')) ? 'today' :'later';
						$bodyU['notificationType'] 		= 'Member';
						$bodyU['bookingDate'] 			= date('Y-m-d',strtotime(@$bookings->bookingDate));
						$bodyU['slote'] 				= @$bookings->slote;
						$bodyU['bookingId'] 			= @$bookings->id;
						$bodyV['message'] 				= 'Booking accepted successfully.';
						if(strtolower(@$bookings->user->device) =='ios'){
							$this->sednIosPushNotification(@$bookings->user->deviceToken,$bodyU);
						}else{
							$this->sendNotificationOnAndroid(@$bookings->user->deviceToken,$bodyU);
						}
						
						if(strtolower(@$bookings->vendor->device) =='ios'){
							$this->sednIosPushNotification(@$bookings->vendor->deviceToken,$bodyV);
						}else{
							$this->sendNotificationOnAndroid(@$bookings->vendor->deviceToken,$bodyV);
						}
					}
								
					if($this->request->data['status'] == 2){
						$response['msg'] = 'Booking completed successfully.';
						$bodyU['message'] = @$bookings->vendor->fullName.' has been completed successfully.';
						$bodyV['message'] = 'Booking accepted successfully.';
						if(strtolower(@$bookings->user->device) =='ios'){
							$this->sednIosPushNotification(@$bookings->user->deviceToken,$bodyU);
						}else{
							$this->sendNotificationOnAndroid(@$bookings->user->deviceToken,$bodyU);
						}
					}
								
					if($this->request->data['status'] == 3){
						$response['msg'] = 'Booking declined successfully.';
						$bodyV['message'] = 'Booking declined process completed.';
						if(strtolower(@$bookings->vendor->device) =='ios'){
							$this->sednIosPushNotification(@$bookings->vendor->deviceToken,$bodyV);
						}else{
							$this->sendNotificationOnAndroid(@$bookings->vendor->deviceToken,$bodyV);
						}
					}
					$response['AuthToken'] = $this->encodejwtreturn();
					//$res = $this->productlist($products->userId);
					//$response['data'] = $res['data'];
				}else{
					$response['status'] = 'Fails';
					$response['msg'] = 'Booking already close or accepted by someone\'s else';
				}
			}else{
				$response['status'] = 'Fails';
				$response['msg'] = 'productId is required';
			}
			return  $response;
		}
	
	
		function canclerequest(){
			$this->loadModel('Bookings');
			if($this->request->data['userId'] !='' && $this->request->data['groupId'] !=''){
				//groupId = bookingId
				//$this->Bookings->deleteAll(['Bookings.groupId'=>$this->request->data['groupId']]);
				$articles = TableRegistry::get('Bookings');
				$query = $articles->query();
				$query->update()
					->set(['status' =>3])
					->where(['id' => $this->request->data['groupId']])
					->execute();
				$response['status'] = "success";
				$response['msg'] = 'Booking cancelled successfully.';
				$response['AuthToken'] = $this->encodejwtreturn();	
			}else{
				$response['status'] = 'Fail';
				$response['msg'] = 'bookingId, userId, are required';	
			}
			return 	$response;
		}
	
	
		private function requestlist($user_id=NULL){
			$this->loadModel('Bookingrequests');
			$userId = ($user_id) ? $user_id : $this->request->data('userId');
			if($userId){
				$pageNo = ($this->request->data('pageNo')) ? $this->request->data('pageNo') : '1';
				$this->paginate = [
						'limit' => '10',//$limit,
						'order' => ['Bookingrequests.id' => 'desc'],
						'page'=>$pageNo,
						'contain'=>['Bookings'=>['Categories','Users']]
				];
				$condition[] = ['Bookingrequests.driverId	' => $userId];
				//echo "<pre>"; print_r($condition); die;
				$userservices =array();    
				$query = $this->Bookingrequests->find('all')->where($condition);
				$totalCount =  $query->count();
				if($pageNo <= ceil($totalCount/10)){
					$userservices = $this->paginate($query);
					$userservices = $userservices->toArray();
				}
				$Darray = array();
				$i=0;
				//echo "<pre>"; print_r($userservices); die;
				foreach($userservices as $userD){
				
					$Darray[$i]['bookingId'] 					= ($userD->booking->id) ? $userD->booking->id : '';
					$Darray[$i]['RequestPickupAddress'] 		= ($userD->booking->RequestPickupAddress) ? $userD->booking->RequestPickupAddress : '';
					$Darray[$i]['bookingDate'] 					= ($userD->booking->bookingDate) ? date("jS M", strtotime($userD->booking->bookingDate)) : '';
					$Darray[$i]['RequestDropAddress'] 			= ($userD->booking->RequestDropAddress) ? $userD->booking->RequestDropAddress : '';
					$Darray[$i]['RequestPickupLatLong'] 		= ($userD->booking->RequestPickupLatLong) ? $userD->booking->RequestPickupLatLong : '';
					$Darray[$i]['RequestDropLatLong'] 			= ($userD->booking->RequestDropLatLong) ? $userD->booking->RequestDropLatLong : '';
					$Darray[$i]['rideStatus'] 					= ($userD->booking->rideStatus) ? $userD->booking->rideStatus : '';
					$Darray[$i]['estimatedPrice'] 				= ($userD->booking->estimatedPrice) ? $userD->booking->estimatedPrice : '';
					$Darray[$i]['FinalFare'] 					= ($userD->booking->FinalFare) ? $userD->booking->FinalFare : '';
					$Darray[$i]['totalAmount'] 					= ($userD->booking->totalAmount) ? $userD->booking->totalAmount : ''; // finalFare + tip + discount
					$Darray[$i]['transactionId'] 				= ($userD->booking->transactionId) ? $userD->booking->transactionId : '';
					$Darray[$i]['paymentStatus'] 				= ($userD->booking->paymentStatus) ? $userD->booking->paymentStatus : '';
					
					$Darray[$i]['userId'] 						= (@$userD->booking->user->id) ? @$userD->booking->user->id : '';
					$Darray[$i]['fullName'] 					= (@$userD->booking->user->fullName) ? @$userD->booking->user->fullName : '';
					$Darray[$i]['email'] 						= (@$userD->booking->user->email) ? @$userD->booking->user->email : '';
					$Darray[$i]['zipCode'] 						= (@$userD->booking->user->zipCode) ? @$userD->booking->user->zipCode : '';
					$Darray[$i]['contactNumber'] 				= (@$userD->booking->user->contactNumber) ? @$userD->booking->user->contactNumber :'';
					$Darray[$i]['userAddress']					= (@$userD->booking->user->address) ? @$userD->booking->user->address : '';
					$Darray[$i]['AVGRating']					= (@$userD->booking->user->AVGRating) ? @$userD->booking->user->AVGRating : '';
					$Darray[$i]['image'] 						= (@$userD->booking->user->profile_picture) ? $this->profilePath.@$userD->booking->user->profile_picture : '';
					
					$Darray[$i]['status'] 						= (@$userD->booking->status) ? @$userD->booking->status : 0;
					$Darray[$i]['CarName'] 						= (@$userD->booking->category->name) ? @$userD->booking->category->name : '';
					$Darray[$i]['perMile'] 						= (@$userD->booking->category->perMile) ? @$userD->booking->category->perMile : "0";
					$Darray[$i]['miniumFair'] 					= (@$userD->booking->category->miniumFair) ? @$userD->booking->category->miniumFair : "0";
					$Darray[$i]['carImage'] 					= (@$userD->booking->category->image) ? $this->carPath.@$userD->booking->category->image : "";
					$Darray[$i]['created'] 						= (@$userD->booking->created) ? date('Y-m-d H:i:s', strtotime(@$userD->booking->created)) : '';
					$i++;
				}
				$response['status'] = 'success';
				$response['data'] = array_values($this->array_filter_recursive($Darray));
				$response['AuthToken'] = $this->encodejwtreturn();
			
			}else{
				$response['status'] = "Fail";	
				$response['msg'] = "userId required";	
			}
			return $response;
		}
	
	
	/*this is for booking not for job*/
	private function bookinglist($user_id=NULL, $userType=NULL,$status=NULL, $startDate=NULL,$endDate=NULL){
		$this->loadModel('Bookings');
		$userId 	= ($user_id) ? $user_id : $this->request->data('userId');
		$STATUS 	= ($status) ? $status : $this->request->data('status');
		$usertype 	= ($userType) ? $userType : $this->request->data('usertype');
		$StartDate 	= ($startDate) ? $startDate : $this->request->data('startDate');
		$ENDDAte 	= ($endDate) ? $endDate : $this->request->data('endDate');
		$scheduled 	= (@$this->request->data['scheduled']) ? @$this->request->data['scheduled'] : '';
		
		$keyFeatures = Configure::read('keyFeatures');
		$Vechle_colors = $keyFeatures['Vechle_colors'];
		$Vechle_colors_B = $keyFeatures['Vechle_colors_B'];

		if($userId){
			$pageNo = ($this->request->data('pageNo')) ? $this->request->data('pageNo') : '1';
			$this->paginate = [
				'limit' => '20',//$limit,
				'order' => ['Bookings.created' => 'desc'],
				'page'=>$pageNo,
				'contain'=>['Users','Drivers'=>['Carinformations'], 'Categories']
			];
			$condition[] = '';
			if($usertype == 'Member'){
				$condition[] = ['Bookings.userId' => $userId];
			}else if($usertype == 'Driver'){
				$condition[] = ['Bookings.driverId' => $userId];
			}
			if($scheduled == 'Yes'){
				//$condition[] = ['Bookings.bookingDate !=' => '','Bookings.bookingTime !=' => ''];
				$condition[] = ['Bookings.bookingDate >=' => date('Y-m-d')];
				$condition[] = ['Bookings.rideStatus NOT IN'=> [7,5]];
			}

			if($StartDate !=''){
				$condition[] = ['Bookings.bookingDate >=' => date('Y-m-d',strtotime($StartDate))];
			}
			if($ENDDAte !=''){
				$condition[] = ['Bookings.bookingDate <=' => date('Y-m-d',strtotime($ENDDAte))];
			}
			$condition[] = ['Bookings.rideStatus <>' => 6];
			if($STATUS != ''){
				$condition[] = ['Bookings.rideStatus' => $STATUS];
			}
			//echo "<pre>"; print_r($condition); die;
			$userservices =array();    
			$query = $this->Bookings->find('all')->where($condition);
			$totalCount =  $query->count();
			if($pageNo <= ceil($totalCount/20)){
				$userservices = $this->paginate($query);
				$userservices = $userservices->toArray();
			}
			$Darray = array();
			$i=0;
			//echo "<pre>"; print_r($userservices); die;
			foreach($userservices as $userD){
				$Darray[$i]['bookingId'] 					= ($userD->id) ? $userD->id : '';
				$Darray[$i]['RequestPickupAddress'] 		= ($userD->RequestPickupAddress) ? $userD->RequestPickupAddress : '';
				//$Darray[$i]['bookingDate'] 				= ($userD->bookingDate) ? date("jS M", strtotime($userD->bookingDate)) : '';
				$Darray[$i]['RequestDropAddress'] 			= ($userD->RequestDropAddress) ? $userD->RequestDropAddress : '';
				$Darray[$i]['RequestPickupLatLong'] 		= ($userD->RequestPickupLatLong) ? $userD->RequestPickupLatLong : '';
				$Darray[$i]['RequestDropLatLong'] 			= ($userD->RequestDropLatLong) ? $userD->RequestDropLatLong : '';
				$Darray[$i]['rideStatus'] 					= ($userD->rideStatus) ? $userD->rideStatus : '0';
				$Darray[$i]['estimatedPrice'] 				= ($userD->estimatedPrice) ? $userD->estimatedPrice : '';
				$Darray[$i]['FinalFare'] 					= ($userD->FinalFare) ? $userD->FinalFare : '';
				$Darray[$i]['totalDistance'] 				= ($userD->totalDistance) ? $userD->totalDistance : 0;
				$Darray[$i]['totalAmount'] 					= ($userD->totalAmount) ? $userD->totalAmount : ''; // finalFare + bookingfee - promotional_discount
				$Darray[$i]['transactionId'] 				= ($userD->transactionId) ? $userD->transactionId : '';
				$Darray[$i]['paymentStatus'] 				= ($userD->paymentStatus) ? $userD->paymentStatus : '';
				$Darray[$i]['promotional_discount'] 		= ($userD->promotional_discount) ? $userD->promotional_discount : '';
				$Darray[$i]['promotional_percentage'] 		= ($userD->promotional_percentage) ? $userD->promotional_percentage : '';
				$Darray[$i]['bookingFee'] 					= ($userD->bookingFee) ? $userD->bookingFee : '';
				//$Darray[$i]['paymentMethod'] 				= ($userD->paymentMethod) ? $userD->paymentMethod : '';

				$Darray[$i]['bookingDate'] 					= ($userD->bookingDate) ? date('m-d-Y',strtotime($userD->bookingDate)) : '';
				$Darray[$i]['bookingTime'] 					= ($userD->bookingTime) ? $userD->bookingTime : '';

				$Darray[$i]['TIP'] 							= ($userD->TIP) ? $userD->TIP : 0;
				$Darray[$i]['discountAmount'] 				= ($userD->discountAmount) ? $userD->discountAmount : '';
				$Darray[$i]['couponCode'] 					= ($userD->couponCode) ? $userD->couponCode : '';
				$Darray[$i]['RideCode'] 					= ($userD->RideCode) ? $userD->RideCode : 0;

				$Darray[$i]['last_cancle_bookingId'] 		= ($userD->last_cancle_bookingId) ? $userD->last_cancle_bookingId : '';
				$Darray[$i]['last_cancel_amount'] 			= ($userD->last_cancel_amount) ? $userD->last_cancel_amount : 0;
				
				$Darray[$i]['vehicleNumber']= '';
				$Darray[$i]['VehicleColor'] = '';
				$Darray[$i]['vehicleType'] = '';
				if(@$userD->driver->carinformations){
					foreach(@$userD->driver->carinformations as $VV){
						if($VV->categoryId == $userD->categoryId){
							$Darray[$i]['vehicleNumber']= ($VV->carNumber) ?  $VV->carNumber : '';
							$Darray[$i]['VehicleColor'] = ($VV->carColor) ? @$Vechle_colors[$VV->carColor] : '';
							if(@$this->request->data['language'] =='bn'){
								$Darray[$i]['VehicleColor'] = ($VV->carColor) ? @$Vechle_colors_B[$VV->carColor] : '';
							}
							$Darray[$i]['vehicleType'] = ($VV->vehicleType) ? $VV->vehicleType : '';
						}
					}
				} 

				if($usertype == 'Member'){
					$Darray[$i]['userId'] 				= (@$userD->driver->id) ? @$userD->driver->id : '';
					$Darray[$i]['fullName'] 			= (@$userD->driver->fullName) ? @$userD->driver->fullName : '';
					$Darray[$i]['email'] 				= (@$userD->driver->email) ? @$userD->driver->email : '';
					$Darray[$i]['zipCode'] 				= (@$userD->driver->zipCode) ? @$userD->driver->zipCode : '';
					$Darray[$i]['AVGRating'] 			= (@$userD->driver->AVGRating) ? @$userD->driver->AVGRating : '0';
					$Darray[$i]['latitude'] 			= (@$userD->driver->latitude) ? @$userD->driver->latitude : '';
					$Darray[$i]['longitude'] 			= (@$userD->driver->longitude) ? @$userD->driver->longitude : '';
					$Darray[$i]['contactNumber'] 		= (@$userD->driver->contactNumber) ? @$userD->driver->contactNumber :'';
					$Darray[$i]['device'] 				= (@$userD->driver->device) ? @$userD->driver->device :'';
					$Darray[$i]['deviceToken'] 			= (@$userD->driver->deviceToken) ? @$userD->driver->deviceToken :'';
					$Darray[$i]['image'] 				= (@$userD->driver->profile_picture) ? $this->profilePath.@$userD->driver->profile_picture : '';
				}else{
					$Darray[$i]['userId'] 				= (@$userD->user->id) ? @$userD->user->id : '';
					$Darray[$i]['fullName'] 			= (@$userD->user->fullName) ? @$userD->user->fullName : '';
					$Darray[$i]['email'] 				= (@$userD->user->email) ? @$userD->user->email : '';
					$Darray[$i]['zipCode'] 				= (@$userD->user->zipCode) ? @$userD->user->zipCode : '';
					$Darray[$i]['AVGRating'] 			= (@$userD->user->AVGRating) ? @$userD->user->AVGRating : '0';
					$Darray[$i]['latitude'] 			= (@$userD->user->latitude) ? @$userD->user->latitude : '';
					$Darray[$i]['longitude'] 			= (@$userD->user->longitude) ? @$userD->user->longitude : '';
					$Darray[$i]['contactNumber'] 		= (@$userD->user->contactNumber) ? @$userD->user->contactNumber :'';
					$Darray[$i]['device'] 				= (@$userD->user->device) ? @$userD->user->device :'';
					$Darray[$i]['deviceToken'] 			= (@$userD->user->deviceToken) ? @$userD->user->deviceToken :'';
					$Darray[$i]['image'] 				= (@$userD->user->profile_picture) ? $this->profilePath.@$userD->user->profile_picture : '';
				}
				$Darray[$i]['status'] 					= ($userD->status) ? $userD->status : 0;
				$Darray[$i]['CarName'] 					= (@$userD->category->name) ? @$userD->category->name : '';
				$Darray[$i]['perMile'] 					= (@$userD->category->perMile) ? @$userD->category->perMile : "0";
				$Darray[$i]['miniumFair'] 				= (@$userD->category->miniumFair) ? @$userD->category->miniumFair : "0";
				$Darray[$i]['carImage'] 				= (@$userD->category->image) ? $this->carPath.@$userD->category->image : "";
				$Darray[$i]['created'] 					= ($userD->created) ? date('m-d-Y H:i:s', strtotime($userD->created)) : '';
				$i++;
			}
			$response['status'] = 'success';
			$response['data'] = array_values($this->array_filter_recursive($Darray));
			$response['AuthToken'] = $this->encodejwtreturn();
			
		}else{
			$response['status'] = "Fail";	
			$response['msg'] = "userId required";	
		}
		return $response;
	}
	
	function bookingdetail($booking_id=NULL,$userId = NULL){
		$this->loadModel('Bookings');
		$this->loadModel('Users');$this->loadModel('Reviews');
		$invoiceId = ($booking_id) ? $booking_id : $this->request->data('bookingId');
		$UserID = ($userId) ? $userId : @$this->request->data['userId'];

		$keyFeatures = Configure::read('keyFeatures');
		$Vechle_colors = $keyFeatures['Vechle_colors'];
		$Vechle_colors_B = $keyFeatures['Vechle_colors_B'];
		
		if($invoiceId){
			$val =	$this->Bookings->find()->where(['Bookings.id'=>$this->request->data('bookingId')])->contain(['Drivers'=>['Carinformations'],'Users', 'Categories'])->first();
			//echo "<pre>";
			//print_r($val); die;
			if($val){
				$bookingRating = $this->Reviews->find()->where(['Reviews.reviewFrom'=>$UserID,'Reviews.bookingId'=>$invoiceId])->first();
				$list['bookingrating'] 			= (@$bookingRating->star) ? @$bookingRating->star : 0;


				$list['bookingId'] 				= ($val->id) ? $val->id : '';
				$list['categoryId'] 			= ($val->categoryId) ? $val->categoryId : '';
				$list['bookingDate'] 			= ($val->bookingDate) ? date("jS M", strtotime($val->bookingDate)) : '';
				$list['RequestPickupAddress'] 	= ($val->RequestPickupAddress) ? $val->RequestPickupAddress : '';
				$list['RequestDropAddress'] 	= ($val->RequestDropAddress) ? $val->RequestDropAddress : '';
				$list['RequestPickupLatLong'] 	= ($val->RequestPickupLatLong) ? $val->RequestPickupLatLong : '';
				$list['RequestDropLatLong'] 	= ($val->RequestDropLatLong) ? $val->RequestDropLatLong : '';
			
				$list['Actual_PickupAddress'] 	= ($val->Actual_PickupAddress) ? $val->Actual_PickupAddress : '';
				$list['Actual_Pickup_Lat_Long']	= ($val->Actual_Pickup_Lat_Long) ? $val->Actual_Pickup_Lat_Long : '';
				$list['Actual_Drop_Address'] 	= ($val->Actual_Drop_Address) ? $val->Actual_Drop_Address : '';
				$list['Actual_Drop_Lat_Long'] 	= ($val->Actual_Drop_Lat_Long) ? $val->Actual_Drop_Lat_Long : '';
			
				$list['rideStatus'] 			= ($val->rideStatus) ? $val->rideStatus : '0';
				$list['estimatedPrice'] 		= ($val->estimatedPrice) ? $val->estimatedPrice : '';
				$list['FinalFare'] 				= ($val->FinalFare) ? $val->FinalFare : '';
				$list['totalAmount'] 			= ($val->totalAmount) ? $val->totalAmount : ''; // finalFare + tip + discount
				$list['transactionId'] 			= ($val->transactionId) ? $val->transactionId : '';
				$list['paymentStatus'] 			= ($val->paymentStatus) ? $val->paymentStatus : '';
				$list['paymentMethod'] 			= ($val->paymentMethod) ? $val->paymentMethod : '';
				$list['totalDistance'] 			= ($val->totalDistance) ? $val->totalDistance : '';
				$list['totalTime'] 				= ($val->totalTime) ? $val->totalTime : '';

				$list['bookingDate'] 				= ($val->bookingDate) ? date('m-d-Y',strtotime($val->bookingDate)) : '';
				$list['bookingTime'] 				= ($val->bookingTime) ? $val->bookingTime : '';

				$list['TIP'] 					= ($val->TIP) ? $val->TIP : 0;
				$list['discountAmount'] 		= ($val->discountAmount) ? $val->discountAmount : 0;
				$list['couponCode'] 			= ($val->couponCode) ? $val->couponCode : '';

				$list['promotional_discount'] 		= ($val->promotional_discount) ? $val->promotional_discount : '';
				$list['promotional_percentage'] 	= ($val->promotional_percentage) ? $val->promotional_percentage : '';
				$list['bookingFee'] 				= ($val->bookingFee) ? $val->bookingFee : '';
			
				$list['status'] 				= ($val->status) ? $val->status : 0;
				$list['CarName'] 				= (@$val->category->name) ? @$val->category->name : '';
				$list['perMile'] 				= (@$val->category->perMile) ? @$val->category->perMile : "0";
				$list['miniumFair'] 			= (@$val->category->miniumFair) ? @$val->category->miniumFair : "0";
				$list['carImage'] 				= (@$val->category->image) ? $this->carPath.@$val->category->image : "0";
				$list['RideCode'] 				= ($val->RideCode) ? $val->RideCode : 0;
				$list['last_cancle_bookingId'] 	= ($val->last_cancle_bookingId) ? $val->last_cancle_bookingId : '';
				$list['last_cancel_amount'] 	= ($val->last_cancel_amount) ? $val->last_cancel_amount : 0;
				
				$list['vehicleNumber']= '';
				$list['VehicleColor'] = '';
				$list['vehicleType'] = '';
				if(@$val->driver->carinformations){
					foreach(@$val->driver->carinformations as $VV){
						if($VV->categoryId == $val->categoryId){
							$list['vehicleNumber']= ($VV->carNumber) ?  $VV->carNumber : '';
							$list['VehicleColor'] = ($VV->carColor) ? @$Vechle_colors[$VV->carColor] : '';
							if(@$this->request->data['language'] =='bn'){
								$list['VehicleColor'] = ($VV->carColor) ? @$Vechle_colors_B[$VV->carColor] : '';
							}
							$list['vehicleType'] = ($VV->vehicleType) ? $VV->vehicleType : '';
						}
					}
				} 

				$list['userId']					= (@$val->user->id) ? @$val->user->id : '';
				$list['userName']				= (@$val->user->fullName) ? @$val->user->fullName : '';
				$list['userEmail']				= (@$val->user->email) ? @$val->user->email : '';
				$list['userPhone']				= (@$val->user->contactNumber) ? @$val->user->contactNumber : '';
				$list['userDevice']				= (@$val->user->device) ? @$val->user->device : '';
				$list['userRating']				= (@$val->user->AVGRating) ? @$val->user->AVGRating : '0';
				$list['userDeviceToken']		= (@$val->user->deviceToken) ? @$val->user->deviceToken : '';
				$list['userImage']				= (@$val->user->profile_picture) ? $this->profilePath.@$val->user->profile_picture : '';
			
				$list['driverId']				= (@$val->driver->id) ? @$val->driver->id : '';
				$list['driverName']				= (@$val->driver->fullName) ? @$val->driver->fullName : '';
				$list['driverAddress']			= (@$val->driver->address) ? @$val->driver->address : '';
				$list['driverLatitude']			= (@$val->driver->latitude) ? @$val->driver->latitude : '';
				$list['driverLongitude']		= (@$val->driver->longitude) ? @$val->driver->longitude : '';
				$list['driverEmail']			= (@$val->driver->email) ? @$val->driver->email : '';
				$list['driverPhone']			= (@$val->driver->contactNumber) ? @$val->driver->contactNumber : '';
				$list['driverRating']			= (@$val->driver->AVGRating) ? @$val->driver->AVGRating : '0';
				$list['driverDevice']			= (@$val->driver->device) ? @$val->driver->device : '';
				$list['driverDeviceToken']		= (@$val->driver->deviceToken) ? @$val->driver->deviceToken : '';
				$list['driverImage']			= (@$val->driver->profile_picture) ? $this->profilePath.@$val->driver->profile_picture : '';
			
				$response['status'] = 'success';
				$response['data'] = $this->array_filter_recursive($list);
				$response['AuthToken'] = $this->encodejwtreturn();
			}else{
				$response['status'] = 'Fail'; 	
				$response['msg'] = "Booking Id invalid.";	
			}
		}else{
			$response['status'] = "Fail";	
			$response['msg'] = "booking Id required";	
		}
		return $response;
	}
			
		
		/*this is for booking not for job*/
	function earninghistory($user_id=NULL,$reportType=NULL, $userType=NULL){
		$this->loadModel('Bookings');
		$userId 		= ($user_id) ? $user_id : $this->request->data('userId');
		$ReportType 	= ($reportType) ? $reportType : $this->request->data('reportType');
		$usertype 		= ($userType) ? $userType : @$this->request->data('usertype');
		
		if($userId !='' && $ReportType !=''){
			$pageNo = ($this->request->data('pageNo')) ? $this->request->data('pageNo') : '1';
			$this->paginate = [
				'limit' => '10',//$limit,
				'order' => ['Bookings.created' => 'desc'],
				'page'=>$pageNo,
				'contain'=>['Users','Drivers'=>['Carinformations'], 'Categories']
			];
			$condition[] = ['Bookings.rideStatus IN' =>[5,7]];
			if($usertype == 'Member'){
				$condition[] = ['Bookings.userId' => $userId];
			}else if($usertype == 'Driver'){
				$condition[] = ['Bookings.driverId' => $userId];
			}
			if($ReportType =='TODAY'){
				$condition[] = ['Bookings.bookingDate >=' => date('Y-m-d')];
			}
			if($ReportType =='WEEK'){
				$condition[] = ['Bookings.bookingDate <=' => date('Y-m-d')];
				$Next_day = date("Y-m-d", strtotime("-7 days"));
				$condition[] = ['Bookings.bookingDate >=' => $Next_day];
			}

			
			
			//if($STATUS != ''){
			//		$condition[] = ['Bookings.rideStatus' => $STATUS];
			//}
			//pr($condition); die;
			$userservices =array();    
			$query = $this->Bookings->find('all')->where($condition);
			$myQuery = $query;
			if($usertype == 'Driver'){
				$Total_Amount = $this->Bookings->find('all')->select(['sum_total' => $myQuery->func()->sum('Bookings.totalAmount'),'sum_driver' => $myQuery->func()->sum('Bookings.driverAmount')])->where($condition)->toArray();
			
			}
			//echo "<pre>"; print_r($Total_Amount); print_r($Total_Amount_driver); die;
			$totalCount =  $query->count();
			if($pageNo <= ceil($totalCount/10)){
				$userservices = $this->paginate($query);
				$userservices = $userservices->toArray();
			}
			$Darray = array();
			$i=0; $TotalAmount = 0;$TotalDriverAmount=0;
			//echo "<pre>"; print_r($userservices); die;
			foreach($userservices as $userD){
				$Darray[$i]['bookingId'] 				= ($userD->id) ? $userD->id : '';
				$Darray[$i]['RequestPickupAddress'] 	= ($userD->RequestPickupAddress) ? $userD->RequestPickupAddress : '';
				//$Darray[$i]['bookingDate'] 			= ($userD->bookingDate) ? date("jS M", strtotime($userD->bookingDate)) : '';
				$Darray[$i]['RequestDropAddress'] 		= ($userD->RequestDropAddress) ? $userD->RequestDropAddress : '';
				$Darray[$i]['RequestPickupLatLong'] 	= ($userD->RequestPickupLatLong) ? $userD->RequestPickupLatLong : '';
				$Darray[$i]['RequestDropLatLong'] 		= ($userD->RequestDropLatLong) ? $userD->RequestDropLatLong : '';
				$Darray[$i]['rideStatus'] 				= ($userD->rideStatus) ? $userD->rideStatus : '0';
				$Darray[$i]['estimatedPrice'] 			= ($userD->estimatedPrice) ? $userD->estimatedPrice : '';
				$Darray[$i]['totalDistance'] 			= ($userD->totalDistance) ? $userD->totalDistance : 0;
				$Darray[$i]['FinalFare'] 				= ($userD->FinalFare) ? $userD->FinalFare : '';
				$Darray[$i]['totalAmount'] 				= ($userD->totalAmount) ? $userD->totalAmount : ''; // finalFare + tip + discount
				$Darray[$i]['driverAmount'] 			= ($userD->driverAmount) ? $userD->driverAmount : ''; // finalFare + tip + discount
				$TotalAmount += (int)$Darray[$i]['totalAmount'];
				$TotalDriverAmount += (int)$Darray[$i]['driverAmount'];
				$Darray[$i]['transactionId'] 			= ($userD->transactionId) ? $userD->transactionId : '';
				$Darray[$i]['paymentStatus'] 			= ($userD->paymentStatus) ? $userD->paymentStatus : '';
				$Darray[$i]['paymentMethod'] 			= ($userD->paymentMethod) ? $userD->paymentMethod : '';
				
				$Darray[$i]['vehicleNumber']= '';
				$Darray[$i]['VehicleColor'] = '';
				if(@$userD->driver->carinformations){
					foreach(@$userD->driver->carinformations as $VV){
						if($VV->id == $userD->categoryId){
							$Darray[$i]['vehicleNumber']= ($VV->carNumber) ?  $VV->carNumber : '';
							$Darray[$i]['VehicleColor'] = ($VV->carColor) ? $VV->carColor : '';
						}
					}
				} 
	
				if($usertype == 'Member'){
					$Darray[$i]['userId'] 				= (@$userD->driver->id) ? @$userD->driver->id : '';
					$Darray[$i]['fullName'] 			= (@$userD->driver->fullName) ? @$userD->driver->fullName : '';
					$Darray[$i]['email'] 				= (@$userD->driver->email) ? @$userD->driver->email : '';
					$Darray[$i]['zipCode'] 				= (@$userD->driver->zipCode) ? @$userD->driver->zipCode : '';
					$Darray[$i]['AVGRating'] 			= (@$userD->driver->AVGRating) ? @$userD->driver->AVGRating : '0';
					$Darray[$i]['latitude'] 			= (@$userD->driver->latitude) ? @$userD->driver->latitude : '';
					$Darray[$i]['longitude'] 			= (@$userD->driver->longitude) ? @$userD->driver->longitude : '';
					$Darray[$i]['contactNumber'] 		= (@$userD->driver->contactNumber) ? @$userD->driver->contactNumber :'';
					$Darray[$i]['image'] 				= (@$userD->driver->profile_picture) ? $this->profilePath.@$userD->driver->profile_picture : '';
				}else{
					$Darray[$i]['userId'] 				= (@$userD->user->id) ? @$userD->user->id : '';
					$Darray[$i]['fullName'] 			= (@$userD->user->fullName) ? @$userD->user->fullName : '';
					$Darray[$i]['email'] 				= (@$userD->user->email) ? @$userD->user->email : '';
					$Darray[$i]['zipCode'] 				= (@$userD->user->zipCode) ? @$userD->user->zipCode : '';
					$Darray[$i]['AVGRating'] 			= (@$userD->user->AVGRating) ? @$userD->user->AVGRating : '0';
					$Darray[$i]['latitude'] 			= (@$userD->user->latitude) ? @$userD->user->latitude : '';
					$Darray[$i]['longitude'] 			= (@$userD->user->longitude) ? @$userD->user->longitude : '';
					$Darray[$i]['contactNumber'] 		= (@$userD->user->contactNumber) ? @$userD->user->contactNumber :'';
					$Darray[$i]['image'] 				= (@$userD->user->profile_picture) ? $this->profilePath.@$userD->user->profile_picture : '';
				}
				
				$Darray[$i]['status'] 					= ($userD->status) ? $userD->status : 0;
				$Darray[$i]['CarName'] 					= (@$userD->category->name) ? @$userD->category->name : '';
				$Darray[$i]['perMile'] 					= (@$userD->category->perMile) ? @$userD->category->perMile : "0";
				$Darray[$i]['miniumFair'] 				= (@$userD->category->miniumFair) ? @$userD->category->miniumFair : "0";
				$Darray[$i]['carImage'] 				= (@$userD->category->image) ? $this->carPath.@$userD->category->image : "";
				$Darray[$i]['created'] 					= ($userD->created) ? date('m-d-Y H:i:s', strtotime($userD->created)) : '';
				$i++;
			}
			$response['status'] 			= 'success';
			$response['data'] 				= array_values($this->array_filter_recursive($Darray));
			$response['totalRide'] 			= $this->Bookings->find('all')->where(['Bookings.driverId'=>$userId,'Bookings.rideStatus'=>5])->count();
			$response['totalRide_conditon'] = $totalCount;
			$response['totalAmount'] 		= ($Total_Amount[0]->sum_total) ? $Total_Amount[0]->sum_total : 0;
			$response['totalDriverAmount'] = ($Total_Amount[0]->sum_driver) ? $Total_Amount[0]->sum_driver : 0;
			$response['AuthToken'] = $this->encodejwtreturn();
		}else{
			$response['status'] = "Fail";	
			$response['msg'] = "userId required";	
		}
		return $response;
	}

	private function getearning($user_id=NULL, $userType=NULL,$status=NULL,$dateBy=NULL){
		$this->loadModel('Bookings');
		$userId = ($user_id) ? $user_id : $this->request->data('userId');
		$STATUS = ($status) ? $status : $this->request->data('status');
		$usertype = ($userType) ? $userType : $this->request->data('usertype');
		$dateBY = ($dateBy) ? $dateBy : $this->request->data('dateBy');
		if($userId){
			$pageNo = ($this->request->data('pageNo')) ? $this->request->data('pageNo') : '1';
			$this->paginate = [
						'limit' => '1000',//$limit,
						'order' => ['Bookings.id' => 'desc'],
						'page'=>$pageNo,
						'contain'=>['Users','Vendors', 'Categories']
			];
			
			if($dateBY !=''){
				if($dateBY == 'Today'){
					$DATES = date('Y-m-d'). ' 00:00:01';
					$DATEE = date('Y-m-d'). ' 23:59:59';
					$condition[] = ['Bookings.created >=' => $DATES, 'Bookings.created <=' => $DATEE];
				}elseif($dateBY == 'Weekly'){
					$DATES = date("Y-m-d", strtotime("-7 days")). ' 00:00:01';
					$DATEE = date("Y-m-d"). ' 23:59:59';
					$condition[] = ['Bookings.created >=' => $DATES, 'Bookings.created <=' => $DATEE];
				}
			}
			
			$condition[] = ['Bookings.vendorId' => $userId];
			$condition[] = ['Bookings.status' => 2];
			$userservices =array();
			$TOTALAM = 0;
			$query = $this->Bookings->find('all')->where($condition)->select('totalAmount','SUM(totalAmount) AS amount');
			$totalCount =  $query->count();
			if($pageNo <= ceil($totalCount/10)){
					$userservices = $this->paginate($query);
					$userservices = $userservices->toArray();
			}
			$Darray = array();
			$i=0;
			//echo "<pre>"; print_r($userservices); die;
			foreach($userservices as $userD){
					$TOTALAM += $userD->totalAmount;
					$i++;
			}
			$response['status'] = 'success';
			$response['totalCount'] = $totalCount;
			$response['totalAmount'] = $TOTALAM;
	
		}else{
			$response['status'] = "Fail";	
			$response['msg'] = "userId required";	
		}
		return $response;
	}
	
		private function cashoutrequest(){
			$this->loadModel('Users');
			$this->loadModel('Cashoutrequests');
			if($this->request->data['userId'] !='' && $this->request->data['requestAmount'] !=''){
				$users = $this->Cashoutrequests->newEntity();
				$users = $this->Cashoutrequests->patchEntity($users, $this->request->data, ['validate' => false]);
				$users['created'] 	= date('Y-m-d H:i:s');
				$users['status'] 	= '1';
				if ($this->Cashoutrequests->save($users)) {
					$response['status'] = 'success';
					$response['msg'] = 'Cashout request sent successfully.';
					if(@$this->request->data['language'] =='bn'){
						$response['msg'] ="ক্যাশআউট অনুরোধ সফলভাবে পাঠানো হয়েছে।";
					}
					$response['AuthToken'] = $this->encodejwtreturn();
				}
			}else{
				$response['status'] = 'Fails';
				$response['msg'] = 'userId and amount are required.';
			}
			return  $response;
		}
			
		function cashoutlist($user_id=NULL){
			$this->loadModel('Users');
			$this->loadModel('Cashoutrequests');
			$userId = ($user_id) ? $user_id : $this->request->data('userId');
			$pageNo = ($this->request->data('pageNo')) ? $this->request->data('pageNo') : '1';
			if($userId !=''){
				$this->paginate = [
					'limit' => '10',//$limit,
					'order' => ['Cashoutrequests.id' => 'desc'],
					'page'=>$pageNo,
					//'contain'=>['Resturents','Categories']
				];
				$condition[] = '';
				if($userId != ''){
						$condition[] = ['Cashoutrequests.userId' => $userId];
				}
				$userservices =array();    
				$query = $this->Cashoutrequests->find('all')->where($condition);
				$totalCount =  $query->count();
				if($pageNo <= ceil($totalCount/10)){
						$userservices = $this->paginate($query);
						$userservices = $userservices->toArray();
				}
				$CATArray = array();
				$Darray = array();
				$i=0;
				//echo "<pre>"; print_r($userservices); die;
				foreach($userservices as $userD){
					$Darray[$i]['requestId']     = ($userD->id) ? $userD->id : '';
					$Darray[$i]['requestAmount'] = ($userD->requestAmount) ? $userD->requestAmount : '';
					$Darray[$i]['sendAmount'] 	 = ($userD->sendAmount) ? $userD->sendAmount : '';
					$Darray[$i]['sendDate'] 	 = ($userD->sendDate) ? date('m-d-Y H:i:s', strtotime($userD->sendDate)) : '';
					$Darray[$i]['created'] 		= ($userD->created) ? date('m-d-Y H:i:s', strtotime($userD->created)) : '';
					$i++;
				}
				$response['status'] = 'success';
				$response['data'] = array_values($this->array_filter_recursive($Darray));
				$response['AuthToken'] = $this->encodejwtreturn();
	
			}else{
				$response['status'] = 'Fails';
				$response['msg'] = 'UserId is required';
			}
			return $response;
		}
			
		function getwallet(){
			if($this->request->data['userId'] !=''){
				$this->loadModel('Users');
				$users = $this->Users->find()->where(['Users.id'=>$this->request->data['userId']])->select(['wallet'])->first();
				$response['status'] = "success";
				$response['wallet'] = ($users->wallet) ? $users->wallet : 0;
				//pr($users); die;
			}else{
				$response['status'] = 'Fails';
				$response['msg'] = 'USERID, foodId are required.';
			}
			return  $response;
		}
	
			
	function checkcoupon(){
		$this->loadModel('Coupons');
		if($this->request->data('userId') !='' && $this->request->data['code'] !=''){
			$coupons = $this->Coupons->find()->where(['Coupons.code'=>$this->request->data['code']])->first();
			if($coupons){
				$response['status'] = 'success';
				$response['description'] 	= ($coupons->description) ? $coupons->description : '';
				$response['amount'] 		= ($coupons->amount) ? $coupons->amount : '0';
				$response['percentage'] 	= ($coupons->percentage) ? $coupons->percentage : '0';
				$response['msg'] 			= "Coupon applied successfully.";	
			}else{
				$response['status'] = "Fail";	
				$response['msg'] = "Invalid coupon code";	
			}
		}else{
			$response['status'] = "Fail";	
			$response['msg'] = "invoiceId required";	
		}
		return $response;
	}
			
			
		function addcarinformation(){
			if($this->request->data['userId'] !='' && $this->request->data['categoryId'] !=''){
				$this->loadModel('Carinformations');
				$reviews = $this->Carinformations->newEntity();
				$reviews = $this->Carinformations->patchEntity($reviews, $this->request->data, ['validate' => false]);
				$fileName6 = '';
				if(@$_FILES['taxTokenImage']['name'] !='' && @$_FILES['taxTokenImage']['error'] == 0){
					$fileName6=time().stripslashes($_FILES['taxTokenImage']['name']);
					$fileName6= str_replace(" ","",$fileName6);
					$reviews['taxTokenImage']=$fileName6;
				}
				$fileName5 = '';
				if(@$_FILES['carImage']['name']){
					$fileName5=time().stripslashes($_FILES['carImage']['name']);
					$fileName5= str_replace(" ","",$fileName5);
					$reviews['carImage']=$fileName5;
				}
				$fileName1 = '';
				if(@$_FILES['carInsuranceImage']['name']){
					$fileName1=time().stripslashes($_FILES['carInsuranceImage']['name']);
					$fileName1= str_replace(" ","",$fileName1);
					$reviews['carInsuranceImage']=$fileName1;
				}
				$fileName2 = '';
				if(@$_FILES['vehiclePermitImage']['name']){
					$fileName2=time().stripslashes($_FILES['vehiclePermitImage']['name']);
					$fileName2= str_replace(" ","",$fileName2);
					$reviews['vehiclePermitImage']=$fileName2;
				}
				$fileName3 = '';
				if(@$_FILES['vehicleRegistationImage']['name']){
					$fileName3=time().stripslashes($_FILES['vehicleRegistationImage']['name']);
					$fileName3= str_replace(" ","",$fileName3);
					$reviews['vehicleRegistationImage']=$fileName3;
				}
				$reviews['created'] 	= date('Y-m-d H:i:s');
				$reviews['status'] 	= '1';
				$this->Carinformations->save($reviews);
				if(@$_FILES['taxTokenImage']['name'] !='' && $fileName6 !=''){
					$target = WWW_ROOT.'/img/uploads/cars/'.$fileName6;
					$source=$_FILES['taxTokenImage']['tmp_name'];
					move_uploaded_file($source,$target);
				}
				if(@$_FILES['carImage']['name'] !='' && $fileName5 !=''){
						$target = WWW_ROOT.'/img/uploads/cars/'.$fileName5;
						$source=$_FILES['carImage']['tmp_name'];
						move_uploaded_file($source,$target);
				}
				if(@$_FILES['carInsuranceImage']['name'] !='' && $fileName1 !=''){
						$target = WWW_ROOT.'/img/uploads/cars/'.$fileName1;
						$source=$_FILES['carInsuranceImage']['tmp_name'];
						move_uploaded_file($source,$target);
				}
				if(@$_FILES['vehiclePermitImage']['name'] !='' && $fileName2 !=''){
						$target = WWW_ROOT.'/img/uploads/cars/'.$fileName2;
						$source=$_FILES['vehiclePermitImage']['tmp_name'];
						move_uploaded_file($source,$target);
				}
				if(@$_FILES['vehicleRegistationImage']['name'] !='' && $fileName3 !=''){
						$target = WWW_ROOT.'/img/uploads/cars/'.$fileName3;
						$source=$_FILES['vehicleRegistationImage']['tmp_name'];
						move_uploaded_file($source,$target);
				}
				$articles = TableRegistry::get('Users');
				$query = $articles->query();
				$query->update()
					->set(['categoryId' =>$this->request->data['categoryId']])
					->where(['id' => $this->request->data['userId']])
					->execute();
			
				$response['status'] = 'Success'; 
				$response['msg'] = "Car Information saved successfully.";
				$DD = $this->carinformationdetails($reviews->id);
				$response['data'] = $DD['data'];
				$response['AuthToken'] = $this->encodejwtreturn();
			}else{
				$response['status'] = 'Fail'; 
				$response['msg'] = 'userId, categoryId and carNumber are required.';
			}
			return $response;
		}
			
		function editcarinformation(){
			if($this->request->data['userId'] !='' && $this->request->data['carinformationId'] !=''){
				$this->loadModel('Carinformations');
				$reviews = $this->Carinformations->find()->where(['Carinformations.id'=>$this->request->data['carinformationId'],'Carinformations.userId'=>$this->request->data['userId']])->first();
				if(@$reviews->id !=''){
					unset($this->request->data['carInsuranceImage']);
					unset($this->request->data['vehiclePermitImage']);
					unset($this->request->data['carImage']);
					unset($this->request->data['taxTokenImage']);
					unset($this->request->data['vehicleRegistationImage']);
					
					$fileName6 = '';
					if(@$_FILES['taxTokenImage']['name'] !='' && @$_FILES['taxTokenImage']['error'] == 0){
						$fileName6=time().stripslashes($_FILES['taxTokenImage']['name']);
						$fileName6= str_replace(" ","",$fileName6);
						$this->request->data['taxTokenImage']=$fileName6;
						$OLDTaxToken  = $reviews->taxTokenImage;
					}
					
					$fileName5 = '';
					if(@$_FILES['carImage']['name'] !='' && @$_FILES['carImage']['error'] == 0){
						$fileName5=time().stripslashes($_FILES['carImage']['name']);
						$fileName5= str_replace(" ","",$fileName5);
						$this->request->data['carImage']=$fileName5;
						$OLDCARI  = $reviews->carImage;
					}
					
					$fileName1 = '';
					if(@$_FILES['carInsuranceImage']['name'] !='' && @$_FILES['carInsuranceImage']['error'] == 0){
						$fileName1=time().stripslashes($_FILES['carInsuranceImage']['name']);
						$fileName1= str_replace(" ","",$fileName1);
						$this->request->data['carInsuranceImage']=$fileName1;
						$OLDCI  = $reviews->carInsuranceImage;
					}
					$fileName2 = '';
					if(@$_FILES['vehiclePermitImage']['name'] !='' && @$_FILES['vehiclePermitImage']['error'] == 0){
						$fileName2=time().stripslashes($_FILES['vehiclePermitImage']['name']);
						$fileName2= str_replace(" ","",$fileName2);
						$this->request->data['vehiclePermitImage']=$fileName2;
						$OLDVP  = $reviews->vehiclePermitImage;
					}
					$fileName3 = '';
					if(@$_FILES['vehicleRegistationImage']['name'] !='' && @$_FILES['vehicleRegistationImage']['error'] == 0){
						$fileName3=time().stripslashes($_FILES['vehicleRegistationImage']['name']);
						$fileName3= str_replace(" ","",$fileName3);
						$this->request->data['vehicleRegistationImage']=$fileName3;
						$OLDVR  = $reviews->vehicleRegistationImage;
					}
					
					$reviews = $this->Carinformations->patchEntity($reviews, $this->request->data, ['validate' => false]);
					$reviews['created'] 	= date('Y-m-d H:i:s');
					$reviews['status'] 	= '1';
					$reviews['update_admin_approve'] = 2;
					$this->Carinformations->save($reviews);
					if(@$this->request->data['categoryId']){
						$articles = TableRegistry::get('Users');
						$query = $articles->query();
						$query->update()
							->set(['categoryId' =>@$this->request->data['categoryId']])
							->where(['id' => $this->request->data['userId']])
							->execute();
					}
					if(@$_FILES['taxTokenImage']['name'] !='' && $fileName6 !=''){
						$target = WWW_ROOT.'/img/uploads/cars/'.$fileName6;
						$source=$_FILES['taxTokenImage']['tmp_name'];
						move_uploaded_file($source,$target);
						@unlink(WWW_ROOT . 'img/uploads/cars/'.$OLDTaxToken);
					}
					if(@$_FILES['carImage']['name'] !='' && $fileName5 !=''){
						$target = WWW_ROOT.'/img/uploads/cars/'.$fileName5;
						$source=$_FILES['carImage']['tmp_name'];
						move_uploaded_file($source,$target);
						@unlink(WWW_ROOT . 'img/uploads/cars/'.$OLDCARI);
					}
					if(@$_FILES['carInsuranceImage']['name'] !='' && $fileName1 !=''){
						$target = WWW_ROOT.'/img/uploads/cars/'.$fileName1;
						$source=$_FILES['carInsuranceImage']['tmp_name'];
						move_uploaded_file($source,$target);
						@unlink(WWW_ROOT . 'img/uploads/cars/'.$OLDCI);
					}
					if(@$_FILES['vehiclePermitImage']['name'] !='' && $fileName2 !=''){
						$target = WWW_ROOT.'/img/uploads/cars/'.$fileName2;
						$source=$_FILES['vehiclePermitImage']['tmp_name'];
						move_uploaded_file($source,$target);
						@unlink(WWW_ROOT . 'img/uploads/cars/'.$OLDVP);
					}
					if(@$_FILES['vehicleRegistationImage']['name'] !='' && $fileName3 !=''){
						$target = WWW_ROOT.'/img/uploads/cars/'.$fileName3;
						$source=$_FILES['vehicleRegistationImage']['tmp_name'];
						move_uploaded_file($source,$target);
						@unlink(WWW_ROOT . 'img/uploads/cars/'.$OLDVR);
					}
					$response['status'] = 'Success'; 
					$response['msg'] = "Car Information saved successfully.";
					$DD = $this->carinformationdetails($reviews->id);
					$response['data'] = $DD['data'];
					$response['AuthToken'] = $this->encodejwtreturn();
				}else{
					$response['status'] = 'Fail'; 
					$response['msg'] = 'Car information no longer available.';
				}
			}else{
				$response['status'] = 'Fail'; 
				$response['msg'] = 'userId, categoryId and carNumber are required.';
			}
			return $response;
		}
			
		private function carinformationlist($userId=NULL){
			$this->loadModel('Users');
			$this->loadModel('Carinformations');
			@$USERID = ($userId) ? $userId : $this->request->data('userId');
			@$pageNo = ($this->request->data['pageNo']) ? $this->request->data['pageNo'] : 1;
			if($USERID !=''){
				$carInfromations = $this->Carinformations->find()->where(['Carinformations.userId'=>$USERID])->contain(['Categories'])->toArray();
				$Darray = array();
				$i=0;
				//echo "<pre>"; print_r($userservices); die;
				foreach($carInfromations as $val){
					$Darray[$i]['carinformationId'] 			= ($val->id) ? $val->id : '';
					$Darray[$i]['userId'] 						= ($val->userId) ? $val->userId : '';
					$Darray[$i]['categoryId'] 					= ($val->categoryId) ? $val->categoryId : '';
					$Darray[$i]['categoryName'] 				= (@$val->category->name) ? @$val->category->name : '';
						
					$Darray[$i]['carNumber'] 					= ($val->carNumber) ? $val->carNumber : '';
					$Darray[$i]['carModel'] 					= ($val->carModel) ? $val->carModel : '';
					$Darray[$i]['carYear'] 						= ($val->carYear) ? $val->carYear : '';
					$Darray[$i]['carColor'] 					= ($val->carColor) ? $val->carColor : '';
					$Darray[$i]['carBrand'] 					= ($val->carYear) ? $val->carBrand : '';
					$Darray[$i]['carInsuranceNo'] 				= ($val->carInsuranceNo) ? $val->carInsuranceNo : '';
					$Darray[$i]['carInsuranceImage'] 			= ($val->carInsuranceImage) ? $this->carPath.$val->carInsuranceImage : '';
					$Darray[$i]['CarRegistrationNo'] 			= ($val->CarRegistrationNo) ? $val->CarRegistrationNo : '';
					$Darray[$i]['registration_state'] 			= ($val->registration_state) ? $val->registration_state : '';
					$Darray[$i]['vehicleRegistationImage'] 		= ($val->vehicleRegistationImage) ? $this->carPath.$val->vehicleRegistationImage : '';
					$Darray[$i]['taxTokenImage'] 				= ($val->taxTokenImage) ? $this->carPath.$val->taxTokenImage : '';

					$Darray[$i]['vehiclePermitIsssuesDate']		= ($val->vehiclePermitIsssuesDate) ? $val->vehiclePermitIsssuesDate : '';
					$Darray[$i]['vehiclePermitIsssuesExpDate']	= ($val->vehiclePermitIsssuesExpDate) ? $val->vehiclePermitIsssuesExpDate : '';
					$Darray[$i]['vehiclePermitNo'] 				= ($val->vehiclePermitNo) ? $val->vehiclePermitNo : '';
					$Darray[$i]['vehiclePermitImage']			= ($val->vehiclePermitImage) ? $this->carPath.$val->vehiclePermitImage : '';
					
					
					$Darray[$i]['insurenceissueDate'] 			= ($val->insurenceissueDate) ? $val->insurenceissueDate : '';
					$Darray[$i]['expDate'] 						= ($val->expDate) ? $val->expDate : '';
					$Darray[$i]['noOfPassagenger'] 				= ($val->noOfPassagenger) ? $val->noOfPassagenger : '';
					$Darray[$i]['policeholder'] 				= ($val->policeholder) ? $val->policeholder : '';
					$Darray[$i]['isurenceCompony'] 				= ($val->isurenceCompony) ? $val->isurenceCompony : '';
					$Darray[$i]['carImage'] 					= ($val->carImage) ? $this->carPath.$val->carImage : '';

					$Darray[$i]['vehicleType'] 					= ($val->vehicleType) ? $val->vehicleType : '';
					$Darray[$i]['registration_state'] 			= ($val->registration_state) ? $val->registration_state : '';
					$Darray[$i]['update_admin_approve'] 		= (@$val->update_admin_approve) ? @$val->update_admin_approve : '';
					$Darray[$i]['created'] 						= ($val->created) ? date("M jS, Y, g:i a", strtotime($val->created)) : '';
					$i++;
				}
				$response['status'] = "success";
				$response['data'] = ($Darray) ? $this->array_filter_recursive($Darray) : array();
				$response['AuthToken'] = $this->encodejwtreturn();
					
			}else{
				$response['status'] = 'Fails';
				$response['msg'] = 'USERID is required.';
		}
		return  $response;
		}
			
		private function carinformationdetails($CarId=NULL){
			$this->loadModel('Users');
			$this->loadModel('Carinformations');
			@$CARID = ($CarId) ? $CarId : $this->request->data('carinformationId');
		
			if($CARID !=''){
				$val = $this->Carinformations->find()->where(['Carinformations.id'=>$CARID])->first();
				$Darray = array();
				$i=0;
				//echo "<pre>"; print_r($userservices); die;
				$Darray['carinformationId'] 			= ($val->id) ? $val->id : '';
				$Darray['userId'] 						= ($val->userId) ? $val->userId : '';
				$Darray['categoryId'] 					= ($val->categoryId) ? $val->categoryId : '';
			
				$Darray['carNumber'] 					= ($val->carNumber) ? $val->carNumber : '';
				$Darray['carModel'] 					= ($val->carModel) ? $val->carModel : '';
				$Darray['carYear'] 						= ($val->carYear) ? $val->carYear : '';
				$Darray['carColor'] 					= ($val->carColor) ? $val->carColor : '';
				$Darray['carBrand'] 					= ($val->carYear) ? $val->carBrand : '';
				$Darray['carInsuranceNo'] 				= ($val->carInsuranceNo) ? $val->carInsuranceNo : '';
				$Darray['carInsuranceImage'] 			= ($val->carInsuranceImage) ? $this->carPath.$val->carInsuranceImage : '';
				$Darray['CarRegistrationNo'] 			= ($val->CarRegistrationNo) ? $val->CarRegistrationNo : '';
				$Darray['registration_state'] 			= ($val->registration_state) ? $val->registration_state : '';
				$Darray['vehicleRegistationImage'] 		= ($val->vehicleRegistationImage) ? $this->carPath.$val->vehicleRegistationImage : '';
				$Darray['taxTokenImage'] 				= ($val->taxTokenImage) ? $this->carPath.$val->taxTokenImage : '';

				$Darray['vehiclePermitIsssuesDate']		= ($val->vehiclePermitIsssuesDate) ? $val->vehiclePermitIsssuesDate : '';
				$Darray['vehiclePermitIsssuesExpDate']	= ($val->vehiclePermitIsssuesExpDate) ? $val->vehiclePermitIsssuesExpDate : '';
				$Darray['vehiclePermitNo'] 				= ($val->vehiclePermitNo) ? $val->vehiclePermitNo : '';
				$Darray['vehiclePermitImage']			= ($val->vehiclePermitImage) ? $this->carPath.$val->vehiclePermitImage : '';
				$Darray['insurenceissueDate'] 			= ($val->insurenceissueDate) ? $val->insurenceissueDate : '';
				$Darray['expDate'] 						= ($val->expDate) ? $val->expDate : '';
				$Darray['noOfPassagenger'] 				= ($val->noOfPassagenger) ? $val->noOfPassagenger : '';
				$Darray['policeholder'] 				= ($val->policeholder) ? $val->policeholder : '';
				$Darray['isurenceCompony'] 				= ($val->isurenceCompony) ? $val->isurenceCompony : '';
				$Darray['update_admin_approve'] 		= ($val->update_admin_approve) ? $val->update_admin_approve : '';
				$Darray['carImage'] 					= ($val->carImage) ? $this->carPath.$val->carImage : '';
				$Darray['created'] 						= ($val->created) ? date("M jS, Y, g:i a", strtotime($val->created)) : '';
					
				$response['status'] = "success";
				$response['data'] = ($Darray) ? $this->array_filter_recursive($Darray) : array();
				$response['AuthToken'] = $this->encodejwtreturn();
					
			}else{
				$response['status'] = 'Fails';
				$response['msg'] = 'CARID is required.';
			}
			return  $response;
		}
			
	
		
		function submitreview(){
			if($this->request->data['reviewTo'] !='' && $this->request->data['reviewFrom'] !='' && $this->request->data['star'] != ''){
				$this->loadModel('Reviews');
				$this->loadModel('Users');
				$reviews = $this->Reviews->newEntity();
				$reviews = $this->Reviews->patchEntity($reviews, $this->request->data, ['validate' => false]);
				$reviews['created'] 	= date('Y-m-d H:i:s');
				$reviews['status'] 	= '1';
				$this->Reviews->save($reviews);
				
				//$avg = $this->Reviews->find('all')->where(['Reviews.reviewTo'=>$this->request->data['reviewTo']])->select(['averagerating' => $query->func()->avg('star')]);
				$query = $this->Reviews->find()->where(['Reviews.reviewTo'=>$this->request->data['reviewTo']]);
				$avg = $query->select(['averagerating' => $query->func()->avg('star')])->toArray();
				//echo "<pre>"; print_r($avg);
				//echo $avg[0]->averagerating;
				//die;
				
				$ABG['AVGRating'] = round($avg[0]->averagerating,2);
				$AVGR = round($avg[0]->averagerating,2);
				$articles = TableRegistry::get('Users');
				$query = $articles->query();
				$query->update()
					->set(['AVGRating' =>$AVGR])
					->where(['id' => $this->request->data['reviewTo']])
					->execute();
							
				$response['status'] = 'Success'; 
				$response['msg'] = "Review submitted successfully.";
				if(@$this->request->data['language'] =='bn'){
					$response['msg'] ="পর্যালোচনা সফলভাবে জমা দেওয়া হয়েছে";
				}
				$response['AuthToken'] = $this->encodejwtreturn();
			}else{
				$response['status'] = 'Fail'; 
				$response['msg'] = 'review_to, review_from, star and message are required.';
			}
			return $response;
		}
	
		private function reviewlist($userId=NULL){
			$this->loadModel('Users');
			$this->loadModel('Reviews');
			@$USERID = ($userId) ? $userId : $this->request->data('userId');
			@$pageNo = ($this->request->data['pageNo']) ? $this->request->data['pageNo'] : 1;
			if($USERID !=''){
				$this->paginate = [
					'limit' => '10',//$limit,
					'order' => ['Reviews.id' => 'desc'],
					'page'=>$pageNo,
					'contain' => ['Reviewfroms']
				];
				$users = $this->Users->find()->where(['Users.id'=>$USERID])->first();
				$keyword = $this->request->query('keyword');
				$condition[] = ['Reviews.reviewTo'=>$USERID, 'Reviews.status'=>1];
				$userservices = array();    
				$query = $this->Reviews->find('all')->where($condition);
				$totalCount =  $query->count();
				if($pageNo <= ceil($totalCount/10)){
					$userservices = $this->paginate($query);
					$userservices = $userservices->toArray();
				}
				$Darray = array();
				$i=0;
				//echo "<pre>"; print_r($userservices); die;
				foreach($userservices as $val){
					$Darray[$i]['reviewId'] 			= ($val->id) ? $val->id : '';
					$Darray[$i]['message'] 				= ($val->message) ? $val->message : '';
					$Darray[$i]['star'] 				= ($val->star) ? $val->star : '';
					$Darray[$i]['created'] 				= ($val->created) ? date("M jS, Y, g:i a", strtotime($val->created)) : '';
		
					$Darray[$i]['userId'] 				= (@$val->reviewfrom->id) ? @$val->reviewfrom->id : '';
					$Darray[$i]['userName'] 			= (@$val->reviewfrom->fullName) ? @$val->reviewfrom->fullName : '';
					$Darray[$i]['userAddress'] 			= (@$val->reviewfrom->address) ? @$val->reviewfrom->address : '';
					$Darray[$i]['profile_picture']		= (@$val->reviewfrom->profile_picture) ? $this->profilePath.@$val->reviewfrom->profile_picture : '';
					$i++;
				}
				$response['status'] = "success";
				$response['data'] 			= ($Darray) ? $this->array_filter_recursive($Darray) : array();
				$response['ONESTAR'] 		= $this->Reviews->find('all')->where(['Reviews.reviewTo'=>$USERID,'Reviews.star'=>1])->count();
				$response['ONETWO'] 		= $this->Reviews->find('all')->where(['Reviews.reviewTo'=>$USERID,'Reviews.star'=>2])->count();
				$response['ONETHREE']		= $this->Reviews->find('all')->where(['Reviews.reviewTo'=>$USERID,'Reviews.star'=>3])->count();
				$response['ONEFOUR'] 		= $this->Reviews->find('all')->where(['Reviews.reviewTo'=>$USERID,'Reviews.star'=>4])->count();
				$response['ONEFIVE'] 		= $this->Reviews->find('all')->where(['Reviews.reviewTo'=>$USERID,'Reviews.star'=>5])->count();
				$response['reviewCount'] 	= $totalCount;
				$response['AVGRating'] 		= ($users->AVGRating) ? $users->AVGRating : '0';
				$response['AuthToken'] = $this->encodejwtreturn();
			}else{
				$response['status'] = 'Fails';
				$response['msg'] = 'USERID is required.';
			}
			return  $response;
		}
		
		
		function referral($userId=NULL){
			@$USERID = ($userId) ? $userId : $this->request->data('userId');
			$response['status'] = "success";
			$response['code'] = base64_encode(base64_encode($USERID));
			return  $response;
		}
	
	function logout(){
		if($this->request->data['userId'] !=''){
			$this->loadModel('Users');
			$users = $this->Users->find()->where(['Users.id'=>$this->request->data['userId']])->first();
			$this->request->data['deviceToken'] = '';
			$this->request->data['device'] = '';
			$users = $this->Users->patchEntity($users, $this->request->data, ['validate' => false]);
			$this->Users->save($users);
			$response['status'] = "success";
			$response['msg'] = 'Logout successfully.';
		}else{
			$response['status'] = 'Fails';
			$response['msg'] = 'USERID is required.';
		}
		return  $response;					
	}
	
	
	function getprice(){
		if(@$this->request->data['userId'] !='' && $this->request->data['pickuplatLong'] !='' && $this->request->data['droplatLong'] !='' && $this->request->data['categoryId'] !=''){
			$pickuplatLong = explode(',',$this->request->data['pickuplatLong']);
			$droplatLong 	= explode(',',$this->request->data['droplatLong']);
			$pickuplat 		= $pickuplatLong[0];
			$pickuplong 	= $pickuplatLong[1];
			$droplat 		= $droplatLong[0];
			$droplong		= $droplatLong[1];
			
			$this->loadModel('Categories');$this->loadModel('Bookings');
			$categoryL = $this->Categories->find()->where(['Categories.id'=>$this->request->data['categoryId'],'Categories.status'=>1])->first();
			$url ="https://maps.googleapis.com/maps/api/distancematrix/json?units=imperial&key=AIzaSyB3sYhSTD7GEn1j6SsH-QL_GVNG6oUsfM0&origins=".$this->request->data['pickuplatLong']."&destinations=".$this->request->data['droplatLong']."&mode=car";
			//die;
			//$url ="https://maps.googleapis.com/maps/api/distancematrix/json?units=imperial&key=AIzaSyA2dE-WpZUYM_2CbBH8_Jh97bY1AJCWoHg&origins=".$this->request->data['pickuplatLong']."&destinations=".$this->request->data['droplatLong'];
			$ch = curl_init();
			// Disable SSL verification
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
			// Will return the response, if false it print the response
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
			// Set the url
			curl_setopt($ch, CURLOPT_URL,$url);
			// Execute
			$result=curl_exec($ch);
			// Closing
			curl_close($ch);
			//echo "<pre>"; print_r(json_decode($result));
				//echo round($result->rows->elements->duration->value*0.000621371192, 2);
			//die;
			$result_array2=json_decode($result);
			$DDS = explode(" ",@$result_array2->rows[0]->elements[0]->distance->text);
			$distance = $DDS[0];
			
				$CATT = array();
				$j = 0;
				//foreach($categoryLIST as $categoryL){
						$CATT['ID'] 				= $categoryL->id;
						$CATT['distance'] 			= (@$distance) ? @$distance : 0;
						$res_distance = preg_replace("/[^0-9-\+\.]+/", "", @$distance);
						$CATT['duration'] 			= @$result_array2->rows[0]->elements[0]->duration->text;
						$TOTAL_MIN 		= ceil((@$result_array2->rows[0]->elements[0]->duration->value) /60 );
						$CATT['total'] 				= round( ( (@$res_distance * $categoryL->perMile) + ($TOTAL_MIN * $categoryL->watingTime) + $categoryL->basic + $categoryL->booking_fee), 2);
						if($CATT['total'] < $categoryL->miniumFair){
							$CATT['total'] = $categoryL->miniumFair;	
						}
						$CATT['Discount_percentage'] = $categoryL->perDiscount;
						$CATT['Promotional_total'] = $CATT['total'];
						if($categoryL->perDiscount > 0){
							$CATT['Promotional_total'] = round(($CATT['total'] * $categoryL->perDiscount)/100,2);
						}

					$j++;
				//}

				$newcondition = ['Bookings.userId'=>$this->request->data['userId'],
				'OR'=>[
					['Bookings.rideStatus IN'=>[1,2,3,4],'Bookings.bookingTime IS'=>NULL],
					['Bookings.rideStatus IN'=>[1,2,3,4],'Bookings.bookingTime <='=>date('H:i',time() + 1800),'Bookings.bookingDate'=>date('Y-m-d')]
					]
				];
				//echo date('Y-m-d H:i');
				//pr($newcondition);
				$historydata = $this->Bookings->find()->where($newcondition)->order(['Bookings.id'=>'desc'])->first();
				//pr($historydata); die('YESSSSSSSSSSSSS');
				$CATT['activeRide'] 				= 0;
				if($historydata){
					$CATT['activeRide'] 			= 1;
				}

			$response['status'] = 'success';
			$response['data'] = $CATT;
		}else{
			$response['status'] = 'Fails';
			$response['msg'] = 'carId ,pickuplatLong, categoryId and droplatLong is required';
		}
		return $response;
	}

	function listbyprice(){
		if(@$this->request->data['userId'] !='' && $this->request->data['pickuplatLong'] !='' && $this->request->data['droplatLong'] !=''){
			$pickuplatLong = explode(',',$this->request->data['pickuplatLong']);
			$droplatLong 	= explode(',',$this->request->data['droplatLong']);
			$pickuplat 		= $pickuplatLong[0];
			$pickuplong 	= $pickuplatLong[1];
			$droplat 		= $droplatLong[0];
			$droplong		= $droplatLong[1];
			
			$type = (@$this->request->data['TYPE']) ? @$this->request->data['TYPE'] : 'CAR';

			$this->loadModel('Categories');$this->loadModel('Bookings');
			$categoryLIST = $this->Categories->find()->where(['Categories.status'=>1,'Categories.TYPE'=>$type])->toArray();
			$url ="https://maps.googleapis.com/maps/api/distancematrix/json?units=imperial&key=AIzaSyB3sYhSTD7GEn1j6SsH-QL_GVNG6oUsfM0&origins=".$this->request->data['pickuplatLong']."&destinations=".$this->request->data['droplatLong']."&mode=car";
			//echo "<pre>"; print_r($categoryLIST);
			//die;
			//$url ="https://maps.googleapis.com/maps/api/distancematrix/json?units=imperial&key=AIzaSyA2dE-WpZUYM_2CbBH8_Jh97bY1AJCWoHg&origins=".$this->request->data['pickuplatLong']."&destinations=".$this->request->data['droplatLong'];
			$ch = curl_init();
			// Disable SSL verification
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
			// Will return the response, if false it print the response
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
			// Set the url
			curl_setopt($ch, CURLOPT_URL,$url);
			// Execute
			$result=curl_exec($ch);
			// Closing
			curl_close($ch);
			//echo "<pre>"; print_r(json_decode($result));
				//echo round($result->rows->elements->duration->value*0.000621371192, 2);
			//die;
			$result_array2=json_decode($result);
			$DDS = explode(" ",@$result_array2->rows[0]->elements[0]->distance->text);
			$distance = $DDS[0];
			
				$CATT = array();
				$j = 0;
				foreach($categoryLIST as $categoryL){
					$CATT[$j]['ID'] 				= $categoryL->id;
					if(@$this->request->data['language'] == 'bn'){
						$CATT[$j]['name'] 	= $categoryL->name_B;
					}else{
						$CATT[$j]['name'] 	= $categoryL->name;
					}
					
					$CATT[$j]['TYPE'] 		= $categoryL->TYPE;
					$CATT[$j]['noOfPerson'] = $categoryL->noOfPerson;
					$CATT[$j]['perMile'] 	= ($categoryL->perMile) ? $categoryL->perMile : "0";
					$CATT[$j]['image'] 		= ($categoryL->image) ? $this->catPath.$categoryL->image : '';

					$CATT[$j]['distance'] 	= (@$distance) ? @$distance : 0;
					$res_distance = preg_replace("/[^0-9-\+\.]+/", "", @$distance);
					$CATT[$j]['duration'] 	= @$result_array2->rows[0]->elements[0]->duration->text;
					$TOTAL_MIN 				= ceil((@$result_array2->rows[0]->elements[0]->duration->value) /60 );
					$CATT[$j]['total'] 		= round( ( (@$res_distance * $categoryL->perMile) + ($TOTAL_MIN * $categoryL->watingTime) + $categoryL->basic + $categoryL->booking_fee), 2);
					if($CATT[$j]['total'] < $categoryL->miniumFair){
						$CATT[$j]['total'] = $categoryL->miniumFair;	
					}
					$CATT[$j]['Discount_percentage'] = $categoryL->perDiscount;
					$CATT[$j]['Promotional_total'] = $CATT[$j]['total'];
					if($categoryL->perDiscount > 0){
						$CATT[$j]['Promotional_total'] = round(($CATT[$j]['total'] * $categoryL->perDiscount)/100,2);
					}
					$j++;
				}

				// $newcondition = ['Bookings.userId'=>$this->request->data['userId'],
				// 'OR'=>[
				// 	['Bookings.rideStatus IN'=>[1,2,3,4],'Bookings.bookingTime IS'=>NULL],
				// 	['Bookings.rideStatus IN'=>[1,2,3,4],'Bookings.bookingTime <='=>date('H:i',time() + 1800),'Bookings.bookingDate'=>date('Y-m-d')]
				// 	]
				// ];
				//echo date('Y-m-d H:i');
				//pr($newcondition);
				// $historydata = $this->Bookings->find()->where($newcondition)->order(['Bookings.id'=>'desc'])->first();
				// //pr($historydata); die('YESSSSSSSSSSSSS');
				// $CATT['activeRide'] 				= 0;
				// if($historydata){
				// 	$CATT['activeRide'] 			= 1;
				// }

			$response['status'] = 'success';
			$response['data'] = $CATT;
		}else{
			$response['status'] = 'Fails';
			$response['msg'] = 'pickuplatLong, categoryId and droplatLong is required';
		}
		return $response;
	}
	
	
	function array_filter_recursive($array) {
		foreach ($array as $key => & $value) {
			if (is_array($value)) {
				$value = $this->array_filter_recursive($value);
			}
			else {
				if ( ! is_null($value)) {
				}
				else {
					$array[$key] = '';
				}
			}
		}
		return $array;
	}
	
	function help(){
		$data['phone'] 	= '180-234-5678';
		$data['whatsappNumber'] 	= '180-234-5678';
		$data['eamil'] = 'support@Pathmark.com';
		$response['status'] = 'success';
		$response['data'] = $data;
		return  $response;
	}
	
	
	function distance($lat1=NULL, $lon1=NULL, $lat2=NULL, $lon2=NULL, $unit=NULL) {
		if (($lat1 == $lat2) && ($lon1 == $lon2)) {
			return 0;
		}
		else {
			$theta = (float)$lon1 - (float)$lon2;
			$dist = sin(deg2rad((float)$lat1)) * sin(deg2rad((float)$lat2)) +  cos(deg2rad((float)$lat1)) * cos(deg2rad((float)$lat2)) * cos(deg2rad((float)$theta));
			$dist = acos($dist);
			$dist = rad2deg($dist);
			$miles = $dist * 60 * 1.1515;
			$unit = strtoupper($unit);

			if ($unit == "K") {
				return ($miles * 1.609344);
			} else if ($unit == "N") {
				return ($miles * 0.8684);
			} else {
				return $miles;
			}
		}
	}
	
	function testnotification(){
		$deviceToken = $this->request->data['deviceToken'];
		$message['message'] = $this->request->data['message'];
		//$message = $this->request->data;
		if(strtolower(@$this->request->data['device']) =='ios'){
			$result = $this->sednIosPushNotification(@$deviceToken,$message);
			
		}else{
			$result = $this->sendNotificationOnAndroid(@$deviceToken,$message);
		}
		echo "<pre>"; print_r($result); die;
	}

	function notificationall(){
		$deviceToken = $this->request->data['deviceToken'];
		$bodyV = $this->request->data;
		$bodyV['message'] = $this->request->data['message'];
		//die('www');
		if(strtolower(@$this->request->data['device']) =='ios'){
			$result = $this->sednIosPushNotification(@$deviceToken,$bodyV);
		}else{
			$result = $this->sendNotificationOnAndroid(@$deviceToken,$bodyV);
		}
		$response['status'] = 'success';
		$response['msg'] = 'Notification sent successfully.';
		return  $response;
	}

	function currenttime(){
		$response['currentTime date'] = date('Y-m-d H:i:s');
		$response['milisecond'] = time();
		echo json_encode($response); die;
	}



	private function addressadd(){
		if($this->request->data['userId'] !='' && $this->request->data['coordinate'] !='' && $this->request->data['address'] != '' && $this->request->data['addressType'] !=''){
			$this->loadModel('Addresses');
			if(@$this->request->data['addressId'] !=''){
				$addresses = $this->Addresses->find()->where(['Addresses.id'=>$this->request->data['addressId']])->first();
			}else{
				$addresses = $this->Addresses->newEntity();
			}
			$addresses = $this->Addresses->patchEntity($addresses, $this->request->data, ['validate' => false]);
			$this->Addresses->save($addresses);
										
			$response['status'] = 'Success'; 
			if(@$this->request->data['addressId'] !=''){
				$response['msg'] = "Addresses updated successfully.";
			}else{
				$response['msg'] = "Addresses added successfully.";
			}
			$response['AuthToken'] = $this->encodejwtreturn();
		}else{
			$response['status'] = 'Fail'; 
			$response['msg'] = 'userId, coordinate, address and addressType are required.';
		}
		return $response;
	}

	private function addresslist($userId=NULL){
		$this->loadModel('Addresses');
		@$USERID = ($userId) ? $userId : $this->request->data('userId');
		@$pageNo = ($this->request->data['pageNo']) ? $this->request->data['pageNo'] : 1;
		if($USERID !=''){
			$this->paginate = [
				'limit' => '10',//$limit,
				'order' => ['Addresses.id' => 'desc'],
				'page'=>$pageNo,
				//'contain' => ['Reviewfroms']
			];
			
			$keyword = $this->request->query('keyword');
			$condition[] = ['Addresses.userId'=>$USERID, 'Addresses.status'=>1];
			$userservices = array();    
			$query = $this->Addresses->find('all')->where($condition);
			$totalCount =  $query->count();
			if($pageNo <= ceil($totalCount/10)){
				$userservices = $this->paginate($query);
				$userservices = $userservices->toArray();
			}
			$Darray = array();
			$i=0;
			//echo "<pre>"; print_r($userservices); die;
			foreach($userservices as $val){
				$Darray[$i]['addressId'] 			= ($val->id) ? $val->id : '';
				$Darray[$i]['coordinate'] 			= ($val->coordinate) ? $val->coordinate : '';
				$Darray[$i]['address'] 				= ($val->address) ? $val->address : '';
				$Darray[$i]['addressType'] 			= ($val->addressType) ? $val->addressType : 0;
				$Darray[$i]['address_Info'] 		= ($val->address_Info) ? $val->address_Info : 0;
				$Darray[$i]['address_name'] 		= ($val->address_name) ? $val->address_name : 0;
				$Darray[$i]['userId'] 				= ($val->userId) ? $val->userId : '';
				$i++;
			}
			$response['status'] = "success";
			$response['data'] 	= ($Darray) ? $this->array_filter_recursive($Darray) : array();
			$response['AuthToken'] = $this->encodejwtreturn();
		}else{
			$response['status'] = 'Fails';
			$response['msg'] = 'USERID is required.';
		}
		return  $response;
	}


	private function addressdelete(){
		if($this->request->data['userId'] !='' && $this->request->data['addressId'] !='' ){
			$this->loadModel('Addresses');
			
			$addresses = $this->Addresses->find()->where(['Addresses.id'=>$this->request->data['addressId'],'Addresses.userId'=>$this->request->data['userId']])->first();
			if(@$addresses->id !=''){
				$this->Addresses->delete($addresses);
				$response['status'] = 'Success'; 
				$response['msg'] = "Addresses deleted successfully.";
			}else{
				$response['status'] = 'Fails';
				$response['msg'] = 'Address no longer available.';
			}										
			$response['AuthToken'] = $this->encodejwtreturn();
		}else{
			$response['status'] = 'Fail'; 
			$response['msg'] = 'userId and addressId are required.';
		}
		return $response;
	}
	

	function couponlist(){
		$this->loadModel('Coupons');
		if(@$this->request->data['type'] !=''){
			$coupons = $this->Coupons->find()->where(['Coupons.TYPE'=>$this->request->data['type'], 'Coupons.startDate <='=>date('Y-m-d'), 'Coupons.endDate >='=>date('Y-m-d'), 'Coupons.status'=>1])->toArray();
		}else{
			$coupons = $this->Coupons->find()->where(['Coupons.startDate <='=>date('Y-m-d'), 'Coupons.endDate >='=>date('Y-m-d'), 'Coupons.status'=>1])->toArray();
		}
		$Darray = array();
		$i=0;
		//echo "<pre>"; print_r($userservices); die;
		foreach($coupons as $val){
			$Darray[$i]['couponCode'] 		= ($val->couponCode) ? $val->couponCode : '';
			$Darray[$i]['description'] 		= ($val->description) ? $val->description : '';
			$Darray[$i]['startDate'] 		= ($val->startDate) ? date('Y-m-d',strtotime($val->startDate)) : '';
			$Darray[$i]['endDate'] 			= ($val->endDate) ? date('Y-m-d',strtotime($val->endDate)) : '';
			$Darray[$i]['discount'] 		= ($val->discount) ? $val->discount : '';
			$i++;
		}
		$response['status'] = "success";
		$response['data'] 	= ($Darray) ? $this->array_filter_recursive($Darray) : array();
		return $response;
	}
	
	
	private function emergencyadd(){
		if($this->request->data['userId'] !='' && $this->request->data['Name'] !='' && $this->request->data['phone'] != ''){
			$this->loadModel('Emergencies');
			if(@$this->request->data['addressId'] !=''){
				$emergency = $this->Emergencies->find()->where(['Emergencies.id'=>$this->request->data['addressId']])->first();
			}else{
				$emergency = $this->Emergencies->newEntity();
			}
			$emergency = $this->Emergencies->patchEntity($emergency, $this->request->data, ['validate' => false]);
			$this->Emergencies->save($emergency);
										
			$response['status'] = 'Success'; 
			if(@$this->request->data['addressId'] !=''){
				$response['msg'] = "Emergency updated successfully.";
			}else{
				$response['msg'] = "Emergency added successfully.";
			}
			$response['AuthToken'] = $this->encodejwtreturn();
		}else{
			$response['status'] = 'Fail'; 
			$response['msg'] = 'userId, Name, and phone are required.';
		}
		return $response;
	}

	private function emergencylist($userId=NULL){
		$this->loadModel('Emergencies');
		@$USERID = ($userId) ? $userId : $this->request->data('userId');
		@$pageNo = ($this->request->data['pageNo']) ? $this->request->data['pageNo'] : 1;
		if($USERID !=''){
			$this->paginate = [
				'limit' => '20',//$limit,
				'order' => ['Emergencies.id' => 'desc'],
				'page'=>$pageNo,
				'contain' => ['Countries']
			];
			
			$keyword = $this->request->query('keyword');
			$condition[] = ['Emergencies.userId'=>$USERID];
			$userservices = array();    
			$query = $this->Emergencies->find('all')->where($condition);
			$totalCount =  $query->count();
			if($pageNo <= ceil($totalCount/20)){
				$userservices = $this->paginate($query);
				$userservices = $userservices->toArray();
			}
			$Darray = array();
			$i=0;
			//echo "<pre>"; print_r($userservices); die;
			foreach($userservices as $val){
				$Darray[$i]['emergencyId'] 		= ($val->id) ? $val->id : '';
				$Darray[$i]['Name'] 			= ($val->Name) ? $val->Name : '';
				$Darray[$i]['email'] 			= ($val->email) ? $val->email : '';
				$Darray[$i]['phone'] 			= ($val->phone) ? $val->phone : '';
				$Darray[$i]['relation'] 		= ($val->relation) ? $val->relation : '';
				$Darray[$i]['userId'] 			= ($val->userId) ? $val->userId : '';
				$Darray[$i]['countryCode'] 		= (@$val->country->phonecode) ? @$val->country->phonecode :'';
				$Darray[$i]['countryName'] 		= (@$val->country->name) ? @$val->country->name :'';
				$Darray[$i]['countryId'] 		= (@$val->countryId) ? @$val->countryId :'';
				$i++;
			}
			$response['status'] = "success";
			$response['data'] 	= ($Darray) ? $this->array_filter_recursive($Darray) : array();
			$response['AuthToken'] = $this->encodejwtreturn();
		}else{
			$response['status'] = 'Fails';
			$response['msg'] = 'USERID is required.';
		}
		return  $response;
	}


	private function emergencydelete(){
		if($this->request->data['userId'] !='' && $this->request->data['emergencyId'] !='' ){
			$this->loadModel('Emergencies');
			
			$emergency = $this->Emergencies->find()->where(['Emergencies.id'=>$this->request->data['emergencyId'],'Emergencies.userId'=>$this->request->data['userId']])->first();
			if(@$emergency->id !=''){
				$this->Emergencies->delete($emergency);
				$response['status'] = 'Success'; 
				$response['msg'] = "Emergency contact has been deleted";
			}else{
				$response['status'] = 'Fails';
				$response['msg'] = 'Emergency no longer available.';
			}										
			$response['AuthToken'] = $this->encodejwtreturn();
		}else{
			$response['status'] = 'Fail'; 
			$response['msg'] = 'userId and emergencyId are required.';
		}
		return $response;
	}
	
	

	function timeshow(){
		$response['time'] = date('Y-m-d H:i:s'); 
		$response['milisecond'] = time();
		echo json_encode($response);
		die;
	}



	function panic(){
		if($this->request->data['userId'] !='' && $this->request->data['panicAddress'] !=''  && $this->request->data['panicLatLong'] !=''){
			$policeNumber = '';
			$AdminNumber = '';

			$this->loadModel('Panics');
			$Panics = $this->Panics->newEntity();
			$Panics = $this->Panics->patchEntity($Panics, $this->request->data, ['validate' => false]);
			$this->Panics->save($Panics);

			$response['status'] = 'Success'; 
			$response['msg'] = "Panic sent successfully.";
			if(@$this->request->data['language'] =='bn'){
				$response['msg'] ="প্যানিক সফলভাবে পাঠানো হয়েছে";
			}
			$response['AuthToken'] = $this->encodejwtreturn();
		}else{
			$response['status'] = 'Fail'; 
			$response['msg'] = 'userId, locationAddress and locationLatLong are required.';
		}
		return $response;
	}



	private function shareride(){
		if($this->request->data['shreFrom'] !='' && $this->request->data['mobilenumber'] !=''  && $this->request->data['bookingId'] !=''){
			$this->loadModel('Rideshares'); $this->loadModel('Users');;
			$usersD = $this->Users->find()->where(['Users.contactNumber'=>trim($this->request->data['mobilenumber'])])->first();
			if(@$usersD->id !=''){
				$newData['shreFrom'] 	= $this->request->data['shreFrom'];
				$newData['shareTo'] 	= $usersD->id;
				$newData['bookingId'] 	= $this->request->data['bookingId'];
				$newData['status']	 	= 1;
				
				$reviews = $this->Rideshares->newEntity();
				$reviews = $this->Rideshares->patchEntity($reviews, $newData, ['validate' => false]);
				$this->Rideshares->save($reviews);

				$shareD = $this->Rideshares->find('all')->where(['Rideshares.id'=>$reviews->id])->contain(['Bookings'=>['Drivers'=>['Carinformations'], 'Categories'],'Users'])->first();

				$bodyV['message'] 					= @$val->user->fullName.' Sharing Ride';
				$bodyV['type'] 						= 'Ride-Share';
				$bodyV['RequestPickupAddress'] 		= (@$shareD->booking->RequestPickupAddress) ? @$shareD->booking->RequestPickupAddress : 
				$bodyV['RequestDropAddress'] 		= (@$shareD->booking->RequestDropAddress) ? @$shareD->booking->RequestDropAddress : '';
				$bodyV['RequestPickupLatLong'] 		= (@$shareD->booking->RequestPickupLatLong) ? @$shareD->booking->RequestPickupLatLong : 
				$bodyV['RequestDropLatLong'] 		= (@$shareD->booking->RequestDropLatLong) ? @$shareD->booking->RequestDropLatLong : '';
				$bodyV['bookingId'] 				= @$shareD->bookingId;
				$bodyV['driver_fullName'] 			= (@$shareD->booking->driver->fullName) ? @$shareD->booking->driver->fullName : '';
				$bodyV['driver_email'] 				= (@$shareD->booking->driver->email) ? @$shareD->booking->driver->email : '';
				$bodyV['driver_image'] 				= (@$shareD->booking->driver->zipCode) ? @$shareD->booking->driver->zipCode : '';
				$bodyV['driver_contactNumber'] 		= (@$shareD->booking->driver->contactNumber) ? @$shareD->booking->driver->contactNumber :'';
				$bodyV['driver_image'] 				= (@$shareD->booking->driver->profile_picture) ? $this->profilePath.@$shareD->booking->driver->profile_picture : '';
				$bodyV['driver_AVGRating'] 			= (@$shareD->booking->driver->AVGRating) ? @$shareD->booking->driver->AVGRating : '';
				
				$bodyV['vehicleNumber']= '';
				$bodyV['VehicleColor'] = '';
				$bodyV['vehicleType'] = '';
				if(@$shareD->booking->driver->carinformations){
					foreach(@$shareD->booking->driver->carinformations as $VV){
						if($VV->categoryId == $shareD->booking->categoryId){
							$bodyV['vehicleNumber']	= ($VV->carNumber) ?  $VV->carNumber : '';
							$bodyV['VehicleColor'] 	= ($VV->carColor) ? $VV->carColor : '';
							$bodyV['vehicleType'] 	= ($VV->vehicleType) ? $VV->vehicleType : '';
						}
					}
				}
				$bodyV['shareFrom'] 				= @$shareD->shreFrom;
				$bodyV['rideStatus'] 				= (@$shareD->booking->rideStatus) ? @$shareD->booking->rideStatus : '';
				$bodyV['Pessenger_fullName'] 		= (@$shareD->user->fullName) ? @$shareD->user->fullName : '';
				$bodyV['Pessenger_email'] 			= (@$shareD->user->email) ? @$shareD->user->email : '';
				$bodyV['Pessenger_contactNumber'] 	= (@$shareD->user->contactNumber) ? @$shareD->user->contactNumber :'';
				$bodyV['Pessenger_device'] 			= (@$shareD->user->device) ? @$shareD->user->device :'';
				$bodyV['Pessenger_deviceToken'] 	= (@$shareD->user->deviceToken) ? @$shareD->user->deviceToken :'';
				$bodyV['Pessenger_Image'] 			= (@$shareD->user->profile_picture) ? $this->profilePath.@$shareD->user->profile_picture : '';

				$bodyV['car_name'] 					= (@$shareD->booking->category->name) ? @$shareD->booking->category->name : '';
				$bodyV['carImage'] 					= (@$shareD->booking->category->image) ? $this->carPath.@$shareD->booking->category->image : '';
				
				if(strtolower(@$usersD->device) =='ios'){
					$this->sednIosPushNotification(@$usersD->deviceToken,$bodyV);
				}else{
					$this->sendNotificationOnAndroid(@$usersD->deviceToken,$bodyV);
				}

				$response['status'] = 'Success'; 
				$response['msg'] = "Ride shared successfully.";
				if(@$this->request->data['language'] =='bn'){
					$response['msg'] ="রাইড সফলভাবে শেয়ার করা হয়েছে।";
				}
				$response['AuthToken'] = $this->encodejwtreturn();
			}else{
				$response['status'] = 'Fail';
				$response['msg'] = "Mobile number not registered with us.";
			}
			
		}else{
			$response['status'] = 'Fail'; 
			$response['msg'] = 'shreFrom, mobilenumber and bookingId are required.';
		}
		return $response;
	}

	private function sharelist($userId=NULL){
		$this->loadModel('Rideshares');
		@$USERID = ($userId) ? $userId : $this->request->data('userId');
		@$pageNo = ($this->request->data['pageNo']) ? $this->request->data['pageNo'] : 1;
		if($USERID !=''){
			$this->paginate = [
				'limit' => '20',//$limit,
				'order' => ['Rideshares.id' => 'desc'],
				'page'=>$pageNo,
				'contain' => ['Bookings'=>['Drivers'=>['Carinformations'], 'Categories'],'Users']
			];
			
			$keyword = $this->request->query('keyword');
			$condition[] = ['Rideshares.shareTo'=>$USERID];
			$userservices = array();    
			$query = $this->Rideshares->find('all')->where($condition);
			$totalCount =  $query->count();
			if($pageNo <= ceil($totalCount/20)){
				$userservices = $this->paginate($query);
				$userservices = $userservices->toArray();
			}
			$Darray = array();
			$i=0;
			//echo "<pre>"; print_r($userservices); die;
			foreach($userservices as $val){
				$Darray[$i]['shreFrom'] 		= ($val->shreFrom) ? $val->shreFrom : '';
				$Darray[$i]['shareTo'] 			= ($val->shareTo) ? $val->shareTo : '';
				$Darray[$i]['bookingId'] 		= ($val->bookingId) ? $val->bookingId : '';

				$Darray[$i]['RequestPickupAddress'] 		= (@$val->booking->RequestPickupAddress) ? @$val->booking->RequestPickupAddress : '';
				$Darray[$i]['RequestDropAddress'] 			= (@$val->booking->RequestDropAddress) ? @$val->booking->RequestDropAddress : '';
				$Darray[$i]['RequestPickupLatLong'] 		= (@$val->booking->RequestPickupLatLong) ? @$val->booking->RequestPickupLatLong : '';
				$Darray[$i]['RequestDropLatLong'] 			= (@$val->booking->RequestDropLatLong) ? @$val->booking->RequestDropLatLong : '';
				$Darray[$i]['rideStatus'] 					= (@$val->booking->rideStatus) ? @$val->booking->rideStatus : '0';
				$Darray[$i]['estimatedPrice'] 				= (@$val->booking->estimatedPrice) ? @$val->booking->estimatedPrice : '';
				$Darray[$i]['FinalFare'] 					= (@$val->booking->FinalFare) ? @$val->booking->FinalFare : '';
				$Darray[$i]['totalDistance'] 				= (@$val->booking->totalDistance) ? @$val->booking->totalDistance : 0;
				$Darray[$i]['totalAmount'] 					= (@$val->booking->totalAmount) ? @$val->booking->totalAmount : ''; // finalFare + tip + discount
				$Darray[$i]['transactionId'] 				= (@$val->booking->transactionId) ? @$val->booking->transactionId : '';
				$Darray[$i]['paymentStatus'] 				= (@$val->booking->paymentStatus) ? @$val->booking->paymentStatus : '';
				$Darray[$i]['paymentMethod'] 				= (@$val->booking->paymentMethod) ? @$val->booking->paymentMethod : '';
				$Darray[$i]['bookingDate'] 					= (@$val->booking->bookingDate) ? date('Y-m-d',strtotime(@$val->booking->bookingDate)) : '';
				$Darray[$i]['bookingTime'] 					= (@$val->booking->bookingTime) ? @$val->booking->bookingTime : '';

				$Darray[$i]['vehicleNumber']= '';
				$Darray[$i]['VehicleColor'] = '';
				$Darray[$i]['vehicleType'] = '';
				$Darray[$i]['car_name'] = (@$val->booking->category->name) ? @$val->booking->category->name : '';
				$Darray[$i]['car_image'] = (@$val->booking->category->image) ? $this->carPath.@$val->booking->category->image : '';
				if(@$val->booking->driver->carinformations){
					foreach(@$val->booking->driver->carinformations as $VV){
						if($VV->categoryId == $val->booking->categoryId){
							$Darray[$i]['vehicleNumber']= ($VV->carNumber) ?  $VV->carNumber : '';
							$Darray[$i]['VehicleColor'] = ($VV->carColor) ? $VV->carColor : '';
							$Darray[$i]['vehicleType'] = ($VV->vehicleType) ? $VV->vehicleType : '';
						}
					}
				} 

				
				$Darray[$i]['Drivber_userId'] 				= (@$val->booking->driver->id) ? @$val->booking->driver->id : '';
				$Darray[$i]['driver_fullName'] 				= (@$val->booking->driver->fullName) ? @$val->booking->driver->fullName : '';
				$Darray[$i]['driver_email'] 				= (@$val->booking->driver->email) ? @$val->booking->driver->email : '';
				$Darray[$i]['driver_zipCode'] 				= (@$val->booking->driver->zipCode) ? @$val->booking->driver->zipCode : '';
				$Darray[$i]['driver_contactNumber'] 		= (@$val->booking->driver->contactNumber) ? @$val->booking->driver->contactNumber :'';
				$Darray[$i]['driver_image'] 				= (@$val->booking->driver->profile_picture) ? $this->profilePath.@$val->booking->driver->profile_picture : '';
				$Darray[$i]['driver_AVGRating'] 			= (@$val->booking->driver->AVGRating) ? @$val->booking->driver->AVGRating : '';

				$Darray[$i]['fullName'] 			= (@$val->user->fullName) ? @$val->user->fullName : '';
				$Darray[$i]['email'] 				= (@$val->user->email) ? @$val->user->email : '';
				$Darray[$i]['contactNumber'] 		= (@$val->user->contactNumber) ? @$val->user->contactNumber :'';
				$Darray[$i]['device'] 				= (@$val->user->device) ? @$val->user->device :'';
				$Darray[$i]['deviceToken'] 			= (@$val->user->deviceToken) ? @$val->user->deviceToken :'';
				$Darray[$i]['image'] 				= (@$val->user->profile_picture) ? $this->profilePath.@$val->user->profile_picture : '';

				$i++;
			}
			$response['status'] = "success";
			$response['data'] 	= ($Darray) ? $this->array_filter_recursive($Darray) : array();
			$response['AuthToken'] = $this->encodejwtreturn();
		}else{
			$response['status'] = 'Fails';
			$response['msg'] = 'USERID is required.';
		}
		return  $response;
	}



	public function newmailformat(){

		//$to='raushan.kumar@evirtualservices.com';
		$email_data['Custome_name'] = 'Raushan';
		$email_data['invoice_id'] = '102346';
		$email_data['date'] = '2024-03-02';
		$email_data['pickup_location'] = 'Housefull';
		$email_data['drop_location'] = 'New Delhi, 110096';
		$email_data['distance'] = '20';
		$email_data['time'] = '35.46';
		$email_data['total_Amount'] = '225';
		$email_data['TIP'] = '10';
		$email_data['Booking_Fee'] = '11';
		$email_data['p_cancelation'] = '5';
		$email_data['discount'] = '5';
		$email_data['payment_method'] = '225';
		$email_data['Driver_name'] = 'ABC';
		$email_data['driver_image'] = 'sfsdf';
		$email_data['driver_rating'] = '4.2';
		$to = 'raushan@mailinator.com';
		$subject = "Payment Invoice";
		$this->caremail($to, $subject, $email_data);
		die('done');

	}


	
}
