<?php
namespace App\Controller\Admin;
use App\Controller\Admin\Component\ImgComponent;

use App\Controller\Admin\AppController;
use Cake\Event\Event;
use Cake\ORM\TableRegistry;
use Cake\Core\Configure;
use Cake\I18n\Time;
use Cake\View\Helper\TimeHelper;
/******************************************************************************
*File Name:	 DepartmentsController
*Creation Date: [11-02-2016]
*Modification Date: [11-02-2016]
*Author: [Raushan Suri]
*Author: [Modified By Raushan Suri]
*Description: [This controller consist of function related to Department.]
******************************************************************************/
class UsersController extends AppController
{

    public function beforeFilter(Event $event)
    {
        parent::beforeFilter($event);
        $this->Auth->allow(['showprofile']);
    }

    
    /********************************************************************************
	Function Name: index
	*Type: Public function used as action of the controller
	*Input: No input
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to view all member list and search.
	*********************************************************************************/
    public function index()
    {
        $layoutTitle = 'zarib::Manage Member';
        $this->set(compact('layoutTitle'));
        $this->viewBuilder()->layout('Admin/admin');
        $limit = Configure::read('App.adminPageLimit');
        
        $this->paginate = [
            'limit' => '20',//$limit,
            'order' => [
                'Users.created' => 'desc'
            ],
            //'contain' => ['Userbookings'=>function($q2){return $q2->select(['total' => $q2->func()->count('Userbookings.id')]);}]
			//'contain' => ['Userbookings'=>function (\Cake\ORM\Query $query) {
			//return $query
			//	->select(function (\Cake\ORM\Query $query) {
			//		return [
			//			'Userbookings.driverId',
			//			'Userbookings.userId',
			//			'number' => $query->func()->count('Userbookings.driverId')
			//		];
			//	});
			//}]
			'contain' => ['Userbookings','Reviews']
        ];        
        $keyword = $this->request->query('keyword');
        $condition = ['Users.role =' => 'Member'];
        if($keyword != ''){
			$condition = [
				"Users.role = 'Member'",
				'OR' => [
					["Users.fullName LIKE '%".$keyword."%'"],
					["Users.email LIKE '%".$keyword."%'"],
					["Users.id LIKE '%".$keyword."%'"],
					["Users.role LIKE '%".$keyword."%'"],
					["Users.contactNumber LIKE '%".$keyword."%'"]
				]				
			];
		}        
        $query = $this->Users->find('all')->where($condition);       
        $users = $this->paginate($query);
        $users = $users->toArray();
		//pr($users); die;
        $this->set(compact('users', 'limit'));
    }
	
	
	/********************************************************************************
	Function Name: index
	*Type: Public function used as action of the controller
	*Input: No input
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to view all member list and search.
	*********************************************************************************/
    public function driver()
    {
        $layoutTitle = 'zarib::Manage Driver';
        $this->set(compact('layoutTitle'));
        $this->viewBuilder()->layout('Admin/admin');
        $limit = Configure::read('App.adminPageLimit');
        
        $this->paginate = [
            'limit' => '20',//$limit,
            'order' => [
                'Users.created' => 'desc'
            ],
            'contain' => ['Driverbookings','Reviews']
        ];        
        $keyword = $this->request->query('keyword');
		$adminapprove = $this->request->query('adminapprove');
		
        $condition[] = ['Users.role =' => 'Driver'];
		if($adminapprove == 'approved'){
			$condition[] = ['Users.AdminApproved' => 1];
		}
		if($adminapprove == 'pending'){
			$condition[] = ['Users.AdminApproved' => 0];
		}
        if($keyword != ''){
			$condition[] = ['OR' => [
					["Users.fullName LIKE '%".$keyword."%'"],
					["Users.email LIKE '%".$keyword."%'"],
					["Users.id LIKE '%".$keyword."%'"],
					["Users.role LIKE '%".$keyword."%'"],
					["Users.contactNumber LIKE '%".$keyword."%'"]
				]				
			];
		}        
        $query = $this->Users->find('all')->where($condition);       
        $users = $this->paginate($query);
        $users = $users->toArray();
		//pr($users); die;
        $this->set(compact('users', 'limit'));
    }
	
	
	
	/********************************************************************************
	Function Name: index
	*Type: Public function used as action of the controller
	*Input: No input
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to view all member list and search.
	*********************************************************************************/
    public function restaurant()
    {
        $layoutTitle = 'zarib::Manage Restaurent';
        $this->set(compact('layoutTitle'));
        $this->viewBuilder()->layout('Admin/admin');
        $limit = Configure::read('App.adminPageLimit');
        
        $this->paginate = [
            'limit' => '50',//$limit,
            'order' => [
                'Users.created' => 'desc'
            ],
            'contain' => ['Foods']
        ];        
        $keyword = $this->request->query('keyword');
        $condition = ['Users.role =' => 'Restaurant'];
        if($keyword != ''){
			$condition = [
				"Users.role = 'Restaurant'",
				'OR' => [
					["Users.fullName LIKE '%".$keyword."%'"],
					["Users.email LIKE '%".$keyword."%'"],
					["Users.country LIKE '%".$keyword."%'"],
					["Users.role LIKE '%".$keyword."%'"],
					["Users.contactNumber LIKE '%".$keyword."%'"]
				]				
			];
		}        
        $query = $this->Users->find('all')->where($condition);       
        $users = $this->paginate($query);
        $users = $users->toArray();
		//pr($users); die;
        $this->set(compact('users', 'limit'));
    }
    
   
    
    
    
    
    
    /********************************************************************************
	Function Name: add
	*Type: Public function used as action of the controller
	*Input: No input
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to add new zarib member.
	*********************************************************************************/
    public function add()
    {
        $layoutTitle = 'zarib::Add New Member';
        $this->set(compact('layoutTitle'));
        $this->viewBuilder()->layout('Admin/admin');
        $users = $this->Users->newEntity();        
       
        if ($this->request->is('post')) {
            
            $this->request->data['username'] = $this->request->data['email']; 			
				
				  
				$userImage = $this->request->data['profile_picture'];	
				unset($this->request->data['profile_picture']);			
				if(!empty($userImage['name'])){
					$filename = time() .'_'. $userImage['name'];
					//$users['profile_picture'] = $filename;
					$this->request->data['profile_picture'] = $filename;
				}
				
				$users = $this->Users->patchEntity($users, $this->request->data, ['validate' => 'customer']);            
				$users['created'] = date('Y-m-d H:i:s'); 
				$users['role'] = 'Member'; 
				if ($this->Users->save($users)) {
					if (!empty($userImage) && $userImage['name'] != '') {
						$path = WWW_ROOT . 'img/uploads/users/';	                    
						move_uploaded_file($userImage['tmp_name'], $path.$filename);
						@chmod($path.$filename, 0777);
						//$MyImageCom = new ImgComponent();
						//$MyImageCom->prepare("img/uploads/users/original/".$filename);
						//$MyImageCom->resize(150,100);
						//$MyImageCom->save("img/uploads/users/thumb/".$filename);
						//@chmod(WWW_ROOT."img/uploads/users/thumb/".$filename, 0777);
					}
                    $this->Flash->success(__('Member added successfully.'));
                    return $this->redirect(['action' => 'index']);	
				}else{
                    //pr($users);die;
					$this->Flash->error(__('Unable to add new member, Please try again later.'));
				}
		}
        $this->set(compact('users'));
    }
    
    
    
    
    /********************************************************************************
	Function Name: edit
	*Type: Public function used as action of the controller
	*Input: Member id
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to edit evs member.
	*********************************************************************************/
    public function edit($id)
    {
        $layoutTitle = 'zarib::Edit Member';
        $this->set(compact('layoutTitle'));
        $this->viewBuilder()->layout('Admin/admin');
        
        $users = $this->Users->find()->where(['Users.id' => $id])->first();//fields name in contain[] with coma
        if ($this->request->is(['patch', 'post', 'put'])) {
			
			if($this->request->data['password'] == '' && $this->request->data['confirm_password'] == ''){
				unset($this->request->data['password']);
				unset($this->request->data['confirm_password']);
			}			
			unset($this->request->data['email']);
			$userImage = $this->request->data['profile_picture'];	
			unset($this->request->data['profile_picture']);
			unset($users['profile_picture']);
			
			$old_data = $this->Users->get($id);            			
			if(!empty($userImage['name'])){
				$filename = time() .'_'. $userImage['name'];
				$users['profile_picture'] = $filename;
				$this->request->data['profile_picture'] = $filename;
			}	
			
			$users = $this->Users->patchEntity($users, $this->request->data, ['validate' => 'customer']);
			
			if(!empty($filename)){				
				$oldfilename = $old_data->profile_picture;
			}	
			if ($this->Users->save($users)) {								
				if (!empty($userImage) && $userImage['name'] != '') {
					$path = WWW_ROOT . 'img/uploads/users/';	
					@unlink(WWW_ROOT . 'img/uploads/users/'.$oldfilename);
					@unlink(WWW_ROOT . 'img/uploads/users/'.$oldfilename);
					move_uploaded_file($userImage['tmp_name'], $path.$filename);
					@chmod($path.$filename, 0777);
					//$MyImageCom = new ImgComponent();
					//$MyImageCom->prepare("img/uploads/users/original/".$filename);
					//$MyImageCom->resize(150,100);
					//$MyImageCom->save("img/uploads/users/thumb/".$filename);
					//@chmod(WWW_ROOT."img/uploads/users/thumb/".$filename, 0777);
					
				}
				$this->Flash->success(__('The member updated successfully.'));
                return $this->redirect(['action' => 'index']);
			} else {
				$users['profile_picture'] = $old_data->profile_picture;
				$this->Flash->error(__('Member information could not be saved. Please try again later.'));
			}
        }
		//$this->set(compact('countries', 'states', 'cities'));		
        $this->set(compact('users'));
    }
    
	
	/********************************************************************************
	Function Name: adddriver
	*Type: Public function used as action of the controller
	*Input: No input
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to add new zarib member.
	*********************************************************************************/
    public function adddriver()
    {
        $layoutTitle = 'zarib::Add New Driver';
        $this->set(compact('layoutTitle'));
        $this->viewBuilder()->layout('Admin/admin');
        $users = $this->Users->newEntity();        
       
        if ($this->request->is('post')) {
            
            $this->request->data['username'] = $this->request->data['email']; 			
				
				  
				$userImage = @$this->request->data['profile_picture'];	
				unset($this->request->data['profile_picture']);			
				if(!empty($userImage['name'])){
					$filename = time() .'_'. $userImage['name'];
					$this->request->data['profile_picture'] = $filename;
				}
				$userImage2 = @$this->request->data['ssnImage'];	
				unset($this->request->data['ssnImage']);			
				if(!empty($userImage2['name'])){
					$filename2 = time() .'_'. $userImage2['name'];
					$this->request->data['ssnImage'] = $filename2;
				}
				$userImage3 = @$this->request->data['DrivingLicenceImage'];	
				unset($this->request->data['DrivingLicenceImage']);			
				if(!empty($userImage3['name'])){
					$filename3 = time() .'_'. $userImage3['name'];
					$this->request->data['DrivingLicenceImage'] = $filename3;
				}
				$userImage4 = @$this->request->data['AutoInsurance'];	
				unset($this->request->data['AutoInsurance']);			
				if(!empty($userImage4['name'])){
					$filename4 = time() .'_'. $userImage4['name'];
					$this->request->data['AutoInsurance'] = $filename4;
				}
				
				$users = $this->Users->patchEntity($users, $this->request->data, ['validate' => 'customer']);            
				$users['created'] = date('Y-m-d H:i:s'); 
				$users['role'] = 'Driver'; 
				if ($this->Users->save($users)) {
					if (!empty($userImage) && $userImage['name'] != '') {
						$path = WWW_ROOT . 'img/uploads/users/';	                    
						move_uploaded_file($userImage['tmp_name'], $path.$filename);
						@chmod($path.$filename, 0777);
					}
					if (!empty($userImage2) && $userImage2['name'] != '') {
						$path = WWW_ROOT . 'img/uploads/users/';	                    
						move_uploaded_file($userImage2['tmp_name'], $path.$filename2);
						@chmod($path.$filename2, 0777);
					}
					if (!empty($userImage3) && $userImage3['name'] != '') {
						$path = WWW_ROOT . 'img/uploads/users/';	                    
						move_uploaded_file($userImage3['tmp_name'], $path.$filename3);
						@chmod($path.$filename3, 0777);
					}
					if (!empty($userImage4) && $userImage4['name'] != '') {
						$path = WWW_ROOT . 'img/uploads/users/';	                    
						move_uploaded_file($userImage4['tmp_name'], $path.$filename4);
						@chmod($path.$filename4, 0777);
					}
                    $this->Flash->success(__('Driver added successfully.'));
                    return $this->redirect(['action' => 'driver']);	
				}else{
                    //pr($users);die;
					$this->Flash->error(__('Unable to add new driver, Please try again later.'));
				}
		}
        $this->set(compact('users'));
    }
    
    
    
    
    /********************************************************************************
	Function Name: editdriver
	*Type: Public function used as action of the controller
	*Input: Member id
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to edit evs member.
	*********************************************************************************/
    public function editdriver($id)
    {
        $layoutTitle = 'zarib::Edit Driver';
        $this->set(compact('layoutTitle'));
        $this->viewBuilder()->layout('Admin/admin');
        
        $users = $this->Users->find()->where(['Users.id' => $id])->first();//fields name in contain[] with coma
        if ($this->request->is(['patch', 'post', 'put'])) {
			
			if($this->request->data['password'] == '' && $this->request->data['confirm_password'] == ''){
				unset($this->request->data['password']);
				unset($this->request->data['confirm_password']);
			}			
			unset($this->request->data['email']);
			$userImage = @$this->request->data['profile_picture'];	
			unset($this->request->data['profile_picture']);
			unset($users['profile_picture']);
			
			$userImage2 = @$this->request->data['ssnImage'];	
			unset($this->request->data['ssnImage']);
			unset($users['ssnImage']);
			
			$userImage3 = @$this->request->data['DrivingLicenceImage'];	
			unset($this->request->data['DrivingLicenceImage']);
			unset($users['DrivingLicenceImage']);
			
			$userImage4 = @$this->request->data['AutoInsurance'];	
			unset($this->request->data['AutoInsurance']);
			unset($users['AutoInsurance']);
			
			$old_data = $this->Users->get($id);            			
			if(!empty($userImage['name'])){
				$filename = time() .'_'. $userImage['name'];
				$users['profile_picture'] = $filename;
				$this->request->data['profile_picture'] = $filename;
			}
			
			if(!empty($userImage2['name'])){
				$filename2 = time() .'_'. $userImage2['name'];
				$users['ssnImage'] = $filename2;
				$this->request->data['ssnImage'] = $filename2;
			}
			
			if(!empty($userImage3['name'])){
				$filename3 = time() .'_'. $userImage3['name'];
				$users['DrivingLicenceImage'] = $filename3;
				$this->request->data['DrivingLicenceImage'] = $filename3;
			}
			
			if(!empty($userImage4['name'])){
				$filename4 = time() .'_'. $userImage4['name'];
				$users['AutoInsurance'] = $filename4;
				$this->request->data['AutoInsurance'] = $filename4;
			}
			
			$users = $this->Users->patchEntity($users, $this->request->data, ['validate' => 'customer']);
			
			if(!empty($filename)){				
				$oldfilename = $old_data->profile_picture;
			}
			if(!empty($filename2)){				
				$oldfilename2 = $old_data->ssnImage;
			}
			if(!empty($filename3)){				
				$oldfilename3 = $old_data->DrivingLicenceImage;
			}
			if(!empty($filename4)){				
				$oldfilename4 = $old_data->AutoInsurance;
			}
			if ($this->Users->save($users)) {								
				if (!empty($userImage) && $userImage['name'] != '') {
					$path = WWW_ROOT . 'img/uploads/users/';	
					@unlink(WWW_ROOT . 'img/uploads/users/'.$oldfilename);
					move_uploaded_file($userImage['tmp_name'], $path.$filename);
					@chmod($path.$filename, 0777);
				}
				
				if (!empty($userImage2) && $userImage2['name'] != '') {
					$path = WWW_ROOT . 'img/uploads/users/';	
					@unlink(WWW_ROOT . 'img/uploads/users/'.$oldfilename2);
					move_uploaded_file($userImage2['tmp_name'], $path.$filename2);
					@chmod($path.$filename2, 0777);
				}
				
				if (!empty($userImage3) && $userImage3['name'] != '') {
					$path = WWW_ROOT . 'img/uploads/users/';	
					@unlink(WWW_ROOT . 'img/uploads/users/'.$oldfilename3);
					move_uploaded_file($userImage3['tmp_name'], $path.$filename3);
					@chmod($path.$filename3, 0777);
				}
				
				if (!empty($userImage4) && $userImage4['name'] != '') {
					$path = WWW_ROOT . 'img/uploads/users/';	
					@unlink(WWW_ROOT . 'img/uploads/users/'.$oldfilename4);
					move_uploaded_file($userImage4['tmp_name'], $path.$filename4);
					@chmod($path.$filename4, 0777);
				}
				$this->Flash->success(__('The driver updated successfully.'));
                return $this->redirect(['action' => 'driver']);
			} else {
				$users['profile_picture'] = $old_data->profile_picture;
				$users['ssnImage'] = $old_data->ssnImage;
				$users['DrivingLicenceImage'] = $old_data->DrivingLicenceImage;
				$users['AutoInsurance'] = $old_data->AutoInsurance;
				$this->Flash->error(__('Driver information could not be saved. Please try again later.'));
			}
        }
		//$this->set(compact('countries', 'states', 'cities'));		
        $this->set(compact('users'));
    }
    
	
	/********************************************************************************
	Function Name: addrestaurant
	*Type: Public function used as action of the controller
	*Input: No input
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to add new zarib member.
	*********************************************************************************/
    public function addrestaurant()
    {
        $layoutTitle = 'zarib::Add Restaurant';
        $this->set(compact('layoutTitle'));
        $this->viewBuilder()->layout('Admin/admin');
        $users = $this->Users->newEntity();        
			
			$this->loadModel('Categories'); 
		$parentClientList = $this->Categories->find('list', ['keyField' => 'id', 'valueField' => ['name']])
						//->where(['Categories.parentId'=>'0'])
                        ->order(['Categories.name'=>'ASC'])->toArray();
        
		
        if ($this->request->is('post')) {
            //pr($this->request->data); die;
			$this->request->data['categoryID'] = implode(",",$this->request->data['categoryID']); 
				$this->request->data['username'] = $this->request->data['email']; 			
				$userImage = $this->request->data['profile_picture'];	
				unset($this->request->data['profile_picture']);			
				if(!empty($userImage['name'])){
					$filename = time() .'_'. $userImage['name'];
					//$users['profile_picture'] = $filename;
					$this->request->data['profile_picture'] = $filename;
				}else{
					$this->request->data['profile_picture'] = '';
				}
				
				$userImage2 = $this->request->data['companyBackground'];	
				unset($this->request->data['companyBackground']);			
				if(!empty($userImage2['name'])){
					$filename2 = time() .'_'. $userImage2['name'];
					//$users['profile_picture'] = $filename;
					$this->request->data['companyBackground'] = $filename2;
				}else{
					$this->request->data['companyBackground'] = '';
				}
				
				$users = $this->Users->patchEntity($users, $this->request->data, ['validate' => 'customer']);            
				$users['created'] = date('Y-m-d H:i:s'); 
				$users['role'] = 'Restaurant'; 
				if ($this->Users->save($users)) {
					if (!empty($userImage) && $userImage['name'] != '') {
						$path = WWW_ROOT . 'img/uploads/users/';	                    
						move_uploaded_file($userImage['tmp_name'], $path.$filename);
						@chmod($path.$filename, 0777);
					}
					if (!empty($userImage2) && $userImage2['name'] != '') {
						$path = WWW_ROOT . 'img/uploads/users/';	                    
						move_uploaded_file($userImage2['tmp_name'], $path.$filename2);
						@chmod($path.$filename2, 0777);
					}
                    $this->Flash->success(__('Restaurant added successfully.'));
                    return $this->redirect(['action' => 'restaurant']);	
				}else{
                    //pr($users);die;
					$this->request->data['categoryID'] = explode(",",$this->request->data['categoryID']); 
					$this->Flash->error(__('Unable to add new Restaurant, Please try again later.'));
				}
		}
        $this->set(compact('users','parentClientList'));
    }
    
    
    
    
    /********************************************************************************
	Function Name: editrestaurant
	*Type: Public function used as action of the controller
	*Input: Member id
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to edit evs member.
	*********************************************************************************/
    public function editrestaurant($id)
    {
        $layoutTitle = 'zarib::Edit Restaurant';
        $this->set(compact('layoutTitle'));
        $this->viewBuilder()->layout('Admin/admin');
        
		$this->loadModel('Categories'); 
		$parentClientList = $this->Categories->find('list', ['keyField' => 'id', 'valueField' => ['name']])
						//->where(['Categories.parentId'=>'0'])
                        ->order(['Categories.name'=>'ASC'])->toArray();
						
        $users = $this->Users->find()->where(['Users.id' => $id])->first();//fields name in contain[] with coma
		$users->categoryID = explode(",",$users->categoryID);
        if ($this->request->is(['patch', 'post', 'put'])) {
			
			$this->request->data['categoryID'] = implode(",",$this->request->data['categoryID']);
			
			if($this->request->data['password'] == '' && $this->request->data['confirm_password'] == ''){
				unset($this->request->data['password']);
				unset($this->request->data['confirm_password']);
			}			
			unset($this->request->data['email']);
			$userImage = $this->request->data['profile_picture'];	
			unset($this->request->data['profile_picture']);
			unset($users['profile_picture']);
			
			$userImage2 = $this->request->data['companyBackground'];	
			unset($this->request->data['companyBackground']);
			unset($users['companyBackground']);
			
			$old_data = $this->Users->get($id);            			
			if(!empty($userImage['name'])){
				$filename = time() .'_'. $userImage['name'];
				$users['profile_picture'] = $filename;
				$this->request->data['profile_picture'] = $filename;
			}
			if(!empty($userImage2['name'])){
				$filename2 = time() .'_'. $userImage2['name'];
				$users['companyBackground'] = $filename2;
				$this->request->data['companyBackground'] = $filename2;
			}
			
			$users = $this->Users->patchEntity($users, $this->request->data, ['validate' => 'customer']);
			
			if(!empty($filename)){				
				$oldfilename = $old_data->profile_picture;
			}
			if(!empty($filename2)){				
				$oldfilename2 = $old_data->companyBackground;
			}	
			if ($this->Users->save($users)) {								
				if (!empty($userImage) && $userImage['name'] != '') {
					$path = WWW_ROOT . 'img/uploads/users/';	
					@unlink(WWW_ROOT . 'img/uploads/users/'.$oldfilename);
					move_uploaded_file($userImage['tmp_name'], $path.$filename);
					@chmod($path.$filename, 0777);
				}
				if (!empty($userImage2) && $userImage2['name'] != '') {
					$path = WWW_ROOT . 'img/uploads/users/';	
					@unlink(WWW_ROOT . 'img/uploads/users/'.$oldfilename2);
					move_uploaded_file($userImage2['tmp_name'], $path.$filename2);
					@chmod($path.$filename2, 0777);
				}
				$this->Flash->success(__('The Restaurant updated successfully.'));
                return $this->redirect(['action' => 'restaurant']);
			} else {
				$users['profile_picture'] = $old_data->profile_picture;
				$users['companyBackground'] = $old_data->companyBackground;
				$this->request->data['categoryID'] = explode(",",$this->request->data['categoryID']);
				$this->Flash->error(__('Restaurant information could not be saved. Please try again later.'));
			}
        }
		$this->set(compact('countries', 'states', 'cities'));		
        $this->set(compact('users','parentClientList'));
    }
	
	
	
    /********************************************************************************
	Function Name: Delete
	*Type: Public function used as action of the controller
	*Input: Member id
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to delete zarib member permanently.
	*********************************************************************************/
    public function delete($id = null)
    {
		$query_String = $_SERVER["QUERY_STRING"];
        $users = $this->Users->get($id);
		if(@$users->id ==''){
			return $this->redirect(['controller' => 'Users', 'action' => 'index']);
		}
        if ($this->Users->delete($users)) {
			@unlink(WWW_ROOT . 'img/uploads/users/'.$users->ssnImage);
			@unlink(WWW_ROOT . 'img/uploads/users/'.$users->DrivingLicenceImage);
			@unlink(WWW_ROOT . 'img/uploads/users/'.$users->AutoInsurance);
			@unlink(WWW_ROOT . 'img/uploads/users/'.$users->profilePicture);
			@unlink(WWW_ROOT . 'img/uploads/users/thumb/'.$users->profilePicture);
			@unlink(WWW_ROOT . 'img/uploads/users/thumb/'.$users->companyBackground);
            $this->Flash->success(__('Member has been deleted.'));
        } else {
            $this->Flash->error(__('Member could not be deleted. Please, try again.'));
        }
		if($users->role == 'Member'){
			return $this->redirect(['controller' => 'Users', 'action' => 'index/?'.$query_String]);
		}elseif($users->role == 'Driver'){
			return $this->redirect(['controller' => 'Users', 'action' => 'driver/?'.$query_String]);
		}elseif($users->role == 'Subadmin'){
			return $this->redirect(['controller' => 'Users', 'action' => 'subadmin/?'.$query_String]);
		}else{
			return $this->redirect(['controller' => 'Users', 'action' => 'restaurant/?'.$query_String]);
		}
        return $this->redirect(['controller' => 'Users', 'action' => 'index']);
    }
    
    
    /********************************************************************************
	Function Name: status
	*Type: Public function used as action of the controller
	*Input: Member id
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to update zarib member status.
	*********************************************************************************/
    public function status($id){
		$users = $this->Users->get($id);
		$query_String = $_SERVER["QUERY_STRING"];
		$status = '1';
		$msg = 'activated';
		if($users->status == '1'){
			$status = '0';
			$msg = 'deactivated';
		}
		
		$articles = TableRegistry::get('Users');
		$query = $articles->query();
		$query->update()
			->set(['status' => $status])
			->where(['id' => $id])
			->execute();
		$this->Flash->success(__('Member has been '.$msg.' successfully.'));
		if($users->role == 'Member'){
			return $this->redirect(['controller' => 'Users', 'action' => 'index/?'.$query_String]);
		}elseif($users->role == 'Driver'){
			return $this->redirect(['controller' => 'Users', 'action' => 'driver/?'.$query_String]);
		}else{
			return $this->redirect(['controller' => 'Users', 'action' => 'restaurant/?'.$query_String]);
		}
		
		
	}

	public function updateinfo($id){
		$users = $this->Users->get($id);
		$status = '1';
		$msg = 'Approved';
		if($users->update_admin_approve == 1){
			$status = '2';
			$msg = 'Not Approved';
		}
		
		$articles = TableRegistry::get('Users');
		$query = $articles->query();
		$query->update()
			->set(['update_admin_approve' => $status])
			->where(['id' => $id])
			->execute();
		$this->Flash->success(__('User infromation has been '.$msg.' successfully.'));
		return $this->redirect(['controller' => 'Users', 'action' => 'driver']);
	}
	
	
	public function adminapprove($id){
		$users = $this->Users->get($id);
		$query_String = $_SERVER["QUERY_STRING"];
		$articles = TableRegistry::get('Users');
		$query = $articles->query();
		$query->update()
			->set(['AdminApproved' => 1])
			->where(['id' => $id])
			->execute();
		$this->Flash->success(__('Driver has been approved successfully.'));
		return $this->redirect(['controller' => 'Users', 'action' => 'driver/?'.$query_String]);
	}
    
    
	
    /********************************************************************************
	Function Name: details
	*Type: Public function used as action of the controller
	*Input: Member id
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to view zarib member information.
	*********************************************************************************/
    public function details($id){
        $layoutTitle = 'zarib::Details';
        $this->set(compact('layoutTitle'));
        $this->viewBuilder()->layout('Admin/admin');        
		$users = $this->Users->find()->where(['Users.id' => $id])->contain(['Countries'])->first();
        if(!empty($users)){
            $this->set(compact('users'));
        }else{
            $this->Flash->error(__('Member doesnot exist.'));
            return $this->redirect(['controller' => 'Users', 'action' => 'index']);
        }
	}
	


	public function subadmin()
    {
        $layoutTitle = 'zarib::Manage Subadmin';
        $this->set(compact('layoutTitle'));
        $this->viewBuilder()->layout('Admin/admin');
        $limit = Configure::read('App.adminPageLimit');
        
        $this->paginate = [
            'limit' => '20',//$limit,
            'order' => ['Users.created' => 'desc'],
			//'contain' => ['Userbookings','Reviews']
        ];        
        $keyword = $this->request->query('keyword');
        $condition = ['Users.role =' => 'Subadmin'];
        if($keyword != ''){
			$condition = [
				"Users.role = 'Subadmin'",
				'OR' => [
					["Users.fullName LIKE '%".$keyword."%'"],
					["Users.email LIKE '%".$keyword."%'"],
					["Users.contactNumber LIKE '%".$keyword."%'"]
				]				
			];
		}        
        $query = $this->Users->find('all')->where($condition);       
        $users = $this->paginate($query);
        $users = $users->toArray();
		//pr($users); die;
        $this->set(compact('users', 'limit'));
    }


    public function addsubadmin()
    {
        $layoutTitle = 'zarib::Add SubAdmin';
        $this->set(compact('layoutTitle'));
        $this->viewBuilder()->layout('Admin/admin');
        $users = $this->Users->newEntity();        
       
        if ($this->request->is('post')) {
            $this->request->data['username'] = $this->request->data['email']; 			
			$userImage = $this->request->data['profile_picture'];	
			unset($this->request->data['profile_picture']);			
			if(!empty($userImage['name'])){
				$filename = time() .'_'. $userImage['name'];
				//$users['profile_picture'] = $filename;
				$this->request->data['profile_picture'] = $filename;
			}
				
			$users = $this->Users->patchEntity($users, $this->request->data, ['validate' => 'customer']);            
			$users['created'] = date('Y-m-d H:i:s'); 
			$users['role'] = 'Subadmin';
			$users['subAdmin'] = 1; 
			if ($this->Users->save($users)) {
				if (!empty($userImage) && $userImage['name'] != '') {
					$path = WWW_ROOT . 'img/uploads/users/';	                    
					move_uploaded_file($userImage['tmp_name'], $path.$filename);
					@chmod($path.$filename, 0777);
				}
				$this->Flash->success(__('Sub admin added successfully.'));
				return $this->redirect(['action' => 'subadmin']);	
			}else{
				//pr($users);die;
				$this->Flash->error(__('Unable to add new subadmin, Please try again later.'));
			}
		}
        $this->set(compact('users'));
    }
    
    public function editsubadmin($id)
    {
        $layoutTitle = 'zarib::Edit Sub Admin';
        $this->set(compact('layoutTitle'));
        $this->viewBuilder()->layout('Admin/admin');
        
        $users = $this->Users->find()->where(['Users.id' => $id])->first();//fields name in contain[] with coma
        if ($this->request->is(['patch', 'post', 'put'])) {
			
			if($this->request->data['password'] == '' && $this->request->data['confirm_password'] == ''){
				unset($this->request->data['password']);
				unset($this->request->data['confirm_password']);
			}			
			unset($this->request->data['email']);
			$userImage = $this->request->data['profile_picture'];	
			unset($this->request->data['profile_picture']);
			unset($users['profile_picture']);
			
			$old_data = $this->Users->get($id);            			
			if(!empty($userImage['name'])){
				$filename = time() .'_'. $userImage['name'];
				$users['profile_picture'] = $filename;
				$this->request->data['profile_picture'] = $filename;
			}	
			
			$users = $this->Users->patchEntity($users, $this->request->data, ['validate' => 'customer']);
			
			if(!empty($filename)){				
				$oldfilename = $old_data->profile_picture;
			}	
			if ($this->Users->save($users)) {								
				if (!empty($userImage) && $userImage['name'] != '') {
					$path = WWW_ROOT . 'img/uploads/users/';	
					@unlink(WWW_ROOT . 'img/uploads/users/'.$oldfilename);
					move_uploaded_file($userImage['tmp_name'], $path.$filename);
					@chmod($path.$filename, 0777);
				}
				$this->Flash->success(__('The member updated successfully.'));
                return $this->redirect(['action' => 'index']);
			} else {
				$users['profile_picture'] = $old_data->profile_picture;
				$this->Flash->error(__('Member information could not be saved. Please try again later.'));
			}
        }
		//$this->set(compact('countries', 'states', 'cities'));		
        $this->set(compact('users'));
    }


	
}