<?php
namespace App\Controller\Admin;
use App\Controller\Admin\Component\ImgComponent;

use App\Controller\Admin\AppController;
use Cake\Event\Event;
use Cake\ORM\TableRegistry;
use Cake\Core\Configure;
use Cake\I18n\Time;
use Cake\View\Helper\TimeHelper;
use Cake\Datasource\ConnectionManager;
/******************************************************************************
*File Name:	 DepartmentsController
*Creation Date: [11-02-2016]
*Modification Date: [11-02-2016]
*Author: [Raushan Suri]
*Author: [Modified By Raushan Suri]
*Description: [This controller consist of function related to Department.]
******************************************************************************/
class TestimonialsController extends AppController
{

    public function beforeFilter(Event $event)
    {
        parent::beforeFilter($event);
        $this->Auth->allow(['showprofile']);
    }

    
    /********************************************************************************
	Function Name: index
	*Type: Public function used as action of the controller
	*Input: No input
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to view all member list and search.
	*********************************************************************************/
    public function index($id=null)
    {
        $layoutTitle = 'Freedom Giving :: Manage Testimonial';
        $this->set(compact('layoutTitle'));
        $this->viewBuilder()->layout('Admin/admin');
        $limit = 30;//Configure::read('App.adminPageLimit');
        
        $this->paginate = [
            'limit' => $limit,
            'order' => [
                'Testimonials.created' => 'DESC'
            ],
        ];        
        $keyword = $this->request->query('keyword');
		$condition = [];
        if($keyword != ''){
			$condition = [
				'OR' => [
					["Testimonials.name LIKE '%".$keyword."%'"],
					["Testimonials.designation LIKE '%".$keyword."%'"],
					["Testimonials.text LIKE '%".$keyword."%'"]
				]				
			];
		}        
        $query = $this->Testimonials->find('all')->where($condition);       
        $testimonials = $this->paginate($query);
        $testimonials = $testimonials->toArray();
		//pr($testimonials);die;
        $this->set(compact('testimonials', 'limit'));
    }

      
    /********************************************************************************
	Function Name: add
	*Type: Public function used as action of the controller
	*Input: No input
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to add hours.
	*********************************************************************************/
    public function add()
    {
        $layoutTitle = 'Freedom Giving ::  Add New Testimonial';
        $this->set(compact('layoutTitle'));
        $this->viewBuilder()->layout('Admin/admin');
		
		
        $testimonials = $this->Testimonials->newEntity();        
       
        if ($this->request->is('post')) {
			$testiImage = $this->request->data['testimonialsimage'];
			unset($this->request->data['testimonialsimage']);
			$this->request->data['image'] = '';
            if(!empty($testiImage['name'])){
				$filename = time() . $testiImage['name'];
				$this->request->data['testimonialsimage'] = $filename;
			}
			$testimonials = $this->Testimonials->patchEntity($testimonials, $this->request->data, ['validate' => 'customer']);            
			$testimonials['created'] = date('Y-m-d H:i:s');
			$path = WWW_ROOT . 'img/uploads/testimonials/original/';
			if ($this->Testimonials->save($testimonials)) {
				if (!empty($testiImage) && $testiImage['name'] != '') {	
                    move_uploaded_file($testiImage['tmp_name'], $path.$filename);
                    $MyImageCom = new ImgComponent();
                    $MyImageCom->prepare("img/uploads/testimonials/original/".$filename);
                    $MyImageCom->resize(100,100);
                    $MyImageCom->save("img/uploads/testimonials/thumb/".$filename);	
				}
				$this->Flash->success(__('Testimonial added successfully.'));
				return $this->redirect(['action' => 'index']);	
			}else{
				//pr($users);die;
				$this->Flash->error(__('Unable to add new feature, Please try again later.'));
			}
		}
        $this->set(compact('testimonials','client_list'));
    }
    
    
    
    
    /********************************************************************************
	Function Name: edit
	*Type: Public function used as action of the controller
	*Input: Member id
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to edit hours.
	*********************************************************************************/
    public function edit($id)
    {
        $layoutTitle = 'Freedom Giving :: Edit Testimonial';
        $this->set(compact('layoutTitle'));
        $this->viewBuilder()->layout('Admin/admin');
        
        $testimonials = $this->Testimonials->find()->where(['Testimonials.id' => $id])->first();//fields name in contain[] with coma
        if ($this->request->is(['patch', 'post', 'put'])) {
			
			$testiImage = $this->request->data['testimonialsimage'];
			unset($this->request->data['testimonialsimage']);
            if(!empty($testiImage['name'])){
				$old_data = $this->Testimonials->get($id);
				$filename = time() . $testiImage['name'];
				$this->request->data['testimonialsimage'] = $filename;
			}
			$testimonials = $this->Testimonials->patchEntity($testimonials, $this->request->data, ['validate' => 'customer']);
			
			if(!empty($filename)){				
				$oldfilename = $old_data->image;
			}
			$path = WWW_ROOT . 'img/uploads/testimonials/original/';
			if ($this->Testimonials->save($testimonials)) {
				if (!empty($testiImage) && $testiImage['name'] != '') {	
                    @unlink(WWW_ROOT . 'img/uploads/testimonials/original/'.$oldfilename);
                    @unlink(WWW_ROOT . 'img/uploads/testimonials/thumb/'.$oldfilename);
                    move_uploaded_file($testiImage['tmp_name'], $path.$filename);
                    $MyImageCom = new ImgComponent();
                    $MyImageCom->prepare("img/uploads/testimonials/original/".$filename);
                    $MyImageCom->resize(230,200);
                    $MyImageCom->save("img/uploads/testimonials/thumb/".$filename);	
				}
				$this->Flash->success(__('The member updated successfully.'));
                return $this->redirect(['action' => 'index']);
			} else {
				$testimonials['testimonialsimage'] = $old_data->testimonialsimage;
				$this->Flash->error(__('Member information could not be saved. Please try again later.'));
			}
        }
        $this->set(compact('testimonials'));
    }
    
    
    /********************************************************************************
	Function Name: delete
	*Type: Public function used as action of the controller
	*Input: Member id
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to delete hours permanently.
	*********************************************************************************/
    public function delete($id = null)
    {
        $users = $this->Testimonials->get($id);
        if ($this->Testimonials->delete($users)) {
            $this->Flash->success(__('Testimonial has been deleted.'));
        } else {
            $this->Flash->error(__('Testimonial could not be deleted. Please, try again.'));
        }
        return $this->redirect(['controller' => 'Testimonials', 'action' => 'index']);
    }
    
    
    /********************************************************************************
	Function Name: status
	*Type: Public function used as action of the controller
	*Input: Member id
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to update hours status.
	*********************************************************************************/
    public function status($id){
		$users = $this->Testimonials->get($id);
		$status = '1';
		$msg = 'activated';
		if($users->status == '1'){
			$status = '0';
			$msg = 'deactivated';
		}
		
		$articles = TableRegistry::get('Testimonials');
		$query = $articles->query();
		$query->update()
			->set(['status' => $status])
			->where(['id' => $id])
			->execute();
		$this->Flash->success(__('Member has been '.$msg.' successfully.'));
		return $this->redirect(['controller' => 'Testimonials', 'action' => 'index']);
	}
    
    
    /********************************************************************************
	Function Name: details
	*Type: Public function used as action of the controller
	*Input: Member id
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to view hours information.
	*********************************************************************************/
    public function details($id){
        $layoutTitle = 'Freedom Giving ::  Member Details';
        $this->set(compact('layoutTitle'));
        $this->viewBuilder()->layout('Admin/admin');        
		$users = $this->Testimonials->find()->where(['Testimonials.id' => $id])->first();
        if(!empty($users)){
            $this->set(compact('users'));
        }else{
            $this->Flash->error(__('Member doesnot exist.'));
            return $this->redirect(['controller' => 'Testimonials', 'action' => 'index']);
        }
	}
	
	/********************************************************************************
	Function Name: generateTTCode
	*Type: Public function used as action of the controller
	*Input: No input
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to return autogenerate ttcode.
	*********************************************************************************/
     public function generateECode(){
		//$this->autoRender = false;
		$digit = str_pad(rand ( 1 , 999999 ), 6, 0, STR_PAD_LEFT);
		
		/*
		$alphabet = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
		$pass = array(); //remember to declare $pass as an array
		$alphaLength = strlen($alphabet) - 1; //put the length -1 in cache
		for ($i = 0; $i < 2; $i++) {
			$n = rand(0, $alphaLength);
			$pass[] = $alphabet[$n];
		}
		$ttcode = implode($pass).$digit;
		*/
		$ttcode = 'Freedom Giving-'.$digit;
		$this->loadModel('Testimonials');
		$users = $this->Testimonials->find('all')->where(['Testimonials.eCode' => $ttcode]);
		$user = $users->toArray();
		if(count($user) == '0'){
			return $ttcode;
		}else{
			$this->generateECode();
		}
	}
}
