<?php
namespace App\Controller\Admin;
use App\Controller\Admin\Component\ImgComponent;

use App\Controller\Admin\AppController;
use Cake\Event\Event;
use Cake\ORM\TableRegistry;
use Cake\Core\Configure;
use Cake\I18n\Time;
use Cake\View\Helper\TimeHelper;
use Cake\Datasource\ConnectionManager;
/******************************************************************************
*File Name:	 Controller
*Creation Date: [11-02-2016]
*Modification Date: [11-02-2016]
*Author: [Raushan Suri]
*Author: [Modified By Raushan Suri]
*Description: [This controller consist of function related to Department.]
******************************************************************************/
class PanicsController extends AppController
{

    public function beforeFilter(Event $event)
    {
        parent::beforeFilter($event);
        $this->Auth->allow(['showprofile']);
    }

    
    /********************************************************************************
	Function Name: index
	*Type: Public function used as action of the controller
	*Input: No input
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to view all member list and search.
	*********************************************************************************/
    public function index($id=null)
    {
        $layoutTitle = 'zarib :: Manage Panic';
        $this->set(compact('layoutTitle'));
        $this->viewBuilder()->layout('Admin/admin');
        $limit = 30;//Configure::read('App.adminPageLimit');
        
        $this->paginate = [
            'limit' => $limit,
            'order' => ['Panics.created' => 'DESC'],
			'contain'=>['Users']
        ];        
        $keyword = $this->request->query('keyword');
		$condition[] = ['Panics.id >'=>0];
        if($keyword != ''){
			$condition[] = [
				'OR' => [
					["Panics.panicAddress LIKE '%".$keyword."%'"],
					["Users.fullName LIKE '%".$keyword."%'"],
				]				
			];
		}        
        $query = $this->Panics->find('all')->where($condition);       
        $panics = $this->paginate($query);
        $panics = $panics->toArray();
		//pr($panics);die;
        $this->set(compact('panics', 'limit'));
    }

      
    /********************************************************************************
	Function Name: add
	*Type: Public function used as action of the controller
	*Input: No input
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to add hours.
	*********************************************************************************/
    public function add()
    {
        $layoutTitle = 'zarib ::  Add New Panic';
        $this->set(compact('layoutTitle'));
        $this->viewBuilder()->layout('Admin/admin');
		
		
        $panics = $this->Panics->newEntity();        
       
        if ($this->request->is('post')) {
            
			$panics = $this->Panics->patchEntity($panics, $this->request->data, ['validate' => 'customer']);            
			$panics['created'] = date('Y-m-d H:i:s');
			//$path = WWW_ROOT . 'img/uploads/feature/original/';
			if ($this->Panics->save($panics)) {
				$this->Flash->success(__('Panic added successfully.'));
				return $this->redirect(['action' => 'index']);	
			}else{
				//pr($users);die;
				$this->Flash->error(__('Unable to add new panic, Please try again later.'));
			}
		}
        $this->set(compact('panics','client_list'));
    }
    
    
    
    
    /********************************************************************************
	Function Name: edit
	*Type: Public function used as action of the controller
	*Input: Member id
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to edit hours.
	*********************************************************************************/
    public function edit($id)
    {
        $layoutTitle = 'zarib :: Edit Panic';
        $this->set(compact('layoutTitle'));
        $this->viewBuilder()->layout('Admin/admin');
        
        $panics = $this->Panics->find()->where(['Panics.id' => $id])->first();//fields name in contain[] with coma
        if ($this->request->is(['patch', 'post', 'put'])) {
			
			
			$panics = $this->Panics->patchEntity($panics, $this->request->data, ['validate' => 'customer']);
			
			
			$path = WWW_ROOT . 'img/uploads/feature/original/';
			if ($this->Panics->save($panics)) {
				
				$this->Flash->success(__('The panic updated successfully.'));
                return $this->redirect(['action' => 'index']);
			} else {
				
				$this->Flash->error(__('Panic information could not be saved. Please try again later.'));
			}
        }
        $this->set(compact('panics'));
    }
    
    
    /********************************************************************************
	Function Name: delete
	*Type: Public function used as action of the controller
	*Input: Member id
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to delete hours permanently.
	*********************************************************************************/
    public function delete($id = null)
    {
        $users = $this->Panics->get($id);
        if ($this->Panics->delete($users)) {
            $this->Flash->success(__('Panic has been deleted.'));
        } else {
            $this->Flash->error(__('Panic could not be deleted. Please, try again.'));
        }
        return $this->redirect(['controller' => 'Panics', 'action' => 'index']);
    }
    
    
    /********************************************************************************
	Function Name: status
	*Type: Public function used as action of the controller
	*Input: Member id
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to update hours status.
	*********************************************************************************/
    public function status($id){
		$users = $this->Panics->get($id);
		$status = '1';
		$msg = 'activated';
		if($users->status == '1'){
			$status = '0';
			$msg = 'deactivated';
		}
		
		$articles = TableRegistry::get('Panics');
		$query = $articles->query();
		$query->update()
			->set(['status' => $status])
			->where(['id' => $id])
			->execute();
		$this->Flash->success(__('Panic has been '.$msg.' successfully.'));
		return $this->redirect(['controller' => 'Panics', 'action' => 'index']);
	}
    
    
    /********************************************************************************
	Function Name: details
	*Type: Public function used as action of the controller
	*Input: Member id
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to view hours information.
	*********************************************************************************/
    public function details($id){
        $layoutTitle = 'zarib ::  Member Details';
        $this->set(compact('layoutTitle'));
        $this->viewBuilder()->layout('Admin/admin');        
		$users = $this->Panics->find()->where(['Panics.id' => $id])->first();
        if(!empty($users)){
            $this->set(compact('users'));
        }else{
            $this->Flash->error(__('Member doesnot exist.'));
            return $this->redirect(['controller' => 'Panics', 'action' => 'index']);
        }
	}
	
	
}