<?php
namespace App\Controller\Admin;
use App\Controller\Admin\Component\ImgComponent;

use App\Controller\Admin\AppController;
use Cake\Event\Event;
use Cake\ORM\TableRegistry;
use Cake\Core\Configure;
use Cake\I18n\Time;
use Cake\View\Helper\TimeHelper;
use Cake\Datasource\ConnectionManager;
/******************************************************************************
*File Name:	 Controller
*Creation Date: [11-02-2016]
*Modification Date: [11-02-2016]
*Author: [Raushan Suri]
*Author: [Modified By Raushan Suri]
*Description: [This controller consist of function related to Department.]
******************************************************************************/
class LatestnewsController extends AppController
{

    public function beforeFilter(Event $event)
    {
        parent::beforeFilter($event);
        $this->Auth->allow(['showprofile']);
    }

    
    /********************************************************************************
	Function Name: index
	*Type: Public function used as action of the controller
	*Input: No input
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to view all member list and search.
	*********************************************************************************/
    public function index($id=null)
    {
        $layoutTitle = 'Freedom Giving :: Manage Latestnews';
        $this->set(compact('layoutTitle'));
        $this->viewBuilder()->layout('Admin/admin');
        $limit = 30;//Configure::read('App.adminPageLimit');
        
        $this->paginate = [
            'limit' => $limit,
            'order' => [
                'Latestnews.created' => 'DESC'
            ],
        ];        
        $keyword = $this->request->query('keyword');
		$condition = [];
        if($keyword != ''){
			$condition = [
				'OR' => [
					["Latestnews.name LIKE '%".$keyword."%'"],
					["Latestnews.newsdate LIKE '%".$keyword."%'"],
					["Latestnews.content LIKE '%".$keyword."%'"],
				]				
			];
		}        
        $query = $this->Latestnews->find('all')->where($condition);       
        $latestnews = $this->paginate($query);
        $latestnews = $latestnews->toArray();
		//pr($latestnews);die;
        $this->set(compact('latestnews', 'limit'));
    }

      
    /********************************************************************************
	Function Name: add
	*Type: Public function used as action of the controller
	*Input: No input
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to add hours.
	*********************************************************************************/
    public function add()
    {
        $layoutTitle = 'Freedom Giving ::  Add New Latestnew';
        $this->set(compact('layoutTitle'));
        $this->viewBuilder()->layout('Admin/admin');
		
		
        $latestnews = $this->Latestnews->newEntity();        
       
        if ($this->request->is('post')) {
            $testiImage = $this->request->data['image'];
			unset($this->request->data['image']);
			$this->request->data['image'] = '';
            if(!empty($testiImage['name'])){
				$filename = time() . $testiImage['name'];
				$this->request->data['image'] = $filename;
			}
			$latestnews = $this->Latestnews->patchEntity($latestnews, $this->request->data, ['validate' => 'customer']);            
			$latestnews['created'] = date('Y-m-d H:i:s');
			$path = WWW_ROOT . 'img/uploads/news/original/';
			//$path = WWW_ROOT . 'img/uploads/feature/original/';
			if ($this->Latestnews->save($latestnews)) {
				if (!empty($testiImage) && $testiImage['name'] != '') {	
                    move_uploaded_file($testiImage['tmp_name'], $path.$filename);
                    $MyImageCom = new ImgComponent();
                    $MyImageCom->prepare("img/uploads/news/original/".$filename);
                    $MyImageCom->resize(84,50);
                    $MyImageCom->save("img/uploads/news/thumb/".$filename);	
				}
				$this->Flash->success(__('Latestnew added successfully.'));
				return $this->redirect(['action' => 'index']);	
			}else{
				//pr($users);die;
				$this->Flash->error(__('Unable to add latest news, Please try again later.'));
			}
		}
        $this->set(compact('latestnews','client_list'));
    }
    
    
    
    
    /********************************************************************************
	Function Name: edit
	*Type: Public function used as action of the controller
	*Input: Member id
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to edit hours.
	*********************************************************************************/
    public function edit($id)
    {
        $layoutTitle = 'Freedom Giving :: Edit Latestnew';
        $this->set(compact('layoutTitle'));
        $this->viewBuilder()->layout('Admin/admin');
        
        $latestnews = $this->Latestnews->find()->where(['Latestnews.id' => $id])->first();//fields name in contain[] with coma
        if ($this->request->is(['patch', 'post', 'put'])) {
			///pr($this->request->data); die;
			$testiImage = $this->request->data['image'];
			unset($this->request->data['image']);
            if(!empty($testiImage['name'])){
				$old_data = $this->Latestnews->get($id);
				$filename = time() . $testiImage['name'];
				$this->request->data['image'] = $filename;
			}
			
			$latestnews = $this->Latestnews->patchEntity($latestnews, $this->request->data, ['validate' => 'customer']);
			
			if(!empty($filename)){				
				$oldfilename = $old_data->image;
			}
			$path = WWW_ROOT . 'img/uploads/news/original/';
			if ($this->Latestnews->save($latestnews)) {
				if (!empty($testiImage) && $testiImage['name'] != '') {	
                    @unlink(WWW_ROOT . 'img/uploads/news/original/'.$oldfilename);
                    @unlink(WWW_ROOT . 'img/uploads/news/thumb/'.$oldfilename);
                    move_uploaded_file($testiImage['tmp_name'], $path.$filename);
                    $MyImageCom = new ImgComponent();
                    $MyImageCom->prepare("img/uploads/news/original/".$filename);
                    $MyImageCom->resize(230,200);
                    $MyImageCom->save("img/uploads/news/thumb/".$filename);	
				}
				$this->Flash->success(__('The latest news updated successfully.'));
                return $this->redirect(['action' => 'index']);
			} else {
				
				$this->Flash->error(__('Latestnew information could not be saved. Please try again later.'));
			}
        }
        $this->set(compact('latestnews'));
    }
    
    
    /********************************************************************************
	Function Name: delete
	*Type: Public function used as action of the controller
	*Input: Member id
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to delete hours permanently.
	*********************************************************************************/
    public function delete($id = null)
    {
        $users = $this->Latestnews->get($id);
        if ($this->Latestnews->delete($users)) {
            $this->Flash->success(__('Latestnew has been deleted.'));
        } else {
            $this->Flash->error(__('Latestnew could not be deleted. Please, try again.'));
        }
        return $this->redirect(['controller' => 'Latestnews', 'action' => 'index']);
    }
    
    
    /********************************************************************************
	Function Name: status
	*Type: Public function used as action of the controller
	*Input: Member id
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to update hours status.
	*********************************************************************************/
    public function status($id){
		$users = $this->Latestnews->get($id);
		$status = '1';
		$msg = 'activated';
		if($users->status == '1'){
			$status = '0';
			$msg = 'deactivated';
		}
		
		$articles = TableRegistry::get('Latestnews');
		$query = $articles->query();
		$query->update()
			->set(['status' => $status])
			->where(['id' => $id])
			->execute();
		$this->Flash->success(__('Latestnew has been '.$msg.' successfully.'));
		return $this->redirect(['controller' => 'Latestnews', 'action' => 'index']);
	}
    
       /********************************************************************************
	Function Name: details
	*Type: Public function used as action of the controller
	*Input: Member id
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to view hours information.
	*********************************************************************************/
    public function details($id){
        $layoutTitle = 'Freedom Giving ::  Member Details';
        $this->set(compact('layoutTitle'));
        $this->viewBuilder()->layout('Admin/admin');        
		$users = $this->Latestnews->find()->where(['Latestnews.id' => $id])->first();
        if(!empty($users)){
            $this->set(compact('users'));
        }else{
            $this->Flash->error(__('Latest news doesnot exist.'));
            return $this->redirect(['controller' => 'Latestnews', 'action' => 'index']);
        }
	}
	
	
}