<?php
namespace App\Controller\Admin;

use App\Controller\Admin\AppController;
use Cake\Event\Event;
use Cake\Filesystem\File;

class GlobalParametersController extends AppController
{

    public function beforeFilter(Event $event)
    {
        parent::beforeFilter($event);
    }

    public function index()
    {
        $layoutTitle = 'Path Mark :: Global Parameters';
        $this->set(compact('layoutTitle'));
        $this->viewBuilder()->layout('Admin/admin');
        $id = 1;
        $globalparameters = $this->GlobalParameters->get($id, ['contain' => []]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $globalparameters = $this->GlobalParameters->patchEntity($globalparameters, $this->request->data);
            //$globalparameters['googleAnalyticsCode'] = $googleAnalyticsCode;
            if ($this->GlobalParameters->save($globalparameters)) {
                $this->Flash->success(__('Global parameter has been updated successfully.'));
                return $this->redirect(['controller' => 'GlobalParameters', 'action' => 'index']);
            } else {
                $this->Flash->error(__('Unable to updae global parameters, Please try again.'));
            }
        }
        $this->set('globalparameters', $globalparameters);
    }
}