<?php
namespace App\Controller\Admin;
use App\Controller\Admin\Component\ImgComponent;

use App\Controller\Admin\AppController;
use Cake\Event\Event;
use Cake\ORM\TableRegistry;
use Cake\Core\Configure;
use Cake\I18n\Time;
use Cake\View\Helper\TimeHelper;
use Cake\Datasource\ConnectionManager;
/******************************************************************************
*File Name:	 Controller
*Creation Date: [11-02-2016]
*Modification Date: [11-02-2016]
*Author: [Raushan Suri]
*Author: [Modified By Raushan Suri]
*Description: [This controller consist of function related to Department.]
******************************************************************************/
class CouponsController extends AppController
{

    public function beforeFilter(Event $event)
    {
        parent::beforeFilter($event);
        $this->Auth->allow(['showprofile']);
    }

    
    /********************************************************************************
	Function Name: index
	*Type: Public function used as action of the controller
	*Input: No input
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to view all member list and search.
	*********************************************************************************/
    public function index($id=null)
    {
        $layoutTitle = 'zarib :: Manage Coupon';
        $this->set(compact('layoutTitle'));
        $this->viewBuilder()->layout('Admin/admin');
        $limit = 30;//Configure::read('App.adminPageLimit');
        
        $this->paginate = [
            'limit' => $limit,
            'order' => [
                'Coupons.created' => 'DESC'
            ],
        ];        
        $keyword = $this->request->query('keyword');
		$condition[] = ['Coupons.id >'=>0];
        if($keyword != ''){
			$condition[] = [
				'OR' => [
					["Coupons.couponCode LIKE"=>$keyword."%"],
					["Coupons.description LIKE" =>$keyword."%"],
				]				
			];
		}        
        $query = $this->Coupons->find('all')->where($condition);       
        $coupons = $this->paginate($query);
        $coupons = $coupons->toArray();
		//pr($coupons);die;
        $this->set(compact('coupons', 'limit'));
    }

      
    /********************************************************************************
	Function Name: add
	*Type: Public function used as action of the controller
	*Input: No input
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to add hours.
	*********************************************************************************/
    public function add()
    {
        $layoutTitle = 'zarib ::  Add New Coupon';
        $this->set(compact('layoutTitle'));
        $this->viewBuilder()->layout('Admin/admin');
		
		
        $coupons = $this->Coupons->newEntity();        
       
        if ($this->request->is('post')) {
            
			$coupons = $this->Coupons->patchEntity($coupons, $this->request->data, ['validate' => 'customer']);            
			$coupons['created'] = date('Y-m-d H:i:s');
			$coupons['startDate'] = ($this->request->data['startDate']) ? date('Y-m-d',strtotime($this->request->data['startDate'])) : date('Y-m-d');
			$coupons['endDate'] = ($this->request->data['endDate']) ? date('Y-m-d',strtotime($this->request->data['endDate'])) : date('Y-m-d');
			//$path = WWW_ROOT . 'img/uploads/feature/original/';
			if ($this->Coupons->save($coupons)) {
				$this->Flash->success(__('Coupon added successfully.'));
				return $this->redirect(['action' => 'index']);	
			}else{
				//pr($users);die;
				$this->Flash->error(__('Unable to add new coupon, Please try again later.'));
			}
		}
        $this->set(compact('coupons'));
    }
    
    
    
    
    /********************************************************************************
	Function Name: edit
	*Type: Public function used as action of the controller
	*Input: Member id
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to edit hours.
	*********************************************************************************/
    public function edit($id)
    {
        $layoutTitle = 'zarib :: Edit Coupon';
        $this->set(compact('layoutTitle'));
        $this->viewBuilder()->layout('Admin/admin');
        
        $coupons = $this->Coupons->find()->where(['Coupons.id' => $id])->first();//fields name in contain[] with coma
        if ($this->request->is(['patch', 'post', 'put'])) {
			//echo "<pre>"; print_r($this->request->data);
			
			$coupons = $this->Coupons->patchEntity($coupons, $this->request->data, ['validate' => 'customer']);
			if($this->request->data['startDate']){
				$coupons['startDate'] = date('Y-m-d',strtotime($this->request->data['startDate']));
			}
			if($this->request->data['endDate']){
				$coupons['endDate'] = date('Y-m-d',strtotime($this->request->data['endDate']));
			}
			//echo "<pre>"; print_r($coupons); die;
			$path = WWW_ROOT . 'img/uploads/feature/original/';
			if ($this->Coupons->save($coupons)) {
				
				$this->Flash->success(__('The coupon updated successfully.'));
                return $this->redirect(['action' => 'index']);
			} else {
				
				$this->Flash->error(__('Coupon information could not be saved. Please try again later.'));
			}
        }
        $this->set(compact('coupons'));
    }
    
    
    /********************************************************************************
	Function Name: delete
	*Type: Public function used as action of the controller
	*Input: Member id
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to delete hours permanently.
	*********************************************************************************/
    public function delete($id = null)
    {
        $users = $this->Coupons->get($id);
        if ($this->Coupons->delete($users)) {
            $this->Flash->success(__('Coupon has been deleted.'));
        } else {
            $this->Flash->error(__('Coupon could not be deleted. Please, try again.'));
        }
        return $this->redirect(['controller' => 'Coupons', 'action' => 'index']);
    }
    
    
    /********************************************************************************
	Function Name: status
	*Type: Public function used as action of the controller
	*Input: Member id
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to update hours status.
	*********************************************************************************/
    public function status($id){
		$users = $this->Coupons->get($id);
		$status = '1';
		$msg = 'activated';
		if($users->status == '1'){
			$status = '0';
			$msg = 'deactivated';
		}
		
		$articles = TableRegistry::get('Coupons');
		$query = $articles->query();
		$query->update()
			->set(['status' => $status])
			->where(['id' => $id])
			->execute();
		$this->Flash->success(__('Coupon has been '.$msg.' successfully.'));
		return $this->redirect(['controller' => 'Coupons', 'action' => 'index']);
	}
    
    
    /********************************************************************************
	Function Name: details
	*Type: Public function used as action of the controller
	*Input: Member id
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to view hours information.
	*********************************************************************************/
    public function details($id){
        $layoutTitle = 'zarib ::  Member Details';
        $this->set(compact('layoutTitle'));
        $this->viewBuilder()->layout('Admin/admin');        
		$users = $this->Coupons->find()->where(['Coupons.id' => $id])->first();
        if(!empty($users)){
            $this->set(compact('users'));
        }else{
            $this->Flash->error(__('Member doesnot exist.'));
            return $this->redirect(['controller' => 'Coupons', 'action' => 'index']);
        }
	}
	
	
}