<?php
namespace App\Controller\Admin;
use App\Controller\Admin\Component\ImgComponent;

use App\Controller\Admin\AppController;
use Cake\Event\Event;
use Cake\ORM\TableRegistry;
use Cake\Core\Configure;
use Cake\I18n\Time;
use Cake\View\Helper\TimeHelper;
use Cake\Datasource\ConnectionManager;
/******************************************************************************
*File Name:	 Controller
*Creation Date: [11-02-2016]
*Modification Date: [11-02-2016]
*Author: [Raushan Suri]
*Author: [Modified By Raushan Suri]
*Description: [This controller consist of function related to Department.]
******************************************************************************/
class CashoutrequestsController extends AppController
{

    public function beforeFilter(Event $event)
    {
        parent::beforeFilter($event);
        $this->Auth->allow(['showprofile']);
    }

    
    /********************************************************************************
	Function Name: index
	*Type: Public function used as action of the controller
	*Input: No input
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to view all member list and search.
	*********************************************************************************/
    public function index($id=null)
    {
        $layoutTitle = 'zarib :: Manage Cashout Request';
        $this->set(compact('layoutTitle'));
        $this->viewBuilder()->layout('Admin/admin');
        $limit = 30;//Configure::read('App.adminPageLimit');
        
        $this->paginate = [
            'limit' => $limit,
            'order' => ['Cashoutrequests.created' => 'DESC'],
			'contain'=> ['Users'],
        ];        
        $keyword = $this->request->query('keyword');
		$condition[] = ['Cashoutrequests.id >'=>0];
        if($keyword != ''){
			$condition[] = [
				'OR' => [
					["Cashoutrequests.requestAmount LIKE '%".$keyword."%'"],
					["Cashoutrequests.created LIKE '%".$keyword."%'"],
					["Cashoutrequests.sendDate LIKE '%".$keyword."%'"],
					["Users.fullName LIKE '%".$keyword."%'"],
					["Cashoutrequests.sendAmount LIKE '%".$keyword."%'"],
				]				
			];
		}        
        $query = $this->Cashoutrequests->find('all')->where($condition);       
        $cashoutrequests = $this->paginate($query);
        $cashoutrequests = $cashoutrequests->toArray();
		//pr($cashoutrequests);die;
        $this->set(compact('cashoutrequests', 'limit'));
    }


    public function dashboard($id=null)
    {
        $layoutTitle = 'zarib :: Manage Cashout Request';
        $this->set(compact('layoutTitle'));
		$this->loadModel('Bookings');$this->loadModel('Users');
        $this->viewBuilder()->layout('Admin/admin');
		if($id == ''){
			return $this->redirect(['controller'=>'Users','action' => 'index']);
		}
		$userD = $this->Users->find()->where(['Users.id'=>$id])->first();
		$Query = $this->Bookings->find()->where(['Bookings.driverId'=>$id]);
		//pr($Query);
		$Total_ride_Count = $Query->count();
		$Total_Amount = $Query->select(['sum' => $Query->func()->sum('Bookings.driverAmount')])->toArray();
		$Total_Amount_cash = $Query->select(['sum' => $Query->func()->sum('Bookings.driverAmount')])->where(['Bookings.paymentMethod'=>'Cash'])->toArray();
		$Total_Amount_CC = $this->Bookings->find()->select(['sum' => $Query->func()->sum('Bookings.driverAmount')])->where(['Bookings.driverId'=>$id,'Bookings.paymentMethod'=>'Card'])->toArray();
		//echo "<pre>";
		// print_r($Total_Amount);
		//print_r($Total_Amount_CC); die;
		// print_r($Total_Amount_cash);// = $Query->func()->sum(['driverAmount']);
		//$Total_Amount2 = $this->Bookings->find('all')->select(['sum'=>$q->func()->sum(['Bookings.driverAmount'])])->where(['Bookings.driverId'=>$id])->toArray();
		//$Total_Amount_cash = $this->Bookings->find('all')->where(['Bookings.driverId'=>$id,'Bookings.paymentMethod'=>'Cash'])->sum(['driverAmount'])->count();
		//$Total_Amount_CC = $this->Bookings->find('all')->where(['Bookings.driverId'=>$id, 'Bookings.driverId'=>'Credit Card'])->sum(['driverAmount'])->count();
//pr($Total_Amount2);
//die;
        $limit = 10;//Configure::read('App.adminPageLimit');
        
        $this->paginate = [
            'limit' => $limit,
            'order' => ['Cashoutrequests.created' => 'DESC'],
			'contain'=> ['Users'],
        ];        
        $keyword = $this->request->query('keyword');
		$condition[] = ['Cashoutrequests.userId'=>$id];
        if($keyword != ''){
			$condition[] = [
				'OR' => [
					["Cashoutrequests.requestAmount LIKE '%".$keyword."%'"],
					["Cashoutrequests.created LIKE '%".$keyword."%'"],
					["Cashoutrequests.sendDate LIKE '%".$keyword."%'"],
					["Users.fullName LIKE '%".$keyword."%'"],
					["Cashoutrequests.sendAmount LIKE '%".$keyword."%'"],
				]				
			];
		}        
        $query = $this->Cashoutrequests->find('all')->where($condition);       
        $cashoutrequests = $this->paginate($query);
        $cashoutrequests = $cashoutrequests->toArray();
		//pr($cashoutrequests);die;
        $this->set(compact('cashoutrequests', 'limit','userD','Total_ride_Count','Total_Amount','Total_Amount_cash','Total_Amount_CC'));
    }






	public function dashboardadmin($id=null)
    {
        $layoutTitle = 'zarib :: Manage Cashout Request';
        $this->set(compact('layoutTitle'));
		$this->loadModel('Bookings');$this->loadModel('Users');
        $this->viewBuilder()->layout('Admin/admin');
		// if($id == ''){
		// 	return $this->redirect(['controller'=>'Users','action' => 'index']);
		// }
		if(@$this->request->query['startDate'] !=''){
			$conditiii[] = ['Bookings.bookingDate >='=>$this->request->query['startDate']];
		}else{
			$conditiii[] = ['Bookings.bookingDate >='=>date('Y-m-d')];
		}
		if(@$this->request->query['endDate'] !=''){
			$conditiii[] = ['Bookings.bookingDate <='=>$this->request->query['endDate']];
		}else{
			$conditiii[] = ['Bookings.bookingDate <='=>date('Y-m-d')];
		}


		$userD = $this->Users->find()->where(['Users.id'=>$id])->first();
		$Query = $this->Bookings->find()->where($conditiii);
		//pr($Query);
		$Total_ride_Count = $Query->count();
		$Total_Amount = $Query->select(['sum_driverAmount' => $Query->func()->sum('Bookings.driverAmount'), 'sum_Total' => $Query->func()->sum('Bookings.totalAmount')])->toArray();
		//$Total_Amount_cash = $Query->select(['sum' => $Query->func()->sum('Bookings.driverAmount')])->where(['Bookings.paymentMethod'=>'Cash'])->toArray();
		//$Total_Amount_CC = $this->Bookings->find()->select(['sum' => $Query->func()->sum('Bookings.driverAmount')])->where(['Bookings.driverId'=>$id,'Bookings.paymentMethod'=>'Card'])->toArray();
		//echo "<pre>";
		//print_r($Total_Amount);die;
		//print_r($Total_Amount_CC); die;
		// print_r($Total_Amount_cash);// = $Query->func()->sum(['driverAmount']);
		//$Total_Amount2 = $this->Bookings->find('all')->select(['sum'=>$q->func()->sum(['Bookings.driverAmount'])])->where(['Bookings.driverId'=>$id])->toArray();
		//$Total_Amount_cash = $this->Bookings->find('all')->where(['Bookings.driverId'=>$id,'Bookings.paymentMethod'=>'Cash'])->sum(['driverAmount'])->count();
		//$Total_Amount_CC = $this->Bookings->find('all')->where(['Bookings.driverId'=>$id, 'Bookings.driverId'=>'Credit Card'])->sum(['driverAmount'])->count();
//pr($Total_Amount2);
//die;
        /*$limit = 10;//Configure::read('App.adminPageLimit');
        
        $this->paginate = [
            'limit' => $limit,
            'order' => ['Cashoutrequests.created' => 'DESC'],
			'contain'=> ['Users'],
        ];        
        $keyword = $this->request->query('keyword');
		$condition[] = ['Cashoutrequests.userId'=>$id];
        if($keyword != ''){
			$condition[] = [
				'OR' => [
					["Cashoutrequests.requestAmount LIKE '%".$keyword."%'"],
					["Cashoutrequests.created LIKE '%".$keyword."%'"],
					["Cashoutrequests.sendDate LIKE '%".$keyword."%'"],
					["Users.fullName LIKE '%".$keyword."%'"],
					["Cashoutrequests.sendAmount LIKE '%".$keyword."%'"],
				]				
			];
		}        
        $query = $this->Cashoutrequests->find('all')->where($condition);       
        $cashoutrequests = $this->paginate($query);
        $cashoutrequests = $cashoutrequests->toArray();
		//pr($cashoutrequests);die;*/
        $this->set(compact('userD','Total_ride_Count','Total_Amount'));
    }

      
    /********************************************************************************
	Function Name: add
	*Type: Public function used as action of the controller
	*Input: No input
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to add hours.
	*********************************************************************************/
    public function add()
    {
        $layoutTitle = 'zarib ::  Add New Cashoutrequest';
        $this->set(compact('layoutTitle'));
        $this->viewBuilder()->layout('Admin/admin');
		
		
        $cashoutrequests = $this->Cashoutrequests->newEntity();        
       
        if ($this->request->is('post')) {
            
			$cashoutrequests = $this->Cashoutrequests->patchEntity($cashoutrequests, $this->request->data, ['validate' => 'customer']);            
			$cashoutrequests['created'] = date('Y-m-d H:i:s');
			//$path = WWW_ROOT . 'img/uploads/feature/original/';
			if ($this->Cashoutrequests->save($cashoutrequests)) {
				$this->Flash->success(__('Cashoutrequest added successfully.'));
				return $this->redirect(['action' => 'index']);	
			}else{
				//pr($users);die;
				$this->Flash->error(__('Unable to add new cashoutrequest, Please try again later.'));
			}
		}
        $this->set(compact('cashoutrequests','client_list'));
    }
    
    
    
    
    /********************************************************************************
	Function Name: edit
	*Type: Public function used as action of the controller
	*Input: Member id
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to edit hours.
	*********************************************************************************/
    public function edit($id)
    {
		$this->loadModel('Users');
        $layoutTitle = 'zarib :: Edit Cashoutrequest';
        $this->set(compact('layoutTitle'));
        $this->viewBuilder()->layout('Admin/admin');
        
        $cashoutrequests = $this->Cashoutrequests->find()->where(['Cashoutrequests.id' => $id])->contain(['Users'])->first();//fields name in contain[] with coma
        //pr($cashoutrequests); die;
		if ($this->request->is(['patch', 'post', 'put'])) {
			//pr($cashoutrequests);
			//pr($this->request->data); die;
			if(@$cashoutrequests->user->wallet < $this->request->data['sendAmount']){
				$this->Flash->error(__('insufficient amount'));
				return $this->redirect(['action' => 'index']);
			}
			
			$cashoutrequests = $this->Cashoutrequests->patchEntity($cashoutrequests, $this->request->data, ['validate' => false]);
			$cashoutrequests['sendDate'] = ($this->request->data['sendDate']) ? $this->request->data['sendDate'] : '';
			$path = WWW_ROOT . 'img/uploads/feature/original/';
			if ($this->Cashoutrequests->save($cashoutrequests)) {
				$articles = TableRegistry::get('Users');
						$query = $articles->query();
						$query->update()
						->set(['wallet' =>($cashoutrequests->user->wallet - $this->request->data['sendAmount'])])
						->where(['id' => $cashoutrequests->user->id])
						->execute();
				$this->Flash->success(__('The cashout Request updated successfully.'));
                return $this->redirect(['action' => 'index']);
			} else {
				
				$this->Flash->error(__('Cashoutrequest information could not be saved. Please try again later.'));
			}
        }
        $this->set(compact('cashoutrequests'));
    }
    
    
    /********************************************************************************
	Function Name: delete
	*Type: Public function used as action of the controller
	*Input: Member id
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to delete hours permanently.
	*********************************************************************************/
    public function delete($id = null)
    {
        $users = $this->Cashoutrequests->get($id);
        if ($this->Cashoutrequests->delete($users)) {
            $this->Flash->success(__('Cashoutrequest has been deleted.'));
        } else {
            $this->Flash->error(__('Cashoutrequest could not be deleted. Please, try again.'));
        }
        return $this->redirect(['controller' => 'Cashoutrequests', 'action' => 'index']);
    }
    
    
    /********************************************************************************
	Function Name: status
	*Type: Public function used as action of the controller
	*Input: Member id
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to update hours status.
	*********************************************************************************/
    public function status($id){
		$users = $this->Cashoutrequests->get($id);
		$status = '1';
		$msg = 'activated';
		if($users->status == '1'){
			$status = '0';
			$msg = 'deactivated';
		}
		
		$articles = TableRegistry::get('Cashoutrequests');
		$query = $articles->query();
		$query->update()
			->set(['status' => $status])
			->where(['id' => $id])
			->execute();
		$this->Flash->success(__('Cashoutrequest has been '.$msg.' successfully.'));
		return $this->redirect(['controller' => 'Cashoutrequests', 'action' => 'index']);
	}
    
    
    /********************************************************************************
	Function Name: details
	*Type: Public function used as action of the controller
	*Input: Member id
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to view hours information.
	*********************************************************************************/
    public function details($id){
        $layoutTitle = 'zarib ::  Member Details';
        $this->set(compact('layoutTitle'));
        $this->viewBuilder()->layout('Admin/admin');        
		$users = $this->Cashoutrequests->find()->where(['Cashoutrequests.id' => $id])->first();
        if(!empty($users)){
            $this->set(compact('users'));
        }else{
            $this->Flash->error(__('Member doesnot exist.'));
            return $this->redirect(['controller' => 'Cashoutrequests', 'action' => 'index']);
        }
	}
	
	
}