<?php
namespace App\Controller\Admin;
use App\Controller\Admin\Component\ImgComponent;

use App\Controller\Admin\AppController;
use Cake\Event\Event;
use Cake\ORM\TableRegistry;
use Cake\Core\Configure;
use Cake\I18n\Time;
use Cake\View\Helper\TimeHelper;
use Cake\Datasource\ConnectionManager;
/******************************************************************************
*File Name:	 Controller
*Creation Date: [11-02-2016]
*Modification Date: [11-02-2016]
*Author: [Raushan Suri]
*Author: [Modified By Raushan Suri]
*Description: [This controller consist of function related to Department.]
******************************************************************************/
class BookingsController extends AppController
{

    public function beforeFilter(Event $event)
    {
        parent::beforeFilter($event);
        $this->Auth->allow(['showprofile']);
    }

    
    /********************************************************************************
	Function Name: index
	*Type: Public function used as action of the controller
	*Input: No input
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to view all member list and search.
	*********************************************************************************/
    public function index($id=null)
    {
        $layoutTitle = 'zarib :: Manage Booking';
        $this->set(compact('layoutTitle'));
        $this->viewBuilder()->layout('Admin/admin');
        $limit = 30;//Configure::read('App.adminPageLimit');
        
		$this->loadModel('Users');
		$DList = $this->Users->find('list', ['keyField' => 'id', 'valueField' => ['fullName', 'email']])
						->where(['Users.role'=>'Driver'])
                        ->order(['Users.fullName'=>'ASC'])->toArray();
		$driverList = str_replace(";"," - ",$DList);
		
        $this->paginate = [
            'limit' => $limit,
            'order' => [
                'Bookings.created' => 'DESC'
            ],
			'contain' =>['Users','Drivers','Categories']
        ];        
        $keyword = $this->request->query('keyword');
		$driverid = $this->request->query('driverid');
		$userid = $this->request->query('userid');
		$Status = $this->request->query('status');
		$startDate = $this->request->query('startDate');
		$endDate = $this->request->query('endDate');
		$condition[] = ['Bookings.id >'=>0];
		if($Status != ''){
			$condition[] = ['Bookings.status'=>$Status];
		}
		if($driverid !=''){
			$condition[] = ['Bookings.driverId'=>$driverid,'Bookings.status IN'=>[1,2]];
		}
		if($userid !=''){
			$condition[] = ['Bookings.userId'=>$userid];
		}
		
		if($startDate != ''){
			//$startDate = $startDate." 00:00:01" ;
			$condition[] = ['Bookings.bookingDate >='=> $startDate];
        }
        if($endDate != ''){
			//$endDate = $endDate." 23:59:59";
			$condition[] = ['Bookings.bookingDate <='=> $endDate];
        }
		
        if($keyword != ''){
			$condition[] = [
				'OR' => [
					["Bookings.bookingDate LIKE '%".$keyword."%'"],
					//["Bookings.transactionId LIKE '%".$keyword."%'"],
					//["Bookings.totalAmount LIKE '%".$keyword."%'"],
					["Bookings.id LIKE '%".$keyword."%'"],
					["Bookings.TIP LIKE '%".$keyword."%'"],
					//["Users.email LIKE '%".$keyword."%'"],
					["Users.fullName LIKE '%".$keyword."%'"],
					//["Drivers.email LIKE '%".$keyword."%'"],
					["Drivers.fullName LIKE '%".$keyword."%'"],
					["Categories.name LIKE '%".$keyword."%'"],
				]				
			];
		}        
        $query = $this->Bookings->find('all')->where($condition);       
        $bookings = $this->paginate($query);
        $bookings = $bookings->toArray();
		//pr($bookings);die;
        $this->set(compact('bookings', 'limit', 'driverList'));
    }
	
	
	/********************************************************************************
	Function Name: index
	*Output: Function for canceled Ride.
	*********************************************************************************/
    public function cindex($id=null)
    {
        $layoutTitle = 'zarib :: Manage Booking';
        $this->set(compact('layoutTitle'));
        $this->viewBuilder()->layout('Admin/admin');
        $limit = 30;//Configure::read('App.adminPageLimit');
        
		$this->loadModel('Users');
		$DList = $this->Users->find('list', ['keyField' => 'id', 'valueField' => ['fullName', 'email']])
						->where(['Users.role'=>'Driver'])
                        ->order(['Users.fullName'=>'ASC'])->toArray();
		$driverList = str_replace(";"," - ",$DList);
		
        $this->paginate = [
            'limit' => $limit,
            'order' => [
                'Bookings.created' => 'DESC'
            ],
			'contain' =>['Users','Drivers','Categories']
        ];        
        $keyword = $this->request->query('keyword');
		$driverid = $this->request->query('driverid');
		$userid = $this->request->query('userid');
		$Status = $this->request->query('status');
		$startDate = $this->request->query('startDate');
		$endDate = $this->request->query('endDate');
		$condition[] = ['Bookings.rideStatus'=>7];
		if($Status != ''){
			$condition[] = ['Bookings.status'=>$Status];
		}
		if($driverid !=''){
			$condition[] = ['Bookings.driverId'=>$driverid,'Bookings.status IN'=>[1,2]];
		}
		if($userid !=''){
			$condition[] = ['Bookings.userId'=>$userid];
		}
		
		if($startDate != ''){
			//$startDate = $startDate." 00:00:01" ;
			$condition[] = ['Bookings.bookingDate >='=> $startDate];
        }
        if($endDate != ''){
			//$endDate = $endDate." 23:59:59";
			$condition[] = ['Bookings.bookingDate <='=> $endDate];
        }
		
        if($keyword != ''){
			$condition[] = [
				'OR' => [
					
					["Bookings.bookingDate LIKE '%".$keyword."%'"],
					["Bookings.transactionId LIKE '%".$keyword."%'"],
					["Bookings.totalAmount LIKE '%".$keyword."%'"],
					["Bookings.discountAmount LIKE '%".$keyword."%'"],
					["Bookings.TIP LIKE '%".$keyword."%'"],
					["Users.email LIKE '%".$keyword."%'"],
					["Users.fullName LIKE '%".$keyword."%'"],
					["Drivers.email LIKE '%".$keyword."%'"],
					["Drivers.fullName LIKE '%".$keyword."%'"],
					["Categories.name LIKE '%".$keyword."%'"],
				]				
			];
		}        
        $query = $this->Bookings->find('all')->where($condition);       
        $bookings = $this->paginate($query);
        $bookings = $bookings->toArray();
		//pr($bookings);die;
        $this->set(compact('bookings', 'limit', 'driverList'));
    }
	
	
	/********************************************************************************
	Function Name: index
	*Type: Public function used as action of the controller
	*Input: No input
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to view all member list and search.
	*********************************************************************************/
    public function nowbooking($id=null)
    {
        $layoutTitle = 'zarib :: Manage Booking';
        $this->set(compact('layoutTitle'));
        $this->viewBuilder()->layout('Admin/admin');
        $limit = 30;//Configure::read('App.adminPageLimit');
        
        $this->paginate = [
            'limit' => $limit,
            'order' => [
                'Bookings.created' => 'DESC'
            ],
			'contain' =>['Users','Vendors','Services']
        ];        
        $keyword = $this->request->query('keyword');
		$Status = $this->request->query('status');
		$condition[] = ['Bookings.bookingDate' => date('Y-m-d')];
		if($Status != ''){
			$condition[] = ['Bookings.status'=>$Status];
		}
        if($keyword != ''){
			$condition[] = [
				'OR' => [
					["Bookings.address LIKE '%".$keyword."%'"],
					["Bookings.couponCode LIKE '%".$keyword."%'"],
					["Bookings.bookingDate LIKE '%".$keyword."%'"],
					["Bookings.transactionId LIKE '%".$keyword."%'"],
					["Bookings.totalAmount LIKE '%".$keyword."%'"],
					["Bookings.vendorType LIKE '%".$keyword."%'"],
					["Bookings.discountAmount LIKE '%".$keyword."%'"],
					["Bookings.TIP LIKE '%".$keyword."%'"],
					["Users.email LIKE '%".$keyword."%'"],
					["Users.fullName LIKE '%".$keyword."%'"],
					["Vendors.email LIKE '%".$keyword."%'"],
					["Vendors.fullName LIKE '%".$keyword."%'"],
					["Categories.name LIKE '%".$keyword."%'"],
				]				
			];
		}        
        $query = $this->Bookings->find('all')->where($condition);       
        $bookings = $this->paginate($query);
        $bookings = $bookings->toArray();
		//pr($bookings);die;
        $this->set(compact('bookings', 'limit'));
    }


	function cashrefund($id=NULL){
		$layoutTitle = 'zarib :: Edit Booking';
        $this->set(compact('layoutTitle'));
        $this->viewBuilder()->layout('Admin/admin');
		$users = $this->Bookings->find()->where(['Bookings.id' => $id])->contain(['Users','Drivers','Categories'])->first();
        if ($this->request->is('post')) {
            //pr($this->request->data); die;
			if($users->refund_Amount !=''){
				$this->Flash->error(__('Already refunded.'));
				return $this->redirect(['controller' => 'Bookings', 'action' => 'index']);
			}
			$resason = ($this->request->data['refund_reason']) ? $this->request->data['refund_reason'] : 'No comment';
			$resund_amount = ($this->request->data['refund_Amount']) ? $this->request->data['refund_Amount'] : 0;

			$field_for_refunds = array(
				"amount"  => $this->request->data['refund_Amount'],
				"paymentId"=> $users->paymentID,
				"trxID" => $users->transactionId,
				"reason"=>  $this->request->data['refund_reason'],
				"sku" => 'Booking-ID-'.$id
			);

			$username = 'sandboxTokenizedUser02';
			$password = 'sandboxTokenizedUser02@12345';
			$api_key = "4f6o0cjiki2rfm34kfdadl1eqq";
			$app_secret = "2is7hdktrekvrbljjh44ll3d9l1dtjo4pasmjvs5vl5qr3fug4b";
			//if($_REQUEST['customerid']){
				$fields = array(
					"app_key"=>$api_key,
					"app_secret"=> $app_secret
				);
				$headers = array(
				'accept: application/json',
					'Content-Type: application/json',
					'username: '.$username,
					'password: '.$password
				);
			$url = "https://tokenized.sandbox.bka.sh/v1.2.0-beta/tokenized/checkout/token/grant";
			$ch = curl_init();
			curl_setopt($ch, CURLOPT_URL, $url);
			curl_setopt($ch, CURLOPT_POST, true);
			curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
			curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
			$result = curl_exec($ch);
			$D = json_decode($result);
			//echo $D->id_token;

			//pr($fields); die;
			$headersnew = array(
				'Authorization: '.$D->id_token,
				'X-APP-Key: '.$api_key,
				'accept: application/json',
				'Content-Type: application/json'
			);
			$url = "https://tokenized.sandbox.bka.sh/v1.2.0-beta/tokenized/checkout/payment/refund";
			$ch = curl_init();
			curl_setopt($ch, CURLOPT_URL, $url);
			curl_setopt($ch, CURLOPT_POST, true);
			curl_setopt($ch, CURLOPT_HTTPHEADER, $headersnew);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
			curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($field_for_refunds));
			$fina_result = curl_exec($ch);
			$fina_result_json = json_decode($fina_result);
			if($fina_result_json->statusCode == '0000'){
				$articles = TableRegistry::get('Bookings');
				$query = $articles->query();
				$query->update()
					->set(['refund_Amount'=>$this->request->data['refund_Amount'],'refund_reason'=>$this->request->data['refund_reason']])
					->where(['id' => $id])
					->execute();
				$DriverAmount = round(($this->request->data['refund_Amount'] * 0.85),2);
				$articles = TableRegistry::get('Users');
				$query = $articles->query();
				$query->update()
				->set($query->newExpr('wallet = wallet - '.(float)@$DriverAmount))
				->where(['id' => @$users->driverId])
				->execute();

				
				$this->Flash->success(__("Refund successfully"));
			}else{
				$this->Flash->error(__($fina_result_json->statusCode.' - '.$fina_result_json->statusMessage));
			}
			
			return $this->redirect(['controller' => 'Bookings', 'action' => 'index']);
			
		}
			//pr($users); die;
            $this->set(compact('users'));
        // }else{
        //     $this->Flash->error(__('Booking does not exist.'));
        //     return $this->redirect(['controller' => 'Bookings', 'action' => 'index']);
        // }
	}
      
    /********************************************************************************
	Function Name: add
	*Type: Public function used as action of the controller
	*Input: No input
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to add hours.
	*********************************************************************************/
    public function add()
    {
        $layoutTitle = 'zarib ::  Add New Booking';
        $this->set(compact('layoutTitle'));
        $this->viewBuilder()->layout('Admin/admin');
		$this->loadModel('Users');
		$this->loadModel('Categories');
		$userList = $this->Users->find('list', ['keyField' => 'id', 'valueField' => ['fullName', 'email']])
						->where(['Users.role'=>'Member'])
                        ->order(['Users.fullName'=>'ASC'])->toArray();
		$userList = str_replace(";", " - ", $userList);
		$vendorList = $this->Users->find('list', ['keyField' => 'id', 'valueField' => ['fullName', 'email']])
						->where(['Users.role'=>'Partner'])
                        ->order(['Users.fullName'=>'ASC'])->toArray();
		$vendorList = str_replace(";", " - ", $vendorList);
		
		$categoriesList = $this->Categories->find('all')->where(['Categories.parentId'=>'0'])->contain(['Subcategories'])->order(['Categories.name'=>'ASC'])->toArray();
		
		$option = '<option value="">Choose One</option>';
		foreach($categoriesList as $value){
			if(@$value->subcategories){
				$option .= '<optgroup label="'.$value->name.'">';
				foreach($value->subcategories as $sub){
					$option .= '<option value="'.$sub->id.'">'.$sub->name.'</option>';
				}
				$option .= '</optgroup>';
			}else{
				$option .=  '<option value="'.$value->id.'">'.$value->name.'</option>';
			}
		}
		//pr($option); die;	
        $bookings = $this->Bookings->newEntity();        
       
        if ($this->request->is('post')) {
            
			$bookings = $this->Bookings->patchEntity($bookings, $this->request->data, ['validate' => 'customer']);            
			$bookings['created'] = date('Y-m-d H:i:s');
			$bookings['created'] = date('Y-m-d', strtotime($this->request->data['bookingDate']));
			//$path = WWW_ROOT . 'img/uploads/feature/original/';
			if ($this->Bookings->save($bookings)) {
				$this->Flash->success(__('Booking added successfully.'));
				return $this->redirect(['action' => 'index']);	
			}else{
				//pr($users);die;
				$this->Flash->error(__('Unable to add new booking, Please try again later.'));
			}
		}
        $this->set(compact('bookings','userList', 'vendorList', 'option'));
    }
    
    
    
    
    /********************************************************************************
	Function Name: edit
	*Type: Public function used as action of the controller
	*Input: Member id
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to edit hours.
	*********************************************************************************/
    public function edit($id)
    {
        $layoutTitle = 'zarib :: Edit Booking';
        $this->set(compact('layoutTitle'));
        $this->viewBuilder()->layout('Admin/admin');
        
		$this->loadModel('Users');
		$this->loadModel('Categories');
		$userList = $this->Users->find('list', ['keyField' => 'id', 'valueField' => ['fullName', 'email']])
						->where(['Users.role'=>'Member'])
                        ->order(['Users.fullName'=>'ASC'])->toArray();
		$userList = str_replace(";", " - ", $userList);
		$vendorList = $this->Users->find('list', ['keyField' => 'id', 'valueField' => ['fullName', 'email']])
						->where(['Users.role'=>'Partner'])
                        ->order(['Users.fullName'=>'ASC'])->toArray();
		$vendorList = str_replace(";", " - ", $vendorList);
		
		$categoriesList = $this->Categories->find('all')->where(['Categories.parentId'=>'0'])->contain(['Subcategories'])->order(['Categories.name'=>'ASC'])->toArray();
		
		$option = '<option value="">Choose One</option>';
		foreach($categoriesList as $value){
			if(@$value->subcategories){
				$option .= '<optgroup label="'.$value->name.'">';
				foreach($value->subcategories as $sub){
					$option .= '<option value="'.$sub->id.'">'.$sub->name.'</option>';
				}
				$option .= '</optgroup>';
			}else{
				$option .=  '<option value="'.$value->id.'">'.$value->name.'</option>';
			}
		}
		
        $bookings = $this->Bookings->find()->where(['Bookings.id' => $id])->first();//fields name in contain[] with coma
        if ($this->request->is(['patch', 'post', 'put'])) {
			
			$bookings = $this->Bookings->patchEntity($bookings, $this->request->data, ['validate' => 'customer']);
			$bookings['created'] = date('Y-m-d', strtotime($this->request->data['bookingDate']));
			
			$path = WWW_ROOT . 'img/uploads/feature/original/';
			if ($this->Bookings->save($bookings)) {
				
				$this->Flash->success(__('The booking updated successfully.'));
                return $this->redirect(['action' => 'index']);
			} else {
				
				$this->Flash->error(__('Booking information could not be saved. Please try again later.'));
			}
        }
        $this->set(compact('bookings','userList', 'vendorList', 'option'));
    }
    
    
    /********************************************************************************
	Function Name: delete
	*Type: Public function used as action of the controller
	*Input: Member id
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to delete hours permanently.
	*********************************************************************************/
    public function delete($id = null)
    {
        $users = $this->Bookings->get($id);
        if ($this->Bookings->delete($users)) {
            $this->Flash->success(__('Booking has been deleted.'));
        } else {
            $this->Flash->error(__('Booking could not be deleted. Please, try again.'));
        }
        return $this->redirect(['controller' => 'Bookings', 'action' => 'index']);
    }
    
    
    /********************************************************************************
	Function Name: status
	*Type: Public function used as action of the controller
	*Input: Member id
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to update hours status.
	*********************************************************************************/
    public function status($id){
		$users = $this->Bookings->get($id);
		$status = '1';
		$msg = 'activated';
		if($users->status == '1'){
			$status = '0';
			$msg = 'deactivated';
		}
		
		$articles = TableRegistry::get('Bookings');
		$query = $articles->query();
		$query->update()
			->set(['status' => $status])
			->where(['id' => $id])
			->execute();
		$this->Flash->success(__('Booking has been '.$msg.' successfully.'));
		return $this->redirect(['controller' => 'Bookings', 'action' => 'index']);
	}
    
    
    /********************************************************************************
	Function Name: details
	*Type: Public function used as action of the controller
	*Input: Member id
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to view hours information.
	*********************************************************************************/
    public function details($id){
        $layoutTitle = 'zarib ::  Member Details';
        $this->set(compact('layoutTitle'));
        $this->viewBuilder()->layout('Admin/admin');        
		$users = $this->Bookings->find()->where(['Bookings.id' => $id])->contain(['Users','Drivers','Categories'])->first();
        if(!empty($users)){
			//pr($users); die;
            $this->set(compact('users'));
        }else{
            $this->Flash->error(__('Booking does not exist.'));
            return $this->redirect(['controller' => 'Bookings', 'action' => 'index']);
        }
	}



	function checksms(){

		// URL: https://gpcmp.grameenphone.com/gp/ecmapigw/webresources/ecmapigw.v3
		// Request Body: 
		// {
		//  "username": "GPICTadmin123",
		//  "password": "@Test123",
		//  "apicode": "1",
		//  "msisdn": ["01711086791"],
		//  "countrycode": "880",
		//  "cli": "GP ICT",
		//  "messagetype": "1",
		//  "message": "This is a test single SMS API.",
		//  "clienttransid": " 1311161161642679986567566",
		//  "bill_msisdn": "01313704545",
		//  "tran_type": "P",
		//  "request_type": "S",
		//  "rn_code": "71"
		// }

		$fields = array(
			"username"=> "GPICTadmin123",
			"password"=> "@Test123",
			"apicode"=> "1",
			"msisdn"=> ["01711086791"],
			"countrycode"=> "880",
			"cli"=> "GP ICT",
			"messagetype"=> "1",
			"message"=> "Hello Zarib",
			"clienttransid"=> "1311161161642679986567566",
			"bill_msisdn"=> "01313704545",
			"tran_type"=> "P",
			"request_type"=> "S",
			"rn_code"=> "71"
		);
		//pr($fields); die;
		
		$url = "https://gpcmp.grameenphone.com/gp/ecmapigw/webresources/ecmapigw.v3";
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_POST, true);
		//curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
		$result = curl_exec($ch);
		echo "<pre>"; print_r($result);
		die('Sms Sent');

	}
	
	
}