<?php

require_once('lib/tcpdf.php');

function outputPdf($html,$output='I',$name){
	
	if($html){
		global $pdf; 
		$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

		$pdf->SetCreator(PDF_CREATOR);
		$pdf->SetAuthor("e-Vertual Services");
		$pdf->SetTitle($name);
		$pdf->SetSubject($name);
		$pdf->SetKeywords('Salary, PDF, Slip');

		$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

		$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

		if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
			require_once(dirname(__FILE__).'/lang/eng.php');
			$pdf->setLanguageArray($l);
		}

		$pdf->SetFont('times', '', 8);

		$pdf->AddPage();

		

		$pdf->writeHTML($html, true, 0, true, 0);

		$pdf->lastPage();

		$pdf->Output($name.'.pdf', $output);
	}
	else{
		
		"Please send htn";
	}
}	
