<?php
namespace App\Model\Table;

use Cake\ORM\Table;
use Cake\Validation\Validator;
use Cake\Auth\DefaultPasswordHasher;
//use Cake\ORM\RulesChecker;
 
class UsersTable extends Table
{
    public function initialize(array $config)
    {
        //$this->belongsTo('Employees');
        //$this->belongsTo('Charities');
        //$this->belongsTo('Businesses');
		//$this->belongsTo('Departments');
        
        $this->addAssociations([
            'belongsTo' => [
              'Tippings' => ['className' => 'App\Model\Table\TippingsTable']
            ],
            'hasMany' => [
            'Tippings' => ['className' => 'App\Model\Table\TippingsTable', 'foreignKey' => ['employer_id']]
            ]
        ]);
        
        
        $this->hasMany('Carinformations', [
            'className' => 'Carinformations',
            //'bindingKey' => ['employer_id'],
			'foreignKey' => ['userId']
        ]);
		
		$this->hasMany('Reviews', [
            'className' => 'Reviews',
            //'bindingKey' => ['employer_id'],
			'foreignKey' => ['reviewTo']
        ]);
		
		
		
		$this->hasMany('Driverbookings', [
            'className' => 'Bookings',
            //'bindingKey' => ['employer_id'],
			'foreignKey' => ['driverId']
        ]);
		
		$this->hasMany('Userbookings', [
            'className' => 'Bookings',
            //'bindingKey' => ['employer_id'],
			'foreignKey' => ['userId']
        ]);

        $this->belongsTo('Countries', [
            'className' => 'Countries',
            //'bindingKey' => ['employee_id'],
			'foreignKey' => ['countryId']
        ]);
       
        
        
        /*$this->hasMany('Tippings', [
            'className' => 'Tippings',
            //'bindingKey' => ['employer_id'],
			'foreignKey' => ['employer_id']
        ]);*/
        
       /*$this->belongsTo('Employees', [
            'className' => 'Employees',
            'bindingKey' => ['employee_id'],
			'foreignKey' => ['id']
        ]);*/
        
       /****************** New Working changes ********************/
       /*$this->belongsTo('Departments', [
            'className' => 'Departments',
            'foreignKey' => 'department_id'
        ]);
        
        $this->belongsTo('Businesses', [
            'className' => 'Businesses',
            'foreignKey' => 'business_id'
        ]);
        
        $this->belongsTo('BusinessDepartments', [
            'className' => 'BusinessDepartments',
            'bindingKey' => ['business_id', 'department_id'],
			'foreignKey' => ['business_id', 'department_id']
            
        ]);*/
        
        
        
        /*************************/
        
        /*
        $this->hasMany(
            'Departments', [
                'foreignKey' => 'department_id'
            ],
            'Businesses', [
                'foreignKey' => 'business_id'
            ]
        );
        */
        /*$this->hasMany('Departments', [
            'className' => 'Departments',
            'foreignKey' => 'department_id'
        ]);
        
        
         $this->belongsTo('Departments', [
            'className' => 'Departments',
            'foreignKey' => 'department_id'
        ]);
        */        
    }
    
    /*
    public function validationDefault(Validator $validator)
    {
        return $validator
            ->notEmpty('username', 'A username is required')
            ->notEmpty('password', 'A password is required')
            ->notEmpty('role', 'A role is required')
            ->add('role', 'inList', [
                'rule' => ['inList', ['admin', 'author']],
                'message' => 'Please enter a valid role'
            ]);
    }*/
    
    //$validator = new Validator();

    
    public function validationCustomer(Validator $validator)
    {
        $validator
			->notEmpty('email', 'Please enter mamber email id.')
			->add('email', 'validFormat', [
				'rule' => 'email',
				'message' => 'Please enter valid email id'])
			 ->add('email', 'unique',[
                    'rule' => 'validateUnique',
                    'provider' => 'table',
                    'message' => 'Email already exist'
			]);
		
		
		$validator->notEmpty('gender', 'Please select sex.');
		$validator->notEmpty('department', 'Please select department.');
        
        $validator->notEmpty('contactNumber', 'Please enter Contact Number')
			->add('contactNumber', 'minLength', [
				'rule' => ['minLength', 10], 
				'message' => 'Contact Number must be 10 digits.'
			])
			->add('contactNumber', 'maxLength', [
				'rule' => ['maxLength', 10], 
				'message' => 'Contact Number must be 10 digits.'
		]); 

        $validator->notEmpty('firstname', 'Please enter mamber fullname.')
			->add('firstname', 'minLength', [
				'rule' => ['minLength', 3], 
				'message' => 'Member fullname must be atleast three character long.'
			])
			->add('firstname', 'maxLength', [
				'rule' => ['maxLength', 50], 
				'message' => 'Member fullname exceeds maximum fifty character limit.'
		]); 
        
			
		$validator->notEmpty('password', 'Please enter member login password.')
			->add('password', 'minLength', [
			'rule' => ['minLength', 6], 
			'message' => 'Member login password must be atleast six character long.'
		])
			->add('password', 'maxLength', [
			'rule' => ['maxLength', 25], 
			'message' => 'Member login password exceeds maximum twenty five character limit.'
		]); 
			
			
		$validator->notEmpty('confirm_password', 'Please re-type member login password.')
			->add('confirm_password', 'minLength', [
			'rule' => ['minLength', 6], 
			'message' => 'Member confirm password must be atleast six character long.'
			])
			->add('confirm_password', 'maxLength', [
			'rule' => ['maxLength', 25], 
			'message' => 'Member confirm password exceeds maximum twenty five character limit.'
			])
			->add('confirm_password',[			
			'match'=>[
				'rule'=> ['compareWith','password'],
				'last' => true,
				'message'=>'Confirm password do not match with password.', 				
			]
		]); 
        
         $validator->add('profile_picture', [      
				'profile_picture' => [                    
					'rule'=>  function($value){
						$ext = explode(".", $value);
						$extension = strtolower(end($ext));
						
						if (in_array(trim($extension), array('jpg', 'jpeg', 'png', 'gif'))) {							
							return true;
						}
						return false;
					},
					'message'=>'Please select jpg, jpeg, gif and png only.',
                ]
		])->allowEmpty('profile_picture'); 
		      
        return $validator;
    }
    
    
   
    public function validationPassword(Validator $validator )
    {
    
        $validator
            ->add('old_password','custom',[
                'rule'=>  function($value, $context){
                    $user = $this->get($context['data']['id']);
                    if ($user) {
                        if ((new DefaultPasswordHasher)->check($value, $user->password)) {
                            return true;
                        }
                    }
                    return false;
                },
                'message'=>'The old password is not correct!',
            ])
            ->notEmpty('old_password');
    
        $validator
            ->add('password1', [
                'length' => [
                    'rule' => ['minLength', 6],
                    'message' => 'Password should be minimum six character',
                ]
            ])
            ->add('password1',[
                'match'=>[
                    'rule'=> ['compareWith','password2'],
                    'message'=>'Password not match from confirm password',
                ]
            ])
            ->notEmpty('password1');
        $validator
            ->add('password2', [
                'length' => [
                    'rule' => ['minLength', 6],
                    'message' => 'Password should be minimum six character',
                ]
            ])
            ->add('password2',[
                'match'=>[
                    'rule'=> ['compareWith','password1'],
                    'message'=>'Confirm password not match from password',
                ]
            ])
            ->notEmpty('password2');
    //pr($validator); die('A');
        return $validator;
    }
    
    
    public function validationEdit(Validator $validator )
    {
    
        $validator
            ->notEmpty('firstname', 'First name can not empty')
            ->add('firstname', 'minLength', [
				'rule' => ['minLength', 3], 
				'message' => 'Admin first name must be atleast three character long.'
			])
			->add('firstname', 'maxLength', [
				'rule' => ['maxLength', 50], 
				'message' => 'Admin first name exceeds maximum fifty character limit.'
			]); 
    
        $validator
            ->notEmpty('lastname', 'Last name can not empty')
            ->add('lastname', 'minLength', [
				'rule' => ['minLength', 3], 
				'message' => 'Admin last name must be atleast three character long.'
			])
			->add('lastname', 'maxLength', [
				'rule' => ['maxLength', 50], 
				'message' => 'Admin last name exceeds maximum fifty character limit.'
			]); 
        $validator->notEmpty('contactNumber', 'Please enter Contact Number')
			->add('contactNumber', 'minLength', [
				'rule' => ['minLength', 10], 
				'message' => 'Contact Number must be 10 digits.'
			])
			->add('contactNumber', 'maxLength', [
				'rule' => ['maxLength', 10], 
				'message' => 'Contact Number must be 10 digits.'
		]); 
        
        $validator
           ->add('email', [
                'notBlank' => [
                    'rule' => 'notBlank',
                    'message' => 'Not blank email address'
                ],
                'email' => [
                    'rule' => ['email'],
                    'message' => 'Please enter valid email address'
                ],
                'unique' => [
                    'rule' => 'validateUnique',
                    'provider' => 'table',
                    'message' => 'Email already exist'
                ]
            ]);
		   
           $validator->notEmpty('role', 'Please select user type.');
		   $validator->notEmpty('department', 'Please select department.');
		   
           $validator->add('profile_picture', [      
				'profile_picture' => [                    
					'rule'=>  function($value){
						$ext = explode(".", $value);
						$extension = strtolower(end($ext));
						
						if (in_array(trim($extension), array('jpg', 'jpeg', 'png', 'gif'))) {							
							return true;
						}
						return false;
					},
					'message'=>'Please select jpg, jpeg, gif and png only.',
                ]
		])->allowEmpty('profile_picture'); 
        return $validator;
    }
    
   

}
