<?php
namespace App\Model\Table;

use Cake\ORM\Table;
use Cake\Validation\Validator;
use Cake\Auth\DefaultPasswordHasher;
//use Cake\ORM\RulesChecker;
 
class CategoriesTable extends Table
{
    public function initialize(array $config)
    {
		$this->belongsTo('ParentCategory', [
            'className' => 'Categories',
			'foreignKey' => ['parentId'],
			'dependent' => true,
			'cascadeCallbacks' => true,
        ]);
		$this->hasMany('Products', [
            'className' => 'Products',
			'foreignKey' => ['categoryId'],
			//'dependent' => true,
			//'cascadeCallbacks' => true,
        ]);
		$this->hasMany('Subproducts', [
            'className' => 'Products',
			'foreignKey' => ['subCategory'],
			//'dependent' => true,
			//'cascadeCallbacks' => true,
        ]);
		$this->hasMany('Freestaffs', [
            'className' => 'Freestaffs',
			'foreignKey' => ['categoryId'],
			//'dependent' => true,
			//'cascadeCallbacks' => true,
        ]);
		
    }
//    public function implementedEvents()
//	{
//		$events = parent::implementedEvents();
//		$events['Model.beforeDelete'] = [
//			'callable' => 'beforeDelete',
//			'priority' => 3
//		];
//		
//		return $events;
//	}
//
//	public function beforeDelete(Event $event, EntityInterface $entity,ArrayObject $options)
//    {
//		echo "<pre>"; print_r($event);
//		print_r($entity);
//		print_r($options);
//		die;
//       return false;
//    }
	
    public function validationCustomer(Validator $validator)
    {
        
        $validator->notEmpty('name', 'Please enter category name.');
//        $validator->notEmpty('venue', 'Please enter venue.');
//        $validator->notEmpty('contactNo', 'Please enter contact No.');
//        $validator->notEmpty('date', 'Please select date.');
//        $validator->notEmpty('time', 'Please select time.');
//        
//        $validator->notEmpty('pax', 'Please enter pax no.');
//        $validator->notEmpty('service', 'Please select service.');
//        
//        $validator
//			->add('email', 'validFormat', [
//				'rule' => 'email',
//				'message' => 'Please enter valid email id'])
//			->allowEmpty('email'); 
//		
//        $validator->notEmpty('name', 'Please enter client full name.')
//			->add('firstname', 'minLength', [
//				'rule' => ['minLength', 3], 
//				'message' => 'Client name must be atleast three character long.'
//			])
//			->add('firstname', 'maxLength', [
//				'rule' => ['maxLength', 50], 
//				'message' => 'Client name exceeds maximum fifty character limit.'
//		]); 
        
		      
        return $validator;
    }
    
    
    
    
    
    public function validationLead(Validator $validator)
    {
        
            
        $validator->notEmpty('name', 'Please first name.');
        $validator->notEmpty('lastName', 'Please enter last name.');
        $validator->notEmpty('phoneNumber', 'Please enter phone number.');
        $validator->notEmpty('source', 'Please select source.');
        $validator->notEmpty('status', 'Please select status.');
        $validator->notEmpty('assignTo', 'Please select assignTo.');
            
        $validator
            ->notEmpty('email', 'Please enter email id.')
			->add('email', 'validFormat', [
				'rule' => 'email',
				'message' => 'Please enter valid email id'])
			 ->add('email', 'unique',[
                    'rule' => 'validateUnique',
                    'provider' => 'table',
                    'message' => 'Email already exist'
			]);
             
        $validator
			->add('email2', 'validFormat', [
				'rule' => 'email',
				'message' => 'Please enter valid email id'])
			->allowEmpty('email2');
		
		
		$validator
			->notEmpty('accountNo', 'Please enter account no.')
			 ->add('accountNo', 'unique',[
                    'rule' => 'validateUnique',
                    'provider' => 'table',
                    'message' => 'Account No already exist'
			]);
        
		      
        return $validator;
    }
	
    
    
    
    
    
    
   

}