<?php
/**
 * CakePHP(tm) : Rapid Development Framework (http://cakephp.org)
 * Copyright (c) Cake Software Foundation, Inc. (http://cakefoundation.org)
 *
 * Licensed under The MIT License
 * For full copyright and license information, please see the LICENSE.txt
 * Redistributions of files must retain the above copyright notice.
 *
 * @copyright Copyright (c) Cake Software Foundation, Inc. (http://cakefoundation.org)
 * @link      http://cakephp.org CakePHP(tm) Project
 * @since     0.2.9
 * @license   http://www.opensource.org/licenses/mit-license.php MIT License
 */
namespace App\Controller;


use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require("/home/demo4ev/public_html/Exception.php");
require("/home/demo4ev/public_html/PHPMailer.php");
require("/home/demo4ev/public_html/SMTP.php");

use Cake\Controller\Controller;
use Cake\Event\Event;
use Cake\Core\Configure;
use Cake\Mailer\Email;

date_default_timezone_set('Asia/Kolkata');
date_default_timezone_set('America/Los_Angeles');

/**
 * Application Controller
 *
 * Add your application-wide methods in the class below, your controllers
 * will inherit them.
 *
 * @link http://book.cakephp.org/3.0/en/controllers.html#the-app-controller
 */
class AppController extends Controller
{

    /**
     * Initialization hook method.
     *
     * Use this method to add common initialization code like loading components.
     *
     * e.g. `$this->loadComponent('Security');`
     *
     * @return void
     */
    public function initialize()
    {
        parent::initialize();

        $this->loadComponent('RequestHandler');
        $this->loadComponent('Flash');
        //$this->loadComponent('Auth', [
        //    'loginRedirect' => [
        //        'controller' => 'Employers',
        //        'action' => 'index'
        //    ],
        //    'logoutRedirect' => [
        //        'controller' => 'Employers',
        //        'action' => 'index',
        //    ],
        //    'authenticate' => [
        //        'Form' => [
        //            'fields' => ['username' => 'email']
        //        ]
        //    ]
        //]);
    }

    /**
     * Before render callback.
     *
     * @param \Cake\Event\Event $event The beforeRender event.
     * @return void
     */
    public function beforeRender(Event $event)
    {
		
        $this->set('PATH', Configure::read('App.siteurl'));
        if (!array_key_exists('_serialize', $this->viewVars) &&
            in_array($this->response->type(), ['application/json', 'application/xml'])
        ) {
            $this->set('_serialize', true);
        }
        
		$this->loadModel('GlobalParameters');
		$globalparameters = $this->GlobalParameters->get(1);
		$this->set('GLOBAL', $globalparameters);
		$this->loadModel('Latestnews');
        $latestnews = $this->Latestnews->find('all')->where(['Latestnews.status' => 1])->limit('5')->order(['Latestnews.id' => 'DESC'])->toArray();
		$this->set('latestnews', $latestnews);
    }
    
    /********************************************************************************
	Function Name: sendmail
	*Type: Public function used as action of the controller
	*Input: template variables, mail template, receiver email and email subject
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to send emails.
	*********************************************************************************/
	function sendmail($Email_variables,$mail_template='', $mailto='', $subject='', $mailcc = '',$from='') {	
		$this->autoRender = false;
        //die('dsds');
        //$email = new Email('Smtp');
		$email = new Email('default');
		$email->helpers(array());
        $email->template($mail_template, 'email_layout')
            ->emailFormat('html')
            ->viewVars($Email_variables)		
            ->subject($subject)
            ->to($mailto)
            ->from(['hr@evirtualservices.com'=>'E-virtual services'])
            ->send();
		return true;
	}
    
//	function sendmail($Email_variables,$mail_template='', $mailto='', $subject='', $mailcc = '',$from='') {	
//		$this->autoRender = false;
//        //$email = new Email('default');
//        $email = new Email('Smtp');
//        $email->template($mail_template, 'email_layout')
//            ->emailFormat('html')
//            ->viewVars($Email_variables)		
//            ->subject($subject)
//            ->to($mailto)
//            ->from(['hr@evirtualservices.com'=>'E-virtualservices'])
//            ->send();
//		return true;
//	}
     /********************************************************************************
	Function Name: random_password
	*Type: Public function used as action of the controller
	*Input: No input
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function for generate n length random password.
	*********************************************************************************/
    public function random_password($length = '10'){
		//$this->autoRender = false;	
		$characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
		$charactersLength = strlen($characters);
		$randomString = '';
		for ($i = 0; $i < $length; $i++) {
			$randomString .= $characters[rand(0, $charactersLength - 1)];
		}
		return $randomString;		
	}
	
	function sendmail2($to=NULL,$subject=NULL,$message=NULL){
	
		if($to && $subject && $message){
		
		$headder = '<html xmlns="http://www.w3.org/1999/xhtml" style="margin: 0;padding: 0;">
		<head style="margin: 0;padding: 0;">
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8" style="margin: 0;padding: 0;">
		<title style="margin: 0;padding: 0;">Untitled Document</title>
		<link href="http://fonts.googleapis.com/css?family=Raleway:500,300|Lato:300,400,700" rel="stylesheet" type="text/css" style="margin: 0;padding: 0;">
		<style style="margin: 0;padding: 0;">
		* {
			margin: 0;
			padding: 0;
		}
		body {
		}
		.style1 {
			color: #555;
			font-family: "Lato", sans-serif;
			font-size: 14px;
			line-height: 24px;
			margin-bottom: 16px;
		}
		</style>
		</head>

		<body style="margin: 0;padding: 0;" width="100%">
		<table border="0" cellspacing="0" cellpadding="0" style="width:80% ;margin: 0 auto;padding: 0;">
		  <tr style="margin: 0;padding: 0;">
			<td bgcolor="#e5e5e5" align="center" style="padding: 10px 0;margin: 0;"><img src="'.Configure::read('App.siteurl').'img/emailer-logo.png" style="margin: 0;padding: 0;"></td>
		  </tr>
		  <tr style="margin: 0;padding: 0;">
			<td bgcolor="#f4f4f4" style="padding:10px;color: #555;font-family: Lato, sans-serif;font-size: 14px;line-height: 24p margin-bottom: 16px;margin: 0;">'; 
			
			$content = '<div class="style1" style="line-height:10px; padding:5px;color: #555;font-family: &quot;Lato&quot;, sans-serif;font-size: 14px;line-height: 24px;margin-bottom: 16px;">'.$message.'</div>'; 
			
			$footer = '<p>&nbsp;</p><p class="style1" style="font-size: 15px;margin: 0;padding: 0;color: #555;font-family: &quot;Lato&quot;, sans-serif;line-height: 24px;margin-bottom: 16px;"><strong style="margin: 0;padding: 0;"> If you have any query please contact to HR team.</strong></p>
			  
			  </td>
		  </tr>
		  <tr style="margin: 0;padding: 0;">
			<td bgcolor="#1e1e66" style="margin: 0;padding:15px;"><p style="font-size: 13px;text-align: center;color: #FFF;padding-top:15px; margin: 0;padding: 0;font-family: &quot;Lato&quot;, sans-serif;line-height: 24px;margin-bottom: 16px;">
			<strong style="font-size: 18px;margin: 0;padding: 0;">Evirtual HR Team</strong>
			<br style="margin: 0;padding: 0;"><a style="color: #FFF;" href="mailto:hr@evirtualservices.com" target="_blank">hr@evirtualservices.com</a> <br style="margin: 0;padding: 0;"></p></td>
		  </tr>
		</table></body></html>';
		
			$body = $headder.$content.$footer; 
			$headers  = 'MIME-Version: 1.0' . "\r\n";
			$headers .= 'Content-type: text/html; charset=UTF-8' . "\r\n";
			//$headers .= 'To: Mary <mary@example.com>, Kelly <kelly@example.com>' . "\r\n";
			$headers .= 'From: EVS-PORTAL <hr@evirtualservices.com>' . "\r\n";
			// Mail it
			mail($to, $subject, $body, $headers);
			return true; 	
		}
		else{
			return false;
		}
	}
	
	function phpemail($to, $subject, $message){
		return true;
		$mailer = new PHPMailer(true);
		$mailer->SMTPDebug = 0;
		$mailer->isSMTP();
		$mailer->Mailer = "smtp";
		$mailer->SMTPOptions = array(
		'ssl' => array(
			'verify_peer' => false,
			'verify_peer_name' => false,
			'allow_self_signed' => true
		));
	
		$headder = '<html xmlns="http://www.w3.org/1999/xhtml" style="margin: 0;padding: 0;">
		<head style="margin: 0;padding: 0;">
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8" style="margin: 0;padding: 0;">
		<title style="margin: 0;padding: 0;">Untitled Document</title>
		<link href="http://fonts.googleapis.com/css?family=Raleway:500,300|Lato:300,400,700" rel="stylesheet" type="text/css" style="margin: 0;padding: 0;">
		<style style="margin: 0;padding: 0;">
		* {
			margin: 0;
			padding: 0;
		}
		body {
		}
		.style1 {
			color: #555;
			font-family: "Lato", sans-serif;
			font-size: 14px;
			line-height: 24px;
			margin-bottom: 16px;
		}
		</style>
		</head>

		<body style="margin: 0;padding: 0;" width="100%">
		<table border="0" cellspacing="0" cellpadding="0" style="width:80% ;margin: 0 auto;padding: 0;">
		  <tr style="margin: 0;padding: 0;">
			<td bgcolor="#f4f4f4" align="center" style="padding: 10px 0;margin: 0;"><img src="'.Configure::read('App.siteurl').'img/admin/logo-black.png" style="margin: 0;padding: 0;"></td>
		  </tr>
		  <tr style="margin: 0;padding: 0;">
			<td bgcolor="#FFF" style="padding:10px;color: #555;font-family: Lato, sans-serif;font-size: 14px;line-height: 24px; margin-bottom: 16px;margin: 0;">'; 
			
			$content = '<div class="style1" style="line-height:10px; padding:5px;color: #555;font-family: &quot;Lato&quot;, sans-serif;font-size: 14px;line-height: 24px;margin-bottom: 16px;">'.$message.'</div>'; 
			
			//$footer = '<p>&nbsp;</p><p class="style1" style="font-size: 15px;margin: 0;padding: 0;color: #555;font-family: &quot;Lato&quot;, sans-serif;line-height: 24px;margin-bottom: 16px;"><strong style="margin: 0;padding: 0;"> If you have any query please call us : +1(844-888-7439)</strong></p>
			  
			  $footer = '</td>
		  </tr>
		  <tr style="margin: 0;padding: 0;">
			<td bgcolor="#FF8C00" style="margin: 0;padding:15px;"><p style="font-size: 13px;text-align: center;color: #FFF;padding-top:15px; margin: 0;padding: 0;font-family: &quot;Lato&quot;, sans-serif;line-height: 24px;margin-bottom: 16px;">
			<strong style="font-size: 18px;margin: 0;padding: 0;">Zarib Support Team</strong>
			<br style="margin: 0;padding: 0;"><a style="color: #FFF;" href="mailto:support@Zarib.com" target="_blank">support@Zarib.com</a> <br style="margin: 0;padding: 0;"></p></td>
		  </tr>
		</table></body></html>';

			$body = $headder.$content.$footer; 
			// echo $body; die;
			$mailer->Host = 'mail.smtp2go.com';
			$mailer->SMTPAuth = true;
			$mailer->Username = 'info@demo2.evirtualservices.co';
			$mailer->Password = 'Testing@1234567890';
			$mailer->SMTPSecure = 'tls';
			$mailer->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
			$mailer->Port = 587;
		
			$mailer->setFrom('info@demo2.evirtualservices.co', 'Zarib');
			$mailer->addAddress($to);
			$mailer->isHTML(true);
			$mailer->Subject = $subject;
			$mailer->Body = $body;
			
			$mailer->send();
			$mailer->ClearAllRecipients();
			return true;
	}
	
	
	function sendNotificationOnAndroid($deviceToken=NULL,$body=NULL){
		$url = Configure::read('App.siteurl').'push.php';
		$fields =[
			'deviceToken' => $deviceToken,
			'body' => json_encode($body)
		];
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_POST, true);
		//curl_setopt($ch, CURLOPT_HTTPHEADER, false);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
		$result = curl_exec($ch);
		//echo "<pre>"; print_r($result); die('G1GG');
		curl_close($ch);
		return $result; 
    }
	
	// function sednIosPushNotification($deviceToken=NULL,$body=NULL){
	// //echo "<pre>"; print_r($body); die;
	// 		$GOOGLE_API_KEY = "AAAArtixum0:APA91bHUusFW81-wCd6C7YUgzTHY9zi-XpqHw_YVyRukf5yNTNpdMe8NXuAk5TnStvbz6_Z-VpOdPs4-nCvxYZ2ejPf6yoLq1Dvk0ZwlBM2HSGD1xY3xdm_MIZrYd6wQbsueAqWlnAiV";
	// 		//$url = 'https://android.googleapis.com/gcm/send';
	// 		$url = 'https://fcm.googleapis.com/fcm/send';
			
	// 		$body['message'] = $body['message']; 
	// 		$body['gcm.notification.body'] = $body['message']; 
	// 		unset($body['msg']);
			
			
	// 		// $fields = array(
	// 		// 	'registration_ids'  => array($deviceToken),
	// 		// 	'data'              => $body,
	// 		// 	'body'              => $body['message'],
	// 		// 	'sound' 			=> 'alert.aiff',
	// 		// 	'priority'			=> 10
	// 		// );
	// 		$fields = array(
	// 			"to" => $deviceToken,
	// 			"notification" => array( 
	// 				//"title" => $body['message'], 
	// 				"sound" => "default" 
	// 			),
	// 			"data"=>$body
	// 		);
	// 		$headers = array(
	// 			'Authorization: key=' . $GOOGLE_API_KEY,
	// 			'Content-Type: application/json'
	// 		);

	// 		$ch = curl_init();
	// 		curl_setopt($ch, CURLOPT_URL, $url);
	// 		curl_setopt($ch, CURLOPT_POST, true);
	// 		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
	// 		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	// 		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
	// 		curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
	// 		$result = curl_exec($ch);
	// 		return $result; 
	// 		//echo "<pre>"; print_r($result); die('APP');
	// 		if ($result === FALSE) {
	// 			return true;
	// 			die('Curl failed: ' . curl_error($ch));
	// 		}
	// 		else{
	// 			return true;
	// 			//echo $result; die('APP');
	// 		}
	// 		curl_close($ch);
	// 		//echo json_encode($result);die;
	// 		return $result; 
    // }

	function sednIosPushNotification($deviceToken=NULL,$body=NULL){
		$url = Configure::read('App.siteurl').'push.php';
		$fields =[
			'deviceToken' => $deviceToken,
			'body' => json_encode($body)
		];
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_POST, true);
		//curl_setopt($ch, CURLOPT_HTTPHEADER, false);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
		$result = curl_exec($ch);
		//echo "<pre>"; print_r($result); die('G1GG');
		curl_close($ch);
		return $result; 
    }
	



	function caremail($to, $subject, $email_data){
		//return true;
		$mailer = new PHPMailer();
		$mailer->SMTPDebug = 0;
		$mailer->isSMTP();
		$mailer->Mailer = "smtp";
		$mailer->SMTPOptions = array(
		'ssl' => array(
			'verify_peer' => false,
			'verify_peer_name' => false,
			'allow_self_signed' => true
		));

		$car_image = 'bike.jpg';
		if($email_data['carType'] == 'CAR'){
			$car_image = 'taxi.png';
		}
		//pr($email_data); die('nnnn');
		$headder = '<html xmlns="http://www.w3.org/1999/xhtml">
		<head>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
		<title>Untitled Document</title>
		 <link rel="preconnect" href="https://fonts.googleapis.com">
		<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
		<link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700&display=swap" rel="stylesheet">
		<style>body{font-family:13px;font-family: "Roboto", sans-serif;}</style>
		</head>
		
		<body>
		<table width="100%" border="0" cellspacing="0" cellpadding="0" style="max-width:800px; margin:0 auto; border:1px solid #CCC; border-top:8px solid #26135f;">
		  <tr>
			<td><table width="100%" border="0" cellspacing="0" cellpadding="0">
			  <tr>
				<td align="center" style="text-align:center;"><img src="'.Configure::read('App.siteurl').'img/admin/logo-black.png" style="max-width:170px; margin:50px 0 0 0;"></td>
			  </tr>
			  <tr>
				<td align="center"><div style="width:100%; text-align:center;margin:30px 0 10px 0;">Hi '.$email_data['Custome_name'].',</div></td>
			  </tr>
			  <tr>
				<td align="center"><div style="width:100%; text-align:center;font-size: 30px;font-weight: bold;">Thank you for riding 
		Zarib App</div><div style="margin-bottom:10px;">We hope you enjoyed you ride with us!</div></td>
			  </tr>
			  <tr>
				<td>&nbsp;</td>
			  </tr>
			  <tr>
				<td align="center" style="text-align:center"><img src="'.Configure::read('App.siteurl').$car_image.'" style="max-width:60%"></td>
			  </tr>';
			  
			  $content = '<tr>
				<td style="background:#f3f0f7; padding:20px 0;" bgcolor="#f3f0f7">
				<div style="max-width:90%; background:#FFF; margin:0 auto; border-radius:20px; padding:15px 20px;">
				<div style="margin-bottom:10px;"><strong>Invoice ID: '.$email_data['invoice_id'].'</strong></div>
				<div style="color:#888; font-size:13px;">'.$email_data['date'].'</div>
				<hr>
			   
				<div style="color:#666; font-size:14px; margin-bottom:15px; margin-top:15px"><strong>Pickup Location:</strong><br>'.$email_data['pickup_location'].'</div>
				<div style="color:#666; font-size:14px;margin-bottom:15px"><strong>Dropoff Location:</strong><br>'.$email_data['drop_location'].'</div> 
				<hr>
				
				<table width="100%" border="0" cellspacing="0" cellpadding="0">
		  <tr>
			<td width="50%" style="padding: 7px 0;">Distance : <strong>'.$email_data['distance'].' km</strong></td>
			<td width="50%" align="right" style="padding: 7px 0;">Time : <strong>'.$email_data['time'].'</strong></td>
		  </tr>
		  
		 
		</table>
		  <hr>
				<div style="margin-bottom:10px; font-weight:bold; font-size:30px; padding:12px 0; background:#26135f; text-align:center; color:#FFF;s "><strong>Total Fare: &#2547;'.$email_data['total_Amount'].'</strong></div>
				<div style="border-bottom:1px solid #CCC">
				<table width="100%" border="0" cellspacing="0" cellpadding="0">
		  <tr>
			<td style="padding: 7px 0;">Trip Fare</td>
			<td style="padding: 7px 0;" align="right"><strong>&#2547; '.$email_data['FinalFare'].'</strong></td>
		  </tr>
		  <tr>
			<td style="padding: 7px 0;">Promotinal Discount</td>
			<td style="padding: 7px 0;" align="right"><strong>&#2547; '.$email_data['promotional_discount'].'</strong></td>
		  </tr>
		  
		  <tr>
			<td style="padding: 7px 0;">Booking Fee</td>
			<td style="padding: 7px 0;" align="right"><strong>&#2547; '.$email_data['Booking_Fee'].'</strong></td>
		  </tr>
		  <tr>
			<td style="padding: 7px 0;">Previous trip\'s cancellation fee</td>
			<td style="padding: 7px 0;" align="right"><strong>&#2547; '.$email_data['p_cancelation'].'</strong></td>
		  </tr>
		   <tr>
			<td style="padding: 7px 0;">Discount</td>
			<td style="padding: 7px 0;" align="right"><strong>-&#2547; '.$email_data['discount'].'</strong></td>
		  </tr>
		  
		 
		</table></div>
		<div style="border-bottom:1px solid #CCC">
				<table width="100%" border="0" cellspacing="0" cellpadding="0">
		  <tr>
			<td style="padding: 15px 0;">Total Fare</td>
			<td style="padding: 15px 0;" align="right"><strong>&#2547; '.$email_data['total_Amount'].'</strong></td>
		  </tr>
		 </table></div>
		 <div>
				<table width="100%" border="0" cellspacing="0" cellpadding="0">
		  <tr>
			<td style="padding: 15px 0;">Paid via</td>
			<td style="padding: 15px 0; vertical-align:middle" valign="middle" align="right"><img src="'.Configure::read('App.siteurl').'taka.png"style="width: 20px;margin-right: 5px;"> <strong>'.$email_data['payment_method'].'</strong></td>
		  </tr>
		 </table></div>
		
				</div>
				</td>
			  </tr>
			  <tr>
				<td style="background:#f3f0f7; padding:0px 0 20px 0;" bgcolor="#f3f0f7">
				<div style="max-width:90%; background:#FFF; margin:0 auto; border-radius:20px; padding:15px 20px;">
				  
				
		
		 <div><table width="100%" border="0" cellspacing="0" cellpadding="0">
		  <tr>
			<td width="19%"><img src="'.$email_data['driver_image'].'" style="border-radius:100%; width:90px"></td>
			<td width="81%" valign="middle"><div style="color:#666; font-size:14px; margin-bottom:15px; margin-top:15px; line-height:25px"><strong style="color:#000">'.$email_data['Driver_name'].'</strong><br>
			<img src="'.Configure::read('App.siteurl').'star.png"style="width: 16px;"> Customer rating: '.$email_data['driver_rating'].'</div> </td>
		  </tr>
		</table>';
		
		$footer = '</div>
		
				</div>
				</td>
			  </tr>
			  <tr>
				<td>&nbsp;</td>
			  </tr>
			  <tr>
				<td align="center" style="text-align:center; padding:5px 0; font-size:13px; color:#666;">Customer Support: <strong>Call us
		+880 1819-050667</strong></td>
			  </tr>
			  <tr>
				<td align="center" style="text-align:center; padding:5px 0; font-size:13px; color:#666;"><strong>Visit us at:</strong> <a href="https://www.google.com/maps/place/35+Rd+-10,+Dhaka+1230,+Bangladesh/@23.8722754,90.4039281,19z/data=!4m6!3m5!1s0x3755c430653773db:0x24cf853345aeb40!8m2!3d23.8721822!4d90.4037162!16s%2Fg%2F11gy5dmvqc?entry=ttu" target="_blank">House-35, Road-10, Sector-6, Uttara, Dhaka.</a></td>
			  </tr>
			</table></td>
		  </tr>
		  <tr>
				<td>&nbsp;</td>
			  </tr>
		</table>
		
		</body>
		</html>'; 
			

			$body = $headder.$content.$footer; 
			// echo $body; die;
			$mailer->Host = 'mail.smtp2go.com';
			$mailer->SMTPAuth = true;
			$mailer->Username = 'info@demo2.evirtualservices.co';
			$mailer->Password = 'Testing@1234567890';
			$mailer->SMTPSecure = 'tls';
			//$mailer->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
			$mailer->Port = "587";
		
			$mailer->setFrom('info@demo2.evirtualservices.co', 'Zarib');
			$mailer->addAddress($to);
			$mailer->isHTML(true);
			$mailer->Subject = $subject;
			$mailer->Body = $body;
			
			$mailer->send();
			$mailer->ClearAllRecipients();
			return true;
	}


	function sendotp($nub=NULL, $msg=NULL){
		$number = ($nub) ? $nub : '01711086791';
		$message = ($msg) ? $msg : "Yes this is good";
		$body_request = '{
			"username": "Pathmark",
			"password": "fK9@f4$1Fcd",
			"apicode": "1",
			"msisdn": ["'.$number.'"],
			"countrycode": "880",
			"cli": "ZARIB",
			"messagetype": "1",
			"message": "'.$message.'",
			"clienttransid": " 1311161161642679986567566",
			"bill_msisdn": "01765099549",
			"tran_type": "P",
			"request_type": "S",
			"rn_code": "71"
		   }';
		   $headers = array(
			"X-Custom-Header: header-value",
			"Content-Type: application/json"
		);
		$url = "https://gpcmp.grameenphone.com/gp/ecmapigw/webresources/ecmapigw.v3";
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $url);
		//curl_setopt($ch, CURLOPT_POST, true);
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $body_request);
		$result = curl_exec($ch);
		return $result;
		//echo "<pre>"; print_r($result); die('APP');
	}

	
	
}