<?php
/**
 * Routes configuration
 *
 * In this file, you set up routes to your controllers and their actions.
 * Routes are very important mechanism that allows you to freely connect
 * different URLs to chosen controllers and their actions (functions).
 *
 * CakePHP(tm) : Rapid Development Framework (http://cakephp.org)
 * Copyright (c) Cake Software Foundation, Inc. (http://cakefoundation.org)
 *
 * Licensed under The MIT License
 * For full copyright and license information, please see the LICENSE.txt
 * Redistributions of files must retain the above copyright notice.
 *
 * @copyright     Copyright (c) Cake Software Foundation, Inc. (http://cakefoundation.org)
 * @link          http://cakephp.org CakePHP(tm) Project
 * @license       http://www.opensource.org/licenses/mit-license.php MIT License
 */

use Cake\Core\Plugin;
use Cake\Routing\Router;

/**
 * The default class to use for all routes
 *
 * The following route classes are supplied with CakePHP and are appropriate
 * to set as the default:
 *
 * - Route
 * - InflectedRoute
 * - DashedRoute
 *
 * If no call is made to `Router::defaultRouteClass()`, the class used is
 * `Route` (`Cake\Routing\Route\Route`)
 *
 * Note that `Route` does not do any inflections on URLs which will result in
 * inconsistently cased URLs when used with `:plugin`, `:controller` and
 * `:action` markers.
 *
 */
 

Router::defaultRouteClass('DashedRoute');

Router::scope('/', function ($routes) {
    /**
     * Here, we are connecting '/' (base path) to a controller called 'Pages',
     * its action called 'display', and we pass a param to select the view file
     * to use (in this case, src/Template/Pages/home.ctp)...
     */
    $routes->connect('/', ['prefix'=> 'admin', 'controller' => 'Admins', 'action' => 'dashboard']);
//    $routes->connect('/about-us', ['controller' => 'Pages', 'action' => 'detail', 'about-us']);
//	
//	$routes->connect('/privacy-policy', ['controller' => 'Pages', 'action' => 'detail', 'privacy-policy']);
//	$routes->connect('/how-it-works', ['controller' => 'Pages', 'action' => 'detail', 'how-it-works']);
//	$routes->connect('/term-and-use', ['controller' => 'Pages', 'action' => 'detail', 'term-and-use']);
//	
//	$routes->connect('/faqs', ['controller' => 'Pages', 'action' => 'faqs']);
//	$routes->connect('/contact', ['controller' => 'Pages', 'action' => 'contact']);
//	$routes->connect('/donate', ['controller' => 'Pages', 'action' => 'donate']);
//	$routes->connect('/testimonials', ['controller' => 'Pages', 'action' => 'testimonials']);
//	
//	$routes->connect('/signup', ['controller' => 'Users', 'action' => 'signup']);
//	$routes->connect('/dashboard', ['controller' => 'Users', 'action' => 'dashboard']);
//	$routes->connect('/editprofile', ['controller' => 'Users', 'action' => 'editprofile']);
//	$routes->connect('/changepassword', ['controller' => 'Users', 'action' => 'changepassword']);
    /**
     * ...and connect the rest of 'Pages' controller's URLs.
     */
    ////$routes->connect('/pages/*', ['controller' => 'Pages', 'action' => 'display']);
    //$routes->connect('/admin/', ['controller' => 'Admins', 'action' => 'login']);

    $routes->connect("/:controller/:action/*");
    
    /**
     * Connect catchall routes for all controllers.
     *
     * Using the argument `DashedRoute`, the `fallbacks` method is a shortcut for
     *    `$routes->connect('/:controller', ['action' => 'index'], ['routeClass' => 'DashedRoute']);`
     *    `$routes->connect('/:controller/:action/*', [], ['routeClass' => 'DashedRoute']);`
     *
     * Any route class can be used with this method, such as:
     * - DashedRoute
     * - InflectedRoute
     * - Route
     * - Or your own route class
     *
     * You can remove these routes once you've connected the
     * routes you want in your application.
     */
    //$routes->fallbacks('DashedRoute');
});





 Router::prefix('admin',function($routes) {
	// Because you are in the admin scope,
	// you do not need to include the /admin prefix
	// or the admin route element.
	$routes->connect('/', ['controller' => 'Admins', 'action' => 'login']);
    $routes->connect('/logout', ['controller' => 'Admins', 'action' => 'logout']);
    $routes->connect('/dashboard', ['controller' => 'Admins', 'action' => 'dashboard']);
    $routes->connect('/index', ['controller' => 'Admins', 'action' => 'index']);
    $routes->connect('/edit', ['controller' => 'Admins', 'action' => 'edit']);
    $routes->connect('/changepassword', ['controller' => 'Admins', 'action' => 'changepassword']);
    $routes->connect('/master', ['controller' => 'Admins', 'action' => 'master']);
    //$routes->connect('/departments/add', ['controller' => 'Departments', 'action' => 'add']);
    //$routes->connect('/departments/index', ['controller' => 'Departments', 'action' => 'index']);
    $routes->connect("/:controller/:action/*");
    
	//$routes->fallbacks('DashedRoute');
	//$routes->fallbacks('DashedRoute');
});
 


 
 
Router::prefix('api',function($routes) {
    $routes->connect("/:controller/:action/*");
});
/**
 * Load all plugin routes.  See the Plugin documentation on
 * how to customize the loading of plugin routes.
 */
Plugin::routes();
