<?php
namespace App\Controller\Admin;
use App\Controller\Admin\Component\ImgComponent;

use App\Controller\Admin\AppController;
use Cake\Event\Event;
use Cake\ORM\TableRegistry;
use Cake\Core\Configure;
use Cake\I18n\Time;
use Cake\View\Helper\TimeHelper;
use Cake\Datasource\ConnectionManager;
/******************************************************************************
*File Name:	 DepartmentsController
*Creation Date: [11-02-2016]
*Modification Date: [11-02-2016]
*Author: [Raushan Suri]
*Author: [Modified By Raushan Suri]
*Description: [This controller consist of function related to Department.]
******************************************************************************/
class NewslettersController extends AppController
{

    public function beforeFilter(Event $event)
    {
        parent::beforeFilter($event);
        $this->Auth->allow(['showprofile']);
    }

    
    /********************************************************************************
	Function Name: index
	*Type: Public function used as action of the controller
	*Input: No input
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to view all member list and search.
	*********************************************************************************/
    public function index($id=null)
    {
        $layoutTitle = 'Freedom Giving :: Manage Newsletter';
        $this->set(compact('layoutTitle'));
        $this->viewBuilder()->layout('Admin/admin');
        $limit = 30;//Configure::read('App.adminPageLimit');
        
        $this->paginate = [
            'limit' => $limit,
            'order' => [
                'Newsletters.created' => 'DESC'
            ],
        ];        
        $keyword = $this->request->query('keyword');
		$condition = [];
        if($keyword != ''){
			$condition = [
				'OR' => [
					["Newsletters.email LIKE '%".$keyword."%'"],
				]				
			];
		}        
        $query = $this->Newsletters->find('all')->where($condition);       
        $newsletters = $this->paginate($query);
        $newsletters = $newsletters->toArray();
		//pr($newsletters);die;
        $this->set(compact('newsletters', 'limit'));
    }

      
    /********************************************************************************
	Function Name: add
	*Type: Public function used as action of the controller
	*Input: No input
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to add hours.
	*********************************************************************************/
    public function add()
    {
        $layoutTitle = 'Freedom Giving ::  Add New Newsletter';
        $this->set(compact('layoutTitle'));
        $this->viewBuilder()->layout('Admin/admin');
		
		
        $newsletters = $this->Newsletters->newEntity();        
       
        if ($this->request->is('post')) {
			$newsletters = $this->Newsletters->patchEntity($newsletters, $this->request->data, ['validate' => 'customer']);            
			$newsletters['created'] = date('Y-m-d H:i:s');
			
			if ($this->Newsletters->save($newsletters)) {
				$this->Flash->success(__('Newsletter added successfully.'));
				return $this->redirect(['action' => 'index']);	
			}else{
				//pr($users);die;
				$this->Flash->error(__('Unable to add new feature, Please try again later.'));
			}
		}
        $this->set(compact('newsletters'));
    }
    
    
    
    
    /********************************************************************************
	Function Name: edit
	*Type: Public function used as action of the controller
	*Input: Member id
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to edit hours.
	*********************************************************************************/
    public function edit($id)
    {
        $layoutTitle = 'Freedom Giving :: Edit Newsletter';
        $this->set(compact('layoutTitle'));
        $this->viewBuilder()->layout('Admin/admin');
        
        $newsletters = $this->Newsletters->find()->where(['Newsletters.id' => $id])->first();//fields name in contain[] with coma
        if ($this->request->is(['patch', 'post', 'put'])) {
			
			$featureimage = $this->request->data['featureimage'];
			unset($this->request->data['featureimage']);
            if(!empty($featureimage['name'])){
				$old_data = $this->Newsletters->get($id);
				$filename = time() . $featureimage['name'];
				$this->request->data['image'] = $filename;
			}
			$newsletters = $this->Newsletters->patchEntity($newsletters, $this->request->data, ['validate' => 'customer']);
			
			if(!empty($filename)){				
				$oldfilename = $old_data->image;
			}
			$path = WWW_ROOT . 'img/uploads/feature/original/';
			if ($this->Newsletters->save($newsletters)) {
				$this->Flash->success(__('The member updated successfully.'));
                return $this->redirect(['action' => 'index']);
			} else {
				$users['profile_picture'] = $old_data->profile_picture;
				$this->Flash->error(__('Member information could not be saved. Please try again later.'));
			}
        }
        $this->set(compact('newsletters'));
    }
    
    
    /********************************************************************************
	Function Name: delete
	*Type: Public function used as action of the controller
	*Input: Member id
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to delete hours permanently.
	*********************************************************************************/
    public function delete($id = null)
    {
        $users = $this->Newsletters->get($id);
        if ($this->Newsletters->delete($users)) {
            $this->Flash->success(__('Hour has been deleted.'));
        } else {
            $this->Flash->error(__('Hour could not be deleted. Please, try again.'));
        }
        return $this->redirect(['controller' => 'Newsletters', 'action' => 'index']);
    }
    
    
    /********************************************************************************
	Function Name: status
	*Type: Public function used as action of the controller
	*Input: Member id
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to update hours status.
	*********************************************************************************/
    public function status($id){
		$users = $this->Newsletters->get($id);
		$status = '1';
		$msg = 'activated';
		if($users->status == '1'){
			$status = '0';
			$msg = 'deactivated';
		}
		
		$articles = TableRegistry::get('Newsletters');
		$query = $articles->query();
		$query->update()
			->set(['status' => $status])
			->where(['id' => $id])
			->execute();
		$this->Flash->success(__('Member has been '.$msg.' successfully.'));
		return $this->redirect(['controller' => 'Newsletters', 'action' => 'index']);
	}
    
    
    /********************************************************************************
	Function Name: details
	*Type: Public function used as action of the controller
	*Input: Member id
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to view hours information.
	*********************************************************************************/
    public function details($id){
        $layoutTitle = 'Freedom Giving ::  Member Details';
        $this->set(compact('layoutTitle'));
        $this->viewBuilder()->layout('Admin/admin');        
		$users = $this->Newsletters->find()->where(['Newsletters.id' => $id])->first();
        if(!empty($users)){
            $this->set(compact('users'));
        }else{
            $this->Flash->error(__('Member doesnot exist.'));
            return $this->redirect(['controller' => 'Newsletters', 'action' => 'index']);
        }
	}
	
	/********************************************************************************
	Function Name: generateTTCode
	*Type: Public function used as action of the controller
	*Input: No input
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to return autogenerate ttcode.
	*********************************************************************************/
     public function generateECode(){
		//$this->autoRender = false;
		$digit = str_pad(rand ( 1 , 999999 ), 6, 0, STR_PAD_LEFT);
		
		/*
		$alphabet = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
		$pass = array(); //remember to declare $pass as an array
		$alphaLength = strlen($alphabet) - 1; //put the length -1 in cache
		for ($i = 0; $i < 2; $i++) {
			$n = rand(0, $alphaLength);
			$pass[] = $alphabet[$n];
		}
		$ttcode = implode($pass).$digit;
		*/
		$ttcode = 'Freedom Giving-'.$digit;
		$this->loadModel('Newsletters');
		$users = $this->Newsletters->find('all')->where(['Newsletters.eCode' => $ttcode]);
		$user = $users->toArray();
		if(count($user) == '0'){
			return $ttcode;
		}else{
			$this->generateECode();
		}
	}
}
