<?php
namespace App\Controller\Admin;
use App\Controller\Admin\Component\ImgComponent;

use App\Controller\Admin\AppController;
use Cake\Event\Event;
use Cake\ORM\TableRegistry;
use Cake\Core\Configure;
use Cake\I18n\Time;
use Cake\View\Helper\TimeHelper;
use Cake\Datasource\ConnectionManager;
/******************************************************************************
*File Name:	 Controller
*Creation Date: [11-02-2016]
*Modification Date: [11-02-2016]
*Author: [Raushan Suri]
*Author: [Modified By Raushan Suri]
*Description: [This controller consist of function related to Department.]
******************************************************************************/
class EmergenciesController extends AppController
{

    public function beforeFilter(Event $event)
    {
        parent::beforeFilter($event);
        $this->Auth->allow(['showprofile']);
    }

    
    /********************************************************************************
	Function Name: index
	*Type: Public function used as action of the controller
	*Input: No input
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to view all member list and search.
	*********************************************************************************/
    public function index($id=null)
    {
        $layoutTitle = 'zarib :: Manage Emergencie';
        $this->set(compact('layoutTitle'));
        $this->viewBuilder()->layout('Admin/admin');
        $limit = 30;//Configure::read('App.adminPageLimit');
        
        $this->paginate = [
            'limit' => $limit,
            'order' => ['Emergencies.created' => 'DESC'],
			'contain'=>['Users']
        ];        
        $keyword = $this->request->query('keyword');
		$condition[] = ['Emergencies.id >'=>0];
        if($keyword != ''){
			$condition[] = [
				'OR' => [
					["Emergencies.name LIKE"=>$keyword."%"],
					["Emergencies.phone LIKE"=>$keyword."%"],
					["Emergencies.email LIKE"=>$keyword."%"],
				]				
			];
		}        
        $query = $this->Emergencies->find('all')->where($condition);       
        $emergencies = $this->paginate($query);
        $emergencies = $emergencies->toArray();
		//pr($emergencies);die;
        $this->set(compact('emergencies', 'limit'));
    }

      
    /********************************************************************************
	Function Name: add
	*Type: Public function used as action of the controller
	*Input: No input
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to add hours.
	*********************************************************************************/
    public function add()
    {
        $layoutTitle = 'zarib ::  Add New Emergencie';
        $this->set(compact('layoutTitle'));
        $this->viewBuilder()->layout('Admin/admin');
		
		
        $emergencies = $this->Emergencies->newEntity();        
       
        if ($this->request->is('post')) {
            
			$emergencies = $this->Emergencies->patchEntity($emergencies, $this->request->data, ['validate' => 'customer']);            
			$emergencies['created'] = date('Y-m-d H:i:s');
			//$path = WWW_ROOT . 'img/uploads/feature/original/';
			if ($this->Emergencies->save($emergencies)) {
				$this->Flash->success(__('Emergencie added successfully.'));
				return $this->redirect(['action' => 'index']);	
			}else{
				//pr($users);die;
				$this->Flash->error(__('Unable to add new emergencie, Please try again later.'));
			}
		}
        $this->set(compact('emergencies','client_list'));
    }
    
    
    
    
    /********************************************************************************
	Function Name: edit
	*Type: Public function used as action of the controller
	*Input: Member id
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to edit hours.
	*********************************************************************************/
    public function edit($id)
    {
        $layoutTitle = 'zarib :: Edit Emergencie';
        $this->set(compact('layoutTitle'));
        $this->viewBuilder()->layout('Admin/admin');
        
        $emergencies = $this->Emergencies->find()->where(['Emergencies.id' => $id])->first();//fields name in contain[] with coma
        if ($this->request->is(['patch', 'post', 'put'])) {
			
			
			$emergencies = $this->Emergencies->patchEntity($emergencies, $this->request->data, ['validate' => 'customer']);
			
			
			$path = WWW_ROOT . 'img/uploads/feature/original/';
			if ($this->Emergencies->save($emergencies)) {
				
				$this->Flash->success(__('The emergencie updated successfully.'));
                return $this->redirect(['action' => 'index']);
			} else {
				
				$this->Flash->error(__('Emergencie information could not be saved. Please try again later.'));
			}
        }
        $this->set(compact('emergencies'));
    }
    
    
    /********************************************************************************
	Function Name: delete
	*Type: Public function used as action of the controller
	*Input: Member id
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to delete hours permanently.
	*********************************************************************************/
    public function delete($id = null)
    {
        $users = $this->Emergencies->get($id);
        if ($this->Emergencies->delete($users)) {
            $this->Flash->success(__('Emergencie has been deleted.'));
        } else {
            $this->Flash->error(__('Emergencie could not be deleted. Please, try again.'));
        }
        return $this->redirect(['controller' => 'Emergencies', 'action' => 'index']);
    }
    
    
    /********************************************************************************
	Function Name: status
	*Type: Public function used as action of the controller
	*Input: Member id
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to update hours status.
	*********************************************************************************/
    public function status($id){
		$users = $this->Emergencies->get($id);
		$status = '1';
		$msg = 'activated';
		if($users->status == '1'){
			$status = '0';
			$msg = 'deactivated';
		}
		
		$articles = TableRegistry::get('Emergencies');
		$query = $articles->query();
		$query->update()
			->set(['status' => $status])
			->where(['id' => $id])
			->execute();
		$this->Flash->success(__('Emergencie has been '.$msg.' successfully.'));
		return $this->redirect(['controller' => 'Emergencies', 'action' => 'index']);
	}
    
    
    /********************************************************************************
	Function Name: details
	*Type: Public function used as action of the controller
	*Input: Member id
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to view hours information.
	*********************************************************************************/
    public function details($id){
        $layoutTitle = 'zarib ::  Member Details';
        $this->set(compact('layoutTitle'));
        $this->viewBuilder()->layout('Admin/admin');        
		$users = $this->Emergencies->find()->where(['Emergencies.id' => $id])->first();
        if(!empty($users)){
            $this->set(compact('users'));
        }else{
            $this->Flash->error(__('Member doesnot exist.'));
            return $this->redirect(['controller' => 'Emergencies', 'action' => 'index']);
        }
	}
	
	
}