<?php
namespace App\Controller\Admin;
use App\Controller\Admin\Component\ImgComponent;

use App\Controller\Admin\AppController;
use Cake\Event\Event;
use Cake\ORM\TableRegistry;
use Cake\Core\Configure;
use Cake\I18n\Time;
use Cake\View\Helper\TimeHelper;
use Cake\Datasource\ConnectionManager;
/******************************************************************************
*File Name:	 Controller
*Creation Date: [11-02-2016]
*Modification Date: [11-02-2016]
*Author: [Raushan Suri]
*Author: [Modified By Raushan Suri]
*Description: [This controller consist of function related to Department.]
******************************************************************************/
class ContactsController extends AppController
{

    public function beforeFilter(Event $event)
    {
        parent::beforeFilter($event);
        $this->Auth->allow(['showprofile']);
    }

    
    /********************************************************************************
	Function Name: index
	*Type: Public function used as action of the controller
	*Input: No input
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to view all member list and search.
	*********************************************************************************/
    public function index($id=null)
    {
        $layoutTitle = 'Path Mark :: Manage Contact';
        $this->set(compact('layoutTitle'));
        $this->viewBuilder()->layout('Admin/admin');
        $limit = 30;//Configure::read('App.adminPageLimit');
        
        $this->paginate = [
            'limit' => $limit,
            'order' => [
                'Contacts.created' => 'DESC'
            ],
        ];        
        $keyword = $this->request->query('keyword');
		$condition = [];
        if($keyword != ''){
			$condition = [
				'OR' => [
					["Contacts.name LIKE '%".$keyword."%'"],
					["Contacts.designation LIKE '%".$keyword."%'"],
					["Contacts.text LIKE '%".$keyword."%'"]
				]				
			];
		}        
        $query = $this->Contacts->find('all')->where($condition);       
        $contacts = $this->paginate($query);
        $contacts = $contacts->toArray();
		//pr($contacts);die;
        $this->set(compact('contacts', 'limit'));
    }

      
    /********************************************************************************
	Function Name: add
	*Type: Public function used as action of the controller
	*Input: No input
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to add hours.
	*********************************************************************************/
    public function add()
    {
        $layoutTitle = 'Path Mark ::  Add New Contact';
        $this->set(compact('layoutTitle'));
        $this->viewBuilder()->layout('Admin/admin');
		
		
        $contacts = $this->Contacts->newEntity();        
       
        if ($this->request->is('post')) {
             $featureimage = $this->request->data['featureimage'];
			unset($this->request->data['featureimage']);
            if(!empty($featureimage['name'])){
				$filename = time() . $featureimage['name'];
				$this->request->data['image'] = $filename;
			}
			$contacts = $this->Contacts->patchEntity($contacts, $this->request->data, ['validate' => 'customer']);            
			$contacts['created'] = date('Y-m-d H:i:s');
			$path = WWW_ROOT . 'img/uploads/feature/original/';
			if ($this->Contacts->save($contacts)) {
				move_uploaded_file($featureimage['tmp_name'], $path.$filename);
                    $MyImageCom = new ImgComponent();
                    $MyImageCom->prepare("img/uploads/feature/original/".$filename);
                    $MyImageCom->resize(230,200);
                    $MyImageCom->save("img/uploads/feature/thumb/".$filename);
				$this->Flash->success(__('Contact added successfully.'));
				return $this->redirect(['action' => 'index']);	
			}else{
				//pr($users);die;
				$this->Flash->error(__('Unable to add new feature, Please try again later.'));
			}
		}
        $this->set(compact('contacts','client_list'));
    }
    
    
    
    
    /********************************************************************************
	Function Name: edit
	*Type: Public function used as action of the controller
	*Input: Member id
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to edit hours.
	*********************************************************************************/
    public function edit($id)
    {
        $layoutTitle = 'Path Mark :: Edit Contact';
        $this->set(compact('layoutTitle'));
        $this->viewBuilder()->layout('Admin/admin');
        
        $contacts = $this->Contacts->find()->where(['Contacts.id' => $id])->first();//fields name in contain[] with coma
        if ($this->request->is(['patch', 'post', 'put'])) {
			
			$featureimage = $this->request->data['featureimage'];
			unset($this->request->data['featureimage']);
            if(!empty($featureimage['name'])){
				$old_data = $this->Contacts->get($id);
				$filename = time() . $featureimage['name'];
				$this->request->data['image'] = $filename;
			}
			$contacts = $this->Contacts->patchEntity($contacts, $this->request->data, ['validate' => 'customer']);
			
			if(!empty($filename)){				
				$oldfilename = $old_data->image;
			}
			$path = WWW_ROOT . 'img/uploads/feature/original/';
			if ($this->Contacts->save($contacts)) {
				if (!empty($featureimage) && $featureimage['name'] != '') {	
                    @unlink(WWW_ROOT . 'img/uploads/feature/original/'.$oldfilename);
                    @unlink(WWW_ROOT . 'img/uploads/feature/thumb/'.$oldfilename);
                    move_uploaded_file($featureimage['tmp_name'], $path.$filename);
                    $MyImageCom = new ImgComponent();
                    $MyImageCom->prepare("img/uploads/feature/original/".$filename);
                    $MyImageCom->resize(230,200);
                    $MyImageCom->save("img/uploads/feature/thumb/".$filename);	
				}
				$this->Flash->success(__('The member updated successfully.'));
                return $this->redirect(['action' => 'index']);
			} else {
				$users['profile_picture'] = $old_data->profile_picture;
				$this->Flash->error(__('Member information could not be saved. Please try again later.'));
			}
        }
        $this->set(compact('features'));
    }
    
    
    /********************************************************************************
	Function Name: delete
	*Type: Public function used as action of the controller
	*Input: Member id
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to delete hours permanently.
	*********************************************************************************/
    public function delete($id = null)
    {
        $users = $this->Contacts->get($id);
        if ($this->Contacts->delete($users)) {
            $this->Flash->success(__('Hour has been deleted.'));
        } else {
            $this->Flash->error(__('Hour could not be deleted. Please, try again.'));
        }
        return $this->redirect(['controller' => 'Contacts', 'action' => 'index']);
    }
    
    
    /********************************************************************************
	Function Name: status
	*Type: Public function used as action of the controller
	*Input: Member id
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to update hours status.
	*********************************************************************************/
    public function status($id){
		$users = $this->Contacts->get($id);
		$status = '1';
		$msg = 'activated';
		if($users->status == '1'){
			$status = '0';
			$msg = 'deactivated';
		}
		
		$articles = TableRegistry::get('Contacts');
		$query = $articles->query();
		$query->update()
			->set(['status' => $status])
			->where(['id' => $id])
			->execute();
		$this->Flash->success(__('Member has been '.$msg.' successfully.'));
		return $this->redirect(['controller' => 'Contacts', 'action' => 'index']);
	}
    
    
    /********************************************************************************
	Function Name: details
	*Type: Public function used as action of the controller
	*Input: Member id
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to view hours information.
	*********************************************************************************/
    public function details($id){
        $layoutTitle = 'Path Mark ::  Member Details';
        $this->set(compact('layoutTitle'));
        $this->viewBuilder()->layout('Admin/admin');        
		$users = $this->Contacts->find()->where(['Contacts.id' => $id])->first();
        if(!empty($users)){
            $this->set(compact('users'));
        }else{
            $this->Flash->error(__('Member doesnot exist.'));
            return $this->redirect(['controller' => 'Contacts', 'action' => 'index']);
        }
	}
	
	/********************************************************************************
	Function Name: conversation
	*Type: Public function used as action of the controller
	*Input: No input
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to return autogenerate ttcode.
	*********************************************************************************/
     public function conversation($id=NULL){
		$layoutTitle = 'Path Mark ::  Conversation';
        
        $this->viewBuilder()->layout('Admin/admin');
		if($id==''){
            $this->Flash->error(__('Conversation doesnot exist.'));
            return $this->redirect(['controller' => 'Contacts', 'action' => 'index']);
        }
		$this->loadmodel('Conversations');
		$conversations = $this->Conversations->newEntity();        
       
        if ($this->request->is('post')) {
             
			$conversations = $this->Conversations->patchEntity($conversations, $this->request->data, ['validate' => 'customer']);            
			$conversations['created'] = date('Y-m-d H:i:s');
			if ($this->Conversations->save($conversations)) {
				$this->Flash->success(__('Contact added successfully.'));
				return $this->redirect(['action' => 'conversation', $this->request->data('contactId')]);	
			}else{
				//pr($users);die;
				$this->Flash->error(__('Unable to add new feature, Please try again later.'));
			}
		}
		$contacts = $this->Contacts->find()->where(['Contacts.id' => $id])->first();
		$contactsConver = $this->Conversations->find()->where(['Conversations.contactId' => $id])->order(['Conversations.id'=>'DESC']);
        $this->set(compact('layoutTitle', 'contacts', 'conversations', 'contactsConver'));
		//echo "<pre>"; print_r($conversations); die('dsf');
	}
}
