<?php
namespace App\Controller\Admin;
use App\Controller\Admin\Component\ImgComponent;

use App\Controller\Admin\AppController;
use Cake\Event\Event;
use Cake\ORM\TableRegistry;
use Cake\Core\Configure;
use Cake\I18n\Time;
use Cake\View\Helper\TimeHelper;
use Cake\Datasource\ConnectionManager;
/******************************************************************************
*File Name:	 Controller
*Creation Date: [11-02-2016]
*Modification Date: [11-02-2016]
*Author: [Raushan Suri]
*Author: [Modified By Raushan Suri]
*Description: [This controller consist of function related to Department.]
******************************************************************************/
class CarinformationsController extends AppController
{

    public function beforeFilter(Event $event)
    {
        parent::beforeFilter($event);
        $this->Auth->allow(['showprofile']);
    }

    
    /********************************************************************************
	Function Name: index
	*Type: Public function used as action of the controller
	*Input: No input
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to view all member list and search.
	*********************************************************************************/
    public function index($id=null)
    {
        $layoutTitle = 'Path Mark :: Manage Car Information';
        $this->set(compact('layoutTitle'));
        $this->viewBuilder()->layout('Admin/admin');
        $limit = 30;//Configure::read('App.adminPageLimit');
        
        $this->paginate = [
            'limit' => $limit,
            'order' => ['Carinformations.created' => 'DESC'],
			'contain'=> ['Users','Categories']
        ];        
        $keyword = $this->request->query('keyword');
		if($id !=''){
			$condition[] = ['Carinformations.userId'=>$id];
		}
		$condition[] = ['Carinformations.id >'=>0];
        if($keyword != ''){
			$condition[] = [
				'OR' => [
					["Carinformations.carNumber LIKE '%".$keyword."%'"],
					["Carinformations.carModel LIKE '%".$keyword."%'"],
					["Carinformations.carYear LIKE '%".$keyword."%'"],
					["Carinformations.carColor LIKE '%".$keyword."%'"],
					["Carinformations.carBrand LIKE '%".$keyword."%'"],
					["Carinformations.carInsuranceNo LIKE '%".$keyword."%'"],
					["Carinformations.vehiclePermitNo LIKE '%".$keyword."%'"],
					["Carinformations.CarRegistrationNo LIKE '%".$keyword."%'"],
					["Carinformations.policeholder LIKE '%".$keyword."%'"],
					["Users.fullName LIKE '%".$keyword."%'"],
					["Users.email LIKE '%".$keyword."%'"],
					["Categories.name LIKE '%".$keyword."%'"],
				]				
			];
		}        
        $query = $this->Carinformations->find('all')->where($condition);       
        $carinformations = $this->paginate($query);
        $carinformations = $carinformations->toArray();
		//pr($carinformations);die;
        $this->set(compact('carinformations', 'limit'));
    }

      
    /********************************************************************************
	Function Name: add
	*Type: Public function used as action of the controller
	*Input: No input
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to add hours.
	*********************************************************************************/
    public function add()
    {
        $layoutTitle = 'Path Mark ::  Add New Carinformation';
        $this->set(compact('layoutTitle'));
        $this->viewBuilder()->layout('Admin/admin');
		$this->loadModel('Categories');
		$categoryList = $this->Categories->find('list', ['keyField' => 'id', 'valueField' => ['name']])->where(['Categories.status'=>1])->order(['Categories.name'=>'ASC'])->toArray();
		$this->loadModel('Users');
		$DriverL = $this->Users->find('list', ['keyField' => 'id', 'valueField' => ['fullName','email']])->where(['Users.role'=>'Driver'])->order(['Users.fullName'=>'ASC'])->toArray();
		$DriverList = str_replace(";", " - ", $DriverL);
        $carinformations = $this->Carinformations->newEntity();        
        if ($this->request->is('post')) {
            $filename1 = ''; $filename2=''; $filename3='';
			if(!empty($this->request->data['carImage_1'])){
				$filename1 = time() .'_'. $this->request->data['carImage_1']['name'];
				$this->request->data['carImage'] = $filename1;
			}
			if(!empty($this->request->data['carImage_2'])){
				$filename2 = time() .'_'. $this->request->data['carImage_2']['name'];
				$this->request->data['carInsuranceImage'] = $filename2;
			}
			if(!empty($this->request->data['carImage_3'])){
				$filename3 = time() .'_'. $this->request->data['carImage_3']['name'];
				$this->request->data['vehiclePermitImage'] = $filename3;
			}
			
			$carinformations = $this->Carinformations->patchEntity($carinformations, $this->request->data, ['validate' => 'customer']);            
			$carinformations['created'] = date('Y-m-d H:i:s');
			$carinformations['insurenceissueDate'] = ($this->request->data['insurenceissueDate']) ? date('Y-m-d',strtotime($this->request->data['insurenceissueDate'])) : '';
			$carinformations['expDate'] = ($this->request->data['expDate']) ? date('Y-m-d',strtotime($this->request->data['expDate'])) : '';
			$carinformations['vehiclePermitIsssuesDate'] = ($this->request->data['vehiclePermitIsssuesDate']) ? date('Y-m-d',strtotime($this->request->data['vehiclePermitIsssuesDate'])) : '';
			$carinformations['vehiclePermitIsssuesExpDate'] = ($this->request->data['vehiclePermitIsssuesExpDate']) ? date('Y-m-d',strtotime($this->request->data['vehiclePermitIsssuesExpDate'])) : '';
			//$path = WWW_ROOT . 'img/uploads/feature/original/';
			if ($this->Carinformations->save($carinformations)) {
				if($filename1 != '' && $this->request->data['carImage_1']['error'] == 0) {
					$path = WWW_ROOT . 'img/uploads/cars/';	                    
					move_uploaded_file($this->request->data['carImage_1']['tmp_name'], $path.$filename1);
					@chmod($path.$filename1, 0777);
				}
				if($filename2 != '' && $this->request->data['carImage_2']['error'] == 0) {
					$path = WWW_ROOT . 'img/uploads/cars/';	                    
					move_uploaded_file($this->request->data['carImage_2']['tmp_name'], $path.$filename2);
					@chmod($path.$filename2, 0777);
				}
				if($filename3 != '' && $this->request->data['carImage_3']['error'] == 0) {
					$path = WWW_ROOT . 'img/uploads/cars/';	                    
					move_uploaded_file($this->request->data['carImage_3']['tmp_name'], $path.$filename3);
					@chmod($path.$filename3, 0777);
				}
				
				//$usersD = $this->Users->find()->where(['Users.id'=>$carinformations->userId])->first();
				//$articles = TableRegistry::get('Users');
				//$query = $articles->query();
				//$query->update()
				//	->set(['AVGRating' =>$AVGR])
				//	->where(['id' => $this->request->data['reviewTo']])
				//	->execute();
				
				$this->Flash->success(__('Carinformation added successfully.'));
				return $this->redirect(['action' => 'index']);	
			}else{
				//pr($users);die;
				$this->Flash->error(__('Unable to add new carinformation, Please try again later.'));
			}
		}
        $this->set(compact('carinformations','categoryList','DriverList'));
    }
    
    
    
    
    /********************************************************************************
	Function Name: edit
	*Type: Public function used as action of the controller
	*Input: Member id
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to edit hours.
	*********************************************************************************/
    public function edit($id)
    {
        $layoutTitle = 'Path Mark :: Edit Carinformation';
        $this->set(compact('layoutTitle'));
        $this->viewBuilder()->layout('Admin/admin');
        $this->loadModel('Categories');
		$categoryList = $this->Categories->find('list', ['keyField' => 'id', 'valueField' => ['name']])->where(['Categories.status'=>1])->order(['Categories.name'=>'ASC'])->toArray();
		$this->loadModel('Users');
		$DriverL = $this->Users->find('list', ['keyField' => 'id', 'valueField' => ['fullName','email']])->where(['Users.role'=>'Driver'])->order(['Users.fullName'=>'ASC'])->toArray();
		$DriverList = str_replace(";", " - ", $DriverL);
		
        $carinformations = $this->Carinformations->find()->where(['Carinformations.id' => $id])->first();//fields name in contain[] with coma
        if ($this->request->is(['patch', 'post', 'put'])) {
			$filename1 = ''; $filename2=''; $filename3='';
			if(!empty($this->request->data['carImage_1'])){
				$filename1 = time() .'_'. $this->request->data['carImage_1']['name'];
				$this->request->data['carImage'] = $filename1;
			}
			if(!empty($this->request->data['carImage_2'])){
				$filename2 = time() .'_'. $this->request->data['carImage_2']['name'];
				$this->request->data['carInsuranceImage'] = $filename2;
			}
			if(!empty($this->request->data['carImage_3'])){
				$filename3 = time() .'_'. $this->request->data['carImage_3']['name'];
				$this->request->data['vehiclePermitImage'] = $filename3;
			}
			
			$carinformations = $this->Carinformations->patchEntity($carinformations, $this->request->data, ['validate' => 'customer']);
			$carinformations['insurenceissueDate'] = ($this->request->data['insurenceissueDate']) ? date('Y-m-d',strtotime($this->request->data['insurenceissueDate'])) : date('Y-m-d',strtotime($carinformations->insurenceissueDate));
			$carinformations['expDate'] = ($this->request->data['expDate']) ? date('Y-m-d',strtotime($this->request->data['expDate'])) : date('Y-m-d',strtotime($carinformations->expDate));
			$carinformations['vehiclePermitIsssuesDate'] = ($this->request->data['vehiclePermitIsssuesDate']) ? date('Y-m-d',strtotime($this->request->data['vehiclePermitIsssuesDate'])) : date('Y-m-d H',strtotime($carinformations->vehiclePermitIsssuesDate));
			$carinformations['vehiclePermitIsssuesExpDate'] = ($this->request->data['vehiclePermitIsssuesExpDate']) ? date('Y-m-d',strtotime($this->request->data['vehiclePermitIsssuesExpDate'])) : date('Y-m-d',strtotime($carinformations->vehiclePermitIsssuesExpDate));
			$path = WWW_ROOT . 'img/uploads/feature/original/';
			if ($this->Carinformations->save($carinformations)) {
				if($filename1 != '' && $this->request->data['carImage_1']['error'] == 0) {
					$path = WWW_ROOT . 'img/uploads/cars/';	                    
					move_uploaded_file($this->request->data['carImage_1']['tmp_name'], $path.$filename1);
					@chmod($path.$filename1, 0777);
				}
				if($filename2 != '' && $this->request->data['carImage_2']['error'] == 0) {
					$path = WWW_ROOT . 'img/uploads/cars/';	                    
					move_uploaded_file($this->request->data['carImage_2']['tmp_name'], $path.$filename2);
					@chmod($path.$filename2, 0777);
				}
				if($filename3 != '' && $this->request->data['carImage_3']['error'] == 0) {
					$path = WWW_ROOT . 'img/uploads/cars/';	                    
					move_uploaded_file($this->request->data['carImage_3']['tmp_name'], $path.$filename3);
					@chmod($path.$filename3, 0777);
				}
				$this->Flash->success(__('The carinformation updated successfully.'));
                return $this->redirect(['action' => 'index']);
			} else {
				
				$this->Flash->error(__('Carinformation information could not be saved. Please try again later.'));
			}
        }
        $this->set(compact('carinformations','categoryList','DriverList'));
    }
    
    
    /********************************************************************************
	Function Name: delete
	*Type: Public function used as action of the controller
	*Input: Member id
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to delete hours permanently.
	*********************************************************************************/
    public function delete($id = null)
    {
        $users = $this->Carinformations->get($id);
        if ($this->Carinformations->delete($users)) {
            $this->Flash->success(__('Carinformation has been deleted.'));
        } else {
            $this->Flash->error(__('Carinformation could not be deleted. Please, try again.'));
        }
        return $this->redirect(['controller' => 'Carinformations', 'action' => 'index']);
    }
    
    
    /********************************************************************************
	Function Name: status
	*Type: Public function used as action of the controller
	*Input: Member id
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to update hours status.
	*********************************************************************************/
    public function status($id){
		$users = $this->Carinformations->get($id);
		$status = '1';
		$msg = 'activated';
		if($users->status == '1'){
			$status = '0';
			$msg = 'deactivated';
		}
		
		$articles = TableRegistry::get('Carinformations');
		$query = $articles->query();
		$query->update()
			->set(['status' => $status])
			->where(['id' => $id])
			->execute();
		$this->Flash->success(__('Carinformation has been '.$msg.' successfully.'));
		return $this->redirect(['controller' => 'Carinformations', 'action' => 'index']);
	}


	public function updateinfo($id){
		$users = $this->Carinformations->get($id);
		$status = '1';
		$msg = 'Approved';
		if($users->update_admin_approve == '1'){
			$status = '2';
			$msg = 'Not Approved';
		}
		
		$articles = TableRegistry::get('Carinformations');
		$query = $articles->query();
		$query->update()
			->set(['update_admin_approve' => $status])
			->where(['id' => $id])
			->execute();
		$this->Flash->success(__('Carinformation has been '.$msg.' successfully.'));
		return $this->redirect(['controller' => 'Carinformations', 'action' => 'index']);
	}
    
    
    /********************************************************************************
	Function Name: details
	*Type: Public function used as action of the controller
	*Input: Member id
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to view hours information.
	*********************************************************************************/
    public function details($id){
        $layoutTitle = 'Path Mark ::  Member Details';
        $this->set(compact('layoutTitle'));
        $this->viewBuilder()->layout('Admin/admin');        
		$users = $this->Carinformations->find()->where(['Carinformations.id' => $id])->contain(['Users','Categories'])->first();
        if(!empty($users)){
            $this->set(compact('users'));
        }else{
            $this->Flash->error(__('Member doesnot exist.'));
            return $this->redirect(['controller' => 'Carinformations', 'action' => 'index']);
        }
	}
	
	
}