<?php
/**
 * CakePHP(tm) : Rapid Development Framework (http://cakephp.org)
 * Copyright (c) Cake Software Foundation, Inc. (http://cakefoundation.org)
 *
 * Licensed under The MIT License
 * For full copyright and license information, please see the LICENSE.txt
 * Redistributions of files must retain the above copyright notice.
 *
 * @copyright Copyright (c) Cake Software Foundation, Inc. (http://cakefoundation.org)
 * @link      http://cakephp.org CakePHP(tm) Project
 * @since     0.2.9
 * @license   http://www.opensource.org/licenses/mit-license.php MIT License
 */
namespace App\Controller\Admin;

use Cake\Core\Configure;
use Cake\Network\Exception\NotFoundException;
use Cake\View\Exception\MissingTemplateException;

use App\Controller\Admin\AppController;
use Cake\Event\Event;
use Cake\ORM\TableRegistry;
/**
 * Static content controller
 *
 * This controller will render views from Template/Pages/
 *
 * @link http://book.cakephp.org/3.0/en/controllers/pages-controller.html
 */
class PagesController extends AppController
{

    /********************************************************************************
	Function Name: index
	*Type: Public function used as action of the controller
	*Input: No input
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to view all page list and search.
	*********************************************************************************/
    public function index()
    {
        $layoutTitle = 'Page';
        $this->set(compact('layoutTitle'));
        $this->viewBuilder()->layout('Admin/admin');
        $this->paginate = [
            'limit' => 25,
		    'order' => ['Pages.created' => 'desc']
		];
		$keyword = $this->request->query('keyword');
		$condition[] = ['Pages.id >'=>0];
        if($keyword != ''){
			$condition[] = [
				'OR' => [
					["Pages.page_title LIKE '%".$keyword."%'"],
				]				
			];
		}        
        
		$query = $this->Pages->find('all')->where($condition);       
        $pages = $this->paginate($query);
        $this->set('pages', $pages);
    }

    
    /********************************************************************************
	Function Name: add
	*Type: Public function used as action of the controller
	*Input: No input
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to add new entry in page.
	*********************************************************************************/
    public function add()
    {
        $layoutTitle = 'Page-add';
        $this->set(compact('layoutTitle'));
        $this->viewBuilder()->layout('Admin/admin');
        $user = $this->Pages->newEntity();
        if ($this->request->is('post')) {
            $this->request->data['created'] = date('Y-m-d H:i:s');
            $user = $this->Pages->patchEntity($user, $this->request->data);
            if ($this->Pages->save($user)) {
                $this->Flash->success(__('The Page has been saved.'));
                return $this->redirect(['action' => 'add']);
            }
            $this->Flash->error(__('Unable to add the page.'));
        }
        $this->set('user', $user);
    }
    
    
    /********************************************************************************
	Function Name: edit
	*Type: Public function used as action of the controller
	*Input: Page id
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to edit existing entry in page.
	*********************************************************************************/
    public function edit($id)
     {
        $layoutTitle = 'Page-edit';
        $this->set(compact('layoutTitle'));
        $this->viewBuilder()->layout('Admin/admin');
        $pages = $this->Pages->get($id, ['contain' => []]);//fields name in contain[] with coma
        if ($this->request->is(['patch', 'post', 'put'])) {
            $pages = $this->Pages->patchEntity($pages, $this->request->data);
            if ($this->Pages->save($pages)) {
                $this->Flash->success(__('The page has been saved.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The page could not be saved. Please, try again.'));
            }
        }
        $this->set(compact('pages'));
    }
    
    /********************************************************************************
	Function Name: status
	*Type: Public function used as action of the controller
	*Input: business id
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to change status of page.
	*********************************************************************************/
    public function status($id = null) {
        if ($id){
            $business = $this->Pages->get($id, ['fields' =>['status'],'contain' => []]);
            $status = ($business->status == 1) ? 0:1;
            $articles = TableRegistry::get('Pages');
            $query = $articles->query();
            $query->update()
                ->set(['status' => $status])
                ->where(['id' => $id])
                ->execute();
                
            $this->Flash->success(__('Page status has been changed successfully.'));
           return $this->redirect(array('action' => 'index'));
        }
        $this->Flash->error(__('Unable to change page status. Please try again later.'));
        $this->redirect(array('action' => 'index'));
    }
	
    /********************************************************************************
	Function Name: delete
	*Type: Public function used as action of the controller
	*Input: Page id
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to delete record from page.
	*********************************************************************************/
    public function delete($id = null)
    {
        //$this->request->allowMethod(['post', 'delete']);
        $tag = $this->Pages->get($id);
        if ($this->Pages->delete($tag)) {
            $this->Flash->success(__('The page has been deleted.'));
        } else {
            $this->Flash->error(__('The page could not be deleted. Please, try again.'));
        }
        return $this->redirect(['action' => 'index']);
    }
}
