<?php
namespace App\Model\Table;

use Cake\ORM\Table;
use Cake\Validation\Validator;
use Cake\Auth\DefaultPasswordHasher;
//use Cake\ORM\RulesChecker;
 
class CouponsTable extends Table
{
    public function initialize(array $config)
    {
        
		$this->belongsTo('Categories', [
            'className' => 'Categories',
            //'bindingKey' => ['clientId'],
			'foreignKey' => ['categoryId']
        ]);  
    }
    
    public function validationCustomer(Validator $validator)
    {
       
		$validator->notEmpty('startDate', 'Please start Date.');
		$validator->notEmpty('endDate', 'Please end Date.');
		$validator->notEmpty('discount', 'Please select discount');
		$validator
			->notEmpty('couponCode', 'Please enter coupon Code.')
			 ->add('couponCode', 'unique',[
                    'rule' => 'validateUnique',
                    'provider' => 'table',
                    'message' => 'coupon Code already exist'
			]);
		
        $validator->add('image', [      
				'image' => [                    
					'rule'=>  function($value){
						$ext = explode(".", $value);
						$extension = strtolower(end($ext));
						
						if (in_array(trim($extension), array('jpg', 'jpeg', 'png', 'gif'))) {							
							return true;
						}
						return false;
					},
					'message'=>'Please select jpg, jpeg, gif and png only.',
                ]
		])->notEmpty('image');
        return $validator;
    }
    
    
    
	
    
    
    
    
    
    
   

}
