<?php
/**
 * CakePHP(tm) : Rapid Development Framework (http://cakephp.org)
 * Copyright (c) Cake Software Foundation, Inc. (http://cakefoundation.org)
 *
 * Licensed under The MIT License
 * For full copyright and license information, please see the LICENSE.txt
 * Redistributions of files must retain the above copyright notice.
 *
 * @copyright Copyright (c) Cake Software Foundation, Inc. (http://cakefoundation.org)
 * @link      http://cakephp.org CakePHP(tm) Project
 * @since     0.2.9
 * @license   http://www.opensource.org/licenses/mit-license.php MIT License
 */
namespace App\Controller;

use Cake\Core\Configure;
use Cake\View\Helper\HtmlHelper;
use Cake\Network\Exception\NotFoundException;
use Cake\View\Exception\MissingTemplateException;
use Cake\Routing\Router;

/**
 * Static content controller
 *
 * This controller will render views from Template/Pages/
 *
 * @link http://book.cakephp.org/3.0/en/controllers/pages-controller.html
 */
class PagesController extends AppController
{
		
    /**
     * Displays a view
     *
     * @return void|\Cake\Network\Response
     * @throws \Cake\Network\Exception\NotFoundException When the view file could not
     *   be found or \Cake\View\Exception\MissingTemplateException in debug mode.
     */
    public function home()
    {
        $this->viewBuilder()->layout('home');
        $layoutTitle = 'Freedom Giving';
        
        $this->loadModel('Testimonials');
        $testimonials = $this->Testimonials->find('all')->where(['Testimonials.status' => 1])->toArray();
		
		
        
		$this->set(compact('layoutTitle', 'testimonials'));
    }
    
    public function detail($slug=NULL)
    {
        $this->viewBuilder()->layout('pages');
        
        
        $this->loadModel('Pages');
        $pages = $this->Pages->find()->where(['Pages.status' => 1, 'Pages.slug' => $slug])->first();
        
		$ex = explode("-", $pages->slug);
		$tilee = '';
		foreach($ex as $exx){
			$tilee .= ucfirst($exx)." ";
		}
		$url = Router::url('/', true);;
		$breadcum = [
					 'Title' => 'About Us',
					 'URL'=>[
							   'Home' => $url,
							   $tilee => $url.$pages->slug
							]
					 ];
		//pr($breadcum); //die;
		$layoutTitle = 'Freedom Giving::'.$pages->slug;
        $this->set(compact('layoutTitle', 'pages', 'breadcum'));
    }
    
    public function faqs()
    {
		//die('dd');
        $this->viewBuilder()->layout('pages');
		
        $layoutTitle = 'Freedom Giving::Faq';
		$url = Router::url('/', true);
		$breadcum = [
					 'Title' => 'FAQS',
					 'URL'=>[
							   'Home' => $url,
							   'FAQS' => $url.'faqs'
							]
					 ];
		$this->loadModel('Faqs');
        $faqs = $this->Faqs->find('all')->where(['Faqs.status' => 1])->toArray();
		//pr($faqs); die('ss');
        $this->set(compact('layoutTitle', 'breadcum', 'faqs'));
        //die('ff');
    }
    
    public function testimonials()
    {
        $this->viewBuilder()->layout('pages');
		
        $layoutTitle = 'Freedom Giving::Testimonials';
		$url = Router::url('/', true);
		$breadcum = [
					 'Title' => 'Testimonials',
					 'URL'=>[
							   'Home' => $url,
							   'Tesimonials' => $url.'testimonials'
							]
					 ];
		$this->loadModel('Testimonials');
        $testimonials = $this->Testimonials->find('all')->where(['Testimonials.status' => 1])->toArray();
		//pr($faqs); die('ss');
        $this->set(compact('layoutTitle', 'breadcum', 'testimonials'));
    }
    
    
    public function contact(){
		$this->viewBuilder()->layout('pages');
		
        $layoutTitle = 'Freedom Giving::Contact Us';
		$url = Router::url('/', true);
		$breadcum = [
					 'Title' => 'Contact Us',
					 'URL'=>[
							   'Home' => $url,
							   'Contact Us' => $url.'contact'
							]
					 ];
		
		if($this->request->is('post')){
			pr($this->request->data); die('dd');
            $this->loadModel('Newsletters');
            $newsletters = $this->Newsletters->newEntity();
            $newsletters = $this->Newsletters->patchEntity($newsletters, $this->request->data, ['validate' => false]);
            $newsletters['created'] = date('Y-m-d H:i:s');
            $newsletters['status'] = 1;
            if ($this->Newsletters->save($newsletters)) {
              $this->Flash->success(__('You newsletter subscribe successfully.'));  
            }else{
                $this->Flash->error(__('Please fill all information.'));
            }
            return $this->redirect(['action' => 'home/#newsletter-subscribe']); 
        }
		
        $this->set(compact('layoutTitle', 'breadcum', 'testimonials'));
        
	}
    
    function newsletter($email=Null){
		//$this->autoRender = false;
		$this->loadModel('Newsletters');
		$nS = $this->Newsletters->find()->where(['Newsletters.email' => $email])->first();
		if(!empty($nS)){
			echo '<span id="newsresponse" style="color:red">Your email address already subscribed.</span>';
		}else{
			$newsLetter = $this->Newsletters->newEntity();
			$newsLetter = $this->Newsletters->patchEntity($newsLetter, $this->request->data, ['validate' => false]);            
			$newsLetter['created'] = date('Y-m-d H:i:s');
			$newsLetter['email'] = $email;
			$newsLetter['status'] = '1';
			//$path = WWW_ROOT . 'img/uploads/feature/original/';
			if ($this->Newsletters->save($newsLetter)) {
			echo '<span id="newsresponse" style="color:green">You newsletter subscribe successfully.</span>';
			}
		}
		die;
	}
	
	function terms(){
		$this->loadModel('Pages');
		$terms = $this->Pages->find()->where(['Pages.id' => '5'])->first();
		//pr($terms);
		echo '<div style="border:1px solid gray; padding:5px; text-align:justify;" ><h2 style="text-align:center;">Term and Use</h2>'.$terms->content.'</div>';die;
	}
    public function display()
    {
        die('sdss');
        //return $this->redirect('/');
        //$path = func_get_args();
        //
        //$count = count($path);
        //if (!$count) {
        //    return $this->redirect('/');
        //}
        //$page = $subpage = null;
        //
        //if (!empty($path[0])) {
        //    $page = $path[0];
        //}
        //if (!empty($path[1])) {
        //    $subpage = $path[1];
        //}
        //$this->set(compact('page', 'subpage'));
        //
        //try {
        //    $this->render(implode('/', $path));
        //} catch (MissingTemplateException $e) {
        //    if (Configure::read('debug')) {
        //        throw $e;
        //    }
        //    throw new NotFoundException();
        //}
    }
}