<?php
namespace App\Controller\Admin;
use App\Controller\Admin\Component\ImgComponent;

use App\Controller\Admin\AppController;
use Cake\Event\Event;
use Cake\ORM\TableRegistry;
use Cake\Core\Configure;
use Cake\I18n\Time;
use Cake\View\Helper\TimeHelper;
use Cake\Datasource\ConnectionManager;
/******************************************************************************
*File Name:	 Controller
*Creation Date: [11-02-2016]
*Modification Date: [11-02-2016]
*Author: [Raushan Suri]
*Author: [Modified By Raushan Suri]
*Description: [This controller consist of function related to Department.]
******************************************************************************/
class ReviewsController extends AppController
{

    public function beforeFilter(Event $event)
    {
        parent::beforeFilter($event);
        $this->Auth->allow(['showprofile']);
    }

    
    /********************************************************************************
	Function Name: index
	*Type: Public function used as action of the controller
	*Input: No input
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to view all member list and search.
	*********************************************************************************/
    public function index($id=null)
    {
        $layoutTitle = 'zarib :: Manage Review';
        $this->set(compact('layoutTitle'));
        $this->viewBuilder()->layout('Admin/admin');
        $limit = 30;//Configure::read('App.adminPageLimit');
        $this->loadModel('Users');
		$parentClientList = $this->Users->find('list', ['keyField' => 'id', 'valueField' => ['fullName', 'email']])
						->where(['Users.role'=>'Restaurant'])
                        ->order(['Users.fullName'=>'ASC'])->toArray();
		$RestaurantList = str_replace(";"," - ",$parentClientList);
		$DList = $this->Users->find('list', ['keyField' => 'id', 'valueField' => ['fullName', 'email']])
						->where(['Users.role'=>'Driver'])
                        ->order(['Users.fullName'=>'ASC'])->toArray();
		$driverList = str_replace(";"," - ",$DList);
		
        $this->paginate = [
            'limit' => $limit,
            'order' => ['Reviews.created' => 'DESC'],
			'contain'=>['Reviewtos','Reviewfroms'],
        ];        
        $keyword = $this->request->query('keyword');
		$resturentid = $this->request->query('resturentid');
		$driverid = $this->request->query('driverid');
		$condition[] = ['Reviewtos.role'=>'Member'];
		if($id !=''){
			$condition[] = ['Reviews.reviewTo'=>$id];
		}
		if($driverid !=''){
			$condition[] = ['Reviews.reviewTo'=>$driverid];
		}
        if($keyword != ''){
			$condition[] = [
				'OR' => [
					["Reviews.star LIKE '%".$keyword."%'"],
					["Reviews.message LIKE '%".$keyword."%'"],
					["Reviewtos.fullName LIKE '%".$keyword."%'"],
					["Reviewfroms.fullName LIKE '%".$keyword."%'"],
				]				
			];
		}        
        $query = $this->Reviews->find('all')->where($condition);       
        $reviews = $this->paginate($query);
        $reviews = $reviews->toArray();
		//pr($reviews);die;
        $this->set(compact('reviews', 'limit','RestaurantList', 'driverList'));
    }
	
	/********************************************************************************
	Function Name: index
	*Type: Public function used as action of the controller
	*Input: No input
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to view all member list and search.
	*********************************************************************************/
    public function dindex($id=null)
    {
        $layoutTitle = 'zarib :: Manage Review';
        $this->set(compact('layoutTitle'));
        $this->viewBuilder()->layout('Admin/admin');
        $limit = 30;//Configure::read('App.adminPageLimit');
        $this->loadModel('Users');
		$parentClientList = $this->Users->find('list', ['keyField' => 'id', 'valueField' => ['fullName', 'email']])
						->where(['Users.role'=>'Restaurant'])
                        ->order(['Users.fullName'=>'ASC'])->toArray();
		$RestaurantList = str_replace(";"," - ",$parentClientList);
		$DList = $this->Users->find('list', ['keyField' => 'id', 'valueField' => ['fullName', 'email']])
						->where(['Users.role'=>'Driver'])
                        ->order(['Users.fullName'=>'ASC'])->toArray();
		$driverList = str_replace(";"," - ",$DList);
		
        $this->paginate = [
            'limit' => $limit,
            'order' => ['Reviews.created' => 'DESC'],
			'contain'=>['Reviewtos','Reviewfroms'],
        ];        
        $keyword = $this->request->query('keyword');
		$resturentid = $this->request->query('resturentid');
		$driverid = $this->request->query('driverid');
		$condition[] = ['Reviewtos.role'=>'Driver'];
		if($id !=''){
			$condition[] = ['Reviews.reviewTo'=>$id];
		}
		if($driverid !=''){
			$condition[] = ['Reviews.reviewTo'=>$driverid];
		}
        if($keyword != ''){
			$condition[] = [
				'OR' => [
					["Reviews.star LIKE '%".$keyword."%'"],
					["Reviews.message LIKE '%".$keyword."%'"],
					["Reviewtos.fullName LIKE '%".$keyword."%'"],
					["Reviewfroms.fullName LIKE '%".$keyword."%'"],
				]				
			];
		}        
        $query = $this->Reviews->find('all')->where($condition);       
        $reviews = $this->paginate($query);
        $reviews = $reviews->toArray();
		//pr($reviews);die;
        $this->set(compact('reviews', 'limit','RestaurantList', 'driverList'));
    }

      
    /********************************************************************************
	Function Name: add
	*Type: Public function used as action of the controller
	*Input: No input
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to add hours.
	*********************************************************************************/
    public function add()
    {
        $layoutTitle = 'zarib ::  Add New Review';
        $this->set(compact('layoutTitle'));
        $this->viewBuilder()->layout('Admin/admin');
		$this->loadModel('Users');
		$vendorList = $this->Users->find('list', ['keyField' => 'id', 'valueField' => ['fullName', 'email']])
						->where(['Users.role'=>'Partner'])
                        ->order(['Users.fullName'=>'ASC'])->toArray();
		$memberList = $this->Users->find('list', ['keyField' => 'id', 'valueField' => ['fullName', 'email']])
						->where(['Users.role'=>'Member'])
                        ->order(['Users.fullName'=>'ASC'])->toArray();
		
        $reviews = $this->Reviews->newEntity();        
       
        if ($this->request->is('post')) {
            
			$reviews = $this->Reviews->patchEntity($reviews, $this->request->data, ['validate' => 'customer']);            
			$reviews['created'] = date('Y-m-d H:i:s');
			//$path = WWW_ROOT . 'img/uploads/feature/original/';
			if ($this->Reviews->save($reviews)) {
				
				$query = $this->Reviews->find()->where(['Reviews.reviewTo'=>$this->request->data['reviewTo']]);
				$avg = $query->select(['averagerating' => $query->func()->avg('star')])->toArray();
				$articles = TableRegistry::get('Users');
				$query = $articles->query();
				$query->update()
					->set(['AVGRating' => round($avg[0]->averagerating,2)])
					->where(['id' => $this->request->data['reviewTo']])
					->execute();			
				$this->Flash->success(__('Review added successfully.'));
				return $this->redirect(['action' => 'index']);	
			}else{
				//pr($users);die;
				$this->Flash->error(__('Unable to add new review, Please try again later.'));
			}
		}
        $this->set(compact('reviews','memberList','vendorList'));
    }
    
    
    
    
    /********************************************************************************
	Function Name: edit
	*Type: Public function used as action of the controller
	*Input: Member id
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to edit hours.
	*********************************************************************************/
    public function edit($id)
    {
        $layoutTitle = 'zarib :: Edit Review';
        $this->set(compact('layoutTitle'));
        $this->viewBuilder()->layout('Admin/admin');
		$this->loadModel('Users');
        $vendorList = $this->Users->find('list', ['keyField' => 'id', 'valueField' => ['fullName', 'email']])
						->where(['Users.role'=>'Partner'])
                        ->order(['Users.fullName'=>'ASC'])->toArray();
		$memberList = $this->Users->find('list', ['keyField' => 'id', 'valueField' => ['fullName', 'email']])
						->where(['Users.role'=>'Member'])
                        ->order(['Users.fullName'=>'ASC'])->toArray();
						
        $reviews = $this->Reviews->find()->where(['Reviews.id' => $id])->first();//fields name in contain[] with coma
        if ($this->request->is(['patch', 'post', 'put'])) {
			
			
			$reviews = $this->Reviews->patchEntity($reviews, $this->request->data, ['validate' => 'customer']);
			
			
			$path = WWW_ROOT . 'img/uploads/feature/original/';
			if ($this->Reviews->save($reviews)) {
				$query = $this->Reviews->find()->where(['Reviews.reviewTo'=>$this->request->data['reviewTo']]);
				$avg = $query->select(['averagerating' => $query->func()->avg('star')])->toArray();
				$articles = TableRegistry::get('Users');
				$query = $articles->query();
				$query->update()
					->set(['AVGRating' => round($avg[0]->averagerating,2)])
					->where(['id' => $this->request->data['reviewTo']])
					->execute();	
				$this->Flash->success(__('The review updated successfully.'));
                return $this->redirect(['action' => 'index']);
			} else {
				
				$this->Flash->error(__('Review information could not be saved. Please try again later.'));
			}
        }
		$this->set(compact('reviews','memberList','vendorList'));
    }
    
    
    /********************************************************************************
	Function Name: delete
	*Type: Public function used as action of the controller
	*Input: Member id
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to delete hours permanently.
	*********************************************************************************/
    public function delete($id = null)
    {
        $users = $this->Reviews->get($id);
        if ($this->Reviews->delete($users)) {
            $this->Flash->success(__('Review has been deleted.'));
        } else {
            $this->Flash->error(__('Review could not be deleted. Please, try again.'));
        }
        return $this->redirect(['controller' => 'Reviews', 'action' => 'index']);
    }
    
    
    /********************************************************************************
	Function Name: status
	*Type: Public function used as action of the controller
	*Input: Member id
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to update hours status.
	*********************************************************************************/
    public function status($id){
		$users = $this->Reviews->get($id);
		$status = '1';
		$msg = 'activated';
		if($users->status == '1'){
			$status = '0';
			$msg = 'deactivated';
		}
		
		$articles = TableRegistry::get('Reviews');
		$query = $articles->query();
		$query->update()
			->set(['status' => $status])
			->where(['id' => $id])
			->execute();
		$this->Flash->success(__('Review has been '.$msg.' successfully.'));
		return $this->redirect(['controller' => 'Reviews', 'action' => 'index']);
	}
    
    
    /********************************************************************************
	Function Name: details
	*Type: Public function used as action of the controller
	*Input: Member id
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to view hours information.
	*********************************************************************************/
    public function details($id){
        $layoutTitle = 'zarib ::  Member Details';
        $this->set(compact('layoutTitle'));
        $this->viewBuilder()->layout('Admin/admin');        
		$users = $this->Reviews->find()->where(['Reviews.id' => $id])->first();
        if(!empty($users)){
            $this->set(compact('users'));
        }else{
            $this->Flash->error(__('Member doesnot exist.'));
            return $this->redirect(['controller' => 'Reviews', 'action' => 'index']);
        }
	}
	
	
}