<?php
namespace App\Controller\Admin;
use App\Controller\Admin\Component\ImgComponent;

use App\Controller\Admin\AppController;
use Cake\Event\Event;
use Cake\ORM\TableRegistry;
use Cake\Core\Configure;
use Cake\I18n\Time;
use Cake\View\Helper\TimeHelper;
use Cake\Datasource\ConnectionManager;
/******************************************************************************
*File Name:	 Controller
*Creation Date: [11-02-2016]
*Modification Date: [11-02-2016]
*Author: [Raushan Suri]
*Author: [Modified By Raushan Suri]
*Description: [This controller consist of function related to Department.]
******************************************************************************/
class PermissionsController extends AppController
{

    public function beforeFilter(Event $event)
    {
        parent::beforeFilter($event);
        $this->loadModel('Permissions');
		$this->loadModel('Users');
    }

    
    /********************************************************************************
	Function Name: index
	*Type: Public function used as action of the controller
	*Input: No input
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to view all member list and search.
	*********************************************************************************/
    public function index($id=null)
    {
        $layoutTitle = 'zarib :: Manage Permission';
        $this->set(compact('layoutTitle'));
        $this->viewBuilder()->layout('Admin/admin');
        $limit = 30;//Configure::read('App.adminPageLimit');
        
        $this->paginate = [
            'limit' => $limit,
            'order' => [
                'Permissions.created' => 'DESC'
            ],
        ];        
        $keyword = $this->request->query('keyword');
		$condition[] = ['Permissions.id >'=>0];
        if($keyword != ''){
			$condition[] = [
				'OR' => [
					["Permissions.ControllerName LIKE"=>$keyword."%"],
				]				
			];
		}        
        $query = $this->Permissions->find('all')->where($condition);       
        $permissions = $this->paginate($query);
        $permissions = $permissions->toArray();
		//pr($permissions);die;
        $this->set(compact('permissions', 'limit'));
    }

      
    /********************************************************************************
	Function Name: add
	*Type: Public function used as action of the controller
	*Input: No input
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to add hours.
	*********************************************************************************/
    public function add()
    {
        $layoutTitle = 'zarib ::  Add New Permission';
        $this->set(compact('layoutTitle'));
        $this->viewBuilder()->layout('Admin/admin');
		
		
        $permissions = $this->Permissions->newEntity();        
       
        if ($this->request->is('post')) {
            
			$permissions = $this->Permissions->patchEntity($permissions, $this->request->data, ['validate' => 'customer']);            
			$permissions['created'] = date('Y-m-d H:i:s');
			//$path = WWW_ROOT . 'img/uploads/feature/original/';
			if ($this->Permissions->save($permissions)) {
				$this->Flash->success(__('Permission added successfully.'));
				return $this->redirect(['action' => 'index']);	
			}else{
				//pr($users);die;
				$this->Flash->error(__('Unable to add new permission, Please try again later.'));
			}
		}
        $this->set(compact('permissions'));
    }
    
    
    
    
    /********************************************************************************
	Function Name: edit
	*Type: Public function used as action of the controller
	*Input: Member id
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to edit hours.
	*********************************************************************************/
    public function edit($id)
    {
        $layoutTitle = 'zarib :: Edit Permission';
        $this->set(compact('layoutTitle'));
        $this->viewBuilder()->layout('Admin/admin');
        
        $permissions = $this->Permissions->find()->where(['Permissions.id' => $id])->first();//fields name in contain[] with coma
        if ($this->request->is(['patch', 'post', 'put'])) {
			
			
			$permissions = $this->Permissions->patchEntity($permissions, $this->request->data, ['validate' => 'customer']);
			
			
			$path = WWW_ROOT . 'img/uploads/feature/original/';
			if ($this->Permissions->save($permissions)) {
				
				$this->Flash->success(__('The permission updated successfully.'));
                return $this->redirect(['action' => 'index']);
			} else {
				
				$this->Flash->error(__('Permission information could not be saved. Please try again later.'));
			}
        }
        $this->set(compact('permissions'));
    }
    
    
    /********************************************************************************
	Function Name: delete
	*Type: Public function used as action of the controller
	*Input: Member id
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to delete hours permanently.
	*********************************************************************************/
    public function delete($id = null)
    {
        $users = $this->Permissions->get($id);
        if ($this->Permissions->delete($users)) {
            $this->Flash->success(__('Permission has been deleted.'));
        } else {
            $this->Flash->error(__('Permission could not be deleted. Please, try again.'));
        }
        return $this->redirect(['controller' => 'Permissions', 'action' => 'index']);
    }
    
    
    /********************************************************************************
	Function Name: status
	*Type: Public function used as action of the controller
	*Input: Member id
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to update hours status.
	*********************************************************************************/
    public function status($id){
		$users = $this->Permissions->get($id);
		$status = '1';
		$msg = 'activated';
		if($users->status == '1'){
			$status = '0';
			$msg = 'deactivated';
		}
		
		$articles = TableRegistry::get('Permissions');
		$query = $articles->query();
		$query->update()
			->set(['status' => $status])
			->where(['id' => $id])
			->execute();
		$this->Flash->success(__('Permission has been '.$msg.' successfully.'));
		return $this->redirect(['controller' => 'Permissions', 'action' => 'index']);
	}
    
    
    /********************************************************************************
	Function Name: details
	*Type: Public function used as action of the controller
	*Input: Member id
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to view hours information.
	*********************************************************************************/
    public function details($id){
        $layoutTitle = 'zarib ::  Member Details';
        $this->set(compact('layoutTitle'));
        $this->viewBuilder()->layout('Admin/admin');        
		$users = $this->Permissions->find()->where(['Permissions.id' => $id])->first();
        if(!empty($users)){
            $this->set(compact('users'));
        }else{
            $this->Flash->error(__('Member doesnot exist.'));
            return $this->redirect(['controller' => 'Permissions', 'action' => 'index']);
        }
	}



	public function subadmin($id=null)
    {
        $layoutTitle = 'zarib :: Sub Admin';
        $this->set(compact('layoutTitle'));
        $this->viewBuilder()->layout('Admin/admin');
        $limit = 30;//Configure::read('App.adminPageLimit');
        
        $this->paginate = [
            'limit' => $limit,
            'order' => ['Users.created' => 'DESC'],
        ];        
        $keyword = $this->request->query('keyword');
		$condition[] = ['Users.subAdmin'=>1];
        if($keyword != ''){
			$condition[] = [
				'OR' => [
					["Users.fullName LIKE"=>$keyword."%"],
				]				
			];
		}        
        $query = $this->Users->find('all')->where($condition);       
        $users = $this->paginate($query);
        $users = $users->toArray();
		//pr($permissions);die;
        $this->set(compact('users', 'limit'));
    }
	

	public function addsubadmin()
    {
        $layoutTitle = 'zarib ::  Add New Permission';
        $this->set(compact('layoutTitle'));
        $this->viewBuilder()->layout('Admin/admin');
		$userList2 = $this->Users->find('list', ['keyField' => 'id', 'valueField' => ['fullName', 'email']])->where(['Users.role <>'=>'Admin','Users.subAdmin'=>0])->order(['Users.fullName'=>'ASC'])->toArray();
		$userList = str_replace(";", " - ", $userList2);
        if ($this->request->is('post')) {
            
			$articles = TableRegistry::get('Users');
			$query = $articles->query();
			$query->update()
				->set(['subAdmin' => 1])
				->where(['id' => $this->request->data['userid']])
				->execute();

			$this->Flash->success(__('Users beacome a sub-admin successfully.'));
			return $this->redirect(['action' => 'subadmin']);	
			
		}
        $this->set(compact('userList'));
    }

	public function removesubadmin($id){
		$articles = TableRegistry::get('Users');
			$query = $articles->query();
			$query->update()
				->set(['subAdmin' => 0])
				->where(['id' => $id])
				->execute();
		$this->Flash->success(__('User has been released from sub-admin position successfully.'));
		return $this->redirect(['controller' => 'Permissions', 'action' => 'subadmin']);
	}
	
}