<?php
namespace App\Controller\Admin;


use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;
use PHPMailer\PHPMailer\Exception;

require("/home/demo4ev/public_html/Exception.php");
require("/home/demo4ev/public_html/PHPMailer.php");
require("/home/demo4ev/public_html/SMTP.php");

use Cake\Controller\Controller;
use Cake\Event\Event;
use Cake\Core\Configure;
use Cake\Mailer\Email;

class AppController extends Controller
{
    //...

    public function initialize()
    {
        $this->loadComponent('Flash');
        $this->loadComponent('Auth', [
            'loginRedirect' => [
                'controller' => 'Admins',
                'action' => 'login'
            ],
            'logoutRedirect' => [
                'controller' => 'Admins',
                'action' => 'login',
                ]
        ]);
    }

    public function beforeFilter(Event $event)
    {
        $this->Auth->allow(['index', 'view', 'display']);
        $this->set('PATH', Configure::read('App.siteurl')); 
        $action = array('login', 'reset', 'forgotpassword', 'showprofile');
        if (in_array($this->request->params['action'], $action) && $this->request->params['prefix'] == 'admin')
        {
            
        }else{
            if ($this->request->session()->read('AnnuityAdmin.role') != 'Admin' && $this->request->session()->read('AnnuityAdmin') == '') {				
                $redirect = $this->request->session()->read('REDIRECT');
                if(isset($redirect)){
                    $this->request->session()->delete('REDIRECT');
                    $cont = $redirect['controller'];
                    $act = $redirect['action'];
                    $pass = $redirect['pass']; 
                    return $this->redirect(['controller'=>$cont, 'action'=>$act, $pass]);
                }
                $data['controller']     = $this->request->params['controller'];
                $data['action']         = $this->request->params['action'];
                $data['prefix']         = $this->request->params['prefix'];
                $data['pass']           = '';
                if(isset($this->request->params['pass']['0']) && $this->request->params['pass']['0'] !='')
                $data['pass'] = $this->request->params['pass']['0'];
                if(!empty($data['pass'])){
                    if(isset($this->request->params['pass']['1']) && $this->request->params['pass']['1'] !='')
                    $data['pass'] = $this->request->params['pass']['0']."/".$this->request->params['pass']['1'];
                }
                $this->request->session()->write('REDIRECT', $data);
                $this->redirect(['controller' => 'Admins', 'action' => 'login']);
            }
            //pr($this->request->session()->read('AnnuityAdmin')); 
            //echo $this->request->session()->read('AnnuityAdmin.subAdmin'); die('ddd');
            if($this->request->session()->read('AnnuityAdmin.subAdmin') == 1){
                $this->loadModel('Permissions');$permission = 'No';
                $permisions = $this->Permissions->find()->toArray();
                //pr($permisions);
                //die('ddd');
                foreach($permisions as $Valuee){
                    if(strtolower($Valuee->ControllerName) == strtolower($this->request->params['controller'])){
                        if($Valuee->view_op == 1 && in_array($this->request->params['action'], ['index','details','detail'])){
                            $permission = 'Yes';
                        }
                        if($Valuee->edit_op == 1 && in_array($this->request->params['action'], ['edit','editdriver'])){
                            $permission = 'Yes';
                        }
                        if($Valuee->add_op == 1 && in_array($this->request->params['action'], ['add','adddriver'])){
                            $permission = 'Yes';
                        }
                        if($Valuee->delete_op == 1 && in_array($this->request->params['action'], ['delete'])){
                            $permission = 'Yes';
                        }
                    }
                }
                if($permission == 'No' && 'admins' != strtolower($this->request->params['controller'])){
                    $this->redirect(['controller' => 'Admins', 'action' => 'dashboard']);
                }
            }
        }
    }
    
    
    /********************************************************************************
	Function Name: sendmail
	*Type: Public function used as action of the controller
	*Input: template variables, mail template, receiver email and email subject
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to send emails.
	*********************************************************************************/
	function sendmail($Email_variables,$mail_template='', $mailto='', $subject='', $mailcc = '',$from='') {	
		$this->autoRender = false;
        
        $email = new Email('Smtp');
        $email->template($mail_template, 'email_layout')
            ->emailFormat('html')
            ->viewVars($Email_variables)		
            ->subject($subject)
            ->to($mailto)
            ->from(['info@evirtualservices.com'=>'E-virtual services'])
            ->send();
		return true;
	}
    
     /********************************************************************************
	Function Name: random_password
	*Type: Public function used as action of the controller
	*Input: No input
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function for generate n length random password.
	*********************************************************************************/
    public function random_password($length = '10'){
		//$this->autoRender = false;	
		$characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
		$charactersLength = strlen($characters);
		$randomString = '';
		for ($i = 0; $i < $length; $i++) {
			$randomString .= $characters[rand(0, $charactersLength - 1)];
		}
		return $randomString;		
	}


    function phpemail($to, $subject, $message){
		return true;
		$mailer = new PHPMailer(true);
		$mailer->SMTPDebug = 0;
		$mailer->isSMTP();
		$mailer->Mailer = "smtp";
		$mailer->SMTPOptions = array(
		'ssl' => array(
			'verify_peer' => false,
			'verify_peer_name' => false,
			'allow_self_signed' => true
		));
	
		$headder = '<html xmlns="http://www.w3.org/1999/xhtml" style="margin: 0;padding: 0;">
		<head style="margin: 0;padding: 0;">
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8" style="margin: 0;padding: 0;">
		<title style="margin: 0;padding: 0;">Untitled Document</title>
		<link href="http://fonts.googleapis.com/css?family=Raleway:500,300|Lato:300,400,700" rel="stylesheet" type="text/css" style="margin: 0;padding: 0;">
		<style style="margin: 0;padding: 0;">
		* {
			margin: 0;
			padding: 0;
		}
		body {
		}
		.style1 {
			color: #555;
			font-family: "Lato", sans-serif;
			font-size: 14px;
			line-height: 24px;
			margin-bottom: 16px;
		}
		</style>
		</head>

		<body style="margin: 0;padding: 0;" width="100%">
		<table border="0" cellspacing="0" cellpadding="0" style="width:80% ;margin: 0 auto;padding: 0;">
		  <tr style="margin: 0;padding: 0;">
			<td bgcolor="#f4f4f4" align="center" style="padding: 10px 0;margin: 0;"><img src="'.Configure::read('App.siteurl').'img/admin/logo-black.png" style="margin: 0;padding: 0;"></td>
		  </tr>
		  <tr style="margin: 0;padding: 0;">
			<td bgcolor="#FFF" style="padding:10px;color: #555;font-family: Lato, sans-serif;font-size: 14px;line-height: 24px; margin-bottom: 16px;margin: 0;">'; 
			
			$content = '<div class="style1" style="line-height:10px; padding:5px;color: #555;font-family: &quot;Lato&quot;, sans-serif;font-size: 14px;line-height: 24px;margin-bottom: 16px;">'.$message.'</div>'; 
			
			//$footer = '<p>&nbsp;</p><p class="style1" style="font-size: 15px;margin: 0;padding: 0;color: #555;font-family: &quot;Lato&quot;, sans-serif;line-height: 24px;margin-bottom: 16px;"><strong style="margin: 0;padding: 0;"> If you have any query please call us : +1(844-888-7439)</strong></p>
			  
			  $footer = '</td>
		  </tr>
		  <tr style="margin: 0;padding: 0;">
			<td bgcolor="#FF8C00" style="margin: 0;padding:15px;"><p style="font-size: 13px;text-align: center;color: #FFF;padding-top:15px; margin: 0;padding: 0;font-family: &quot;Lato&quot;, sans-serif;line-height: 24px;margin-bottom: 16px;">
			<strong style="font-size: 18px;margin: 0;padding: 0;">Pathmark Support Team</strong>
			<br style="margin: 0;padding: 0;"><a style="color: #FFF;" href="mailto:support@pathmark.com" target="_blank">support@pathmark.com</a> <br style="margin: 0;padding: 0;"></p></td>
		  </tr>
		</table></body></html>';

			$body = $headder.$content.$footer; 
			// echo $body; die;
			$mailer->Host = 'mail.smtp2go.com';
			$mailer->SMTPAuth = true;
			$mailer->Username = 'info@demo2.evirtualservices.co';
			$mailer->Password = 'Testing@1234567890';
			$mailer->SMTPSecure = 'tls';
			$mailer->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
			$mailer->Port = 587;
		
			$mailer->setFrom('info@demo2.evirtualservices.co', 'Pathmark');
			$mailer->addAddress($to);
			$mailer->isHTML(true);
			$mailer->Subject = $subject;
			$mailer->Body = $body;
			
			$mailer->send();
			$mailer->ClearAllRecipients();
			return true;
	}


}