<?php
namespace App\Controller\Admin;
use App\Controller\Admin\Component\ImgComponent;

use App\Controller\Admin\AppController;
use Cake\Event\Event;
use Cake\ORM\TableRegistry;
use Cake\Core\Configure;
use Cake\I18n\Time;
use Cake\View\Helper\TimeHelper;
use Cake\Datasource\ConnectionManager;
/******************************************************************************
*File Name:	 Controller
*Creation Date: [11-02-2016]
*Modification Date: [11-02-2016]
*Author: [Raushan Suri]
*Author: [Modified By Raushan Suri]
*Description: [This controller consist of function related to Department.]
******************************************************************************/
class AdminpaymentsController extends AppController
{

    public function beforeFilter(Event $event)
    {
        parent::beforeFilter($event);
        $this->Auth->allow(['showprofile']);
    }

    
    /********************************************************************************
	Function Name: index
	*Type: Public function used as action of the controller
	*Input: No input
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to view all member list and search.
	*********************************************************************************/
    public function index($id=null)
    {
        $layoutTitle = 'zarib :: Manage Admin Payment';
        $this->set(compact('layoutTitle'));
        $this->viewBuilder()->layout('Admin/admin');
        $limit = 30;//Configure::read('App.adminPageLimit');
        
        $this->paginate = [
            'limit' => $limit,
            'order' => ['Adminpayments.created' => 'DESC'],
			'contain' => ['Users']
        ];        
        $keyword = $this->request->query('keyword');
		$condition[] = ['Adminpayments.id >'=>0];
        if($keyword != ''){
			$condition[] = [
				'OR' => [
					["Adminpayments.amount LIKE '%".$keyword."%'"],
					["Users.fullName LIKE '%".$keyword."%'"],
				]				
			];
		}        
        $query = $this->Adminpayments->find('all')->where($condition);       
        $adminpayments = $this->paginate($query);
        $adminpayments = $adminpayments->toArray();
		//pr($adminpayments);die;
        $this->set(compact('adminpayments', 'limit'));
    }

      
    /********************************************************************************
	Function Name: add
	*Type: Public function used as action of the controller
	*Input: No input
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to add hours.
	*********************************************************************************/
    public function add()
    {
        $layoutTitle = 'zarib ::  Add New Admin Payment';
        $this->set(compact('layoutTitle'));
        $this->viewBuilder()->layout('Admin/admin');
		
		
        $adminpayments = $this->Adminpayments->newEntity();        
       
        if ($this->request->is('post')) {
            
			$adminpayments = $this->Adminpayments->patchEntity($adminpayments, $this->request->data, ['validate' => 'customer']);            
			$adminpayments['created'] = date('Y-m-d H:i:s');
			//$path = WWW_ROOT . 'img/uploads/feature/original/';
			if ($this->Adminpayments->save($adminpayments)) {
				$this->Flash->success(__('Adminpayment added successfully.'));
				return $this->redirect(['action' => 'index']);	
			}else{
				//pr($users);die;
				$this->Flash->error(__('Unable to add new adminpayment, Please try again later.'));
			}
		}
        $this->set(compact('adminpayments'));
    }
    
    
    
    
    /********************************************************************************
	Function Name: edit
	*Type: Public function used as action of the controller
	*Input: Member id
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to edit hours.
	*********************************************************************************/
    public function edit($id)
    {
        $layoutTitle = 'zarib :: Edit Admin Payment';
        $this->set(compact('layoutTitle'));
        $this->viewBuilder()->layout('Admin/admin');
        
        $adminpayments = $this->Adminpayments->find()->where(['Adminpayments.id' => $id])->contain(['Users'])->first();//fields name in contain[] with coma
        if($adminpayments->status == 2){
			return $this->redirect(['action' => 'index']);
		}
		if ($this->request->is(['patch', 'post', 'put'])) {
			
			if($this->request->data['status'] == 2){
				$articles = TableRegistry::get('Users');
				$query = $articles->query();
				$query->update()
				->set($query->newExpr('wallet = wallet + '.(float)@$adminpayments->amount))
				->where(['id' => $adminpayments->userId])
				->execute();
			}
			$adminpayments = $this->Adminpayments->patchEntity($adminpayments, $this->request->data, ['validate' => 'customer']);
			
			
			$path = WWW_ROOT . 'img/uploads/feature/original/';
			if ($this->Adminpayments->save($adminpayments)) {
				
				$this->Flash->success(__('The adminpayment updated successfully.'));
                return $this->redirect(['action' => 'index']);
			} else {
				
				$this->Flash->error(__('Adminpayment information could not be saved. Please try again later.'));
			}
        }
        $this->set(compact('adminpayments'));
    }
    
    
    /********************************************************************************
	Function Name: delete
	*Type: Public function used as action of the controller
	*Input: Member id
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to delete hours permanently.
	*********************************************************************************/
    public function delete($id = null)
    {
        $users = $this->Adminpayments->get($id);
        if ($this->Adminpayments->delete($users)) {
            $this->Flash->success(__('Adminpayment has been deleted.'));
        } else {
            $this->Flash->error(__('Adminpayment could not be deleted. Please, try again.'));
        }
        return $this->redirect(['controller' => 'Adminpayments', 'action' => 'index']);
    }
    
    
    /********************************************************************************
	Function Name: status
	*Type: Public function used as action of the controller
	*Input: Member id
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to update hours status.
	*********************************************************************************/
    public function status($id){
		$users = $this->Adminpayments->get($id);
		$status = '1';
		$msg = 'activated';
		if($users->status == '1'){
			$status = '0';
			$msg = 'deactivated';
		}
		
		$articles = TableRegistry::get('Adminpayments');
		$query = $articles->query();
		$query->update()
			->set(['status' => $status])
			->where(['id' => $id])
			->execute();
		$this->Flash->success(__('Adminpayment has been '.$msg.' successfully.'));
		return $this->redirect(['controller' => 'Adminpayments', 'action' => 'index']);
	}
    
    
    /********************************************************************************
	Function Name: details
	*Type: Public function used as action of the controller
	*Input: Member id
	*Author: Raushan Suri
	*Modified By: Raushan Suri
	*Output: Function to view hours information.
	*********************************************************************************/
    public function details($id){
        $layoutTitle = 'zarib ::  Member Details';
        $this->set(compact('layoutTitle'));
        $this->viewBuilder()->layout('Admin/admin');        
		$users = $this->Adminpayments->find()->where(['Adminpayments.id' => $id])->first();
        if(!empty($users)){
            $this->set(compact('users'));
        }else{
            $this->Flash->error(__('Member doesnot exist.'));
            return $this->redirect(['controller' => 'Adminpayments', 'action' => 'index']);
        }
	}
	
	
}